/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "automaton.h"

int		CNdAutomaton::new_state;
int		CNdAutomaton::input_range;

CNdAutomaton::CStateMap		CNdAutomaton::state_map(31);

CNdTransition	&CNdTransition::operator+=(const CNdTransition &tr)
{
	if (this != &tr)
	{
		VListInt::listptr	states_listptr	= states.FirstListPtr();
		VListInt::listptr	tr_listptr		= tr.states.FirstListPtr();

		while (states_listptr)
		{
			int		state = states.Data(states_listptr);

			while (tr_listptr)
			{
				int		tr_state = tr.states.Data(tr_listptr);

				if (tr_state < state)
				{
					states.InsertBefore(states_listptr, tr_state);
					tr.states.NextListPtr(tr_listptr);
				}
				else if (tr_state == state)
				{
					tr.states.NextListPtr(tr_listptr);
					break;
				}
				else
					break;
			}

			states.NextListPtr(states_listptr);
		}

		while (tr_listptr)
			states.PushBack(tr.states.NextData(tr_listptr));
	}

	return *this;
}

CNdState	&CNdState::operator+=(const CNdState &st)
{
	if (this != &st)
	{
		VListNdTrans::listptr	tr_listptr
									= transitions.FirstListPtr();
		VListNdTrans::listptr	st_tr_listptr
									= st.transitions.FirstListPtr();

		while (tr_listptr)
		{
			CNdTransition	*tr = transitions.Data(tr_listptr);

			while (st_tr_listptr)
			{
				CNdTransition	*st_tr = st.transitions.Data(st_tr_listptr);

				if (*st_tr < *tr)
				{
					transitions.InsertBefore(	tr_listptr,
												new CNdTransition(*st_tr));
					st.transitions.NextListPtr(st_tr_listptr);
				}
				else if (*st_tr == *tr)
				{
					*tr += *st_tr;
					st.transitions.NextListPtr(st_tr_listptr);
					break;
				}
				else
					break;
			}

			transitions.NextListPtr(tr_listptr);
		}

		while (st_tr_listptr)
		{
			CNdTransition	*st_tr = st.transitions.NextData(st_tr_listptr);
			transitions.PushBack(new CNdTransition(*st_tr));
		}
	}

	return *this;
}

CNdAutomaton	*NdSymbol(int s)
{
	CNdAutomaton	*nd = new CNdAutomaton;

	CNdState	*st1 = new CNdState;
	CNdState	*st2 = new CNdState;

	st1->state_number	= CNdAutomaton::new_state++;
	st1->final_flag		= false;

	st2->state_number	= CNdAutomaton::new_state++;
	st2->final_flag		= true;

	CNdTransition	*tr = new CNdTransition(s, st2->state_number);

	st1->AddNewTransition(tr);

	nd->AddNewStartState(st1);
	nd->AddNewState(st2);

	return nd;
};

CNdAutomaton	*NdSymbolString(const VListInt &s_string)
{
	CNdAutomaton	*nd = new CNdAutomaton;

	int		length = s_string.Size();

	CNdState	*s_states[length + 1];

	int	i;
	for (i=0; i<length+1; i++)
	{
		s_states[i] = new CNdState;
		s_states[i]->state_number	= CNdAutomaton::new_state++;
		s_states[i]->final_flag		= false;
	}

	s_states[length]->final_flag	= true;

	VListInt::listptr	s_string_listptr = s_string.FirstListPtr();

	for (i=0; i<length; i++)
	{
		int		s_char = s_string.NextData(s_string_listptr);

		CNdTransition	*tr = new CNdTransition(s_char,
												s_states[i + 1]->state_number);

		s_states[i]->AddNewTransition(tr);
	}

	nd->AddNewStartState(s_states[0]);

	for (i=1; i<length+1; i++)
		nd->AddNewState(s_states[i]);

	return nd;
}

CNdAutomaton	*NdSymbolClass(const VListInt &c_set)
{
	CNdAutomaton	*nd = new CNdAutomaton;

	CNdState	*st1 = new CNdState;
	CNdState	*st2 = new CNdState;

	st1->state_number	= CNdAutomaton::new_state++;
	st1->final_flag		= false;

	st2->state_number	= CNdAutomaton::new_state++;
	st2->final_flag		= true;

	bool	set_flags[CNdAutomaton::input_range];

	int	i;
	for (i=0; i<CNdAutomaton::input_range; i++)
		set_flags[i] = false;

	VListInt::listptr	int_listptr = c_set.FirstListPtr();

	while (int_listptr)
		set_flags[c_set.NextData(int_listptr)] = true;

	for (i=0; i<CNdAutomaton::input_range; i++)
		if (set_flags[i])
			st1->AddNewTransition(new CNdTransition(i, st2->state_number));

	nd->AddNewStartState(st1);
	nd->AddNewState(st2);

	return nd;
}

CNdAutomaton	*NdSymbolComplement(const VListInt &c_set)
{
	CNdAutomaton	*nd = new CNdAutomaton;

	CNdState	*st1 = new CNdState;
	CNdState	*st2 = new CNdState;

	st1->state_number	= CNdAutomaton::new_state++;
	st1->final_flag		= false;

	st2->state_number	= CNdAutomaton::new_state++;
	st2->final_flag		= true;

	bool	set_flags[CNdAutomaton::input_range];

	int	i;
	for (i=0; i<CNdAutomaton::input_range; i++)
		set_flags[i] = true;

	VListInt::listptr	int_listptr = c_set.FirstListPtr();

	while (int_listptr)
		set_flags[c_set.NextData(int_listptr)] = false;

	for (i=0; i<CNdAutomaton::input_range; i++)
		if (set_flags[i])
			st1->AddNewTransition(new CNdTransition(i, st2->state_number));

	nd->AddNewStartState(st1);
	nd->AddNewState(st2);

	return nd;
}

CNdAutomaton	*NdCat(CNdAutomaton *nd1, CNdAutomaton *nd2)
{
	CNdAutomaton	*nd = new CNdAutomaton;

	CNdState	*nd2_start = nd2->GetStartState();

	CNdState	*st = nd1->GetStartState();

	if (st->final_flag)
	{
		*st += *nd2_start;

		if (!nd2_start->final_flag)
			st->final_flag = false;
	}

	nd->AddNewStartState(st);

	nd1->RemoveStartState();

	VListNdStatePtr		state_listptr	= nd1->states.FirstListPtr();

	while (state_listptr)
	{
		st = nd1->states.NextData(state_listptr);

		if (st->final_flag)
		{
			*st += *nd2_start;

			if (!nd2_start->final_flag)
				st->final_flag = false;
		}

		nd->AddNewState(st);
	}

	state_listptr	= nd2->states.FirstListPtr();

	while (state_listptr)
		nd->AddNewState(nd2->states.NextData(state_listptr));

	delete nd1;
	delete nd2;

	return nd;
}

CNdAutomaton	*NdOr(CNdAutomaton *nd_array[], int count)
{
	CNdAutomaton	*nd = new CNdAutomaton;

	CNdState	*st = new CNdState;

	st->state_number	= CNdAutomaton::new_state++;
	st->final_flag		= false;

	int	i;
	for (i=0; i<count; i++)
	{
		CNdState	*start_state = nd_array[i]->GetStartState();

		*st += *start_state;

		if (start_state->final_flag)
			st->final_flag = true;
	}

	nd->AddNewStartState(st);

	for (i=0; i<count; i++)
	{
		VListNdStatePtr	state_listptr = nd_array[i]->states.FirstListPtr();

		while (state_listptr)
			nd->AddNewState(nd_array[i]->states.NextData(state_listptr));
	}

	for (i=0; i<count; i++)
		delete nd_array[i];

	return nd;
}

CNdAutomaton	*NdClone(CNdAutomaton *nd1)
{
	CNdAutomaton::state_map.Clear();

	CNdAutomaton	*nd = new CNdAutomaton(*nd1);

	VListNdStatePtr	st_listptr = nd->states.FirstListPtr();

	while (st_listptr)
	{
		CNdState	*st = nd->states.NextData(st_listptr);

		st->state_number =
			CNdAutomaton::state_map.ReturnNewState(st->state_number);

		VListNdTransPtr		tr_listptr = st->transitions.FirstListPtr();

		while (tr_listptr)
		{
			CNdTransition	*tr = st->transitions.NextData(tr_listptr);

			VListInt::listptr	int_listptr = tr->states.FirstListPtr();

			while (int_listptr)
			{
				int		state = tr->states.Data(int_listptr);

				tr->states.SetData(int_listptr,
					CNdAutomaton::state_map.ReturnNewState(state));

				tr->states.NextListPtr(int_listptr);
			}
		}
	}

	return nd;
}

CNdAutomaton	*NdEmpty()
{
	CNdAutomaton	*nd = new CNdAutomaton;

	CNdState	*st1 = new CNdState;

	st1->state_number	= CNdAutomaton::new_state++;
	st1->final_flag		= true;

	nd->AddNewStartState(st1);

	return nd;
}

CNdAutomaton	*NdZeroOrMore(CNdAutomaton *nd1)
{
	CNdAutomaton	*nd = new CNdAutomaton;

	CNdState	*nd1_start = nd1->GetStartState();

	nd1_start->final_flag = true;

	nd->AddNewStartState(nd1_start);

	nd1->RemoveStartState();

	VListNdStatePtr		st_listptr	= nd1->states.FirstListPtr();

	while (st_listptr)
	{
		CNdState	*st = nd1->states.NextData(st_listptr);

		if (st->final_flag)
			*st += *nd1_start;

		nd->AddNewState(st);
	}

	delete nd1;

	return nd;
}

CNdAutomaton	*NdMOrMore(CNdAutomaton *nd1, int m)
{
	if (!m)
		return NdZeroOrMore(nd1);

	CNdAutomaton	*a = NdClone(nd1);

	for (int i=1; i<m; i++)
		a = NdCat(a, NdClone(nd1));

	CNdAutomaton	*b = NdZeroOrMore(nd1);

	return NdCat(a, b);
}

CNdAutomaton	*NdZeroToN(CNdAutomaton *nd1, int n)
{
	if (!n)
	{
		nd1->DeleteObjects();
		delete nd1;

		return NdEmpty();
	}
	else if (n == 1)
	{
		CNdAutomaton	*or_array[2];

		or_array[0]	= NdEmpty();
		or_array[1]	= nd1;

		return NdOr(or_array, 2);
	}
	else
	{
		CNdAutomaton	*or_array[n + 1];

		or_array[0] = NdEmpty();
		or_array[1] = NdClone(nd1);

		int	i;
		for (i=2; i<n; i++)
			or_array[i] = NdCat(NdClone(or_array[i - 1]), NdClone(nd1));

		or_array[n] = NdCat(NdClone(or_array[n - 1]), nd1);

		return NdOr(or_array, n + 1);
	}
}

CNdAutomaton	*NdMToN(CNdAutomaton *nd1, int m, int n)
{
	if (!m && !n)
	{
		nd1->DeleteObjects();
		delete nd1;

		return NdEmpty();
	}
	else if (!m && n)
	{
		return NdZeroToN(nd1, n);
	}
	else if (m == 1 && n == 1)
	{
		return nd1;
	}
	else if (1 < m && 1 < n && m == n)
	{
		CNdAutomaton	*a = NdClone(nd1);

		int	i;
		for (i=1; i<n-1; i++)
			a = NdCat(a, NdClone(nd1));
			
		return NdCat(a, nd1);
	}
	else
	{
		CNdAutomaton	*a = NdClone(nd1);

		int	i;
		for (i=1; i<m; i++)
			a = NdCat(a, NdClone(nd1));

		CNdAutomaton	*or_array[n - m + 1];

		or_array[0] = a;

		for (i=1; i<n-m; i++)
			or_array[i] = NdCat(NdClone(or_array[i - 1]), NdClone(nd1));

		or_array[n - m] = NdCat(NdClone(or_array[n - m - 1]), nd1);

		return NdOr(or_array, n - m + 1);
	}
}

void	InsertString(VListPtrChar &s_list, char *t)
{
	VListPtrCharPtr		listptr = s_list.FirstListPtr();

	while (listptr)
	{
		char	*s = s_list.Data(listptr);

		int		comparison = strcmp(t, s);

		if (comparison < 0)
		{
			s_list.InsertBefore(listptr, t);
			return;
		}
		else if (!comparison)
			return;
		else
			s_list.NextListPtr(listptr);
	}

	s_list.PushBack(t);
}

void	CContext::SetStartActivations(VListPtrChar &s_list)
{
	VListPtrCharPtr		listptr = s_list.FirstListPtr();

	while (listptr)
		InsertString(start_activations, s_list.NextData(listptr));
}

void	CContext::SetStartAssignments(VListPtrChar &s_list)
{
	VListPtrCharPtr		listptr = s_list.FirstListPtr();

	while (listptr)
		InsertString(start_assignments, s_list.NextData(listptr));
}

void	CAutomaton::SetStartContext(VListPtrChar &s_list)
{
	VListPtrCharPtr		listptr = s_list.FirstListPtr();

	while (listptr)
		InsertString(start_context, s_list.NextData(listptr));
}

bool	IntersectionTestInt(VListInt &s1, VListInt &s2)
{
	VListIntPtr		s1_listptr	= s1.FirstListPtr();
	VListIntPtr		s2_listptr	= s2.FirstListPtr();

	while (s1_listptr)
	{
		int		s1_state = s1.Data(s1_listptr);

		while (s2_listptr)
		{
			int		s2_state = s2.Data(s2_listptr);

			if (s2_state < s1_state)
				s2.NextListPtr(s2_listptr);
			else if (s2_state == s1_state)
				return true;
			else
				break;
		}

		s1.NextListPtr(s1_listptr);
	}

	return false;
}

bool	IntersectionTestChar(VListPtrChar &s1, VListPtrChar &s2)
{
	VListPtrCharPtr		s1_listptr	= s1.FirstListPtr();
	VListPtrCharPtr		s2_listptr	= s2.FirstListPtr();

	while (s1_listptr)
	{
		char	*s1_string = s1.Data(s1_listptr);

		while (s2_listptr)
		{
			char	*s2_string = s2.Data(s2_listptr);

			int		comparison = strcmp(s2_string, s1_string);

			if (comparison < 0)
				s2.NextListPtr(s2_listptr);
			else if (!comparison)
				return true;
			else
				break;
		}

		s1.NextListPtr(s1_listptr);
	}

	return false;
}

bool	CAutomaton::CalculateLexical()
{
	CNdAutomaton::input_range = input_range;

	bool	r;

	if (scan_type == CLexicalDriver::SingleCharLexical)
	{
		fsm_count			= regexp_count;
		all_tokens_compiled	= true;
		r					= true;
	}
	else if (scan_type == CLexicalDriver::RegexpLexical)
	{
		if (ParseNdAutomata())
		{
			CalculateAutomata();

			r = true;
		}
		else
			r = false;
	}
	else
		r = false;

	return r;
}

bool	CAutomaton::StartAssignmentFlag()
{
	bool	r = false;

	for (int i=0; i<regexp_count; i++)
		if (start_assignment[i])
		{
			r = true;

			break;
		}

	return r;
}

bool	CAutomaton::TrailingContextFlag()
{
	bool	r = false;

	for (int i=0; i<regexp_count; i++)
		if (trailing_context[i])
		{
			r = true;

			break;
		}

	return r;
}

bool	CAutomaton::ParseNdAutomata()
{
	CLexicalSingleCharDriver	*lexical =
					new CLexicalSingleCharDriver(regexp_char_token_names);

	CRegexpParserDriver	*parser = new CRegexpParserDriver();

	parser->SetLexical(lexical);

	all_tokens_compiled		= true;
	CNdAutomaton::new_state	= 0;
	lowest_state_number[0]	= 0;

	token_count		= 0;
	filter_count	= 0;

	int		i;

	for (i=0; i<regexp_count; i++)
	{
		if (terminals[i].filter_flag)
			filter_count++;
		else
			token_count++;

		char	*re		= terminals[i].regexp;
		int		length	= strlen(re);

		lexical->SetInputBuffer(
			reinterpret_cast<const unsigned char *>(re), length);
		lexical->Initialize();
		parser->InitializeSyntaxMode();

		CParserDriver::StatusCode   sc = parser->ParseStream();

		current_char_number[i] = lexical->GetCurrentCharNumber();

		if (sc == CParserDriver::EndOfFile)
		{
			CStackElement   *se = parser->CompiledObject();

			context_array[i]			= (CContext *)se->data;
			lowest_state_number[i + 1]	= CNdAutomaton::new_state;
		}
		else
		{
			all_tokens_compiled = false;
		}
	}

	delete parser;
	delete lexical;

	return all_tokens_compiled;
}

VListInt			*CFSMStateNode::nd_state_list;
VListInt::listptr	CFSMStateNode::nd_state_listptr;
CFSMStateNode		*CFSMStateNode::final_node;
bool				CFSMStateNode::existing_fsm_state;
CMemoryAllocator	*CFSMStateNode::allocator;

void	CFSMStateNode::SetupAllocator(int block_size)
{
	allocator = new CMemoryAllocator(sizeof(CFSMStateNode), block_size);
}

void	CAutomaton::CalculateAutomata()
{
	int		i;
	int		j;
	int		k;

	CNdAutomaton	*copies[regexp_count];

	for (i=0; i<regexp_count; i++)
		copies[i] = new CNdAutomaton(*context_array[i]->nd);

	nd_or = NdOr(copies, regexp_count);

	number_of_nd_states = CNdAutomaton::new_state;

	nd_states			= new (CNdState *[number_of_nd_states]);
	final_states		= new VListInt[regexp_count];
	prefix_final_states	= new VListInt[regexp_count];

	for (i=0; i<number_of_nd_states; i++)
		nd_states[i] = 0;

	for (i=0; i<regexp_count; i++)
	{
		CNdAutomaton	*nd		= context_array[i]->nd;
		VListNdState	&states	= nd->states;

		VListNdStatePtr		s_listptr = states.FirstListPtr();

		while (s_listptr)
		{
			CNdState	*nds = states.NextData(s_listptr);

			nd_states[nds->state_number] = nds;
		}
	}

	CNdState	*or_start		= nd_or->GetStartState();
	int			or_start_index	= or_start->state_number;

	nd_states[or_start_index] = or_start;

	for (i=0; i<regexp_count; i++)
	{
		for (j=lowest_state_number[i]; j<lowest_state_number[i+1]; j++)
		{
			CNdState	*nds = nd_states[j];

			if (nds)
			{
				if (nds->final_flag)
					final_states[i].PushBack(j);

				if (nds->prefix_final_flag)
					prefix_final_states[i].PushBack(j);
			}
		}
	}

	fsm_states = new ListFSMS(number_of_nd_states);

	ListFSMS::listptr	fsms_listptr;
	VListListFSMSptr	pending_states(number_of_nd_states);

	CFSMStateNode::SetupAllocator(number_of_nd_states);

	CFSMStateNode	*fsm_state_tree		= new CFSMStateNode(0, -1, false);
	CFSMStateNode	*fsm_state_node_ptr	= fsm_state_tree;

	VListInt	fsm_start_nd_list;

	fsm_start_nd_list.PushBack(or_start_index);

	CFSMStateNode::nd_state_list	= &fsm_start_nd_list;
	CFSMStateNode::nd_state_listptr	= fsm_start_nd_list.FirstListPtr();

	while (fsm_state_node_ptr)
		fsm_state_node_ptr = fsm_state_node_ptr->InsertOrMatch();

	CFSMState	*new_fsm_state = new CFSMState(0, fsm_start_nd_list);

	fsms_listptr = fsm_states->PushBack(new_fsm_state);

	CFSMStateNode::final_node->fsm_state_flag		= true;
	CFSMStateNode::final_node->fsm_state_listptr	= fsms_listptr;

	pending_states.PushBack(fsms_listptr);

	while (1)
	{
		VListListFSMSptr::listptr	pending_listptr =
										pending_states.FirstListPtr();

		if (!pending_listptr)
			break;

		fsms_listptr = pending_states.FirstData();
		pending_states.PopFront();

		CFSMState	*fsms = fsm_states->Data(fsms_listptr);

		VListInt		&nd_list	= fsms->nd_state_list;
		VListIntPtr		nd_listptr	= nd_list.FirstListPtr();

		CNdState	*merge_state = new CNdState;

		while (nd_listptr)
		{
			int		nd_number = nd_list.NextData(nd_listptr);

			*merge_state += *nd_states[nd_number];
		}

		VListNdTrans		&tr_list	= merge_state->transitions;
		VListNdTransPtr		tr_listptr	= tr_list.FirstListPtr();

		while (tr_listptr)
		{
			CNdTransition	*tr = tr_list.NextData(tr_listptr);

			VListInt	&s_list = tr->states;

			CFSMStateNode::nd_state_list	= &s_list;
			CFSMStateNode::nd_state_listptr	= s_list.FirstListPtr();

			fsm_state_node_ptr = fsm_state_tree;

			while (fsm_state_node_ptr)
				fsm_state_node_ptr = fsm_state_node_ptr->InsertOrMatch();

			if (CFSMStateNode::existing_fsm_state)
			{
				CFSMState	*existing_state =
				fsm_states->Data(CFSMStateNode::final_node->fsm_state_listptr);

				fsms->fsm_transitions.PushBack(CFSMState::SPair(
									tr->symbol, existing_state->fsm_number));
			}
			else
			{
				CFSMState	*new_fsm_state =
								new CFSMState(fsm_states->Size(), s_list);

				fsms->fsm_transitions.PushBack(CFSMState::SPair(
									tr->symbol, new_fsm_state->fsm_number));

				fsms_listptr = fsm_states->PushBack(new_fsm_state);

				CFSMStateNode::final_node->fsm_state_flag		= true;
				CFSMStateNode::final_node->fsm_state_listptr	= fsms_listptr;

				pending_states.PushBack(fsms_listptr);
			}
		}

		merge_state->DeleteObjects();
		delete merge_state;
	}

	delete fsm_state_tree;
	delete CFSMStateNode::allocator;

	fsm_count	= fsm_states->Size();
	fsm_table	= new int[fsm_count * input_range];

	for (i=0; i<fsm_count*input_range; i++)
		fsm_table[i] = -1;

	fsms_listptr = fsm_states->FirstListPtr();

	while (fsms_listptr)
	{
		CFSMState	*fsms = fsm_states->NextData(fsms_listptr);

		TValueList<CFSMState::SPair>			&fsm_tr_list	=
												fsms->fsm_transitions;
		TValueList<CFSMState::SPair>::listptr	fsm_tr_listptr	=
												fsm_tr_list.FirstListPtr();

		while (fsm_tr_listptr)
		{
			CFSMState::SPair	p = fsm_tr_list.NextData(fsm_tr_listptr);

			fsm_table[fsms->fsm_number * input_range + p.symbol] = p.fsm_number;
		}
	}

	regexp_match = new int[fsm_count * regexp_count];
	prefix_match = new int[fsm_count * regexp_count];

	fsms_listptr = fsm_states->FirstListPtr();

	while (fsms_listptr)
	{
		CFSMState	*fsms = fsm_states->NextData(fsms_listptr);

		VListInt	&ndsl = fsms->nd_state_list;

		for (i=0; i<regexp_count; i++)
		{
			int		index = fsms->fsm_number * regexp_count + i;

			int		match = 0;
			if (final_states[i].Size() &&
				IntersectionTestInt(ndsl, final_states[i]))
				match = 1;

			regexp_match[index] = match;

			match = 0;
			if (prefix_final_states[i].Size() &&
				IntersectionTestInt(ndsl, prefix_final_states[i]))
				match = 1;

			prefix_match[index] = match;
		}
	}

	terminal_match		= new int[fsm_count * (regexp_count + 1)];
	start_assignment	= new int[regexp_count];
	trailing_context	= new int[regexp_count];
	token_map			= new int[regexp_count];
	filter_map			= new int[regexp_count];
	literal_terminal	= new int[regexp_count];

	for (i=0; i<fsm_count*(regexp_count+1); i++)
		terminal_match[i] = -1;

	int		mask[regexp_count];

	for (i=0; i<regexp_count; i++)
	{
		VListPtrChar	&activations = context_array[i]->start_activations;

		if (!activations.Size() || !start_context.Size() ||
			IntersectionTestChar(start_context, activations))
			mask[i] = 1;
		else
			mask[i] = 0;
	}

	for (i=0; i<fsm_count; i++)
	{
		for (j=0; j<regexp_count; j++)
			if (mask[j] && regexp_match[i * regexp_count + j])
				break;

		if (j < regexp_count)
			terminal_match[i * (regexp_count + 1) + regexp_count] = j;
	}

	for (i=0; i<regexp_count; i++)
	{
		VListPtrChar	&assignments = context_array[i]->start_assignments;

		if (!assignments.Size())
		{
			start_assignment[i] = 0;
			continue;
		}
		else
			start_assignment[i] = 1;

		for (j=0; j<regexp_count; j++)
		{
			VListPtrChar	&activations = context_array[j]->start_activations;

			if (!activations.Size() ||
				IntersectionTestChar(assignments, activations))
				mask[j] = 1;
			else
				mask[j] = 0;
		}

		for (j=0; j<fsm_count; j++)
		{
			for (k=0; k<regexp_count; k++)
				if (mask[k] && regexp_match[j * regexp_count + k])
					break;

			if (k < regexp_count)
				terminal_match[j * (regexp_count + 1) + i] = k;
		}
	}

	for (i=0; i<regexp_count; i++)
		if (prefix_final_states[i].Size())
			trailing_context[i] = 1;
		else
			trailing_context[i] = 0;

	for (i=0; i<regexp_count; i++)
	{
		if (!terminals[i].filter_flag)
			token_map[i] = terminals[i].symbol_index;
		else
			token_map[i] = -2;

		if (terminals[i].filter_flag)
			filter_map[i] = -terminals[i].symbol_index - 1;
		else
			filter_map[i] = -1;

		if (terminals[i].literal_flag)
			literal_terminal[i] = 1;
		else
			literal_terminal[i] = 0;
	}
}
