/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef COMPILERCALCULATE_H
#define COMPILERCALCULATE_H

#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <ctype.h>

class CCompilerCalculate;

#include "filePath.h"
#include "stringToken.h"
#include "compilerData.h"
#include "automaton.h"
#include "parse.h"

class CCompilerCalculate
{
	public:
	CCompilerCalculate(CCompilerData *d)
		: compiler_data(d), automaton(0), parser(0),
			lexical_calculated(false),
			parser_calculated(false),
			error_entries_numbered(false),
			error_entries_calculated(false),
			unit_rule_elimination_calculated(false)
	{
	}

	~CCompilerCalculate()
	{
		delete automaton;
		delete parser;
	}

	CCompilerData		*compiler_data;
	CAutomaton			*automaton;
	CParse				*parser;
	bool				undefined_symbol_rules;
	bool				undefined_entry_precedences;
	bool				lexical_calculated;
	bool				parser_calculated;
	bool				error_entries_numbered;
	bool				error_entries_calculated;
	bool				unit_rule_elimination_calculated;
	bool				conflict_sections_valid;
	bool				error_code_sections_valid;
	bool				generate_lexical_source_files;
	bool				generate_parser_source_files;
	bool				generate_base_source_files;
	bool				generate_tty_source_files;
	bool				source_files_previously_exist;
	bool				code_generation_directory_accesible;
	bool				lexical_single_char_data_h_exists;
	bool				lexical_regexp_data_h_exists;
	bool				lexical_driver_h_exists;
	bool				lexical_driver_cpp_exists;
	bool				lexical_base_h_exists;
	bool				lexical_base_cpp_exists;
	bool				parser_data_h_exists;
	bool				parser_driver_h_exists;
	bool				parser_driver_cpp_exists;
	bool				parser_base_h_exists;
	bool				parser_base_cpp_exists;
	bool				stack_element_h_exists;
	bool				tty_main_cpp_exists;
	bool				tty_makefile_exists;
	string				code_generation_directory_name;
	string				lexical_single_char_data_h_name;
	string				lexical_regexp_data_h_name;
	string				lexical_driver_h_name;
	string				lexical_driver_cpp_name;
	string				lexical_base_h_name;
	string				lexical_base_cpp_name;
	string				parser_data_h_name;
	string				parser_driver_h_name;
	string				parser_driver_cpp_name;
	string				parser_base_h_name;
	string				parser_base_cpp_name;
	string				stack_element_h_name;
	string				tty_main_cpp_name;
	string				tty_makefile_name;
	string				lexical_single_char_data_h_path;
	string				lexical_regexp_data_h_path;
	string				lexical_driver_h_path;
	string				lexical_driver_cpp_path;
	string				lexical_base_h_path;
	string				lexical_base_cpp_path;
	string				parser_data_h_path;
	string				parser_driver_h_path;
	string				parser_driver_cpp_path;
	string				parser_base_h_path;
	string				parser_base_cpp_path;
	string				stack_element_h_path;
	string				tty_main_cpp_path;
	string				tty_makefile_path;

	bool	CalculateLexical();
	bool	CalculateParser();
	void	CalculateErrorEntries();
	void	CalculateUnitRuleElimination();
	bool	GenerateCode(	bool generate_l, bool generate_p, bool generate_b,
							bool unit_rule_flag, string &directory);
	void	GenerateLexicalCode(bool tty, bool rm_table);
	void	GenerateParserCode(bool unit_rule_flag, bool tty);
	void	GenerateBaseAndStackCode();
	void	GenerateTTYCode();
	void	SubstituteIdentifiers();
	int		GlobalSubstitute(	const string &file_path,
								const string &identifier,
								const string &replace);
	void	GetTemporaryFilePath(const string &file_path, string &tfp);
	bool	ValidateConflictSections();
	void	ModifyConflictActions();
	void	ClearConflictSections();
	bool	ValidateErrorCodeSections();
	void	ClearErrorCodeSections();
	string	&MachineStatusString(string &s);
	string	&LexicalStatusString(string &s);
	string	&ParserStatusString(string &s);
	string	&ConflictSectionStatusString(string &s);
	string	&ErrorEntriesStatusString(string &s);
	string	&ErrorCodeSectionStatusString(string &s);
	string	&UnitRuleEliminationStatusString(string &s);
	string	&GenerateCodeStatusString(string &s);
	string	&LR1MachineStateString(int state, string &s);
	string	&LR0MachineStateString(int state, string &s);
	string	&LALR1LookaheadString(int state, string &s);
	string	&SLR1LookaheadString(int state, string &s);
	bool	GetLexicalCalculated() const
	{ return lexical_calculated; }
	bool	GetParserCalculated() const
	{ return parser_calculated; }
	bool	GetErrorEntriesNumbered() const
	{ return error_entries_numbered; }
	bool	GetErrorEntriesCalculated() const
	{ return error_entries_calculated; }
	bool	GetUnitRuleEliminationCalculated() const
	{ return unit_rule_elimination_calculated; }
	CAutomaton		*GetAutomaton() const
	{ return automaton; }
	CParse			*GetParser() const
	{ return parser; }

	static int	temporary_file_id;

	static const char * const	lexical_base_code_h[];
	static const char * const	lexical_base_code_cpp[];
	static const char * const	parser_base_code_h[];
	static const char * const	parser_base_code_cpp[];
};

#endif
