/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "compilerInterface.h"

int		CCompilerInterface::grammar_submenu_id;

const	CCompilerInterface::SGrammarSubmenuNodeData
		CCompilerInterface::grammar_submenu_node_data[] =
{
	{	MN::mn_popup, ""		, 0		, "&Grammar",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "0"		, 0		, "Terminal",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,0"		, 0		, "Start Context",
		0								, SLOT(ModifyStartContext()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,1"		, 1		, "Insert After",
		0								, SLOT(InsertAfterTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,2"		, 2		, "Insert Before",
		0								, SLOT(InsertBeforeTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,3"		, 3		, "Edit",
		0								, SLOT(EditTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,4"		, 4		, "Delete",
		0								, SLOT(DeleteTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,5"		, 5		, "Move Up",
		0								, SLOT(MoveTerminalUp()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,6"		, 6		, "Move Down",
		0								, SLOT(MoveTerminalDown()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "1"		, 0		, "Error Token",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,0"		, 0		, "Insert After",
		0								, SLOT(InsertAfterErrorToken()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,1"		, 1		, "Insert Before",
		0								, SLOT(InsertBeforeErrorToken()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,2"		, 2		, "Edit",
		0								, SLOT(EditErrorToken()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,3"		, 3		, "Delete",
		0								, SLOT(DeleteErrorToken()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,4"		, 4		, "Move Up",
		0								, SLOT(MoveErrorTokenUp()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,5"		, 5		, "Move Down",
		0								, SLOT(MoveErrorTokenDown()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "2"		, 0		, "NonTerminal",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,0"		, 0		, "Insert After",
		0								, SLOT(InsertAfterNonTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,1"		, 1		, "Insert Before",
		0								, SLOT(InsertBeforeNonTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,2"		, 2		, "Edit",
		0								, SLOT(EditNonTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,3"		, 3		, "Delete",
		0								, SLOT(DeleteNonTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,4"		, 4		, "Move Up",
		0								, SLOT(MoveNonTerminalUp()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,5"		, 5		, "Move Down",
		0								, SLOT(MoveNonTerminalDown()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "3"		, 0		, "Precedence",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,0"		, 0		, "Insert After",
		0								, SLOT(InsertAfterPrecedence()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,1"		, 1		, "Insert Before",
		0								, SLOT(InsertBeforePrecedence()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,2"		, 2		, "Edit",
		0								, SLOT(EditPrecedence()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,3"		, 3		, "Delete",
		0								, SLOT(DeletePrecedence()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,4"		, 4		, "Move Up",
		0								, SLOT(MovePrecedenceUp()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,5"		, 5		, "Move Down",
		0								, SLOT(MovePrecedenceDown()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "4"		, 0		, "Rule",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,0"		, 0		, "Insert After",
		0								, SLOT(InsertAfterRule()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,1"		, 1		, "Insert Before",
		0								, SLOT(InsertBeforeRule()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,2"		, 2		, "Edit",
		0								, SLOT(EditRule()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,3"		, 3		, "Delete",
		0								, SLOT(DeleteRule()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,4"		, 4		, "Move Up",
		0								, SLOT(MoveRuleUp()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,5"		, 5		, "Move Down",
		0								, SLOT(MoveRuleDown()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_sep	, "5"		, 0		, "",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "6"		, 1		, "Undo",
		0								, SLOT(UndoGrammar()),
		MN::mn_enable			,MN::mn_disable	},

	{   MN::menu_node_type_end, 0, 0, 0, 0, 0, 0, 0 }
};

int		CCompilerInterface::parser_submenu_id;

const	CCompilerInterface::SParserSubmenuNodeData
		CCompilerInterface::parser_submenu_node_data[] =
{
	{	MN::mn_popup, ""		, 0		, "&Parser",
		0								, 0,
		MN::mn_enable			,MN::mn_enable			,MN::mn_enable,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0"		, 0		, "Calculate",
		0								, SLOT(CalculateDialog()),
		MN::mn_enable			,MN::mn_enable			,MN::mn_enable,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1"		, 1		, "Error Entries",
		0								, SLOT(ErrorEntriesDialog()),
		MN::mn_disable			,MN::mn_disable			,MN::mn_enable,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2"		, 2		, "Unit Rules",
		0								, SLOT(UnitRulesDialog()),
		MN::mn_disable			,MN::mn_disable			,MN::mn_disable,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3"		, 3		, "Generate Code",
		0								, SLOT(GenerateCodeDialog()),
		MN::mn_disable			,MN::mn_enable			,MN::mn_enable,
		MN::mn_enable			,MN::mn_disable	},

	{   MN::menu_node_type_end, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
};

int		CCompilerInterface::code_submenu_id;

const	CCompilerInterface::SCodeSubmenuNodeData
		CCompilerInterface::code_submenu_node_data[] =
{
	{	MN::mn_popup, ""		, 0		, "&Code",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "0"		, 0		, "Terminal",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,0"		, 0		, "Find String",
		0								, SLOT(FindStringTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,1"		, 1		, "Undo Edit",
		0								, SLOT(UndoEditTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,2"		, 2		, "Redo Edit",
		0								, SLOT(RedoEditTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,3"		, 3		, "Clear",
		0								, SLOT(ClearTerminal()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "1"		, 0		, "Rule",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,0"		, 0		, "Find String",
		0								, SLOT(FindStringRule()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,1"		, 1		, "Undo Edit",
		0								, SLOT(UndoEditRule()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,2"		, 2		, "Redo Edit",
		0								, SLOT(RedoEditRule()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,3"		, 3		, "Clear",
		0								, SLOT(ClearRule()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "2"		, 0		, "Class",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,0"		, 0		, "Find String",
		0								, SLOT(FindStringClass()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,1"		, 1		, "Undo Edit",
		0								, SLOT(UndoEditClass()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,2"		, 2		, "Redo Edit",
		0								, SLOT(RedoEditClass()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "2,3"		, 3		, "Clear",
		0								, SLOT(ClearClass()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "3"		, 0		, "Conflict",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,0"		, 0		, "Find String",
		0								, SLOT(FindStringConflict()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,1"		, 1		, "Undo Edit",
		0								, SLOT(UndoEditConflict()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,2"		, 2		, "Redo Edit",
		0								, SLOT(RedoEditConflict()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "3,3"		, 3		, "Clear",
		0								, SLOT(ClearConflict()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "4"		, 0		, "Error",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,0"		, 0		, "Find String",
		0								, SLOT(FindStringError()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,1"		, 1		, "Undo Edit",
		0								, SLOT(UndoEditError()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,2"		, 2		, "Redo Edit",
		0								, SLOT(RedoEditError()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "4,3"		, 3		, "Clear",
		0								, SLOT(ClearError()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "5"		, 0		, "Source",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "5,0"		, 0		, "Open",
		0								, SLOT(OpenSource()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "5,1"		, 1		, "Save",
		0								, SLOT(SaveSource()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "5,2"		, 2		, "Find String",
		0								, SLOT(FindStringSource()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "5,3"		, 3		, "Undo Edit",
		0								, SLOT(UndoEditSource()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "5,4"		, 4		, "Redo Edit",
		0								, SLOT(RedoEditSource()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "5,5"		, 5		, "Clear",
		0								, SLOT(ClearSource()),
		MN::mn_enable			,MN::mn_disable	},

	{   MN::menu_node_type_end, 0, 0, 0, 0, 0, 0, 0 }
};

int		CCompilerInterface::simulate_submenu_id;

const	CCompilerInterface::SSimulateSubmenuNodeData
		CCompilerInterface::simulate_submenu_node_data[] =
{
	{	MN::mn_popup, ""		, 0		, "&Simulate",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "0"		, 0		, "Control",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,0"		, 0		, "Set Options",
		0								, SLOT(SetSimulatorControlOptions()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,1"		, 1		, "Reset Simulator",
		0								, SLOT(ResetSimulator()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,2"		, 2		, "Next Operation",
		0								, SLOT(NextSimulatorOperation()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,3"		, 3		, "Run Simulator",
		0								, SLOT(RunSimulator()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "0,4"		, 4		, "Expand Parse Tree",
		0								, SLOT(ExpandSimulatorParseTree()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_popup, "1"		, 0		, "Input",
		0								, 0,
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,0"		, 0		, "Open",
		0								, SLOT(OpenSimulateInput()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,1"		, 1		, "Save",
		0								, SLOT(SaveSimulateInput()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,2"		, 2		, "Find String",
		0								, SLOT(FindStringSimulateInput()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,3"		, 3		, "Undo Edit",
		0								, SLOT(UndoEditSimulateInput()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,4"		, 4		, "Redo Edit",
		0								, SLOT(RedoEditSimulateInput()),
		MN::mn_enable			,MN::mn_disable	},

	{	MN::mn_item	, "1,5"		, 5		, "Clear",
		0								, SLOT(ClearSimulateInput()),
		MN::mn_enable			,MN::mn_disable	},

	{   MN::menu_node_type_end, 0, 0, 0, 0, 0, 0, 0 }
};

CCompilerData					*CCompilerInterface::compiler_data_load;
vector< pair<string, int> >		CCompilerInterface::subview_types;
map< string, set<string> >		CCompilerInterface::subview_connection_map;

void	CCompilerInterface::SetupSubviewTypeData()
{
	subview_types.clear();

	subview_types.push_back(pair<string, int>("UNDEFINED_VIEW"			,-1));
	subview_types.push_back(pair<string, int>("TERMINAL_VIEW"			,1));
	subview_types.push_back(pair<string, int>("ERROR_TOKEN_VIEW"		,1));
	subview_types.push_back(pair<string, int>("NONTERMINAL_VIEW"		,1));
	subview_types.push_back(pair<string, int>("IMPLICIT_VIEW"			,1));
	subview_types.push_back(pair<string, int>("PRECEDENCE_VIEW"			,1));
	subview_types.push_back(pair<string, int>("RULE_VIEW"				,1));
	subview_types.push_back(pair<string, int>("CONFLICT_ENTRY_VIEW"		,1));
	subview_types.push_back(pair<string, int>("CONFLICT_STATUS_VIEW"	,1));
	subview_types.push_back(pair<string, int>("CONFLICT_ACTION_VIEW"	,1));
	subview_types.push_back(pair<string, int>("CONFLICT_CODE_VIEW"		,1));
	subview_types.push_back(pair<string, int>("ERROR_SELECT_VIEW"		,1));
	subview_types.push_back(pair<string, int>("ERROR_CODE_VIEW"			,1));
	subview_types.push_back(pair<string, int>("TERMINAL_SELECT_VIEW"	,1));
	subview_types.push_back(pair<string, int>("TERMINAL_CODE_VIEW"		,1));
	subview_types.push_back(pair<string, int>("RULE_SELECT_VIEW"		,1));
	subview_types.push_back(pair<string, int>("RULE_CODE_VIEW"			,1));
	subview_types.push_back(pair<string, int>("CLASS_CODE_VIEW"			,1));
	subview_types.push_back(pair<string, int>("MACHINE_VIEW"			,-1));
	subview_types.push_back(pair<string, int>("SOURCE_VIEW"				,-1));
	subview_types.push_back(pair<string, int>("SIMULATE_CONTROL_VIEW"	,1));
	subview_types.push_back(pair<string, int>("SIMULATE_INPUT_VIEW"		,1));
	subview_types.push_back(pair<string, int>("SIMULATE_TREE_VIEW"		,1));

	set<string>		terminal_connection_types;
	set<string>		error_token_connection_types;
	set<string>		nonterminal_connection_types;
	set<string>		implicit_connection_types;
	set<string>		precedence_connection_types;
	set<string>		rule_connection_types;
	set<string>		conflict_entry_connection_types;
	set<string>		conflict_status_connection_types;
	set<string>		conflict_action_connection_types;
	set<string>		conflict_code_connection_types;
	set<string>		error_select_connection_types;
	set<string>		error_code_connection_types;
	set<string>		terminal_select_connection_types;
	set<string>		terminal_code_connection_types;
	set<string>		rule_select_connection_types;
	set<string>		rule_code_connection_types;
	set<string>		class_code_connection_types;
	set<string>		machine_connection_types;
	set<string>		source_connection_types;
	set<string>		simulate_control_connection_types;
	set<string>		simulate_input_connection_types;
	set<string>		simulate_tree_connection_types;

	terminal_connection_types.insert("ERROR_TOKEN_VIEW");
	terminal_connection_types.insert("NONTERMINAL_VIEW");
	terminal_connection_types.insert("IMPLICIT_VIEW");
	terminal_connection_types.insert("PRECEDENCE_VIEW");
	terminal_connection_types.insert("RULE_VIEW");
	terminal_connection_types.insert("TERMINAL_SELECT_VIEW");

	error_token_connection_types.insert("NONTERMINAL_VIEW");
	error_token_connection_types.insert("IMPLICIT_VIEW");
	error_token_connection_types.insert("PRECEDENCE_VIEW");
	error_token_connection_types.insert("RULE_VIEW");

	nonterminal_connection_types.insert("IMPLICIT_VIEW");
	nonterminal_connection_types.insert("RULE_VIEW");

	rule_connection_types.insert("IMPLICIT_VIEW");
	rule_connection_types.insert("PRECEDENCE_VIEW");
	rule_connection_types.insert("RULE_SELECT_VIEW");

	conflict_entry_connection_types.insert("CONFLICT_STATUS_VIEW");
	conflict_entry_connection_types.insert("CONFLICT_ACTION_VIEW");
	conflict_entry_connection_types.insert("CONFLICT_CODE_VIEW");
	conflict_entry_connection_types.insert("MACHINE_VIEW");

	conflict_status_connection_types.insert("CONFLICT_ENTRY_VIEW");

	conflict_action_connection_types.insert("CONFLICT_ENTRY_VIEW");

	conflict_code_connection_types.insert("CONFLICT_ENTRY_VIEW");

	error_select_connection_types.insert("ERROR_CODE_VIEW");

	error_code_connection_types.insert("ERROR_SELECT_VIEW");

	terminal_select_connection_types.insert("TERMINAL_CODE_VIEW");

	terminal_code_connection_types.insert("TERMINAL_SELECT_VIEW");

	rule_select_connection_types.insert("RULE_CODE_VIEW");

	rule_code_connection_types.insert("RULE_SELECT_VIEW");

	source_connection_types.insert("SOURCE_VIEW");

	simulate_control_connection_types.insert("SIMULATE_INPUT_VIEW");
	simulate_control_connection_types.insert("SIMULATE_TREE_VIEW");
	simulate_control_connection_types.insert("ERROR_SELECT_VIEW");

	subview_connection_map.clear();

	map< string, set<string> >		&scm = subview_connection_map;

	scm["TERMINAL_VIEW"]			= terminal_connection_types;
	scm["ERROR_TOKEN_VIEW"]			= error_token_connection_types;
	scm["NONTERMINAL_VIEW"]			= nonterminal_connection_types;
	scm["IMPLICIT_VIEW"]			= implicit_connection_types;
	scm["PRECEDENCE_VIEW"]			= precedence_connection_types;
	scm["RULE_VIEW"]				= rule_connection_types;
	scm["CONFLICT_ENTRY_VIEW"]		= conflict_entry_connection_types;
	scm["CONFLICT_STATUS_VIEW"] 	= conflict_status_connection_types;
	scm["CONFLICT_ACTION_VIEW"] 	= conflict_action_connection_types;
	scm["CONFLICT_CODE_VIEW"] 		= conflict_code_connection_types;
	scm["ERROR_SELECT_VIEW"] 		= error_select_connection_types;
	scm["ERROR_CODE_VIEW"] 			= error_code_connection_types;
	scm["TERMINAL_SELECT_VIEW"] 	= terminal_select_connection_types;
	scm["TERMINAL_CODE_VIEW"]		= terminal_code_connection_types;
	scm["RULE_SELECT_VIEW"]			= rule_select_connection_types;
	scm["RULE_CODE_VIEW"]			= rule_code_connection_types;
	scm["CLASS_CODE_VIEW"]			= class_code_connection_types;
	scm["MACHINE_VIEW"]				= machine_connection_types;
	scm["SOURCE_VIEW"]				= source_connection_types;
	scm["SIMULATE_CONTROL_VIEW"]	= simulate_control_connection_types;
	scm["SIMULATE_INPUT_VIEW"]		= simulate_input_connection_types;
	scm["SIMULATE_TREE_VIEW"]		= simulate_tree_connection_types;
}

void	CCompilerInterface::SetupConfiguration(
								vector<SInterfaceConfiguration> &c,
								CIdGenerator &submenu_id_generator)
{
	vector< pair<int, SSubmenuNodeData *> >		submenu_node_data;

	SetupSubmenuNodeData(submenu_node_data, submenu_id_generator);

	QDesktopWidget	*dw = QApplication::desktop();

	int		w = dw->width();
	int		h = dw->height();

	const char * const	*default_option_data;

	if (w == 1024 && h == 768)
		default_option_data = compiler_default_1024x768;
	else if (w == 1152 && h == 864)
		default_option_data = compiler_default_1024x768;
	else if (w == 1280 && h == 1024)
		default_option_data = compiler_default_1280x1024;
	else if (w == 1400 && h == 1050)
		default_option_data = compiler_default_1400x1050;
	else if (w == 1600 && h == 1200)
		default_option_data = compiler_default_1400x1050;
	else if (w == 1800 && h == 1440)
		default_option_data = compiler_default_1400x1050;
	else if (w == 1920 && h == 1440)
		default_option_data = compiler_default_1400x1050;
	else
		default_option_data = compiler_default_1024x768;


	c.push_back(SInterfaceConfiguration(".grammar",
										".option",
										"compiler.option",
										default_option_data,
										&subview_types,
										&subview_connection_map,
										submenu_node_data,
										SetupSubviewTypeData,
										CreateInterfaceControl,
										CreateNewData,
										LoadData,
										LoadDataError));
}

int		CCompilerInterface::GetGrammarSubmenuNodeCount(
								const SGrammarSubmenuNodeData *d)
{
	int		index = 0;
	while (d[index].node_type != MN::menu_node_type_end)
		index++;

	return index;
}

int		CCompilerInterface::GetParserSubmenuNodeCount(
								const SParserSubmenuNodeData *d)
{
	int		index = 0;
	while (d[index].node_type != MN::menu_node_type_end)
		index++;

	return index;
}

int		CCompilerInterface::GetCodeSubmenuNodeCount(
								const SCodeSubmenuNodeData *d)
{
	int		index = 0;
	while (d[index].node_type != MN::menu_node_type_end)
		index++;

	return index;
}

int		CCompilerInterface::GetSimulateSubmenuNodeCount(
								const SSimulateSubmenuNodeData *d)
{
	int		index = 0;
	while (d[index].node_type != MN::menu_node_type_end)
		index++;

	return index;
}

void	CCompilerInterface::SetupSubmenuNodeData(
								vector< pair<int, SSubmenuNodeData *> > &d,
								CIdGenerator &submenu_id_generator)
{
	int					i;
	int					node_count;
	SSubmenuNodeData	*snd;

	grammar_submenu_id = submenu_id_generator.GetId();

	node_count = GetGrammarSubmenuNodeCount(grammar_submenu_node_data) + 1;

	snd = new SSubmenuNodeData[node_count];

	for (i=0; i<node_count; i++)
	{
		snd[i] = SSubmenuNodeData(
					grammar_submenu_node_data[i].node_type,
					grammar_submenu_node_data[i].tree_index,
					grammar_submenu_node_data[i].node_identifier,
					grammar_submenu_node_data[i].text,
					grammar_submenu_node_data[i].accelerator,
					grammar_submenu_node_data[i].slot,
					grammar_submenu_node_data[i].operation_list,
					SGrammarSubmenuNodeData::grammar_submenu_operation_count);
	}

	d.push_back(pair<int, SSubmenuNodeData *>(grammar_submenu_id, snd));

	parser_submenu_id = submenu_id_generator.GetId();

	node_count = GetParserSubmenuNodeCount(parser_submenu_node_data) + 1;

	snd = new SSubmenuNodeData[node_count];

	for (i=0; i<node_count; i++)
	{
		snd[i] = SSubmenuNodeData(
					parser_submenu_node_data[i].node_type,
					parser_submenu_node_data[i].tree_index,
					parser_submenu_node_data[i].node_identifier,
					parser_submenu_node_data[i].text,
					parser_submenu_node_data[i].accelerator,
					parser_submenu_node_data[i].slot,
					parser_submenu_node_data[i].operation_list,
					SParserSubmenuNodeData::parser_submenu_operation_count);
	}

	d.push_back(pair<int, SSubmenuNodeData *>(parser_submenu_id, snd));

	code_submenu_id = submenu_id_generator.GetId();

	node_count = GetCodeSubmenuNodeCount(code_submenu_node_data) + 1;

	snd = new SSubmenuNodeData[node_count];

	for (i=0; i<node_count; i++)
	{
		snd[i] = SSubmenuNodeData(
					code_submenu_node_data[i].node_type,
					code_submenu_node_data[i].tree_index,
					code_submenu_node_data[i].node_identifier,
					code_submenu_node_data[i].text,
					code_submenu_node_data[i].accelerator,
					code_submenu_node_data[i].slot,
					code_submenu_node_data[i].operation_list,
					SCodeSubmenuNodeData::code_submenu_operation_count);
	}

	d.push_back(pair<int, SSubmenuNodeData *>(code_submenu_id, snd));

	simulate_submenu_id = submenu_id_generator.GetId();

	node_count = GetSimulateSubmenuNodeCount(simulate_submenu_node_data) + 1;

	snd = new SSubmenuNodeData[node_count];

	for (i=0; i<node_count; i++)
	{
		snd[i] = SSubmenuNodeData(
					simulate_submenu_node_data[i].node_type,
					simulate_submenu_node_data[i].tree_index,
					simulate_submenu_node_data[i].node_identifier,
					simulate_submenu_node_data[i].text,
					simulate_submenu_node_data[i].accelerator,
					simulate_submenu_node_data[i].slot,
					simulate_submenu_node_data[i].operation_list,
					SSimulateSubmenuNodeData::simulate_submenu_operation_count);
	}

	d.push_back(pair<int, SSubmenuNodeData *>(simulate_submenu_id, snd));
}

CCompilerInterface::CCompilerInterface(	int c_id,
										int i_id,
										CMainViewMenu *mvm,
										CMainWindow *mw)
	: CInterfaceControl(c_id, i_id, mvm, mw),
		compiler_data(0), undo_data(0), undo_buffer(0), compiler_calculate(0)
{
}

CCompilerInterface::~CCompilerInterface()
{
	delete compiler_data;
	delete undo_data;
	delete undo_buffer;
	delete compiler_calculate;
}

CInterfaceControl		*CCompilerInterface::CreateInterfaceControl(
					int c_id, int i_id, CMainViewMenu *mvm, CMainWindow *mw)
{
	return new CCompilerInterface(c_id, i_id, mvm, mw);
}

void	CCompilerInterface::CreateNewData()
{
	compiler_data_load = new CCompilerData();

	compiler_data_load->InitializeStackCode();
}

bool	CCompilerInterface::LoadData(ifstream &f)
{
	CreateNewData();

	f >> *compiler_data_load;

	return true;
}

void	CCompilerInterface::LoadDataError()
{
}

void	CCompilerInterface::PostApplicationData()
{
	if (conflict_entry_view)
		conflict_entry_view->PostCurrentEntryChanges();

	if (error_select_view)
		error_select_view->PostCurrentFunctionChanges();

	if (terminal_select_view)
		terminal_select_view->PostCurrentFunctionChanges();

	if (rule_select_view)
		rule_select_view->PostCurrentFunctionChanges();

	if (class_code_view)
		class_code_view->PostCurrentCodeChanges();
}

void	CCompilerInterface::SetApplicationData()
{
	SetCompilerData(compiler_data_load);

	compiler_calculate = new CCompilerCalculate(GetCompilerData());
}

bool	CCompilerInterface::SaveData(ofstream &f)
{
	PostApplicationData();

	compiler_data->CalculateOutputWidths();
	
	f << *compiler_data;

	SetDataModifiedFlag(false);

	return true;
}

void	CCompilerInterface::EnableInterfaceMenu()
{
	main_window->ModifyMenu(
					grammar_submenu_id,
					SGrammarSubmenuNodeData::grammar_submenu_interface_enable,
					this);

	EnableParserSubmenu();

	main_window->ModifyMenu(
					code_submenu_id,
					SCodeSubmenuNodeData::code_submenu_interface_enable,
					this);

	main_window->ModifyMenu(
					simulate_submenu_id,
					SSimulateSubmenuNodeData::simulate_submenu_interface_enable,
					this);
}

void	CCompilerInterface::EnableParserSubmenu()
{
	SParserSubmenuNodeData::Operations	operation;

	if (!compiler_calculate->GetLexicalCalculated() &&
		!compiler_calculate->GetParserCalculated())
	{
		operation = SParserSubmenuNodeData::
						parser_submenu_interface_calculate_enable;
	}
	else if (	compiler_calculate->GetLexicalCalculated() &&
				!compiler_calculate->GetParserCalculated())
	{
		operation = SParserSubmenuNodeData::
						parser_submenu_interface_generate_code_enable;
	}
	else if (	compiler_calculate->GetParserCalculated() &&
				!compiler_calculate->GetErrorEntriesCalculated())
	{
		operation = SParserSubmenuNodeData::
						parser_submenu_interface_error_entries_enable;
	}
	else if (	compiler_calculate->GetParserCalculated() &&
				compiler_calculate->GetErrorEntriesCalculated())
	{
		operation = SParserSubmenuNodeData::
						parser_submenu_interface_unit_rules_enable;
	}

	main_window->ModifyMenu(parser_submenu_id, operation, this);
}

void	CCompilerInterface::DisableInterfaceMenu()
{
	main_window->ModifyMenu(
					grammar_submenu_id,
					SGrammarSubmenuNodeData::grammar_submenu_interface_disable,
					this);

	main_window->ModifyMenu(
					parser_submenu_id,
					SParserSubmenuNodeData::parser_submenu_interface_disable,
					this);

	main_window->ModifyMenu(
					code_submenu_id,
					SCodeSubmenuNodeData::code_submenu_interface_disable,
					this);

	main_window->ModifyMenu(
				simulate_submenu_id,
				SSimulateSubmenuNodeData::simulate_submenu_interface_disable,
				this);
}

void	CCompilerInterface::InitializeModulePointers()
{
	CSubView	*sv;

	sv = FindSubviewTypePointer("UNDEFINED_VIEW");

	if (sv)
		undefined_view = dynamic_cast<CUndefinedView *>(sv);
	else
		undefined_view = 0;

	sv = FindSubviewTypePointer("TERMINAL_VIEW");

	if (sv)
		terminal_view = dynamic_cast<CTerminalView *>(sv);
	else
		terminal_view = 0;

	sv = FindSubviewTypePointer("ERROR_TOKEN_VIEW");

	if (sv)
		error_token_view = dynamic_cast<CErrorTokenView *>(sv);
	else
		error_token_view = 0;

	sv = FindSubviewTypePointer("NONTERMINAL_VIEW");

	if (sv)
		nonterminal_view = dynamic_cast<CNonTerminalView *>(sv);
	else
		nonterminal_view = 0;

	sv = FindSubviewTypePointer("IMPLICIT_VIEW");

	if (sv)
		implicit_view = dynamic_cast<CImplicitView *>(sv);
	else
		implicit_view = 0;

	sv = FindSubviewTypePointer("PRECEDENCE_VIEW");

	if (sv)
		precedence_view = dynamic_cast<CPrecedenceView *>(sv);
	else
		precedence_view = 0;

	sv = FindSubviewTypePointer("RULE_VIEW");

	if (sv)
		rule_view = dynamic_cast<CRuleView *>(sv);
	else
		rule_view = 0;

	sv = FindSubviewTypePointer("CONFLICT_ENTRY_VIEW");

	if (sv)
		conflict_entry_view = dynamic_cast<CConflictEntryView *>(sv);
	else
		conflict_entry_view = 0;

	sv = FindSubviewTypePointer("CONFLICT_STATUS_VIEW");

	if (sv)
		conflict_status_view = dynamic_cast<CConflictStatusView *>(sv);
	else
		conflict_status_view = 0;

	sv = FindSubviewTypePointer("CONFLICT_ACTION_VIEW");

	if (sv)
		conflict_action_view = dynamic_cast<CConflictActionView *>(sv);
	else
		conflict_action_view = 0;

	sv = FindSubviewTypePointer("CONFLICT_CODE_VIEW");

	if (sv)
		conflict_code_view = dynamic_cast<CConflictCodeView *>(sv);
	else
		conflict_code_view = 0;

	sv = FindSubviewTypePointer("ERROR_SELECT_VIEW");

	if (sv)
		error_select_view = dynamic_cast<CErrorSelectView *>(sv);
	else
		error_select_view = 0;

	sv = FindSubviewTypePointer("ERROR_CODE_VIEW");

	if (sv)
		error_code_view = dynamic_cast<CErrorCodeView *>(sv);
	else
		error_code_view = 0;

	sv = FindSubviewTypePointer("TERMINAL_SELECT_VIEW");

	if (sv)
		terminal_select_view = dynamic_cast<CTerminalSelectView *>(sv);
	else
		terminal_select_view = 0;

	sv = FindSubviewTypePointer("TERMINAL_CODE_VIEW");

	if (sv)
		terminal_code_view = dynamic_cast<CTerminalCodeView *>(sv);
	else
		terminal_code_view = 0;

	sv = FindSubviewTypePointer("RULE_SELECT_VIEW");

	if (sv)
		rule_select_view = dynamic_cast<CRuleSelectView *>(sv);
	else
		rule_select_view = 0;

	sv = FindSubviewTypePointer("RULE_CODE_VIEW");

	if (sv)
		rule_code_view = dynamic_cast<CRuleCodeView *>(sv);
	else
		rule_code_view = 0;

	sv = FindSubviewTypePointer("CLASS_CODE_VIEW");

	if (sv)
		class_code_view = dynamic_cast<CClassCodeView *>(sv);
	else
		class_code_view = 0;

	sv = FindSubviewTypePointer("MACHINE_VIEW");

	if (sv)
		machine_view = dynamic_cast<CMachineView *>(sv);
	else
		machine_view = 0;

	sv = FindSubviewTypePointer("SOURCE_VIEW");

	if (sv)
		source_view = dynamic_cast<CSourceView *>(sv);
	else
		source_view = 0;

	sv = FindSubviewTypePointer("SIMULATE_CONTROL_VIEW");

	if (sv)
		simulate_control_view = dynamic_cast<CSimulateControlView *>(sv);
	else
		simulate_control_view = 0;

	sv = FindSubviewTypePointer("SIMULATE_INPUT_VIEW");

	if (sv)
		simulate_input_view = dynamic_cast<CSimulateInputView *>(sv);
	else
		simulate_input_view = 0;

	sv = FindSubviewTypePointer("SIMULATE_TREE_VIEW");

	if (sv)
		simulate_tree_view = dynamic_cast<CSimulateTreeView *>(sv);
	else
		simulate_tree_view = 0;

	SetMultiLineEditTabStopWidth();
	SetSimulateInputViewWordWrap();
}

void	CCompilerInterface::SetModulePointer(CSubView *sv, const string &type)
{
	if (type == "UNDEFINED_VIEW")
		undefined_view = dynamic_cast<CUndefinedView *>(sv);
	else if (type == "TERMINAL_VIEW")
		terminal_view = dynamic_cast<CTerminalView *>(sv);
	else if (type == "ERROR_TOKEN_VIEW")
		error_token_view = dynamic_cast<CErrorTokenView *>(sv);
	else if (type == "NONTERMINAL_VIEW")
		nonterminal_view = dynamic_cast<CNonTerminalView *>(sv);
	else if (type == "IMPLICIT_VIEW")
		implicit_view = dynamic_cast<CImplicitView *>(sv);
	else if (type == "PRECEDENCE_VIEW")
		precedence_view = dynamic_cast<CPrecedenceView *>(sv);
	else if (type == "RULE_VIEW")
		rule_view = dynamic_cast<CRuleView *>(sv);
	else if (type == "CONFLICT_ENTRY_VIEW")
		conflict_entry_view = dynamic_cast<CConflictEntryView *>(sv);
	else if (type == "CONFLICT_STATUS_VIEW")
		conflict_status_view = dynamic_cast<CConflictStatusView *>(sv);
	else if (type == "CONFLICT_ACTION_VIEW")
		conflict_action_view = dynamic_cast<CConflictActionView *>(sv);
	else if (type == "CONFLICT_CODE_VIEW")
		conflict_code_view = dynamic_cast<CConflictCodeView *>(sv);
	else if (type == "ERROR_SELECT_VIEW")
		error_select_view = dynamic_cast<CErrorSelectView *>(sv);
	else if (type == "ERROR_CODE_VIEW")
		error_code_view = dynamic_cast<CErrorCodeView *>(sv);
	else if (type == "TERMINAL_SELECT_VIEW")
		terminal_select_view = dynamic_cast<CTerminalSelectView *>(sv);
	else if (type == "TERMINAL_CODE_VIEW")
		terminal_code_view = dynamic_cast<CTerminalCodeView *>(sv);
	else if (type == "RULE_SELECT_VIEW")
		rule_select_view = dynamic_cast<CRuleSelectView *>(sv);
	else if (type == "RULE_CODE_VIEW")
		rule_code_view = dynamic_cast<CRuleCodeView *>(sv);
	else if (type == "CLASS_CODE_VIEW")
		class_code_view = dynamic_cast<CClassCodeView *>(sv);
	else if (type == "MACHINE_VIEW")
		machine_view = dynamic_cast<CMachineView *>(sv);
	else if (type == "SOURCE_VIEW")
		source_view = dynamic_cast<CSourceView *>(sv);
	else if (type == "SIMULATE_CONTROL_VIEW")
		simulate_control_view = dynamic_cast<CSimulateControlView *>(sv);
	else if (type == "SIMULATE_INPUT_VIEW")
		simulate_input_view = dynamic_cast<CSimulateInputView *>(sv);
	else if (type == "SIMULATE_TREE_VIEW")
		simulate_tree_view = dynamic_cast<CSimulateTreeView *>(sv);
}

CSubView	*CCompilerInterface::CreateSubView(
				QWidget *p,
				CViewNode *n,
				CInterfaceControl *ic,
				SMainViewControl *mvc,
				const string &dfs,
				CPaletteData *dpd,
				COptionData::SSubViewData *d)
{
	if (d->GetSubViewName() == "UNDEFINED_VIEW")
		return new CUndefinedView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "TERMINAL_VIEW")
		return new CTerminalView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "ERROR_TOKEN_VIEW")
		return new CErrorTokenView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "NONTERMINAL_VIEW")
		return new CNonTerminalView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "IMPLICIT_VIEW")
		return new CImplicitView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "PRECEDENCE_VIEW")
		return new CPrecedenceView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "RULE_VIEW")
		return new CRuleView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "CONFLICT_ENTRY_VIEW")
		return new CConflictEntryView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "CONFLICT_STATUS_VIEW")
		return new CConflictStatusView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "CONFLICT_ACTION_VIEW")
		return new CConflictActionView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "CONFLICT_CODE_VIEW")
		return new CConflictCodeView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "ERROR_SELECT_VIEW")
		return new CErrorSelectView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "ERROR_CODE_VIEW")
		return new CErrorCodeView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "TERMINAL_SELECT_VIEW")
		return new CTerminalSelectView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "TERMINAL_CODE_VIEW")
		return new CTerminalCodeView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "RULE_SELECT_VIEW")
		return new CRuleSelectView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "RULE_CODE_VIEW")
		return new CRuleCodeView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "CLASS_CODE_VIEW")
		return new CClassCodeView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "MACHINE_VIEW")
		return new CMachineView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "SOURCE_VIEW")
		return new CSourceView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "SIMULATE_CONTROL_VIEW")
		return new CSimulateControlView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "SIMULATE_INPUT_VIEW")
		return new CSimulateInputView(p, n, ic, mvc, dfs, dpd, d);
	else if (d->GetSubViewName() == "SIMULATE_TREE_VIEW")
		return new CSimulateTreeView(p, n, ic, mvc, dfs, dpd, d);
	else
		return new CUndefinedView(p, n, ic, mvc, dfs, dpd, d);
}

void	CCompilerInterface::SetMultiLineEditTabStopWidth()
{
	COptionData		*d = GetOptionData();

	string		*tab_string;
	string		id("MULTI_LINE_EDIT_TAB_STOP_WIDTH");

	if (tab_string = d->GetAuxiliaryString(id))
	{
		istrstream		is(tab_string->c_str());
		int				tab_width;

		is >> tab_width;

		if (tab_width >= 1 && tab_width <= 20)
		{
			if (conflict_code_view)
				conflict_code_view->SetTabStopWidth(tab_width);

			if (error_code_view)
				error_code_view->SetTabStopWidth(tab_width);

			if (terminal_code_view)
				terminal_code_view->SetTabStopWidth(tab_width);

			if (rule_code_view)
				rule_code_view->SetTabStopWidth(tab_width);

			if (class_code_view)
				class_code_view->SetTabStopWidth(tab_width);

			if (source_view)
				source_view->SetTabStopWidth(tab_width);

			if (simulate_input_view)
				simulate_input_view->SetTabStopWidth(tab_width);
		}
	}
}

void	CCompilerInterface::SetSimulateInputViewWordWrap()
{
	COptionData		*d = GetOptionData();

	string		*wrap_string;
	string		id("SIMULATE_INPUT_VIEW_WORD_WRAP");

	if (wrap_string = d->GetAuxiliaryString(id))
	{
		static QRegExp		regexp("(T|t)(R|r)(U|u)(E|e)");

		if (simulate_input_view)
		{
			if (regexp.exactMatch(wrap_string->c_str()))
				simulate_input_view->SetWordWrap(true);
			else
				simulate_input_view->SetWordWrap(false);
		}
	}
}

void	CCompilerInterface::CalculateMachine(
								bool calculate_l,
								CCompilerData::FiniteStateMachineType l_type,
								int range,
								bool calculate_p,
								CCompilerData::ParserType p_type)
{
	bool	a1 = compiler_data->GetLexicalAutomatonCalculate();

	CCompilerData::FiniteStateMachineType
			a2 = compiler_data->GetLexicalFiniteStateMachineType();

	int		a3 = compiler_data->GetLexicalInputRange();
	bool	a4 = compiler_data->GetParserAutomatonCalculate();

	CCompilerData::ParserType
			a5 = compiler_data->GetParserType();

	if (a1 != calculate_l	||
		a2 != l_type		||
		a3 != range			||
		a4 != calculate_p	||
		a5 != p_type)
	{
		compiler_data->SetLexicalAutomatonCalculate(calculate_l);
		compiler_data->SetLexicalFiniteStateMachineType(l_type);
		compiler_data->SetLexicalInputRange(range);
		compiler_data->SetParserAutomatonCalculate(calculate_p);
		compiler_data->SetParserType(p_type);

		SetDataModifiedFlag(true);
	}

	compiler_calculate->CalculateLexical();
	compiler_calculate->CalculateParser();

	if (compiler_calculate->GetParserCalculated())
	{
		if (compiler_calculate->ValidateConflictSections())
			compiler_calculate->ModifyConflictActions();
		else
		{
			compiler_calculate->ClearConflictSections();
			compiler_calculate->ClearErrorCodeSections();

			SetDataModifiedFlag(true);
		}
	}

	if (conflict_entry_view)
		conflict_entry_view->UpdateListView();

	if (error_select_view)
		error_select_view->UpdateListView();

	if (simulate_control_view)
		simulate_control_view->InitializeSimulator();
}

void	CCompilerInterface::CalculateErrorEntries(
									CCompilerData::ErrorCalculation c,
									CCompilerData::ErrorFunctionNumbering n,
									CCompilerData::ErrorFunctionAggregation a)
{
	CCompilerData::ErrorCalculation
		a1 = compiler_data->GetParserErrorCalculation();

	CCompilerData::ErrorFunctionNumbering
		a2 = compiler_data->GetParserErrorFunctionNumbering();

	CCompilerData::ErrorFunctionAggregation
		a3 = compiler_data->GetParserErrorFunctionAggregation();

	if (a1 != c || a2 != n || a3 != a)
	{
		compiler_data->SetParserErrorCalculation(c);
		compiler_data->SetParserErrorFunctionNumbering(n);
		compiler_data->SetParserErrorFunctionAggregation(a);

		SetDataModifiedFlag(true);
	}

	compiler_calculate->CalculateErrorEntries();

	if (!compiler_calculate->ValidateErrorCodeSections())
	{
		compiler_calculate->ClearErrorCodeSections();

		SetDataModifiedFlag(true);
	}

	if (error_select_view)
		error_select_view->UpdateListView();

	if (simulate_control_view)
		simulate_control_view->InitializeSimulator();
}

void	CCompilerInterface::CalculateUnitRuleElimination(bool calculate)
{
	bool	a1 = compiler_data->GetParserOptimizeUnitRuleReduction();

	if (a1 != calculate)
	{
		compiler_data->SetParserOptimizeUnitRuleReduction(calculate);

		SetDataModifiedFlag(true);
	}

	compiler_calculate->CalculateUnitRuleElimination();

	if (simulate_control_view)
		simulate_control_view->InitializeSimulator();
}

void	CCompilerInterface::GenerateCode(	bool generate_l,
											bool generate_p,
											bool generate_b,
											bool unit_rule_flag,
											string &directory,
											string &l_prefix,
											string &p_prefix,
											string &b_prefix,
											bool tty,
											bool rm_table)
{
	const string	&a1 = compiler_data->GetLexicalPrefixName();
	const string	&a2 = compiler_data->GetParserPrefixName();
	const string	&a3 = compiler_data->GetBasePrefixName();
	bool			a4  = compiler_data->GetGenerateBaseClasses();
	bool			a5  = compiler_data->GetParserOptimizeUnitRuleReduction();
	bool			a6  = compiler_data->GetGenerateTTYCode();
	bool			a7  = compiler_data->GetRegexpMatchTable();

	if (a1 != l_prefix || a2 != p_prefix || a3 != b_prefix ||
		a4 != generate_b || a5 != unit_rule_flag || a6 != tty || a7 != rm_table)
	{
		compiler_data->SetLexicalPrefixName(l_prefix);
		compiler_data->SetParserPrefixName(p_prefix);
		compiler_data->SetBasePrefixName(b_prefix);
		compiler_data->SetGenerateBaseClasses(generate_b);
		compiler_data->SetParserOptimizeUnitRuleReduction(unit_rule_flag);
		compiler_data->SetGenerateTTYCode(tty);
		compiler_data->SetRegexpMatchTable(rm_table);

		SetDataModifiedFlag(true);
	}

	PostApplicationData();

	compiler_calculate->GenerateCode(	generate_l, generate_p, generate_b,
										unit_rule_flag, directory);
}

string	&CCompilerInterface::MachineStatusString(string &s)
{
	return compiler_calculate->MachineStatusString(s);
}

string	&CCompilerInterface::LexicalStatusString(string &s)
{
	return compiler_calculate->LexicalStatusString(s);
}

string	&CCompilerInterface::ParserStatusString(string &s)
{
	return compiler_calculate->ParserStatusString(s);
}

string	&CCompilerInterface::ConflictSectionStatusString(string &s)
{
	return compiler_calculate->ConflictSectionStatusString(s);
}

string	&CCompilerInterface::ErrorEntriesStatusString(string &s)
{
	return compiler_calculate->ErrorEntriesStatusString(s);
}

string	&CCompilerInterface::ErrorCodeSectionStatusString(string &s)
{
	return compiler_calculate->ErrorCodeSectionStatusString(s);
}

string	&CCompilerInterface::UnitRuleEliminationStatusString(string &s)
{
	return compiler_calculate->UnitRuleEliminationStatusString(s);
}

string	&CCompilerInterface::GenerateCodeStatusString(string &s)
{
	return compiler_calculate->GenerateCodeStatusString(s);
}

void	CCompilerInterface::ModifyStartContext()
{
	if (terminal_view)
		terminal_view->ModifyStartContext();
}

void	CCompilerInterface::InsertAfterTerminal()
{
	if (terminal_view)
		terminal_view->InsertAfterTerminal();
}

void	CCompilerInterface::InsertBeforeTerminal()
{
	if (terminal_view)
		terminal_view->InsertBeforeTerminal();
}

void	CCompilerInterface::EditTerminal()
{
	if (terminal_view)
		terminal_view->EditTerminal();
}

void	CCompilerInterface::DeleteTerminal()
{
	if (terminal_view)
		terminal_view->DeleteTerminal();
}

void	CCompilerInterface::MoveTerminalUp()
{
	if (terminal_view)
		terminal_view->MoveTerminalUp();
}

void	CCompilerInterface::MoveTerminalDown()
{
	if (terminal_view)
		terminal_view->MoveTerminalDown();
}

void	CCompilerInterface::InsertAfterErrorToken()
{
	if (error_token_view)
		error_token_view->InsertAfterErrorToken();
}

void	CCompilerInterface::InsertBeforeErrorToken()
{
	if (error_token_view)
		error_token_view->InsertBeforeErrorToken();
}

void	CCompilerInterface::EditErrorToken()
{
	if (error_token_view)
		error_token_view->EditErrorToken();
}

void	CCompilerInterface::DeleteErrorToken()
{
	if (error_token_view)
		error_token_view->DeleteErrorToken();
}

void	CCompilerInterface::MoveErrorTokenUp()
{
	if (error_token_view)
		error_token_view->MoveErrorTokenUp();
}

void	CCompilerInterface::MoveErrorTokenDown()
{
	if (error_token_view)
		error_token_view->MoveErrorTokenDown();
}

void	CCompilerInterface::InsertAfterNonTerminal()
{
	if (nonterminal_view)
		nonterminal_view->InsertAfterNonTerminal();
}

void	CCompilerInterface::InsertBeforeNonTerminal()
{
	if (nonterminal_view)
		nonterminal_view->InsertBeforeNonTerminal();
}

void	CCompilerInterface::EditNonTerminal()
{
	if (nonterminal_view)
		nonterminal_view->EditNonTerminal();
}

void	CCompilerInterface::DeleteNonTerminal()
{
	if (nonterminal_view)
		nonterminal_view->DeleteNonTerminal();
}

void	CCompilerInterface::MoveNonTerminalUp()
{
	if (nonterminal_view)
		nonterminal_view->MoveNonTerminalUp();
}

void	CCompilerInterface::MoveNonTerminalDown()
{
	if (nonterminal_view)
		nonterminal_view->MoveNonTerminalDown();
}

void	CCompilerInterface::InsertAfterPrecedence()
{
	if (precedence_view)
		precedence_view->InsertAfterPrecedence();
}

void	CCompilerInterface::InsertBeforePrecedence()
{
	if (precedence_view)
		precedence_view->InsertBeforePrecedence();
}

void	CCompilerInterface::EditPrecedence()
{
	if (precedence_view)
		precedence_view->EditPrecedence();
}

void	CCompilerInterface::DeletePrecedence()
{
	if (precedence_view)
		precedence_view->DeletePrecedence();
}

void	CCompilerInterface::MovePrecedenceUp()
{
	if (precedence_view)
		precedence_view->MovePrecedenceUp();
}

void	CCompilerInterface::MovePrecedenceDown()
{
	if (precedence_view)
		precedence_view->MovePrecedenceDown();
}

void	CCompilerInterface::InsertAfterRule()
{
	if (rule_view)
		rule_view->InsertAfterRule();
}

void	CCompilerInterface::InsertBeforeRule()
{
	if (rule_view)
		rule_view->InsertBeforeRule();
}

void	CCompilerInterface::EditRule()
{
	if (rule_view)
		rule_view->EditRule();
}

void	CCompilerInterface::DeleteRule()
{
	if (rule_view)
		rule_view->DeleteRule();
}

void	CCompilerInterface::MoveRuleUp()
{
	if (rule_view)
		rule_view->MoveRuleUp();
}

void	CCompilerInterface::MoveRuleDown()
{
	if (rule_view)
		rule_view->MoveRuleDown();
}

void	CCompilerInterface::CalculateDialog()
{
	ParserDialog::SetCalculatePaletteAndFont(GetOptionData());

	CCalculateDialog     *cd = ParserDialog::calculate_dialog;

	cd->SetTitleAndResize("Calculate Parser");
	cd->SetCompilerInterfacePointer(this);

	cd->exec();
}

void	CCompilerInterface::ErrorEntriesDialog()
{
	ParserDialog::SetErrorEntriesPaletteAndFont(GetOptionData());

	CErrorEntriesDialog		*ed = ParserDialog::error_entries_dialog;

	ed->SetTitleAndResize("Calculate Essential Error Entries");
	ed->SetCompilerInterfacePointer(this);

	ed->exec();
}

void	CCompilerInterface::UnitRulesDialog()
{
	ParserDialog::SetUnitRulesPaletteAndFont(GetOptionData());

	CUnitRulesDialog	*ud = ParserDialog::unit_rules_dialog;

	ud->SetTitleAndResize("Calculate Unit Rule Eliminations");
	ud->SetCompilerInterfacePointer(this);

	ud->exec();
}

void	CCompilerInterface::GenerateCodeDialog()
{
	ParserDialog::SetGenerateCodePaletteAndFont(GetOptionData());

	CGenerateCodeDialog		*gd = ParserDialog::generate_code_dialog;

	gd->SetTitleAndResize("Generate Code");
	gd->SetCompilerInterfacePointer(this);

	gd->exec();
}

void	CCompilerInterface::FindStringTerminal()
{
	if (terminal_code_view)
		terminal_code_view->FindString();
}

void	CCompilerInterface::UndoEditTerminal()
{
	if (terminal_code_view)
		terminal_code_view->UndoEdit();
}

void	CCompilerInterface::RedoEditTerminal()
{
	if (terminal_code_view)
		terminal_code_view->RedoEdit();
}

void	CCompilerInterface::ClearTerminal()
{
	if (terminal_code_view)
	{
		terminal_code_view->ClearMultiLineEditText();

		SetDataModifiedFlag(true);
	}
}

void	CCompilerInterface::FindStringRule()
{
	if (rule_code_view)
		rule_code_view->FindString();
}

void	CCompilerInterface::UndoEditRule()
{
	if (rule_code_view)
		rule_code_view->UndoEdit();
}

void	CCompilerInterface::RedoEditRule()
{
	if (rule_code_view)
		rule_code_view->RedoEdit();
}

void	CCompilerInterface::ClearRule()
{
	if (rule_code_view)
	{
		rule_code_view->ClearMultiLineEditText();

		SetDataModifiedFlag(true);
	}
}

void	CCompilerInterface::FindStringClass()
{
	if (class_code_view)
		class_code_view->FindString();
}

void	CCompilerInterface::UndoEditClass()
{
	if (class_code_view)
		class_code_view->UndoEdit();
}

void	CCompilerInterface::RedoEditClass()
{
	if (class_code_view)
		class_code_view->RedoEdit();
}

void	CCompilerInterface::ClearClass()
{
	if (class_code_view)
	{
		class_code_view->ClearCodeSection();

		SetDataModifiedFlag(true);
	}
}

void	CCompilerInterface::FindStringConflict()
{
	if (conflict_code_view)
		conflict_code_view->FindString();
}

void	CCompilerInterface::UndoEditConflict()
{
	if (conflict_code_view)
		conflict_code_view->UndoEdit();
}

void	CCompilerInterface::RedoEditConflict()
{
	if (conflict_code_view)
		conflict_code_view->RedoEdit();
}

void	CCompilerInterface::ClearConflict()
{
	if (conflict_code_view)
	{
		conflict_code_view->ClearMultiLineEditText();

		SetDataModifiedFlag(true);
	}
}

void	CCompilerInterface::FindStringError()
{
	if (error_code_view)
		error_code_view->FindString();
}

void	CCompilerInterface::UndoEditError()
{
	if (error_code_view)
		error_code_view->UndoEdit();
}

void	CCompilerInterface::RedoEditError()
{
	if (error_code_view)
		error_code_view->RedoEdit();
}

void	CCompilerInterface::ClearError()
{
	if (error_code_view)
	{
		error_code_view->ClearMultiLineEditText();

		SetDataModifiedFlag(true);
	}
}

void	CCompilerInterface::OpenSource()
{
	if (source_view)
		source_view->OpenSourceFile();
}

void	CCompilerInterface::SaveSource()
{
	if (source_view)
		source_view->SaveSourceFile();
}

void	CCompilerInterface::FindStringSource()
{
	if (source_view)
		source_view->FindString();
}

void	CCompilerInterface::UndoEditSource()
{
	if (source_view)
		source_view->UndoEdit();
}

void	CCompilerInterface::RedoEditSource()
{
	if (source_view)
		source_view->RedoEdit();
}

void	CCompilerInterface::ClearSource()
{
	if (source_view)
		source_view->ClearSourceFile();
}

void	CCompilerInterface::SetSimulatorControlOptions()
{
	if (simulate_control_view)
		simulate_control_view->SetControlOptions();
}

void	CCompilerInterface::ResetSimulator()
{
	if (simulate_control_view)
		simulate_control_view->ResetSimulator();
}

void	CCompilerInterface::NextSimulatorOperation()
{
	if (simulate_control_view)
		simulate_control_view->NextOperation();
}

void	CCompilerInterface::RunSimulator()
{
	if (simulate_control_view)
		simulate_control_view->RunSimulator();
}

void	CCompilerInterface::ExpandSimulatorParseTree()
{
	if (simulate_control_view)
		simulate_control_view->ExpandParseTree();
}

void	CCompilerInterface::OpenSimulateInput()
{
	if (simulate_input_view)
		simulate_input_view->OpenSimulateInputFile();
}

void	CCompilerInterface::SaveSimulateInput()
{
	if (simulate_input_view)
		simulate_input_view->SaveSimulateInputFile();
}

void	CCompilerInterface::FindStringSimulateInput()
{
	if (simulate_input_view)
		simulate_input_view->FindString();
}

void	CCompilerInterface::UndoEditSimulateInput()
{
	if (simulate_input_view)
		simulate_input_view->UndoEdit();
}

void	CCompilerInterface::RedoEditSimulateInput()
{
	if (simulate_input_view)
		simulate_input_view->RedoEdit();
}

void	CCompilerInterface::ClearSimulateInput()
{
	if (simulate_input_view)
		simulate_input_view->ClearSimulateInputFile();
}

void	CCompilerInterface::UndoGrammar()
{
	RestoreUndoData();
}

void	CCompilerInterface::StoreUndoData()
{
	delete undo_data;
	delete undo_buffer;

	undo_data	= new CCompilerData();
	undo_buffer	= new strstream;

	PostApplicationData();

	*undo_buffer << *compiler_data;
	*undo_buffer >> *undo_data;
}

void	CCompilerInterface::RestoreUndoData()
{
	if (undo_data)
	{
		CCompilerData	*cd = compiler_data;

		compiler_data	= undo_data;
		undo_data		= cd;

		delete compiler_calculate;

		compiler_calculate = new CCompilerCalculate(compiler_data);

		EnableParserSubmenu();

		if (terminal_view)
			terminal_view->RestoreUndoData();

		if (error_token_view)
			error_token_view->RestoreUndoData();

		if (nonterminal_view)
			nonterminal_view->RestoreUndoData();

		if (implicit_view)
			implicit_view->RestoreUndoData();

		if (precedence_view)
			precedence_view->RestoreUndoData();

		if (rule_view)
			rule_view->RestoreUndoData();

		if (conflict_entry_view)
			conflict_entry_view->RestoreUndoData();

		if (conflict_status_view)
			conflict_status_view->RestoreUndoData();

		if (conflict_action_view)
			conflict_action_view->RestoreUndoData();

		if (conflict_code_view)
			conflict_code_view->RestoreUndoData();

		if (error_select_view)
			error_select_view->RestoreUndoData();

		if (error_code_view)
			error_code_view->RestoreUndoData();

		if (terminal_select_view)
			terminal_select_view->RestoreUndoData();

		if (terminal_code_view)
			terminal_code_view->RestoreUndoData();

		if (rule_select_view)
			rule_select_view->RestoreUndoData();

		if (rule_code_view)
			rule_code_view->RestoreUndoData();

		if (class_code_view)
			class_code_view->RestoreUndoData();

		if (simulate_control_view)
			simulate_control_view->RestoreUndoData();

		if (simulate_input_view)
			simulate_input_view->RestoreUndoData();

		if (simulate_tree_view)
			simulate_tree_view->RestoreUndoData();

		if (terminal_view)
			terminal_view->UpdateListView();

		if (rule_select_view)
			rule_select_view->UpdateListView();

		if (class_code_view)
			class_code_view->UpdateView();

		if (conflict_entry_view)
			conflict_entry_view->UpdateListView();

		if (error_select_view)
			error_select_view->UpdateListView();

		if (simulate_control_view)
			simulate_control_view->InitializeSimulator();
	}
}
