/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef CONFLICTACTIONVIEW_H
#define	CONFLICTACTIONVIEW_H

class CConflictActionListBox;
class CConflictActionVBoxWidget;
class CConflictActionView;

#include <string>
#include <list>

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "conflictEntryView.h"

class CConflictActionListBox: public CListBoxFc
{
	Q_OBJECT
	public:
	CConflictActionListBox(CConflictActionVBoxWidget *v)
		: CListBoxFc((QWidget *)v, "", 4), conflict_action_vbox(v) { }
	~CConflictActionListBox() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);

	private:
	CConflictActionVBoxWidget	*conflict_action_vbox;
	QColor						active_highlight;
	QColor						active_highlighted_text;
	QColor						inactive_highlight;
	QColor						inactive_highlighted_text;
};

class CConflictActionVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CConflictActionVBoxWidget(	QWidget *parent,
								CCompilerInterface *ci,
								SMainViewControl *mvc,
								COptionData::SSubViewData *d,
								CConflictActionView *cav);

	virtual ~CConflictActionVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_box->InitializePalette(p); }
	void	InitializeModulePointers();

	void	ClearListBox();
	void	UpdateListBox(const list<string> &items, int current);
	void	SetCurrentListBoxItem(int current);
	void	RestoreUndoData();

	public slots:
	void	SelectConflictAction(int index);

	private:
	CLabelFc					*label;
	CConflictActionListBox		*list_box;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CConflictActionView			*conflict_action_view;
	ModulePtrMap				&module_ptr_map;
};

class CConflictActionView: public CSubView
{
	public:
	CConflictActionView(QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CConflictActionView();

	virtual CConflictActionVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ClearListBox();
	void	UpdateListBox(const list<string> &items, int current);
	void	SetCurrentListBoxItem(int current);
	void	RestoreUndoData();

	private:
	CConflictActionVBoxWidget		*frame;
};

#endif
