/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef CONFLICTENTRYVIEW_H
#define	CONFLICTENTRYVIEW_H

class CConflictEntryListView;
class CConflictEntryVBoxWidget;
class CConflictEntryView;

#include <qobject.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qheader.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "conflictStatusView.h"
#include "conflictActionView.h"
#include "conflictCodeView.h"
#include "machineView.h"
#include "optionDialog.h"

class CConflictEntryListView: public QListView
{
	Q_OBJECT
	public:
	CConflictEntryListView(CConflictEntryVBoxWidget *v)
		: QListView((QWidget *)v, 0, 0), conflict_entry_vbox(v) { }
	~CConflictEntryListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);

	private:
	CConflictEntryVBoxWidget	*conflict_entry_vbox;
	QColor						active_highlight;
	QColor						active_highlighted_text;
	QColor						inactive_highlight;
	QColor						inactive_highlighted_text;
};

class CConflictEntryVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CConflictEntryVBoxWidget(	QWidget *parent,
								CCompilerInterface *ci,
								SMainViewControl *mvc,
								COptionData::SSubViewData *d,
								CConflictEntryView *cev);

	virtual ~CConflictEntryVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	UpdateListView();
	void	ClearCodeCurrentEntry();
	void	ClearCodeAll();
	void	DefaultResetCurrentEntry();
	void	DefaultResetAll();
	void	SelectConflictAction(int index);
	void	GetCurrentEntryString(string &s);
	void	PostCurrentEntryChanges();
	void	RestoreUndoData();
	void	CodeTextChanged();

	public slots:
	void	SelectConflictEntry(QListViewItem *item);

	private:
	CLabelFc				*label;
	CConflictEntryListView	*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CConflictEntryView			*conflict_entry_view;
	ModulePtrMap				&module_ptr_map;

	CConflictStatusView		*csv;
	CConflictActionView		*cav;
	CConflictCodeView		*ccv;

	CSymbolInformation		*symbols;
	CRuleInformation		*rules;
	ListConflict			*conflicts;

	bool	parser_calculated;
	int		shift_action;
	int		conflict_entry;
	int		state_index_width;
	int		symbol_index_width;
	int		rule_index_width;
	int		rule_left_name_width;
	int		current_entry;
	void	IndexString(int index, string &s);
	void	EntryString(CConflict *c, string &s);
	void	ActionSummaryString(CConflict *c, string &s);
	void	ResolveString(CConflict *c, string &s);
	void	StateString(CConflict *c, string &s);
	void	SymbolString(CConflict *c, string &s);
	void	ActionStringSet(CConflict *c, list<string> &actions);
	int		ResolveIndex(CConflict *c);
	void	UpdateConflictViews();
};

class CConflictEntryView: public CSubView
{
	public:
	CConflictEntryView(	QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CConflictEntryView();

	virtual CConflictEntryVBoxWidget	*GetWidget() { return frame; }
	virtual void						SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	UpdateListView();
	void	ClearCodeCurrentEntry();
	void	ClearCodeAll();
	void	DefaultResetCurrentEntry();
	void	DefaultResetAll();
	void	SelectConflictAction(int index);
	void	GetCurrentEntryString(string &s);
	void	PostCurrentEntryChanges();
	void	RestoreUndoData();
	void	CodeTextChanged();

	private:
	CConflictEntryVBoxWidget		*frame;
};

#endif
