/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "connectionInterface.h"

using namespace ConnectionInterface;

OptionDataMainViewMap    *ConnectionInterface::
							CreateOptionDataMainViewMap(
							COptionData *d,
							const map< string, set<string> >
								*subview_connection_map)
{
	OptionDataMainViewMap	*odmvm = new OptionDataMainViewMap;

	vector<COptionData::SMainViewData *>::size_type		i;
	vector<COptionData::SViewNodeData *>::size_type		j;

	vector<COptionData::SMainViewData *>	*mv = d->GetMainViewPtrs();

	if (!mv)
		return odmvm;

	for (i=0; i<mv->size(); i++)
	{
		string		main_view_name = (*mv)[i]->GetMainViewName();

		vector<COptionData::SViewNodeData *>	*vn =
											(*mv)[i]->GetViewNodeDataPtrs();

		if (!vn)
			continue;

		for (j=0; j<vn->size(); j++)
		{
			COptionData::SViewNodeData	*view_node_data = (*vn)[j];

			if (view_node_data->GetNodeType() ==
				COptionData::SViewNodeData::SubViewNode)
			{
				COptionData::SSubViewData	*subview_data =
					dynamic_cast<COptionData::SSubViewData *>(view_node_data);

				string		subview_name	= subview_data->GetSubViewName();
				vector<int>	*index			= subview_data->GetIndex();

				OptionDataSubtypeMap	&odsm = (*odmvm)[main_view_name];
				OptionDataIndexMap		&odim = odsm[subview_name];

				odim[*index] =
					pair<COptionData::SSubViewData *, ConnectionMainViewMap *>
						(	subview_data,
							CreateConnectionMainViewMap(
								d, subview_data, subview_connection_map));
			}
		}
	}

	return odmvm;
}

ConnectionMainViewMap	*ConnectionInterface::
							CreateConnectionMainViewMap(
							COptionData *d,
							COptionData::SSubViewData *svd,
							const map< string, set<string> >
								*subview_connection_map)
{
	string		source_module = svd->GetSubViewName();

	map< string, set<string> >::const_iterator	scm_iterator;

	scm_iterator = subview_connection_map->find(source_module);

	set<string>		target_modules;

	if (scm_iterator != subview_connection_map->end())
		target_modules = (*scm_iterator).second;

	ConnectionMainViewMap	*cmvm = new ConnectionMainViewMap;

	vector<COptionData::SMainViewData *>::size_type		i;
	vector<COptionData::SViewNodeData *>::size_type		j;

	vector<COptionData::SMainViewData *>	*mv = d->GetMainViewPtrs();

	for (i=0; i<mv->size(); i++)
	{
		string		main_view_name = (*mv)[i]->GetMainViewName();

		vector<COptionData::SViewNodeData *>	*vn =
											(*mv)[i]->GetViewNodeDataPtrs();

		if (!vn)
			continue;

		for (j=0; j<vn->size(); j++)
		{
			COptionData::SViewNodeData	*view_node_data = (*vn)[j];

			if (view_node_data->GetNodeType() ==
				COptionData::SViewNodeData::SubViewNode)
			{
				COptionData::SSubViewData	*subview_data =
					dynamic_cast<COptionData::SSubViewData *>(view_node_data);

				string		subview_name	= subview_data->GetSubViewName();

				if (target_modules.find(subview_name) !=
					target_modules.end())
				{
					vector<int>	*index			= subview_data->GetIndex();

					ConnectionSubtypeMap	&csm = (*cmvm)[main_view_name];
					ConnectionIndexMap		&cim = csm[subview_name];

					cim[*index] = false;
				}
			}
		}
	}

	InitializeConnectionMainViewMap(svd, cmvm);

	return cmvm;
}

void					ConnectionInterface::
							InitializeConnectionMainViewMap(
								COptionData::SSubViewData *svd,
								ConnectionMainViewMap *cmvm)
{
	ConnectionMainViewMapIterator		cmvm_iterator;
	ConnectionSubtypeMapIterator		csm_iterator;
	ConnectionIndexMapIterator			cim_iterator;

	vector<COptionData::SSubViewData::SInterfaceSpecifier *>
		*interface_specifiers = svd->GetInterfaceSpecifiers();

	if (!interface_specifiers)
		return;

	vector<COptionData::SSubViewData::SInterfaceSpecifier *>::size_type		i;

	for (i=0; i<interface_specifiers->size(); i++)
	{
		COptionData::SSubViewData::SInterfaceSpecifier	*is =
			(*interface_specifiers)[i];

		string		main_view_name	= is->GetMainViewName();
		string		subview_name	= is->GetSubViewName();

		if (main_view_name.length())
		{
			if ((cmvm_iterator = cmvm->find(main_view_name)) != cmvm->end())
			{
				ConnectionSubtypeMap	&csm = (*cmvm_iterator).second;

				if (subview_name.length())
				{
					if ((csm_iterator = csm.find(subview_name)) != csm.end())
					{
						ConnectionIndexMap		&cim = (*csm_iterator).second;

						cim_iterator = cim.begin();

						while (cim_iterator != cim.end())
						{
							(*cim_iterator).second = true;

							cim_iterator++;
						}
					}
				}
				else
				{
					vector<int>		*index = is->GetIndex();

					csm_iterator = csm.begin();

					while (csm_iterator != csm.end())
					{
						ConnectionIndexMap		&cim = (*csm_iterator).second;

						if ((cim_iterator = cim.find(*index)) != cim.end())
						{
							(*cim_iterator).second = true;
							break;
						}

						csm_iterator++;
					}
				}
			}
		}
		else
		{
			cmvm_iterator = cmvm->begin();

			while (cmvm_iterator != cmvm->end())
			{
				ConnectionSubtypeMap	&csm = (*cmvm_iterator).second;

				if ((csm_iterator = csm.find(subview_name)) != csm.end())
				{
					ConnectionIndexMap		&cim = (*csm_iterator).second;

					cim_iterator = cim.begin();

					while (cim_iterator != cim.end())
					{
						(*cim_iterator).second = true;

						cim_iterator++;
					}
				}

				cmvm_iterator++;
			}
		}
	}
}

void					ConnectionInterface::
							StoreOptionDataMainViewMap(
								OptionDataMainViewMap *odmvm)
{
	OptionDataMainViewMapIterator		odmvm_iterator;
	OptionDataSubtypeMapIterator		odsm_iterator;
	OptionDataIndexMapIterator			odim_iterator;

	odmvm_iterator = odmvm->begin();

	while (odmvm_iterator != odmvm->end())
	{
		OptionDataSubtypeMap	&odsm = (*odmvm_iterator).second;

		odsm_iterator = odsm.begin();

		while (odsm_iterator != odsm.end())
		{
			OptionDataIndexMap		&odim = (*odsm_iterator).second;

			odim_iterator = odim.begin();

			while (odim_iterator != odim.end())
			{
				StoreConnectionMainViewMap(	(*odim_iterator).second.first,
											(*odim_iterator).second.second);

				odim_iterator++;
			}

			odsm_iterator++;
		}

		odmvm_iterator++;
	}
}

void					ConnectionInterface::
							StoreConnectionMainViewMap(
								COptionData::SSubViewData *svd,
								ConnectionMainViewMap *cmvm)
{
	set<string>									subtype_set;
	set<string>									completion_set;
	set<string>::iterator						set_iterator;
	map<string, map<string, bool> >				subtype_completion_map;
	map<string, map<string, bool> >::iterator	scm_iterator;
	map<string, bool>::iterator					s_iterator;

	ConnectionMainViewMapIterator		cmvm_iterator;
	ConnectionSubtypeMapIterator		csm_iterator;
	ConnectionIndexMapIterator			cim_iterator;

	cmvm_iterator = cmvm->begin();

	while (cmvm_iterator != cmvm->end())
	{
		string					main_view_name	= (*cmvm_iterator).first;
		ConnectionSubtypeMap	&csm			= (*cmvm_iterator).second;

		csm_iterator = csm.begin();

		while (csm_iterator != csm.end())
		{
			string					subview_name	= (*csm_iterator).first;
			ConnectionIndexMap		&cim			= (*csm_iterator).second;

			subtype_set.insert(subview_name);

			cim_iterator = cim.begin();

			while (cim_iterator != cim.end())
			{
				if ((*cim_iterator).second == false)
					break;

				cim_iterator++;
			}

			map<string, bool>	&subtype_completion =
									subtype_completion_map[main_view_name];

			if (cim_iterator != cim.end())
				subtype_completion[subview_name] = false;
			else
				subtype_completion[subview_name] = true;

			csm_iterator++;
		}

		cmvm_iterator++;
	}

	set_iterator = subtype_set.begin();

	while (set_iterator != subtype_set.end())
	{
		string		subtype = *set_iterator;

		scm_iterator = subtype_completion_map.begin();

		while (scm_iterator != subtype_completion_map.end())
		{
			map<string, bool>	&subtype_completion =
									(*scm_iterator).second;

			if ((s_iterator = subtype_completion.find(subtype)) !=
				subtype_completion.end() &&
					(*s_iterator).second == false)
				break;

			scm_iterator++;
		}

		if (scm_iterator == subtype_completion_map.end())
			completion_set.insert(subtype);

		set_iterator++;
	}

	svd->SetInterfaceSpecifiers(0);

	COptionData::SSubViewData::SInterfaceSpecifier	*is;

	set_iterator = completion_set.begin();

	while (set_iterator != completion_set.end())
	{
		is = new COptionData::SSubViewData::SInterfaceSpecifier();

		is->SetSubViewName(*set_iterator);

		svd->AddInterfaceSpecifier(is);

		subtype_set.erase(*set_iterator);

		set_iterator++;
	}

	cmvm_iterator = cmvm->begin();

	while (cmvm_iterator != cmvm->end())
	{
		string					main_view_name	= (*cmvm_iterator).first;
		ConnectionSubtypeMap	&csm			= (*cmvm_iterator).second;

		csm_iterator = csm.begin();

		while (csm_iterator != csm.end())
		{
			string					subview_name	= (*csm_iterator).first;
			ConnectionIndexMap		&cim			= (*csm_iterator).second;

			if (subtype_set.find(subview_name) != subtype_set.end())
			{
				if (subtype_completion_map[main_view_name][subview_name])
				{
					is = new COptionData::SSubViewData::SInterfaceSpecifier();

					is->SetMainViewName(main_view_name);
					is->SetSubViewName(subview_name);

					svd->AddInterfaceSpecifier(is);
				}
				else
				{
					cim_iterator = cim.begin();

					while (cim_iterator != cim.end())
					{
						if ((*cim_iterator).second)
						{
							is = new COptionData::SSubViewData::
														SInterfaceSpecifier();

							is->SetMainViewName(main_view_name);
							is->SetIndex(
									new vector<int>((*cim_iterator).first));

							svd->AddInterfaceSpecifier(is);
						}

						cim_iterator++;
					}
				}
			}

			csm_iterator++;
		}

		cmvm_iterator++;
	}
}

void					ConnectionInterface::
							DestroyOptionDataMainViewMap(
								OptionDataMainViewMap *odmvm)
{
	if (!odmvm)
		return;

	OptionDataMainViewMapIterator		odmvm_iterator;
	OptionDataSubtypeMapIterator		odsm_iterator;
	OptionDataIndexMapIterator			odim_iterator;

	odmvm_iterator = odmvm->begin();

	while (odmvm_iterator != odmvm->end())
	{
		OptionDataSubtypeMap	&odsm = (*odmvm_iterator).second;

		odsm_iterator = odsm.begin();

		while (odsm_iterator != odsm.end())
		{
			OptionDataIndexMap		&odim = (*odsm_iterator).second;

			odim_iterator = odim.begin();

			while (odim_iterator != odim.end())
			{
				delete (*odim_iterator).second.second;

				odim_iterator++;
			}

			odsm_iterator++;
		}

		odmvm_iterator++;
	}

	delete odmvm;
}

RuntimeMainViewMap		*ConnectionInterface::
							CreateRuntimeMainViewMap(
								CInterfaceControl *ic)
{
	RuntimeMainViewMap		*rmvm = new RuntimeMainViewMap;

	const map<int, SMainViewControl *>	&id_map =
											ic->GetMainViewIdToControlMap();

	map<int, SMainViewControl *>::const_iterator
		id_map_iterator = id_map.begin();

	while (id_map_iterator != id_map.end())
	{
		CViewNode	*view_tree = (*id_map_iterator).second->GetViewTree();

		if (view_tree)
			view_tree->CreateRuntimeModuleMap(rmvm);

		id_map_iterator++;
	}

	return rmvm;
}

void					ConnectionInterface::
							StoreRuntimeMainViewMap(
								CInterfaceControl *ic,
								RuntimeMainViewMap *rmvm)
{
	const map<int, SMainViewControl *>	&id_map =
											ic->GetMainViewIdToControlMap();

	map<int, SMainViewControl *>::const_iterator
		id_map_iterator = id_map.begin();

	while (id_map_iterator != id_map.end())
	{
		CViewNode	*view_tree = (*id_map_iterator).second->GetViewTree();

		if (view_tree)
			view_tree->StoreRuntimeModulePointers(rmvm);

		id_map_iterator++;
	}
}

void					ConnectionInterface::
							ClearRuntimeMainViewMap(
								RuntimeMainViewMap *rmvm)
{
	RuntimeMainViewMapIterator		rmvm_iterator;
	RuntimeSubtypeMapIterator		rsm_iterator;
	RuntimeIndexMapIterator			rim_iterator;

	rmvm_iterator = rmvm->begin();

	while (rmvm_iterator != rmvm->end())
	{
		RuntimeSubtypeMap	&rsm = (*rmvm_iterator).second;

		rsm_iterator = rsm.begin();

		while (rsm_iterator != rsm.end())
		{
			RuntimeIndexMap		&rim = (*rsm_iterator).second;

			rim_iterator = rim.begin();

			while (rim_iterator != rim.end())
			{
				pair<CSubView *, bool>	&p = (*rim_iterator).second;

				p.second = false;

				rim_iterator++;
			}

			rsm_iterator++;
		}

		rmvm_iterator++;
	}
}

void					ConnectionInterface::
							InitializeModulePtrMap(
								RuntimeMainViewMap *rmvm,
								COptionData::SSubViewData *svd,
								ModulePtrMap &mpm)
{
	RuntimeMainViewMapIterator		rmvm_iterator;
	RuntimeSubtypeMapIterator		rsm_iterator;
	RuntimeIndexMapIterator			rim_iterator;

	vector<COptionData::SSubViewData::SInterfaceSpecifier *>
		*interface_specifiers = svd->GetInterfaceSpecifiers();

	if (!interface_specifiers)
		return;

	vector<COptionData::SSubViewData::SInterfaceSpecifier *>::size_type		i;

	for (i=0; i<interface_specifiers->size(); i++)
	{
		COptionData::SSubViewData::SInterfaceSpecifier	*is =
			(*interface_specifiers)[i];

		string		main_view_name	= is->GetMainViewName();
		string		subview_name	= is->GetSubViewName();

		if (main_view_name.length())
		{
			if ((rmvm_iterator = rmvm->find(main_view_name)) != rmvm->end())
			{
				RuntimeSubtypeMap	&rsm = (*rmvm_iterator).second;

				if (subview_name.length())
				{
					if ((rsm_iterator = rsm.find(subview_name)) != rsm.end())
					{
						RuntimeIndexMap		&rim = (*rsm_iterator).second;

						rim_iterator = rim.begin();

						while (rim_iterator != rim.end())
						{
							(*rim_iterator).second.second = true;

							rim_iterator++;
						}
					}
				}
				else
				{
					vector<int>		*index = is->GetIndex();

					rsm_iterator = rsm.begin();

					while (rsm_iterator != rsm.end())
					{
						RuntimeIndexMap		&rim = (*rsm_iterator).second;

						if ((rim_iterator = rim.find(*index)) != rim.end())
						{
							(*rim_iterator).second.second = true;
							break;
						}

						rsm_iterator++;
					}
				}
			}
		}
		else
		{
			rmvm_iterator = rmvm->begin();

			while (rmvm_iterator != rmvm->end())
			{
				RuntimeSubtypeMap	&rsm = (*rmvm_iterator).second;

				if ((rsm_iterator = rsm.find(subview_name)) != rsm.end())
				{
					RuntimeIndexMap		&rim = (*rsm_iterator).second;

					rim_iterator = rim.begin();

					while (rim_iterator != rim.end())
					{
						(*rim_iterator).second.second = true;

						rim_iterator++;
					}
				}

				rmvm_iterator++;
			}
		}
	}

	rmvm_iterator = rmvm->begin();

	while (rmvm_iterator != rmvm->end())
	{
		RuntimeSubtypeMap	&rsm = (*rmvm_iterator).second;

		rsm_iterator = rsm.begin();

		while (rsm_iterator != rsm.end())
		{
			string				subview_name	= (*rsm_iterator).first;
			RuntimeIndexMap		&rim			= (*rsm_iterator).second;

			rim_iterator = rim.begin();

			while (rim_iterator != rim.end())
			{
				pair<CSubView *, bool>	&p = (*rim_iterator).second;

				if (p.second)
				{
					vector<CSubView *>		&v = mpm[subview_name];

					v.push_back(p.first);
				}

				rim_iterator++;
			}

			rsm_iterator++;
		}

		rmvm_iterator++;
	}
}
