/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef CONNECTIONVIEW_H
#define	CONNECTIONVIEW_H

class CConnectionFrameWidget;
class CConnectionView;
struct SDefaultViewItem;
struct SConnectionViewItem;

#include "viewControl.h"
#include "defaultView.h"
#include "defaultInterface.h"

class CConnectionFrameWidget: public CFrameWidget
{
	Q_OBJECT
	public:
	CConnectionFrameWidget(	QWidget *parent,
							CDefaultInterface *di,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CConnectionView *cv);

	virtual ~CConnectionFrameWidget();

	void	SetLineEditText(const QString &s);
	void	InitializeModulePointers();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	public slots:
	void	SelectionChanged();
	void	SendAll();
	void	SendSelected();

	private:
	QGridLayout		*grid_layout;
	CLabelFc		*label;
	CLineEditFc		*line_edit;
	CPushButtonFc	*send_all;
	CPushButtonFc	*send_selected;
	QListView		*connection_list;

	CDefaultInterface			*default_interface;
	COptionData::SSubViewData	*subview_data;
	CConnectionView				*connection_view;
	string						index_text;
	string						default_text;
	ModulePtrMap				&module_ptr_map;
	vector<CDefaultView *>		default_views;
	vector<CConnectionView *>	connection_views;
};

class CConnectionView: public CSubView
{
	public:
	CConnectionView(QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CConnectionView();

	void	SetLineEditText(const QString &s);
	void	SendAll();
	void	SendSelected();

	virtual void	InitializeModulePointers();

	virtual CConnectionFrameWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	protected:
	CConnectionFrameWidget		*frame;
};

struct SSubViewItem: public QListViewItem
{
	SSubViewItem(QListView *p, QString s1, QString s2, QString s3)
		: QListViewItem(p, s1, s2, s3) { }

	virtual ~SSubViewItem() { }

	virtual void	SendText(const QString &s) = 0;
};

struct SDefaultViewItem: public SSubViewItem
{
	SDefaultViewItem(QListView *p, QString s1, QString s2, QString s3,
						CDefaultView *dv)
		: SSubViewItem(p, s1, s2, s3), default_view(dv) { }

	virtual ~SDefaultViewItem() { }

	virtual void	SendText(const QString &s);

	CDefaultView	*default_view;
};

struct SConnectionViewItem: public SSubViewItem
{
	SConnectionViewItem(QListView *p, QString s1, QString s2, QString s3,
						CConnectionView *cv)
		: SSubViewItem(p, s1, s2, s3), connection_view(cv) { }

	virtual ~SConnectionViewItem() { }

	virtual void	SendText(const QString &s);

	CConnectionView		*connection_view;
};

#endif
