/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "errorCodeView.h"

bool	CErrorCodeMultiLineEdit::event(QEvent *e)
{
	bool	tab_flag = error_code_vbox->GetTabIndicator();

	if (e->type() == QEvent::KeyPress)
	{
		if (((QKeyEvent *)e)->key() == Qt::Key_Escape)
		{
			error_code_vbox->ToggleTabIndicator();

			if (!tab_flag)
			{
				this->keyPressEvent((QKeyEvent *)e);
				return true;
			}
		}
		else
		{
			if (((QKeyEvent *)e)->key() == Qt::Key_F1)
				error_code_vbox->ToggleErrorIndicator();
			else if (((QKeyEvent *)e)->key() == Qt::Key_G &&
				((QKeyEvent *)e)->state() == Qt::ControlButton)
				error_code_vbox->FindString();

			if (tab_flag)
			{
				this->keyPressEvent((QKeyEvent *)e);
				return true;
			}
		}
	}
	else if (e->type() == QEvent::KeyRelease)
	{
		if (tab_flag)
		{
			this->keyReleaseEvent((QKeyEvent *)e);
			return true;
		}
	}

	return CMultiLineEditFc::event(e);
}

CErrorCodeVBoxWidget::CErrorCodeVBoxWidget(
									QWidget *parent,
									CCompilerInterface *ci,
									SMainViewControl *mvc,
									COptionData::SSubViewData *d,
									CErrorCodeView *ecv)
	: CVBoxWidget(parent, ci, mvc), compiler_interface(ci),
		subview_data(d), error_code_view(ecv),
		module_ptr_map(ecv->GetModulePtrMap())
{
	label = new CLabelFc("error code", this, true);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	tab_indicator	= false;
	error_indicator	= false;

	multi_line_edit = new CErrorCodeMultiLineEdit(this);

	multi_line_edit->setWordWrap(QMultiLineEdit::NoWrap);

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	setSpacing(0);
	setStretchFactor(label, 0);
	setStretchFactor(multi_line_edit, 1);

	compiler_data = compiler_interface->GetCompilerData();
}

CErrorCodeVBoxWidget::~CErrorCodeVBoxWidget()
{
}

void	CErrorCodeVBoxWidget::ClearMultiLineEditText()
{
	disconnect(	multi_line_edit,
				SIGNAL(textChanged()),
				this,
				SLOT(CodeTextChanged()));

	multi_line_edit->clear();

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	if (error_indicator)
	{
		error_indicator = false;

		ToggleErrorIndicator();
	}
}

void	CErrorCodeVBoxWidget::SetTabStopWidth(int count)
{
	QFontMetrics	fm(font());

	int		w = fm.width(QChar('Z'));

	multi_line_edit->setTabStopWidth(count * w);
}

void	CErrorCodeVBoxWidget::SetMultiLineEditText(const list<string> &code)
{
	disconnect(	multi_line_edit,
				SIGNAL(textChanged()),
				this,
				SLOT(CodeTextChanged()));

	multi_line_edit->clear();

	list<string>::const_iterator	s_iterator = code.begin();

	while (s_iterator != code.end())
	{
		const string	&s = *s_iterator++;

		if (!s.length())
			multi_line_edit->append("\n");
		else
			multi_line_edit->append(s.c_str());
	}

	multi_line_edit->setCursorPosition(0, 0);

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	if (error_indicator)
	{
		error_indicator = false;

		ToggleErrorIndicator();
	}
}

void	CErrorCodeVBoxWidget::GetMultiLineEditText(list<string> &code)
{
	code.clear();

	int		count = multi_line_edit->numLines();
	int		i;

	for (i=0; i<count; i++)
		code.push_back(
			(const char *)(multi_line_edit->textLine(i).local8Bit()));

	if (code.back() == string(""))
		code.pop_back();
}

bool	CErrorCodeVBoxWidget::GetCodeEditedFlag()
{
	return multi_line_edit->edited();
}

void	CErrorCodeVBoxWidget::SetCodeEditedFlag(bool f)
{
	multi_line_edit->setEdited(f);
}

bool	CErrorCodeVBoxWidget::GetTabIndicator()
{
	return tab_indicator;
}

void	CErrorCodeVBoxWidget::ToggleTabIndicator()
{
	string	s1("error code");
	string	s2;

	if (tab_indicator)
	{
		tab_indicator = false;
	}
	else
	{
		s1 += " (tab entry)";

		tab_indicator = true;
	}

	if (error_indicator)
	{
		if (esv)
			esv->GetCurrentFunctionString(s2);

		s1 += ": ";
		s1 += s2;

		label->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	}
	else
		label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	label->setText(s1.c_str());
}

void	CErrorCodeVBoxWidget::ToggleErrorIndicator()
{
	string	s1("error code");
	string	s2;

	if (tab_indicator)
		s1 += " (tab entry)";

	if (error_indicator)
	{
		label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

		error_indicator = false;
	}
	else
	{
		if (esv)
			esv->GetCurrentFunctionString(s2);

		s1 += ": ";
		s1 += s2;

		label->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);

		error_indicator = true;
	}

	label->setText(s1.c_str());
}

void	CErrorCodeVBoxWidget::UndoEdit()
{
	multi_line_edit->undo();
}

void	CErrorCodeVBoxWidget::RedoEdit()
{
	multi_line_edit->redo();
}

void	FindMultiLineEditString(QMultiLineEdit *multi_line_edit);

void	CErrorCodeVBoxWidget::FindString()
{
	FindMultiLineEditString(multi_line_edit);
}

void	CErrorCodeVBoxWidget::InitializeModulePointers()
{
	vector<CSubView *>		&v1 = module_ptr_map["ERROR_SELECT_VIEW"];

	if (v1.size())
		esv = dynamic_cast<CErrorSelectView *>(v1[0]);
	else
		esv = 0;
}

void	CErrorCodeVBoxWidget::RestoreUndoData()
{
	compiler_data = compiler_interface->GetCompilerData();
}

void	CErrorCodeVBoxWidget::CodeTextChanged()
{
	if (esv)
		esv->CodeTextChanged();
}

CErrorCodeView::CErrorCodeView(	QWidget *p,
								CViewNode *n,
								CInterfaceControl *ic,
								SMainViewControl *mvc,
								const string &dfs,
								CPaletteData *dpd,
								COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CErrorCodeVBoxWidget(
		p, dynamic_cast<CCompilerInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
		frame->setPalette(view_node_palette);
	else
		frame->setPalette(frame->palette());
}

CErrorCodeView::~CErrorCodeView()
{
	delete frame;
}

void	CErrorCodeView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CErrorCodeView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CErrorCodeView::InitializeModulePointers()
{
	frame->InitializeModulePointers();
}

void	CErrorCodeView::ClearMultiLineEditText()
{
	frame->ClearMultiLineEditText();
}

void	CErrorCodeView::SetTabStopWidth(int count)
{
	frame->SetTabStopWidth(count);
}

void	CErrorCodeView::SetMultiLineEditText(const list<string> &code)
{
	frame->SetMultiLineEditText(code);
}

void	CErrorCodeView::GetMultiLineEditText(list<string> &code)
{
	frame->GetMultiLineEditText(code);
}

bool	CErrorCodeView::GetCodeEditedFlag()
{
	return frame->GetCodeEditedFlag();
}

void	CErrorCodeView::SetCodeEditedFlag(bool f)
{
	frame->SetCodeEditedFlag(f);
}

void	CErrorCodeView::UndoEdit()
{
	frame->UndoEdit();
}

void	CErrorCodeView::RedoEdit()
{
	frame->RedoEdit();
}

void	CErrorCodeView::FindString()
{
	frame->FindString();
}

void	CErrorCodeView::RestoreUndoData()
{
	frame->RestoreUndoData();
}
