/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef ERRORCODEVIEW_H
#define	ERRORCODEVIEW_H

class CErrorCodeMultiLineEdit;
class CErrorCodeVBoxWidget;
class CErrorCodeView;

#include <string>
#include <list>

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "errorSelectView.h"

class CErrorCodeMultiLineEdit: public CMultiLineEditFc
{
	Q_OBJECT
	public:
	CErrorCodeMultiLineEdit(CErrorCodeVBoxWidget *v)
		: CMultiLineEditFc((QWidget *)v, "", 4), error_code_vbox(v) { }
	~CErrorCodeMultiLineEdit() { }

	protected:
	virtual bool	event(QEvent *e);

	private:
	CErrorCodeVBoxWidget	*error_code_vbox;
};

class CErrorCodeVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CErrorCodeVBoxWidget(	QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CErrorCodeView *ecv);

	virtual ~CErrorCodeVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	bool	GetTabIndicator();
	void	ToggleTabIndicator();
	void	ToggleErrorIndicator();
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	RestoreUndoData();

	public slots:
	void	CodeTextChanged();

	private:
	bool						tab_indicator;
	bool						error_indicator;
	CLabelFc					*label;
	CErrorCodeMultiLineEdit		*multi_line_edit;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CErrorCodeView				*error_code_view;
	ModulePtrMap				&module_ptr_map;

	CErrorSelectView			*esv;
};

class CErrorCodeView: public CSubView
{
	public:
	CErrorCodeView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CErrorCodeView();

	virtual CErrorCodeVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	RestoreUndoData();

	private:
	CErrorCodeVBoxWidget		*frame;
};

#endif
