/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef ERRORTOKENVIEW_H
#define	ERRORTOKENVIEW_H

class CErrorTokenListView;
class CErrorTokenVBoxWidget;
class CErrorTokenView;

#include <qobject.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qheader.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "nonterminalView.h"
#include "implicitView.h"
#include "precedenceView.h"
#include "ruleView.h"
#include "grammarDialog.h"

class CErrorTokenListView: public QListView
{
	Q_OBJECT
	public:
	CErrorTokenListView(CErrorTokenVBoxWidget *v)
		: QListView((QWidget *)v, 0, 0), error_token_vbox(v) { }
	~CErrorTokenListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	keyPressEvent(QKeyEvent *e);
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);
	virtual void	mouseDoubleClickEvent(QMouseEvent *e);

	private:
	CErrorTokenVBoxWidget	*error_token_vbox;
	QColor					active_highlight;
	QColor					active_highlighted_text;
	QColor					inactive_highlight;
	QColor					inactive_highlighted_text;
};

class CErrorTokenVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CErrorTokenVBoxWidget(	QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CErrorTokenView *ev);

	virtual ~CErrorTokenVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	InsertBeforeErrorToken();
	void	InsertAfterErrorToken();
	void	EditErrorToken();
	void	DeleteErrorToken();
	void	MoveErrorTokenUp();
	void	MoveErrorTokenDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CLabelFc				*label;
	CErrorTokenListView		*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CErrorTokenView				*error_token_view;
	ModulePtrMap				&module_ptr_map;

	void	SetSelectedItem(int i);
	void	InsertBeforeErrorToken(int i, const CErrorToken &t);
	void	InsertAfterErrorToken(int i, const CErrorToken &t);
	void	UpdateErrorToken(int i, const CErrorToken &t);
	void	DeleteErrorToken(int i);
	void	MoveErrorTokenUp(int i);
	void	MoveErrorTokenDown(int i);
};

class CErrorTokenView: public CSubView
{
	public:
	CErrorTokenView(QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CErrorTokenView();

	virtual CErrorTokenVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	InsertAfterErrorToken();
	void	InsertBeforeErrorToken();
	void	EditErrorToken();
	void	DeleteErrorToken();
	void	MoveErrorTokenUp();
	void	MoveErrorTokenDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CErrorTokenVBoxWidget		*frame;
};

#endif
