/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef FILEPATH_H
#define FILEPATH_H

using namespace std;

#include <errno.h>
#include <unistd.h>

#include <fstream>
#include <string>

namespace FilePath
{
	bool		FileExists(const string &f);

	bool		GetCurrentWorkingDirectory(string &cwd);

	void		GetPathAndFileName(	const string &path_and_file_name,
									string &path,
									string &file_name);

	bool		CheckFileExtension(	const string &path_and_file_name,
									const string &extension);

	void		GetFileBaseName(const string &path_and_file_name,
								const string &extension,
								string &base_name);

	void		CreateAssociatedFileName(
								const string &path_and_file_name,
								const string &extension1,
								const string &extension2,
								string &associated_file_name);
};

#endif
