/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef FONTCHANGECONTROL_H
#define FONTCHANGECONTROL_H

#include <string>
#include <vector>

#include <qsize.h>
#include <qpoint.h>
#include <qstring.h>
#include <qfont.h>
#include <qfontinfo.h>
#include <qfontmetrics.h>
#include <qapplication.h>
#include <qevent.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qmultilineedit.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qhgroupbox.h>
#include <qvgroupbox.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qbuttongroup.h>
#include <qhbuttongroup.h>
#include <qvbuttongroup.h>
#include <qdialog.h>
#include <qlayout.h>

#include "stringToken.h"

const int	grid_layout_margin_data[80] =
{
  1,	  1,	  1,	  1,	  1,	  1,	  1,	  1,	  2,	  2,
  2,	  2,	  3,	  3,	  3,	  3,	  4,	  4,	  4,	  4,
  5,	  5,	  5,	  5,	  6,	  6,	  6,	  6,	  7,	  7,
  7,	  7,	  8,	  8,	  8,	  8,	  9,	  9,	  9,	  9,
 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,
 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12
};

const int	grid_layout_spacing_data[80] =
{
  1,	  1,	  1,	  1,	  1,	  1,	  1,	  1,	  2,	  2,
  2,	  2,	  3,	  3,	  3,	  3,	  4,	  4,	  4,	  4,
  5,	  5,	  5,	  5,	  6,	  6,	  6,	  6,	  7,	  7,
  7,	  7,	  8,	  8,	  8,	  8,	  9,	  9,	  9,	  9,
 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,
 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12
};

const int * const	h_box_margin_data	= grid_layout_margin_data;
const int * const	h_box_spacing_data	= grid_layout_spacing_data;
const int * const	v_box_margin_data	= grid_layout_margin_data;
const int * const	v_box_spacing_data	= grid_layout_spacing_data;

const int	group_box_margin_data[80] =
{
 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,
 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,
 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,
 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12,	 12
};

const int	group_box_spacing_data[80] =
{
  4,	  4,	  4,	  4,	  4,	  4,	  4,	  4,	  4,	  4,
  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,
  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,
  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,	  5,
  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,
  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,
  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,
  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6
};

const int	push_button_width_data[80] =
{
  3,	  3,	  3,	  3,	  3,	  3,	  3,	  3,	  5,	  5,
  5,	  5,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,
  9,	  9,	  9,	  9,	  9,	  9,	  9,	  9,	  9,	  9,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,
 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11,	 11
};

const int	push_button_height_data[80] =
{
  3,	  3,	  3,	  3,	  3,	  3,	  3,	  3,	  5,	  5,
  5,	  5,	  6,	  6,	  6,	  6,	  6,	  6,	  6,	  6,
  8,	  8,	  8,	  8,	  8,	  8,	  8,	  8,	  8,	  8,
 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,
 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,
 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,
 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,
 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10,	 10
};

const int * const	label_width_data			= push_button_width_data;
const int * const	label_height_data			= push_button_height_data;
const int * const	line_edit_width_data		= push_button_width_data;
const int * const	line_edit_height_data		= push_button_height_data;
const int * const	combo_box_width_data		= push_button_width_data;
const int * const	combo_box_height_data		= push_button_height_data;
const int * const	radio_button_width_data		= push_button_width_data;
const int * const	radio_button_height_data	= push_button_height_data;

class CPushButtonFc: public QPushButton
{
	Q_OBJECT
	public:
	CPushButtonFc(	const QString &text,
					QWidget *parent,
					const QString &s = QString(""));
	virtual ~CPushButtonFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();

	private:
	QString		size_string;
};

class CCheckBoxFc: public QCheckBox
{
	Q_OBJECT
	public:
	CCheckBoxFc(const QString &text, QWidget *parent);
	virtual ~CCheckBoxFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();
};

class CRadioButtonFc: public QRadioButton
{
	Q_OBJECT
	public:
	CRadioButtonFc(const QString &text, QWidget *parent);
	virtual ~CRadioButtonFc() { }

	virtual void	setFont(const QFont &f);
	virtual void	setState(ToggleState s) { QRadioButton::setState(s); }
	void			CalculateGeometry();
};

class CLabelFc: public QLabel
{
	Q_OBJECT
	public:
	CLabelFc(const QString &text, QWidget *parent,
				bool hh_flag = false, bool m_flag = false, bool e_flag = false);
	virtual ~CLabelFc() { }

	virtual void	setFont(const QFont &f);
	virtual QSize	sizeHint() const;
	void			CalculateGeometry();

	private:
	bool	half_height_flag;
	bool	maximum_size_flag;
	bool	extra_spacing_flag;
};

class CLineEditFc: public QLineEdit
{
	Q_OBJECT
	public:
	CLineEditFc(QWidget *parent, const QString &s);
	virtual ~CLineEditFc() { }

	virtual void	setFont(const QFont &f);
	virtual QSize	sizeHint() const;
	void			CalculateGeometry();

	private:
	QString		size_string;
};

class CComboBoxFc: public QComboBox
{
	Q_OBJECT
	public:
	CComboBoxFc(bool rw, QWidget *parent, const QString &s);
	virtual ~CComboBoxFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();

	private:
	QString		size_string;
};

class CListBoxFc: public QListBox
{
	Q_OBJECT
	public:
	CListBoxFc(QWidget *parent, const QString &s,
				int c = 2, bool m_flag = false);
	virtual ~CListBoxFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();

	private:
	QString		size_string;
	int			line_count;
	bool		maximum_size_flag;
};

class CMultiLineEditFc: public QMultiLineEdit
{
	Q_OBJECT
	public:
	CMultiLineEditFc(QWidget *parent, const QString &s,
						int c = 2, bool m_flag = false);
	virtual ~CMultiLineEditFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();

	virtual void	newLine() { QMultiLineEdit::newLine(); }

	private:
	QString		size_string;
	int			line_count;
	bool		maximum_size_flag;
};

class CFrameFc: public QFrame
{
	Q_OBJECT
	public:
	CFrameFc(QWidget *parent, int nRows, int nCols,
				const char *name = 0, WFlags f = 0);
	virtual ~CFrameFc() { }

	virtual void	setFont(const QFont &f);

	protected:
	QGridLayout     *grid_layout;
};

class CHBoxFc: public QHBox
{
	Q_OBJECT
	public:
	CHBoxFc(QWidget *parent, bool s_flag);
	virtual ~CHBoxFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();

	private:
	bool		spacing_flag;
};

class CVBoxFc: public QVBox
{
	Q_OBJECT
	public:
	CVBoxFc(QWidget *parent, bool s_flag);
	virtual ~CVBoxFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();

	private:
	bool		spacing_flag;
};

class CGroupBoxFc: public QGroupBox
{
	Q_OBJECT
	public:
	CGroupBoxFc(	int strips,
					Orientation orientation,
					const QString &title,
					QWidget *parent,
					const char *name = 0);
	virtual ~CGroupBoxFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();
};

class CHGroupBoxFc: public QHGroupBox
{
	Q_OBJECT
	public:
	CHGroupBoxFc(const QString &title, QWidget *parent, const char *name = 0);
	virtual ~CHGroupBoxFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();
};

class CVGroupBoxFc: public QVGroupBox
{
	Q_OBJECT
	public:
	CVGroupBoxFc(const QString &title, QWidget *parent, const char *name = 0);
	virtual ~CVGroupBoxFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();
};

class CButtonGroupFc: public QButtonGroup
{
	Q_OBJECT
	public:
	CButtonGroupFc(	int strips,
					Orientation orientation,
					const QString &title,
					QWidget *parent);
	virtual ~CButtonGroupFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();
};

class CHButtonGroupFc: public QHButtonGroup
{
	Q_OBJECT
	public:
	CHButtonGroupFc(const QString &title, QWidget *parent);
	CHButtonGroupFc(QWidget *parent);
	virtual ~CHButtonGroupFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();
};

class CVButtonGroupFc: public QVButtonGroup
{
	Q_OBJECT
	public:
	CVButtonGroupFc(const QString &title, QWidget *parent);
	virtual ~CVButtonGroupFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();
};

class CSpacerFc: public QWidget
{
	Q_OBJECT
	public:
	CSpacerFc(QWidget *parent, bool fs = false);
	virtual ~CSpacerFc() { }

	virtual void	setFont(const QFont &f);
	void			CalculateGeometry();

	private:
	bool	fixed_size_flag;
};

class CDialogFc: public QDialog
{
	Q_OBJECT
	public:
	CDialogFc(QWidget *parent, int nRows, int nCols,
				bool modal = true, const char *name = 0, WFlags f = 0);
	virtual ~CDialogFc() { }

	virtual void	setFont(const QFont &f);

	protected:
	QGridLayout     *grid_layout;
};

class CResizeDialogFc: public CDialogFc
{
	Q_OBJECT
	public:
	CResizeDialogFc(QWidget *parent, int nRows, int nCols,
					bool modal = true, const char *name = 0, WFlags f = 0)
		: CDialogFc(parent, nRows, nCols, modal, name, f) { }
	virtual ~CResizeDialogFc() { }

	int		ExecuteDialog();

	enum EventCodes
	{
		ResizeDialogFc	= QEvent::User
	};

	protected:
	virtual bool	event(QEvent *ev);

	virtual void	CalculateSizeAndPosition()
	{
		dialog_size		= QSize(-1, -1);
		dialog_position	= QPoint(-1, -1);
	}

	QSize			dialog_size;
	QPoint			dialog_position;
};

#endif
