/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef GRAMMERDIALOG_H
#define GRAMMERDIALOG_H

#include <strstream>
#include <qwidget.h>
#include <qspinbox.h>

class CTerminalDialog;
class CErrorTokenDialog;
class CNonTerminalDialog;
class CPrecedenceDialog;
class CRuleDialog;
class CUnitRuleDialog;

namespace GrammarDialog
{
	extern CTerminalDialog				*terminal_dialog;
	extern CErrorTokenDialog			*error_token_dialog;
	extern CNonTerminalDialog			*nonterminal_dialog;
	extern CPrecedenceDialog			*precedence_dialog;
	extern CRuleDialog					*rule_dialog;
	extern CUnitRuleDialog				*unit_rule_dialog;

	void	CreateGrammarDialogs(QWidget *parent);
	void	DestroyGrammarDialogs();
	void	SetTerminalPaletteAndFont(QWidget *w);
	void	SetErrorTokenPaletteAndFont(QWidget *w);
	void	SetNonTerminalPaletteAndFont(QWidget *w);
	void	SetPrecedencePaletteAndFont(QWidget *w);
	void	SetRulePaletteAndFont(QWidget *w);
	void	SetUnitRulePaletteAndFont(QWidget *w);

	const char * const	line_edit_string_size =
		"0123456789012345678901234567890123456789";
}

#include "fontchangeControl.h"
#include "compilerData.h"
#include "stringToken.h"

class CTerminalDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CTerminalDialog(QWidget *parent);
	virtual	~CTerminalDialog() { }

	void	SetTitleAndResize(const string &title);

	void	SetTerminalPointer(CTerminal *t)
	{ terminal_pointer = t; }
	void	SetControlValues(const CTerminal &t);

	virtual void	setFont(const QFont &f);

	public slots:
	void	AcceptOperation();

	private:
	CTerminal			*terminal_pointer;
	QGridLayout			*subgrid_layout1;
	CHButtonGroupFc		*type_button_group;
	CRadioButtonFc		*filter_radio_button;
	CRadioButtonFc		*token_radio_button;
	CHButtonGroupFc		*driver_button_group;
	CRadioButtonFc		*literal_radio_button;
	CRadioButtonFc		*regexp_radio_button;
	CSpacerFc			*spacer1;
	QGridLayout			*subgrid_layout2;
	CLabelFc			*name_label;
	CLineEditFc			*name_line_edit;
	CLabelFc			*regexp_label;
	CLineEditFc			*regexp_line_edit;
	CPushButtonFc		*ok_button;
	CPushButtonFc		*cancel_button;
	CSpacerFc			*spacer2;
};

class CErrorTokenDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CErrorTokenDialog(QWidget *parent);
	virtual	~CErrorTokenDialog() { }

	void	SetTitleAndResize(const string &title);

	void	SetErrorTokenPointer(CErrorToken *e)
	{ error_token_pointer = e; }
	void	SetControlValues(const CErrorToken &e);

	virtual void	setFont(const QFont &f);

	public slots:
	void	AcceptOperation();

	private:
	CErrorToken			*error_token_pointer;
	QGridLayout			*subgrid_layout1;
	CLabelFc			*name_label;
	CLineEditFc			*name_line_edit;
	QGridLayout			*subgrid_layout2;
	CLabelFc			*sync_length_label;
	QSpinBox			*sync_length_spinbox;
	CSpacerFc			*spacer1;
	CPushButtonFc		*ok_button;
	CPushButtonFc		*cancel_button;
	CSpacerFc			*spacer2;
};

class CNonTerminalDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CNonTerminalDialog(QWidget *parent);
	virtual	~CNonTerminalDialog() { }

	void	SetTitleAndResize(const string &title);

	void	SetNonTerminalPointer(CNonTerminal *n)
	{ nonterminal_pointer = n; }
	void	SetControlValues(const CNonTerminal &n);

	virtual void	setFont(const QFont &f);

	public slots:
	void	AcceptOperation();

	private:
	CNonTerminal		*nonterminal_pointer;
	QGridLayout			*subgrid_layout1;
	CLabelFc			*name_label;
	CLineEditFc			*name_line_edit;
	QGridLayout			*subgrid_layout2;
	CSpacerFc			*spacer1;
	CCheckBoxFc			*start_symbol_check_box;
	CSpacerFc			*spacer2;
	CPushButtonFc		*ok_button;
	CPushButtonFc		*cancel_button;
	CSpacerFc			*spacer3;
};

class CPrecedenceDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CPrecedenceDialog(QWidget *parent);
	virtual	~CPrecedenceDialog() { }

	void	SetTitleAndResize(const string &title);

	void	SetCompilerDataPointer(CCompilerData *d);
	void	SetPrecedencePointer(CPrecedence *p)
	{ precedence_pointer = p; }
	void	SetControlValues(const CPrecedence &p);

	virtual void	setFont(const QFont &f);

	public slots:
	void	AddEntry();
	void	DeleteEntry();
	void	AcceptOperation();

	private:
	CCompilerData		*compiler_data;
	CPrecedence			*precedence_pointer;
	QGridLayout			*subgrid_layout1;
	CHButtonGroupFc		*associativity_button_group;
	CRadioButtonFc		*left_button;
	CRadioButtonFc		*right_button;
	CRadioButtonFc		*nonassociative_button;
	CSpacerFc			*spacer1;
	QGridLayout			*subgrid_layout2;
	CLabelFc			*entry_label;
	CLineEditFc			*entry_line_edit;
	CListBoxFc			*entry_listbox;
	CPushButtonFc		*add_button;
	CPushButtonFc		*delete_button;
	CPushButtonFc		*ok_button;
	CPushButtonFc		*cancel_button;
	CSpacerFc			*spacer2;
};

class CRuleDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CRuleDialog(QWidget *parent);
	virtual	~CRuleDialog() { }

	void	SetTitleAndResize(const string &title);

	void	SetCompilerDataPointer(CCompilerData *d);
	void	SetRulePointer(CRule *r)
	{ rule_pointer = r; }
	void	SetControlValues(const CRule &r);

	virtual void	setFont(const QFont &f);

	public slots:
	void	AddSymbol();
	void	DeleteSymbol();
	void	UnitRuleFlag();
	void	AcceptOperation();

	private:
	CCompilerData		*compiler_data;
	CRule				*rule_pointer;
	bool				unit_rule_flag;
	QGridLayout			*subgrid_layout1;
	CLabelFc			*rule_label;
	CLineEditFc			*rule_line_edit;
	CListBoxFc			*symbol_listbox;
	CPushButtonFc		*add_button;
	CPushButtonFc		*delete_button;
	CPushButtonFc		*unit_rule_button;
	CPushButtonFc		*ok_button;
	CPushButtonFc		*cancel_button;
	CSpacerFc			*spacer1;
};

class CUnitRuleDialog: public CDialogFc
{
	Q_OBJECT
	public:
	CUnitRuleDialog(QWidget *parent);
	virtual	~CUnitRuleDialog() { }

	void	SetTitleAndResize(const string &title);

	void	SetFlagPointer(bool *b)
	{ flag_pointer = b; }
	void	SetControlValues(bool b);

	public slots:
	void	AcceptOperation();

	private:
	bool				*flag_pointer;
	CSpacerFc			*spacer1;
	CCheckBoxFc			*unit_rule_check_box;
	CPushButtonFc		*ok_button;
	CPushButtonFc		*cancel_button;
	CSpacerFc			*spacer2;
};

#endif
