/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "idMap.h"

CIdMap::CIdMap()
{
}

CIdMap::~CIdMap()
{
}

CIdMap::rvalue		CIdMap::GetIndex(int existing_id, int &index) const
{
	rvalue			status;
	TIterator1		map_iterator;

	if ((status = GetMapIterator(existing_id, map_iterator)) != NoError)
		return status;

	index = (*map_iterator).second;

	return NoError;
}

CIdMap::rvalue		CIdMap::InsertBeforeId(int existing_id, int new_id)
{
	rvalue			status;
	int				index;

	if ((status = GetIndex(existing_id, index)) != NoError)
		return status;

	return InsertBeforeIndex(index, new_id);
}

CIdMap::rvalue		CIdMap::InsertAfterId(int existing_id, int new_id)
{
	rvalue			status;
	int				index;

	if ((status = GetIndex(existing_id, index)) != NoError)
		return status;

	return InsertAfterIndex(index, new_id);
}

CIdMap::rvalue		CIdMap::RemoveId(int existing_id)
{
	rvalue			status;
	int				index;

	if ((status = GetIndex(existing_id, index)) != NoError)
		return status;

	return RemoveIndex(index);
}

CIdMap::rvalue		CIdMap::InsertBeforeIndex(int index, int new_id)
{
	rvalue			status;
	TIterator1		map_iterator;
	TIterator2		list_iterator;

	if ((status = GetMapIterator(new_id, map_iterator)) == NoError)
		return DuplicateId;

	if ((status = GetListIterator(index, list_iterator)) != NoError)
		return status;

	id_to_index_map[new_id] = index;

	map_iterator = id_to_index_map.find(new_id);

	map_iterator_list.insert(list_iterator, map_iterator);

	while (list_iterator != map_iterator_list.end())
	{
		(**list_iterator).second++;
		++list_iterator;
	}

	return NoError;
}

CIdMap::rvalue		CIdMap::InsertAfterIndex(int index, int new_id)
{
	rvalue			status;
	TIterator1		map_iterator;
	TIterator2		list_iterator;

	if ((status = GetMapIterator(new_id, map_iterator)) == NoError)
		return DuplicateId;

	if ((status = GetListIterator(index, list_iterator)) != NoError)
		return status;

	id_to_index_map[new_id] = ++index;

	map_iterator = id_to_index_map.find(new_id);

	map_iterator_list.insert(++list_iterator, map_iterator);

	while (list_iterator != map_iterator_list.end())
	{
		(**list_iterator).second++;
		++list_iterator;
	}

	return NoError;
}

CIdMap::rvalue		CIdMap::RemoveIndex(int index)
{
	rvalue			status;
	TIterator1		map_iterator;
	TIterator2		list_iterator;
	TIterator2		current_iterator;

	if ((status = GetListIterator(index, list_iterator)) != NoError)
		return status;

	map_iterator = *list_iterator;

	current_iterator = list_iterator;
	++current_iterator;

	while (current_iterator != map_iterator_list.end())
	{
		(**current_iterator).second--;
		++current_iterator;
	}

	id_to_index_map.erase(map_iterator);
	map_iterator_list.erase(list_iterator);

	return NoError;
}

CIdMap::rvalue		CIdMap::Append(int new_id)
{
	rvalue			status;
	int				index;
	TIterator1		map_iterator;

	if ((status = GetMapIterator(new_id, map_iterator)) == NoError)
		return DuplicateId;

	index = (int)map_iterator_list.size();

	id_to_index_map[new_id] = index;

	map_iterator = id_to_index_map.find(new_id);

	map_iterator_list.push_back(map_iterator);

	return NoError;
}

const CIdMap::TMap1&	CIdMap::GetIdToIndexMap() const
{
	return id_to_index_map;
}

const CIdMap::TList2&	CIdMap::GetMapIteratorList() const
{
	return map_iterator_list;
}

CIdMap::rvalue	CIdMap::GetMapIterator(int id, TIterator1 &iterator) const
{
	iterator = (TIterator1 &)(id_to_index_map.find(id));

	if (iterator == id_to_index_map.end())
		return IdNotFound;

	return NoError;
}

CIdMap::rvalue	CIdMap::GetListIterator(int index, TIterator2 &iterator) const
{
	if (index < 0 || index >= (int)map_iterator_list.size())
		return IndexOutOfRange;

	iterator = (TIterator2 &)(map_iterator_list.begin());

	int		i;

	for (i=0; i<index; i++)
		++iterator;

	return NoError;
}

ostream		&operator<<(ostream &s, const CIdMap &idm)
{
	const CIdMap::TMap1			&map			= idm.GetIdToIndexMap();
	CIdMap::TConstIterator1		map_iterator	= map.begin();

	s << "map  =";

	while (map_iterator != map.end())
	{
		s	<< " (" << (*map_iterator).first
			<< ", " << (*map_iterator).second << ")";

		++map_iterator;
	}

	s << endl;

	const CIdMap::TList2		&list			= idm.GetMapIteratorList();
	CIdMap::TConstIterator2		list_iterator	= list.begin();

	s << "list =";

	while (list_iterator != list.end())
	{
		map_iterator = *list_iterator;

		s	<< " (" << (*map_iterator).first
			<< ", " << (*map_iterator).second << ")";

		++list_iterator;
	}

	return s;
}
