/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "implicitView.h"

CImplicitVBoxWidget::CImplicitVBoxWidget(	QWidget *parent,
											CCompilerInterface *ci,
											SMainViewControl *mvc,
											COptionData::SSubViewData *d,
											CImplicitView *iv)
	: CVBoxWidget(parent, ci, mvc), compiler_interface(ci),
		subview_data(d), implicit_view(iv),
		module_ptr_map(iv->GetModulePtrMap())
{
	label		= new CLabelFc("implicit", this, true);
	implicit	= new CLabelFc("augmented", this);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
	implicit->setAlignment(Qt::AlignLeft | Qt::AlignTop);
	implicit->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	setSpacing(0);
	setStretchFactor(label, 0);
	setStretchFactor(implicit, 1);

	compiler_data = compiler_interface->GetCompilerData();

	UpdateListView();
}

CImplicitVBoxWidget::~CImplicitVBoxWidget()
{
}

void	CImplicitVBoxWidget::UpdateListView()
{
	ostrstream		augmented;
	string			left;
	string			right;

	augmented 	<< "End Of File Symbol     = ";
	augmented	<< compiler_data->GetEndOfFileSymbol().GetSymbolIndex();
	augmented	<< endl;
	augmented	<< "Augmented Start Symbol = ";
	augmented	<< compiler_data->GetAugmentedStartSymbol().GetSymbolIndex();
	augmented	<< endl;
	augmented	<< "Augmented Start Rule   = ";
	augmented	<< compiler_data->GetAugmentedStartRule().GetIndex();
	augmented	<< endl;
	augmented	<< compiler_data->GetAugmentedStartRule().GetLeftString(left);
	augmented	<< " -> ";
	augmented	<< compiler_data->GetAugmentedStartRule().GetRightString(right);
	augmented	<< '\0';

	implicit->setText(augmented.str());
}

void	CImplicitVBoxWidget::InitializeModulePointers()
{
}

void	CImplicitVBoxWidget::RestoreUndoData()
{
	compiler_data = compiler_interface->GetCompilerData();
}

CImplicitView::CImplicitView(	QWidget *p,
								CViewNode *n,
								CInterfaceControl *ic,
								SMainViewControl *mvc,
								const string &dfs,
								CPaletteData *dpd,
								COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CImplicitVBoxWidget(
		p, dynamic_cast<CCompilerInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
		frame->setPalette(view_node_palette);
	else
		frame->setPalette(frame->palette());
}

CImplicitView::~CImplicitView()
{
	delete frame;
}

void	CImplicitView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CImplicitView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CImplicitView::InitializeModulePointers()
{
	frame->InitializeModulePointers();
}

void	CImplicitView::UpdateListView()
{
	frame->UpdateListView();
}

void	CImplicitView::RestoreUndoData()
{
	frame->RestoreUndoData();
}
