/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "interfaceControl.h"

CInterfaceControl::CInterfaceControl(	int c_id,
										int i_id,
										CMainViewMenu *mvm,
										CMainWindow *mw)
	: QObject(), configuration_id(c_id), interface_id(i_id),
		main_view_menu_manager(mvm),
		main_window(mw), option_data(0),
		data_modified_flag(false), options_modified_flag(false),
		runtime_map(0), current_main_view_id(-1)
{
}

CInterfaceControl::~CInterfaceControl()
{
	DestroyViews();

	delete option_data;
}

void	CInterfaceControl::SetDataModifiedFlag(bool f)
{
	if (data_modified_flag != f)
	{
		data_modified_flag = f;

		main_window->UpdateCurrentFileMessage(	GetDataFileName(),
												GetOptionFileName(),
												GetDataModifiedFlag(),
												GetOptionsModifiedFlag());
	}
}

void	CInterfaceControl::SetOptionsModifiedFlag(bool f)
{
	if (options_modified_flag != f)
	{
		options_modified_flag = f;

		main_window->UpdateCurrentFileMessage(	GetDataFileName(),
												GetOptionFileName(),
												GetDataModifiedFlag(),
												GetOptionsModifiedFlag());
	}
}

void	CInterfaceControl::DestroyViews()
{
	if (main_view_menu_manager)
		main_view_menu_manager->RemoveSeparatorAndMainViewSet(
			view_separator_id, title_id_and_name, main_view_id_and_name_info);

	for_each(	main_view_id_to_control_map.begin(),
				main_view_id_to_control_map.end(),
				destroy_view_tree());

	for_each(	main_view_id_to_control_map.begin(),
				main_view_id_to_control_map.end(),
				destroy_map_T<int, SMainViewControl *>());

	main_view_id_to_control_map.clear();

	main_view_id_and_name_info.clear();

	delete runtime_map;
}

void    raise_default_display_main_view::operator()(
											pair<int, SMainViewControl *> x)
{
	if (x.second->GetViewData()->GetDefaultDisplayFlag())
		interface_control->RaiseMainView(x.second->main_view_id);
}

void    raise_visible_main_view::operator()(pair<int, SMainViewControl *> x)
{
	if (x.second->GetMainViewVisibleFlag())
		interface_control->RaiseMainView(x.second->main_view_id);
}

void    capture_splitter_pane_sizes::operator()(
											pair<int, SMainViewControl *> x)
{
	if (x.second->GetMainViewVisibleFlag() &&
		x.second->GetViewTree())
		x.second->GetViewTree()->CapturePaneSizes(reset_flag);
}

void    CInterfaceControl::CaptureSizeAndPosition(InterfaceType type, bool rf)
{
	if (rf)
	{
		for_each(	main_view_id_to_control_map.begin(),
					main_view_id_to_control_map.end(),
					capture_main_view_size_and_position(true));
	}
	else
	{
		map<int, SMainViewControl *>::iterator		m_iterator;

		switch (type)
		{
			case ::SingleDocumentSingleView:
			for_each(	main_view_id_to_control_map.begin(),
						main_view_id_to_control_map.end(),
						capture_main_view_size_and_position(true));
			break;

			case ::MultipleDocumentSingleView:
			m_iterator =
				find_if(main_view_id_to_control_map.begin(),
						main_view_id_to_control_map.end(),
						find_visible_main_view());

			if (m_iterator != main_view_id_to_control_map.end())
				for_each(	main_view_id_to_control_map.begin(),
							main_view_id_to_control_map.end(),
							capture_main_view_size_and_position(
										true,
										widget_stack->parentWidget()->pos(),
										widget_stack->parentWidget()->size()));
			break;

			case ::MultipleDocumentMultipleView:
			for_each(	main_view_id_to_control_map.begin(),
						main_view_id_to_control_map.end(),
						capture_main_view_size_and_position());
			break;
		}
	}

	for_each(	main_view_id_to_control_map.begin(),
				main_view_id_to_control_map.end(),
				capture_splitter_pane_sizes(rf));
}

void	CInterfaceControl::CreateWorkspaceViews(QWorkspace *ws)
{
	widget_stack_parent_flag = false;

	workspace = ws;

	CreateMainViews(ws);

	for_each(	main_view_id_to_control_map.rbegin(),
				main_view_id_to_control_map.rend(),
				raise_default_display_main_view(this));

	runtime_map = CreateRuntimeMainViewMap(this);

	StoreRuntimeMainViewMap(this, runtime_map);

	InitializeModulePointers();
}

void	CInterfaceControl::CreateWidgetStackViews(QWidgetStack *ws)
{
	widget_stack_parent_flag = true;

	widget_stack = ws;

	CreateMainViews(ws);

	for_each(	main_view_id_to_control_map.begin(),
				main_view_id_to_control_map.end(),
				add_views_to_widget_stack(ws));

	map<int, SMainViewControl *>::iterator	m_iterator =
		find_if(main_view_id_to_control_map.begin(),
				main_view_id_to_control_map.end(),
				find_default_display_main_view());

	if (m_iterator != main_view_id_to_control_map.end())
		RaiseMainView((*m_iterator).second->main_view_id);
	else if (main_view_id_to_control_map.size())
		RaiseMainView(
			(*main_view_id_to_control_map.begin()).second->main_view_id);

	runtime_map = CreateRuntimeMainViewMap(this);

	StoreRuntimeMainViewMap(this, runtime_map);

	InitializeModulePointers();
}

void    CInterfaceControl::CreateTitleName(string &tn)
{
	string		directory_path;
	string		file_name;
	string		*prefix_text =
		option_data->GetAuxiliaryString("Menu_Name_Prefix_Text");

	FilePath::GetPathAndFileName(data_file_name, directory_path, file_name);

	if (prefix_text)
		tn = *prefix_text;
	else
		tn = "Data File: ";

	tn += file_name;
}

void    CInterfaceControl::UpdateTitleName()
{
	string		tn;

	CreateTitleName(tn);

	title_id_and_name.second = tn;

	main_view_menu_manager->ChangeItemText(title_id_and_name.first, tn);
}

void	CInterfaceControl::CreateMainViews(QWidget *w)
{
	view_separator_id = main_view_menu_manager->GetSeparatorId();

	string		tn;

	CreateTitleName(tn);

	title_id_and_name =
		pair<int, string>(main_view_menu_manager->GetTitleId(), tn);

	if (option_data && option_data->GetMainViewPtrs())
	{
		COptionData::SApplicationData	*application_option_data =
											option_data->GetApplicationData();

		vector<COptionData::SMainViewData *>
			*v = option_data->GetMainViewPtrs();

		vector<COptionData::SMainViewData *>::size_type		i;

		for (i=0; i<v->size(); i++)
		{
			int		main_view_id = main_view_menu_manager->GetMainViewId();

			SMainViewControl	*mvc =
				new SMainViewControl(main_view_id, (*v)[i]);

			if (application_option_data)
				mvc->CreateViewTree(w, this,
									application_option_data->GetFontString(),
									application_option_data->GetPaletteData());
			else
				mvc->CreateViewTree(w, this, string(), 0);

			main_view_id_to_control_map[main_view_id] = mvc;

			mvc->SetWidgetStackParentFlag(widget_stack_parent_flag);

			string	mvvt;

			if (widget_stack_parent_flag)
			{
				CreateMainViewHiddenText((*v)[i]->GetMainViewName(), mvvt);

				mvc->SetMainViewVisibleFlag(false);
			}
			else
			{
				if (mvc->GetViewData()->GetDefaultDisplayFlag())
				{
					CreateMainViewVisibleText((*v)[i]->GetMainViewName(), mvvt);

					mvc->SetMainViewVisibleFlag(true);
				}
				else
				{
					CreateMainViewHiddenText((*v)[i]->GetMainViewName(), mvvt);

					mvc->SetMainViewVisibleFlag(false);
				}
			}

			main_view_id_and_name_info.push_back(
				pair<int, string>(main_view_id, mvvt));
		}
	}

	main_view_menu_manager->AppendSeparatorAndMainViewSet(
		view_separator_id, title_id_and_name, main_view_id_and_name_info);
}

void    CInterfaceControl::ChangeMenuItemToHidden(SMainViewControl *mvc)
{
	string		mvht;

	CreateMainViewHiddenText(mvc->view_data->GetMainViewName(), mvht);

	main_view_menu_manager->ChangeItemText(mvc->main_view_id, mvht);

	mvc->SetMainViewVisibleFlag(false);
}

void    CInterfaceControl::ChangeMenuItemToVisible(SMainViewControl *mvc)
{
	string		mvvt;

	CreateMainViewVisibleText(mvc->view_data->GetMainViewName(), mvvt);

	main_view_menu_manager->ChangeItemText(mvc->main_view_id, mvvt);

	mvc->SetMainViewVisibleFlag(true);
}

void    CInterfaceControl
			::CreateMainViewHiddenText(const string &mvn, string &ht)
{
	string		*prefix_text =
		option_data->GetAuxiliaryString("Menu_Hidden_Prefix_Text");

	if (prefix_text)
		ht = *prefix_text + mvn;
	else
		ht = string("   ") + mvn;
}

void    CInterfaceControl
			::CreateMainViewVisibleText(const string &mvn, string &vt)
{
	string		*prefix_text =
		option_data->GetAuxiliaryString("Menu_Visible_Prefix_Text");

	if (prefix_text)
		vt = *prefix_text + mvn;
	else
		vt = string(" * ") + mvn;
}

void	SMainViewControl::CreateViewTree(
			QWidget *p,
			CInterfaceControl *ic,
			const string &dfs,
			CPaletteData *dpd)
{
	vector<COptionData::SViewNodeData *>
		*view_node_data_ptrs = view_data->GetViewNodeDataPtrs();

	if (!view_node_data_ptrs)
		return;

	if (view_node_data_ptrs->size())
	{
		COptionData::SViewNodeData		*vnd = (*view_node_data_ptrs)[0];

		switch (vnd->GetNodeType())
		{
			case COptionData::SViewNodeData::SplitterNode:
			view_tree = new CSplitterView(
							p, 0, ic, this, dfs, dpd,
							dynamic_cast<COptionData::SSplitterData *>(vnd));

			break;

			case COptionData::SViewNodeData::SubViewNode:
			view_tree = ic->CreateSubView(
							p, 0, ic, this, dfs, dpd,
							dynamic_cast<COptionData::SSubViewData *>(vnd));

			break;
		}

		if (ic->main_view_menu_manager)
			view_tree->SetProcessCloseEventFlag(true);
	}

	vector<COptionData::SViewNodeData *>::size_type		i;

	for (i=1; i<view_node_data_ptrs->size(); i++)
	{
		COptionData::SViewNodeData		*vnd = (*view_node_data_ptrs)[i];

		view_tree->AddViewNode(vnd);
	}
}

void	SMainViewControl::DestroyViewTree()
{
	delete view_tree;
}

QWidget		*SMainViewControl::GetRootViewWidget() const
{
	return view_tree->GetWidget();
}

QWidget		*SMainViewControl::GetRootViewParentWidget() const
{
	return view_tree->GetParentWidget();
}

void	SMainViewControl::ShowViewTree()
{
	view_tree->GetWidget()->show();
}

void	SMainViewControl::HideViewTree()
{
	view_tree->GetWidget()->hide();
}

int		CInterfaceControl::RaiseCurrentView()
{
	RaiseMainView(current_main_view_id);

	return current_main_view_id;
}

void	CInterfaceControl::RaiseMainView(int id)
{
	if (id == title_id_and_name.first)
	{
		for_each(	main_view_id_to_control_map.rbegin(),
					main_view_id_to_control_map.rend(),
					raise_visible_main_view(this));

		return;
	}

	map<int, SMainViewControl *>::iterator
		m_iterator = main_view_id_to_control_map.find(id);

	if (m_iterator != main_view_id_to_control_map.end())
	{
		SMainViewControl	*mvc = (*m_iterator).second;

		if (!mvc->GetViewTree())
			return;

		if (widget_stack_parent_flag)
		{
			map<int, SMainViewControl *>::iterator
				m_iterator_current  =
					main_view_id_to_control_map.find(current_main_view_id);

			if (m_iterator_current != main_view_id_to_control_map.end())
				ChangeMenuItemToHidden((*m_iterator_current).second);

			mvc->GetRootViewParentWidget()->show();

			dynamic_cast<QWidgetStack *>
				(mvc->GetRootViewParentWidget())->raiseWidget(
													mvc->main_view_id);

			const QPoint    &position	 = mvc->GetViewData()->GetPosition();
			const QSize     &size		 = mvc->GetViewData()->GetSize();

			if (position != QPoint(-1, -1))
				mvc->GetRootViewParentWidget()->parentWidget()->move(position);

			if (size != QSize(-1, -1))
				mvc->GetRootViewParentWidget()->parentWidget()->resize(size);

			mvc->GetViewTree()->SetPaneSizes();
			mvc->GetRootViewParentWidget()->setFocus();
		}
		else
		{
			mvc->GetRootViewWidget()->show();
			mvc->GetViewTree()->SetPositionAndSize(true);
			mvc->GetViewTree()->SetPaneSizes();
			mvc->GetRootViewWidget()->setFocus();
		}

		current_main_view_id = id;

		ChangeMenuItemToVisible(mvc);
	}
}

CSubView	*CInterfaceControl::FindSubviewTypePointer(const string &s)
{
	CSubView	*sv;

	map<int, SMainViewControl *>::const_iterator	id_map_iterator;

	id_map_iterator = main_view_id_to_control_map.begin();

	while (id_map_iterator != main_view_id_to_control_map.end())
	{
		CViewNode   *view_tree = (*id_map_iterator).second->GetViewTree();

		if (view_tree)
		{
			sv = view_tree->FindSubviewTypePointer(s);

			if (sv)
				return sv;
		}

		id_map_iterator++;
	}

	return 0;
}

ostream		&operator<<(ostream &s, const CInterfaceControl &ic)
{
	s	<< "CInterfaceControl" << endl;
	s	<< "option_file_name  = " << ic.GetOptionFileName() << endl;
	s	<< "interface_id      = " << ic.GetInterfaceId() << endl;
	s	<< "view_separator_id = " << ic.GetViewSeparatorId() << endl;
	s	<< "title_id          = " << ic.GetTitleIdAndName().first << endl;
	s	<< "title_name        = " << ic.GetTitleIdAndName().second << endl;

	s	<< "map<int, SMainViewControl *>  main_view_id_to_control_map" << endl;

	const map<int, SMainViewControl *>	&cm = ic.GetMainViewIdToControlMap();

	map<int, SMainViewControl *>::const_iterator
		cm_iterator = cm.begin();

	int		index = 0;
	while (cm_iterator != cm.end())
	{
		s	<< "main_view_id   = " << (*cm_iterator).first << endl;
		s	<< index++ << " SMainViewControl " << endl;
		s	<< "main_view_id   = "
			<< (*cm_iterator).second->main_view_id << endl;
		s	<< "main_view_name = "
			<< (*cm_iterator).second->view_data->GetMainViewName() << endl;

		cm_iterator++;
	}

	s	<< "vector< pair<int, string> >  main_view_id_and_name_info" << endl;

	const vector< pair<int, string> >
									&mviani = ic.GetMainViewIdAndNameInfo();

	vector< pair<int, string> >::const_iterator
		mviani_iterator = mviani.begin();

	while (mviani_iterator != mviani.end())
	{
		s	<< index++ << " vector< pair<int, string> > " << endl;
		s	<< "main_view_id   = " << (*mviani_iterator).first << endl;
		s	<< "main_view_name = " << (*mviani_iterator).second << endl;

		mviani_iterator++;
	}

	return s;
}
