/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "mainViewMenu.h"

void	CMainViewMenu::SetupIndexMap()
{
	menu_offset = main_view_menu->count();

	for (int i=0; i<menu_offset; i++)
		id_to_menu_index_map.Append(id_generator.GetId());
}

void	CMainViewMenu::AppendSeparatorAndMainViewSet(
											int id, pair<int, string> &title,
											vector< pair< int, string> > &mv)
{
	id_to_menu_index_map.Append(id);

	main_view_menu->insertSeparator();

	id_to_menu_index_map.Append(title.first);

	main_view_menu->insertItem(title.second.c_str(), title.first);
		
	for (int i=0; i<mv.size(); i++)
	{
		main_view_menu->insertItem(mv[i].second.c_str(), mv[i].first);
		
		id_to_menu_index_map.Append(mv[i].first);
	}
}

void	CMainViewMenu::RemoveSeparatorAndMainViewSet(
											int id, pair<int, string> &title,
											vector< pair< int, string> > &mv)
{
	int		separator_index;
	int		i;

	CIdMap::rvalue	r = id_to_menu_index_map.GetIndex(id, separator_index);

	if (r == CIdMap::NoError)
		for (i=0; i<mv.size()+2; i++)
			main_view_menu->removeItemAt(separator_index);

	id_generator.ReturnId(id);
	id_to_menu_index_map.RemoveId(id);

	id_generator.ReturnId(title.first);
	id_to_menu_index_map.RemoveId(title.first);

	for (i=0; i<mv.size(); i++)
	{
		id_generator.ReturnId(mv[i].first);
		id_to_menu_index_map.RemoveId(mv[i].first);
	}
}

ostream		&operator<<(ostream &s, const CMainViewMenu &mvm)
{
	s	<< "CMainViewMenu" << endl;
	s	<< "menu_offset = " << mvm.GetMenuOffset() << endl;
	s	<< "CIdGenerator    id_generator" << endl;
	s	<< mvm.GetIdGenerator() << endl;
	s	<< "CIdMap          id_to_menu_index_map" << endl;
	s	<< mvm.GetIdMap() << endl;

	return s;
}
