/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef MAINVIEWMENU_H
#define MAINVIEWMENU_H

using namespace std;

#include <string>
#include <vector>
#include <qpopupmenu.h>

#include "idGenerator.h"
#include "idMap.h"

class CMainViewMenu
{
	public:
	CMainViewMenu(QPopupMenu *m) : main_view_menu(m) { SetupIndexMap(); }
	~CMainViewMenu() { }

	void	SetupIndexMap();
	int		GetMenuOffset() const { return menu_offset; }
	int		GetSeparatorId()	{ return id_generator.GetId(); }
	int		GetTitleId()		{ return id_generator.GetId(); }
	int		GetMainViewId()		{ return id_generator.GetId(); }
	void	AppendSeparatorAndMainViewSet(	int id, pair<int, string> &title,
											vector< pair< int, string> > &mv);
	void	RemoveSeparatorAndMainViewSet(	int id, pair<int, string> &title,
											vector< pair< int, string> > &mv);
	void	SetVisibleIndicatorOn(int id)
	{ main_view_menu->setItemChecked(id, true); }
	void	SetVisibleIndicatorOff(int id)
	{ main_view_menu->setItemChecked(id, false); }
	void	ChangeItemText(int id, const string &s)
	{ main_view_menu->changeItem(id, s.c_str()); }

	const CIdGenerator	&GetIdGenerator() const { return id_generator; }
	const CIdMap		&GetIdMap() const { return id_to_menu_index_map; }

	private:
	QPopupMenu		*main_view_menu;
	CIdGenerator	id_generator;
	CIdMap			id_to_menu_index_map;
	int				menu_offset;
};

ostream		&operator<<(ostream &s, const CMainViewMenu &mvm);

#endif
