/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef MENUNODEDATA_H
#define MENUNODEDATA_H

#include <string>
#include <vector>
#include <map>
#include <strstream>

#include "menuControl.h"

struct SSubmenuNodeData
{
	SSubmenuNodeData() { }
	SSubmenuNodeData(	int nt, const char *ti, int ni, const char *t,
						int a, const char *s, const int *ol, int oc)
		: node_type(nt), tree_index(ti), node_identifier(ni), text(t),
			accelerator(a), slot(s), operation_list(ol), operation_count(oc) { }

	int			node_type;
	const char	*tree_index;
	int			node_identifier;
	const char	*text;
	int			accelerator;
	const char	*slot;
	const int	*operation_list;
	int			operation_count;
};

struct SMainMenuNodeData
{
	SMainMenuNodeData() : operation_list(0) { }
	SMainMenuNodeData(SSubmenuNodeData &snd, const char *index_prefix, int oc)
		:	node_type(snd.node_type),
			node_identifier(snd.node_identifier),
			text(snd.text),
			accelerator(snd.accelerator),
			slot(snd.slot),
			operation_count(oc)
	{
		string	ti(snd.tree_index);

		if (ti.length())
			tree_index = string(index_prefix) + "," + ti;
		else
			tree_index = string(index_prefix);

		operation_list = new int[operation_count + 1];

		int		i;

		for (i=0; i<operation_count; i++)
			operation_list[i] = MN::menu_node_operation_noop;

		operation_list[i] = MN::menu_node_operation_disable;
	}
	~SMainMenuNodeData() { }

	int			node_type;
	string		tree_index;
	int			node_identifier;
	const char	*text;
	int			accelerator;
	const char	*slot;
	int			*operation_list;
	int			operation_count;
	
	void	DeleteOperationList() { delete [] operation_list; }
	int		GetOperationCount() const
	{ return operation_count + 1; }
};

struct SMainMenuConfiguration
{
	SMainMenuConfiguration(vector< pair<int, SSubmenuNodeData *> > &submenus);
	~SMainMenuConfiguration();

	int									menu_node_count;
	int									operation_count;
	SMainMenuNodeData					*main_menu_node_data;
	CMenuBarNode<SMainMenuNodeData>		*menu_tree;

	void		CreateMenu(QMenuBar *b);
	void		DestroyMenu();
	bool		ModifyMenu(int id, int op, QObject *obj);
	bool		DisableMenu();
	QPopupMenu	*GetSubMenu(const string &index);
	void		SetMenuFont(QFont &f);
	void		SetMenuPalette(QPalette &p);

	struct SSubmenuConfiguration
	{
		SSubmenuConfiguration(int si, int snc, int soc, int soo)
			:	submenu_id(si),
				node_count(snc),
				operation_count(soc),
				operation_offset(soo) { }

		int		submenu_id;
		int		node_count;
		int		operation_count;
		int		operation_offset;
	};

	vector<SSubmenuConfiguration>	submenu_configurations;
	map<int, int>					submenu_id_map;
};

int		GetSubmenuNodeCount(const SSubmenuNodeData *d);

ostream	&operator<<(ostream &os, const SSubmenuNodeData &d);
ostream	&operator<<(ostream &os, const SMainMenuNodeData &d);
ostream	&operator<<(ostream &os, const SMainMenuConfiguration &d);

#endif
