/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef NONTERMINALVIEW_H
#define	NONTERMINALVIEW_H

class CNonTerminalListView;
class CNonTerminalVBoxWidget;
class CNonTerminalView;

#include <qobject.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qheader.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "implicitView.h"
#include "ruleView.h"
#include "grammarDialog.h"

class CNonTerminalListView: public QListView
{
	Q_OBJECT
	public:
	CNonTerminalListView(CNonTerminalVBoxWidget *v)
		: QListView((QWidget *)v, 0, 0), nonterminal_vbox(v) { }
	~CNonTerminalListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	keyPressEvent(QKeyEvent *e);
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);
	virtual void	mouseDoubleClickEvent(QMouseEvent *e);

	private:
	CNonTerminalVBoxWidget	*nonterminal_vbox;
	QColor					active_highlight;
	QColor					active_highlighted_text;
	QColor					inactive_highlight;
	QColor					inactive_highlighted_text;
};

class CNonTerminalVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CNonTerminalVBoxWidget(	QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CNonTerminalView *nv);

	virtual ~CNonTerminalVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	InsertBeforeNonTerminal();
	void	InsertAfterNonTerminal();
	void	EditNonTerminal();
	void	DeleteNonTerminal();
	void	MoveNonTerminalUp();
	void	MoveNonTerminalDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CLabelFc				*label;
	CNonTerminalListView	*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CNonTerminalView			*nonterminal_view;
	ModulePtrMap				&module_ptr_map;

	void	SetSelectedItem(int i);
	void	InsertBeforeNonTerminal(int i, const CNonTerminal &n);
	void	InsertAfterNonTerminal(int i, const CNonTerminal &n);
	void	UpdateNonTerminal(int i, const CNonTerminal &n);
	void	DeleteNonTerminal(int i);
	void	MoveNonTerminalUp(int i);
	void	MoveNonTerminalDown(int i);
};

class CNonTerminalView: public CSubView
{
	public:
	CNonTerminalView(	QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CNonTerminalView();

	virtual CNonTerminalVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	InsertAfterNonTerminal();
	void	InsertBeforeNonTerminal();
	void	EditNonTerminal();
	void	DeleteNonTerminal();
	void	MoveNonTerminalUp();
	void	MoveNonTerminalDown();
	void	UpdateListView();
	void	RestoreUndoData();

	private:
	CNonTerminalVBoxWidget		*frame;
};

#endif
