/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef OPTIONEDITVIEW_H
#define	OPTIONEDITVIEW_H

#include <string>
#include <vector>
#include <algorithm>
#include <iostream>
#include <strstream>
#include <fstream>

#include <qnamespace.h>
#include <qpoint.h>
#include <qobject.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qwidgetstack.h>
#include <qtabwidget.h>
#include <qheader.h>
#include <qscrollview.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qspinbox.h>
#include <qfont.h>
#include <qfontinfo.h>
#include <qfontmetrics.h>
#include <qcolor.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qapplication.h>
#include <qclipboard.h>

class COptionEditFrame;

class CMainviewEditView;
class CApplicationEditView;
class CConnectionEditView;

class CMainviewSelect;
class CMainviewTreeEdit;

class CNavigateTree;
class CSubviewEdit;

struct SNavigateTreeNode;

class CAuxiliaryPaletteView;
class CAuxiliaryColorView;
class CAuxiliaryBrushView;
class CAuxiliaryXpmImageView;
class CAuxiliaryFontView;
class CAuxiliaryStringView;

#include "fontchangeControl.h"
#include "optionData.h"
#include "filePath.h"
#include "optionDialog.h"
#include "applicationMainWindow.h"
#include "interfaceControl.h"
#include "viewControl.h"
#include "replaceNode.h"
#include "connectionInterface.h"

using namespace ConnectionInterface;

struct SOptionFileItem
{
	SOptionFileItem(const string &ofn,
					SInterfaceConfiguration *configuration,
					CInterfaceControl *ic)
		: option_file_name(ofn), interface_configuration(configuration),
			interface_control(ic) { }

	string						option_file_name;
	SInterfaceConfiguration		*interface_configuration;
	CInterfaceControl			*interface_control;

	bool	operator<(const SOptionFileItem &ofi) const
	{
		if (option_file_name < ofi.option_file_name)
			return true;
		else
			return false;
	}
};

class COptionEditFrame: public CFrameFc
{
	Q_OBJECT
	public:
	enum DefaultOptionsIndexMode
	{
		AtTop,
		AtBottom,
		Sorted
	};

	COptionEditFrame(	QWidget *parent,
						CMainWindow *mw,
						DefaultOptionsIndexMode dm);
	~COptionEditFrame() { delete current_option_data; }

	void	UpdateOptionEditFrameGeometry();
	void	SetEditViewOptionData(bool undo_flag);
	void	SetConnectionEditViewOptionData();
	void	CreateUndoOptionData();
	void	CreateInitialViewTree(int tab_widget_height = -1);

	private:
	CMainWindow					*main_window;
	DefaultOptionsIndexMode		default_options_index_mode;
	vector<SOptionFileItem>		option_file_items;
	int							current_index;
	SOptionFileItem				*current_option_file_item;
	COptionData					*current_option_data;
	COptionData					*undo_option_data;

	public slots:
	void	CurrentTabChanged(QWidget *tab_page);
	void	SelectOptionFile(int index);
	void	UndoChanges();
	void	ReloadOptionData();
	void	SetOptionDataToDefault();
	void	ApplyChanges();
	void	SaveChanges();
	void	Quit();

	private:
	CLabelFc				*option_file_label;
	CComboBoxFc				*option_file_combo_box;
	CSpacerFc				*spacer;
	CPushButtonFc			*undo_button;
	CPushButtonFc			*reload_button;
	CPushButtonFc			*default_button;
	CPushButtonFc			*apply_button;
	CPushButtonFc			*save_button;
	CPushButtonFc			*quit_button;
	QTabWidget				*tab_widget;
	CMainviewEditView		*mainview_edit_view;
	CApplicationEditView	*application_edit_view;
	CConnectionEditView		*connection_edit_view;
	QListBox				*main_view_list_box;
	const int				mainview_page_index;
	const int				application_page_index;
	const int				connection_page_index;
};

class CMainviewEditView: public CFrameFc
{
	Q_OBJECT
	public:
	CMainviewEditView(QWidget *parent, CMainWindow *mw, COptionEditFrame *oef);
	virtual ~CMainviewEditView();

	void	SetAuxiliaryPaletteView(CAuxiliaryPaletteView *apv);
	void	SetAuxiliaryColorView(CAuxiliaryColorView *acv);
	void	SetAuxiliaryFontView(CAuxiliaryFontView *afv);
	void	SetupNavigateTreeListView();
	void	SetupSubviewTypeListView();

	void	UpdateOptionEditFrameGeometry();
	void	SetOptionData(SOptionFileItem *ofi, COptionData *d, bool undo_flag);
	void	SetCurrentMainViewIndex(int index);
	void	CreateViewTree(vector<int> *highlight_index = 0);
	void	ClearInterfaceSpecifiers(bool sdf = false);

	QListBox	*GetMainViewListBox();

	public slots:
	void	CurrentTabChanged(QWidget *tab_page);

	private:
	QTabWidget			*tab_widget;
	CMainviewSelect		*mainview_select;
	CMainviewTreeEdit	*mainview_tree_edit;
	QScrollView			*tree_scroll_view;
	QWidgetStack		*widget_stack;
	int					tree_widget_id;

	CMainWindow			*main_window;
	COptionEditFrame	*option_edit_frame;
	SMainViewControl	*main_view_control;
	CInterfaceControl	*interface_control;
	SOptionFileItem		*option_file_item;
	COptionData			*option_data;
	CViewNode			*view_tree;
	int					current_mainview_index;
};

class CMainviewSelect: public CFrameFc
{
	Q_OBJECT
	public:
	CMainviewSelect(QWidget *parent,
					CMainviewEditView *mvev,
					COptionEditFrame *oef);
	virtual ~CMainviewSelect() { }

	void	SetOptionData(SOptionFileItem *ofi, COptionData *d, bool undo_flag);
	QListBox	*GetMainViewListBox()
	{ return main_view_list_box; }

	public slots:
	void	SelectMainView(int index);
	void	SortMainViews();
	void	SetDefaultFlag();
	void	AddMainViewBefore();
	void	AddMainViewAfter();
	void	DeleteMainView();
	void	RenameMainView();
	void	CopyMainView();
	void	PasteMainView();

	private:
	QListBox		*main_view_list_box;
	CPushButtonFc	*sort_main_views_button;
	CPushButtonFc	*set_default_flag_button;
	CPushButtonFc	*add_main_view_before_button;
	CPushButtonFc	*add_main_view_after_button;
	CPushButtonFc	*delete_main_view_button;
	CPushButtonFc	*rename_main_view_button;
	CPushButtonFc	*copy_main_view_button;
	CPushButtonFc	*paste_main_view_button;

	CMainviewEditView	*mainview_edit_view;
	COptionEditFrame	*option_edit_frame;
	SOptionFileItem		*option_file_item;
	COptionData			*option_data;
	int					current_mainview_index;
};

class CMainviewTreeEdit: public CFrameFc
{
	Q_OBJECT
	public:
	CMainviewTreeEdit(	QWidget *parent,
						CMainviewEditView *mvev,
						COptionEditFrame *oef);
	virtual ~CMainviewTreeEdit();

	void	SetAuxiliaryPaletteView(CAuxiliaryPaletteView *apv)
	{ auxiliary_palette_view = apv; }
	void	SetAuxiliaryColorView(CAuxiliaryColorView *acv)
	{ auxiliary_color_view = acv; }
	void	SetAuxiliaryFontView(CAuxiliaryFontView *afv)
	{ auxiliary_font_view = afv; }
	void	SetupNavigateTreeListView();
	void	SetupSubviewTypeListView();

	COptionData		*GetOptionData() { return option_data; }

	void	UpdateOptionEditFrameGeometry();
	void	SetOptionData(SOptionFileItem *ofi, COptionData *d);
	void	SetViewTree(CViewNode *n, vector<int> *highlight_index);
	void	SetCurrentMainViewIndex(int index);
	void	CreateHighlightPaletteData();
	void	MoveHighlight(NavigationType nt);
	void	MoveHighlightToIndex(vector<int> *highlight_index);
	void	SelectFont(bool s_flag);
	void	SelectPalette(bool s_flag);
	void	AddTreeNode(SAddNode &an, AddNodeType t);
	void	ReplaceNode(SReplaceNode &rn);
	void	DeleteNode();

	public slots:
	void	ResetOptions();
	void	HighlightTree();
	void	MoveDown();
	void	MoveUp();
	void	MoveLeft();
	void	MoveRight();
	void	CurrentTabChanged(QWidget *tab_page);

	private:
	CPushButtonFc		*reset_options_button;
	CPushButtonFc		*highlight_tree_button;
	CPushButtonFc		*move_down_subview_tree_button;
	CPushButtonFc		*move_up_subview_tree_button;
	CPushButtonFc		*move_left_subview_tree_button;
	CPushButtonFc		*move_right_subview_tree_button;
	QTabWidget			*tab_widget;
	CNavigateTree		*navigate_tree;
	CSubviewEdit		*subview_edit;

	CMainviewEditView	*mainview_edit_view;
	COptionEditFrame	*option_edit_frame;
	SOptionFileItem		*option_file_item;
	COptionData			*option_data;
	CViewNode			*view_tree;
	int					current_mainview_index;
	bool				highlight_tree_mode;
	CViewNode			*highlight_view_node;
	CPaletteData		*highlight_palette_data;
	bool				delete_palette_data_flag;

	CAuxiliaryPaletteView	*auxiliary_palette_view;
	CAuxiliaryColorView		*auxiliary_color_view;
	CAuxiliaryFontView		*auxiliary_font_view;
};

struct SNavigateTreeItem: public QListViewItem
{
	SNavigateTreeItem(	SNavigateTreeNode *n,
						QListView *p,
						QString s1,
						QString s2)
		: QListViewItem(p, s1, s2), node(n) { }

	SNavigateTreeItem(	SNavigateTreeNode *n,
						QListViewItem *p,
						QString s1,
						QString s2)
		: QListViewItem(p, s1, s2), node(n) { }

	void	SetNode(SNavigateTreeNode *n) { node = n; }

	SNavigateTreeNode	*node;
};

struct SNavigateTreeNode
{
	SNavigateTreeNode(	SNavigateTreeNode *p,
						SNavigateTreeItem *i,
						const string &n_name,
						vector<int> *index)
		: parent(p), item(i), node_name(n_name), node_index(index) { }

	~SNavigateTreeNode()
	{
		vector<SNavigateTreeNode *>::size_type	i;

		for (i=0; i<descendants.size(); i++)
			delete descendants[i];
	}

	void    AddChild(SNavigateTreeNode *n) { descendants.push_back(n); }

	SNavigateTreeNode			*parent;
	SNavigateTreeItem			*item;
	string						node_name;
	vector<int>					*node_index;
	vector<SNavigateTreeNode *>	descendants;
};

class CNavigateTree: public QListView
{
	Q_OBJECT
	public:
	CNavigateTree(QWidget *parent, CMainviewTreeEdit *mvte);
	virtual ~CNavigateTree();

	void	SetupListView();

	void	SetViewTree(CViewNode *n, vector<int> *highlight_index);

	SNavigateTreeNode	*FindNode(SNavigateTreeNode *n, vector<int> *index);
	SNavigateTreeNode	*FindNode(SNavigateTreeNode *n, vector<int> &iv);
	void				MoveHighlightToIndex(vector<int> *highlight_index);

	void				CreateIndexText(ostrstream &s, vector<int> *index);
	SNavigateTreeNode	*CreateNavigateTree(SNavigateTreeNode *parent,
											CViewNode *vn);
	void				OpenNavigateTree(SNavigateTreeNode *n);

	public slots:
	void	CurrentItemChanged(QListViewItem *item);

	private:
	CMainviewTreeEdit	*mainview_tree_edit;
	CViewNode			*view_tree;
	SNavigateTreeNode	*navigate_tree;
	SNavigateTreeNode	*highlight_navigate_tree_node;
	bool				foward_current_item_changed_flag;
};

class CSubviewEdit: public CFrameFc
{
	Q_OBJECT
	public:
	CSubviewEdit(QWidget *parent, CMainviewTreeEdit *mvte);
	virtual ~CSubviewEdit();

	void	SetupListView();

	SReplaceNode	CreateModifyStruct();
	void			SetSubviewTypes(const vector< pair<string, int> > *st);
	void			UpdateMultiplicityCountMap();
	bool			MultiplicityCountReached(const string &sv);

	virtual void    setFont(const QFont &f);

	public slots:
	void	SelectFont();
	void	SelectPalette();
	void	AddNodeBefore();
	void	AddNodeAfter();
	void	ReplaceNode();
	void	DeleteNode();
	void	SplitterRadioToggled(bool on);
	void	SubviewRadioToggled(bool on);
	void	HorizontalRadioToggled(bool on);
	void	VerticalRadioToggled(bool on);

	private:
	CPushButtonFc	*select_font_button;
	CPushButtonFc	*select_palette_button;

	QGridLayout		*subgrid_layout1;
	CSpacerFc		*spacer1_1;
	CCheckBoxFc		*subtree_font_check_box;
	CSpacerFc		*spacer1_2;
	CCheckBoxFc		*subtree_palette_check_box;

	CPushButtonFc	*add_node_before_button;
	CPushButtonFc	*add_node_after_button;

	CPushButtonFc	*replace_node_button;
	CPushButtonFc	*delete_node_button;

	QGridLayout		*subgrid_layout2;
	CSpacerFc		*spacer2_1;
	CRadioButtonFc	*splitter_radio_button;
	CRadioButtonFc	*subview_radio_button;
	CSpacerFc		*spacer2_2;

	QGridLayout		*subgrid_layout3;
	CSpacerFc		*spacer3_1;
	CRadioButtonFc	*horizontal_radio_button;
	CRadioButtonFc	*vertical_radio_button;
	CSpacerFc		*spacer3_2;

	CLabelFc		*splitter_pane_count_label;
	QSpinBox		*splitter_pane_count_spinbox;

	QListView		*subview_type_list_view;

	CMainviewTreeEdit					*mainview_tree_edit;
	const vector< pair<string, int> >	*subview_types;
	map<string, pair<int, int> >		subview_multiplicity_count_map;
};

class CApplicationEditView: public CFrameFc
{
	Q_OBJECT
	public:
	CApplicationEditView(QWidget *parent, COptionEditFrame *oef);
	virtual ~CApplicationEditView();

	void	UpdateOptionEditFrameGeometry();
	void	SetupAuxiliaryListViews();
	void	SetOptionData(SOptionFileItem *ofi, COptionData *d);
	void	DisplayMainOptionData();
	void	DisplayHelpOptionData();

	CAuxiliaryPaletteView	*GetAuxiliaryPaletteView() const
	{ return auxiliary_palette_view; }
	CAuxiliaryColorView		*GetAuxiliaryColorView() const
	{ return auxiliary_color_view; }
	CAuxiliaryFontView		*GetAuxiliaryFontView() const
	{ return auxiliary_font_view; }

	public slots:
	void	SelectMainFont();
	void	DefaultMainFont();
	void	SelectMainPalette();
	void	DefaultMainPalette();
	void	CopyMainPalette();
	void	PasteMainPalette();
	void	SelectHelpFont();
	void	DefaultHelpFont();
	void	SelectHelpPalette();
	void	DefaultHelpPalette();
	void	CopyHelpPalette();
	void	PasteHelpPalette();

	private:
	CPushButtonFc	*select_main_font_button;
	CPushButtonFc	*default_main_font_button;
	CLineEditFc		*main_font_line_edit;
	CPushButtonFc	*select_main_palette_button;
	CPushButtonFc	*default_main_palette_button;
	CPushButtonFc	*copy_main_palette_button;
	CPushButtonFc	*paste_main_palette_button;
	CSpacerFc		*spacer1;
	QScrollView		*main_scrollview;
	QLabel			*main_palette_label;
	CPushButtonFc	*select_help_font_button;
	CPushButtonFc	*default_help_font_button;
	CLineEditFc		*help_font_line_edit;
	CPushButtonFc	*select_help_palette_button;
	CPushButtonFc	*default_help_palette_button;
	CPushButtonFc	*copy_help_palette_button;
	CPushButtonFc	*paste_help_palette_button;
	CSpacerFc		*spacer2;
	QScrollView		*help_scrollview;
	QLabel			*help_palette_label;

	QTabWidget				*tab_widget;
	CAuxiliaryPaletteView	*auxiliary_palette_view;
	CAuxiliaryColorView		*auxiliary_color_view;
	CAuxiliaryBrushView		*auxiliary_brush_view;
	CAuxiliaryXpmImageView	*auxiliary_xpm_image_view;
	CAuxiliaryFontView		*auxiliary_font_view;
	CAuxiliaryStringView	*auxiliary_string_view;

	COptionEditFrame				*option_edit_frame;
	CPaletteData					*default_palette;
	SOptionFileItem					*option_file_item;
	COptionData						*option_data;
	COptionData::SApplicationData	*application_data;
	COptionData::SHelpData			*help_data;
};

class CAuxiliaryView: public CFrameFc
{
	Q_OBJECT
	public:
	CAuxiliaryView(QWidget *parent, COptionEditFrame *oef);
	virtual ~CAuxiliaryView() { }

	void	SetOptionData(COptionData *d)
	{ option_data = d; UpdateListView(0); }
	QListView	*GetListView() const
	{ return auxiliary_list_view; }
	COptionData	*GetOptionData() const
	{ return option_data; }

	void			SetupListView(const string &column1);

	virtual void	UpdateListView(const string *s) = 0;

	public slots:
	virtual void	AddAuxiliary() = 0;
	virtual void	EditAuxiliary() = 0;
	virtual void	RenameAuxiliary() = 0;
	virtual void	DeleteAuxiliary() = 0;
	virtual void	CopyAuxiliary() = 0;
	virtual void	PasteAuxiliary() = 0;
	void			NameEntry();
	void			CurrentItemChanged(QListViewItem *item);

	protected:
	CPushButtonFc	*add_auxiliary_button;
	CPushButtonFc	*edit_auxiliary_button;
	CPushButtonFc	*rename_auxiliary_button;
	CPushButtonFc	*delete_auxiliary_button;
	CPushButtonFc	*copy_auxiliary_button;
	CPushButtonFc	*paste_auxiliary_button;
	CLabelFc		*auxiliary_name_label;
	CLineEditFc		*auxiliary_name_line_edit;
	QListView		*auxiliary_list_view;

	COptionEditFrame	*option_edit_frame;
	COptionData			*option_data;
};

class CAuxiliaryPaletteView: public CAuxiliaryView
{
	Q_OBJECT
	public:
	CAuxiliaryPaletteView(QWidget *parent, COptionEditFrame *oef)
		: CAuxiliaryView(parent, oef), auxiliary_palettes(0) { }
	virtual ~CAuxiliaryPaletteView() { }

	CAuxiliaryColorView		*GetAuxiliaryColorView() const
	{ return auxiliary_color_view; }
	void	SetAuxiliaryColorView(CAuxiliaryColorView *acv)
	{ auxiliary_color_view = acv; }

	bool	AddAuxiliaryPalette(const string &name,
								CPaletteData *value);

	virtual void	UpdateListView(const string *s);

	public slots:
	virtual void	AddAuxiliary();
	virtual void	EditAuxiliary();
	virtual void	RenameAuxiliary();
	virtual void	DeleteAuxiliary();
	virtual void	CopyAuxiliary();
	virtual void	PasteAuxiliary();

	private:
	map<string, CPaletteData *>		*auxiliary_palettes;
	CAuxiliaryColorView				*auxiliary_color_view;
};

class CAuxiliaryColorView: public CAuxiliaryView
{
	Q_OBJECT
	public:
	CAuxiliaryColorView(QWidget *parent, COptionEditFrame *oef)
		: CAuxiliaryView(parent, oef), auxiliary_colors(0) { }
	virtual ~CAuxiliaryColorView() { }

	bool	AddAuxiliaryColor(	const string &name,
								CPaletteData::SColorSpecifier *value);

	virtual void	UpdateListView(const string *s);

	public slots:
	virtual void	AddAuxiliary();
	virtual void	EditAuxiliary();
	virtual void	RenameAuxiliary();
	virtual void	DeleteAuxiliary();
	virtual void	CopyAuxiliary();
	virtual void	PasteAuxiliary();

	private:
	map<string, CPaletteData::SColorSpecifier *>	*auxiliary_colors;
};

class CAuxiliaryBrushView: public CAuxiliaryView
{
	Q_OBJECT
	public:
	CAuxiliaryBrushView(QWidget *parent, COptionEditFrame *oef)
		: CAuxiliaryView(parent, oef), auxiliary_brushes(0) { }
	virtual ~CAuxiliaryBrushView() { }

	CAuxiliaryColorView		*GetAuxiliaryColorView() const
	{ return auxiliary_color_view; }
	void	SetAuxiliaryColorView(CAuxiliaryColorView *acv)
	{ auxiliary_color_view = acv; }

	CAuxiliaryXpmImageView		*GetAuxiliaryXpmImageView() const
	{ return auxiliary_xpm_image_view; }
	void	SetAuxiliaryXpmImageView(CAuxiliaryXpmImageView *axiv)
	{ auxiliary_xpm_image_view = axiv; }

	virtual void	UpdateListView(const string *s);

	public slots:
	virtual void	AddAuxiliary();
	virtual void	EditAuxiliary();
	virtual void	RenameAuxiliary();
	virtual void	DeleteAuxiliary();
	virtual void	CopyAuxiliary();
	virtual void	PasteAuxiliary();

	private:
	map<string, CPaletteData::SBrushSpecifier *>	*auxiliary_brushes;
	CAuxiliaryColorView								*auxiliary_color_view;
	CAuxiliaryXpmImageView							*auxiliary_xpm_image_view;
};

class CAuxiliaryXpmImageView: public CAuxiliaryView
{
	Q_OBJECT
	public:
	CAuxiliaryXpmImageView(QWidget *parent, COptionEditFrame *oef)
		: CAuxiliaryView(parent, oef), auxiliary_xpm_images(0) { }
	virtual ~CAuxiliaryXpmImageView() { }

	bool	AddAuxiliaryXpmImage(	const string &name,
									CXpmImage *value);

	virtual void	UpdateListView(const string *s);

	public slots:
	virtual void	AddAuxiliary();
	virtual void	EditAuxiliary();
	virtual void	RenameAuxiliary();
	virtual void	DeleteAuxiliary();
	virtual void	CopyAuxiliary();
	virtual void	PasteAuxiliary();

	private:
	map<string, CXpmImage *>	*auxiliary_xpm_images;
};

class CAuxiliaryFontView: public CAuxiliaryView
{
	Q_OBJECT
	public:
	CAuxiliaryFontView(QWidget *parent, COptionEditFrame *oef)
		: CAuxiliaryView(parent, oef), auxiliary_fonts(0) { }
	virtual ~CAuxiliaryFontView() { }

	bool			AddAuxiliaryFont(const string &name, const string &value);
	virtual void	UpdateListView(const string *s);

	public slots:
	virtual void	AddAuxiliary();
	virtual void	EditAuxiliary();
	virtual void	RenameAuxiliary();
	virtual void	DeleteAuxiliary();
	virtual void	CopyAuxiliary();
	virtual void	PasteAuxiliary();

	private:
	map<string, string>		*auxiliary_fonts;
};

class CAuxiliaryStringView: public CAuxiliaryView
{
	Q_OBJECT
	public:
	CAuxiliaryStringView(QWidget *parent, COptionEditFrame *oef)
		: CAuxiliaryView(parent, oef), auxiliary_strings(0) { }
	virtual ~CAuxiliaryStringView() { }

	virtual void	UpdateListView(const string *s);

	public slots:
	virtual void	AddAuxiliary();
	virtual void	EditAuxiliary();
	virtual void	RenameAuxiliary();
	virtual void	DeleteAuxiliary();
	virtual void	CopyAuxiliary();
	virtual void	PasteAuxiliary();

	private:
	map<string, string>		*auxiliary_strings;
};

struct SConnectionTreeItem: public QCheckListItem
{
	SConnectionTreeItem(QListViewItem *parent, const QString &s, bool &cf)
		: QCheckListItem(parent, s, QCheckListItem::CheckBox),
			connection_flag(cf) { setOn(connection_flag); }

	virtual void	stateChange(bool cf) { connection_flag = cf; }

	bool	&connection_flag;
};

class CConnectionEditView: public CFrameFc
{
	Q_OBJECT
	public:
	CConnectionEditView(QWidget *parent, COptionEditFrame *oef);
	virtual ~CConnectionEditView();

	void	UpdateOptionEditFrameGeometry();
	void	SetOptionData(SOptionFileItem *ofi, COptionData *d);
	void	StoreConnectionData();
	void	CreateOptionDataMainViewTree(OptionDataMainViewMap *odmvm);
	void	CreateConnectionMainViewTree(	QListViewItem *item,
											ConnectionMainViewMap *cmvm);
	void	CreateIndexText(ostrstream &s, const vector<int> &index);

	public slots:
	void	Connect();
	void	Disconnect();
	void	ConnectAll();
	void	DisconnectAll();

	private:
	CPushButtonFc	*connect_button;
	CPushButtonFc	*disconnect_button;
	CPushButtonFc	*connect_all_button;
	CPushButtonFc	*disconnect_all_button;
	CSpacerFc		*spacer;
	QListView		*connection_list_view;

	COptionEditFrame	*option_edit_frame;
	SOptionFileItem		*option_file_item;
	COptionData			*option_data;

	OptionDataMainViewMap	*option_data_main_view_map;
};

#endif
