/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef PARSERDRIVER_H
#define PARSERDRIVER_H

using namespace std;

#include "tvaluelist.h"
#include "lexicalDriver.h"

class CParserDriver
{
	public:
	enum StatusCode
	{
		NoError				= 0,
		LexicalError		= 1,
		ParserError			= 2,
		CodeGenerationError	= 4,
		ParserHalted		= 8,
		EndOfFile			= 16
	};

	enum ActionType
	{
		Shift,
		Reduce,
		Accept,
		Error,
		Conflict,
		Quit,
		SetupErrorStack,
		ShiftErrorToken,
		DiscardToken,
		InputSynchronized,
		SynchronizationComplete
	};

	enum DriverState
	{
		NonErrorParse,
		FindErrorInputState,
		ErrorParseThruErrorShift,
		ErrorParseAfterErrorShift,
		ErrorParseSynchronization,
		ParseStreamDone
	};

	CParserDriver(	int tce, int sca, int rca, int est, int sa,
					int aa, int ce, int sc, int nce, int nei,
					const int *a_table, const int *g_table,
					const int *rls_table, const int *rrl_table);
	virtual ~CParserDriver();

	void			Initialize(	int iss = 100, bool icgf = true,
								bool dlef = false, bool erf = false,
								bool spm = false);
	void			InitializeSyntaxMode(	int iss = 100, bool icgf = true,
											bool dlef = false, bool erf = false)
	{ Initialize(iss, icgf, dlef, erf, true); }
	void			SetInitialCodeGenerationFlag(bool f)
	{ initial_code_generation_flag = f; }
	void			SetDiscardLexicalErrorFlag(bool f)
	{ discard_lexical_error_flag = f; }
	void			SetErrorReportingFlag(bool f)
	{ error_reporting_flag = f; }
	void			SetErrorOutputStream(ostream *o_stream)
	{ error_output_stream = o_stream; }
	void			HaltParser()
	{ halt_parser_flag = true; }
	void			SetErrorToken(int et)
	{ error_token = et; }
	void			SetSynchronizationLength(int sl)
	{ synchronization_length = sl; }

	void			SetLexical(CLexicalDriver *l) { lexical = l; }
	void			PushLexical(CLexicalDriver *l);
	void			PopLexical();
	StatusCode		ParseStream();
	ActionType		ParseStreamSingleStep();
	CStackElement	*CompiledObject() { return stack + 1; }

	virtual void	SetupFunctionTables() { }
	virtual int     CallReduceFunction(int action, void *data)
	{ stack_ptr->type = StackNonTerminal; return 0; }
	virtual void	CallErrorFunction(int index) { }
	virtual void	CallConflictFunction(int index) { }
	virtual void    DeleteGeneratedCode(CStackElement *s, int c) { }

	int			GetToken() const			{ return token; }
	int			GetAction() const			{ return action; }
	int			GetMachineState() const		{ return machine_state; }
	int			GetStackCount() const		{ return stack_count; }
	int			GetErrorToken() const		{ return error_token; }
	int			GetErrorStackCount() const	{ return error_stack_count; }
	int			GetDriverState() const		{ return driver_state; }

	private:
	int			terminal_count_e;
	int			symbol_count_a;
	int			rule_count_a;
	int			empty_symbol_token;
	int			shift_action;
	int			accept_action;
	int			conflict_entry;
	int			state_count;
	int			number_of_conflict_entries;
	int			number_of_error_indexes;
	const int	*action_table;
	const int	*goto_table;
	const int	*rule_left_symbol_table;
	const int	*rule_right_length_table;

	ostream			*error_output_stream;
	DriverState		driver_state;

	int				initial_stack_size;
	int				stack_size;
	int				stack_count;
	CStackElement	*stack;

	protected:
	CStackElement	*stack_ptr;

	private:
	bool			stack_modification_flag;
	int				error_token;
	int				synchronization_length;
	int				synchronization_count;
	int				error_stack_size;
	int				error_stack_count;
	CStackElement	*error_stack;
	CStackElement	*error_stack_ptr;

	TValueList<CStackElement>			input_token_fifo;
	TValueList<CStackElement>::listptr	input_token_fifo_listptr;

	CLexicalDriver					*lexical;
	TValueList<CLexicalDriver *>	lexical_stack;

	int			token;
	int			action;
	int			machine_state;

	bool		initial_code_generation_flag;
	bool		discard_lexical_error_flag;
	bool		error_reporting_flag;
	bool		syntax_parsing_mode;
	bool		code_generation_flag;
	bool		call_reduce_function_flag;
	bool		halt_parser_flag;

	bool		lexical_error_flag;
	bool		parser_error_flag;
	bool		code_generation_error_flag;
	bool		end_of_file_flag;

	StatusCode		ReturnStatusCode();
	void			DoubleStack();
	void			DoubleErrorStack();
	ActionType		MapActionToType(int action);
	void			HaltCodeGeneration();
	ActionType		ProcessNonErrorParse();
	ActionType		ProcessFindErrorInputState();
	ActionType		ProcessErrorParseThruErrorShift();
	ActionType		ProcessErrorParseAfterErrorShift();
	ActionType		ProcessErrorParseSynchronized();
};

#endif
