/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef ROLEDATA_H
#define ROLEDATA_H

#include <qnamespace.h>
#include <qpalette.h>

const int	number_of_color_groups = 3;

struct SGroupName
{
	const char				*name;
	QPalette::ColorGroup	group_id;
};

const SGroupName group_names[] =
{
	{ "Active",				QPalette::Active	},
	{ "Inactive",			QPalette::Inactive	},
	{ "Disabled",			QPalette::Disabled	},
	(const char *)0
};

const int	number_of_color_roles = 16;

struct SRoleName
{
	const char				*name;
	QColorGroup::ColorRole	role_id;
};

const SRoleName	role_names[] =
{
	{ "Background",			QColorGroup::Background		},
	{ "Foreground",			QColorGroup::Foreground		},
	{ "Base",				QColorGroup::Base			},
	{ "Text",				QColorGroup::Text			},
	{ "Button",				QColorGroup::Button			},
	{ "ButtonText",			QColorGroup::ButtonText		},
	{ "Light",				QColorGroup::Light			},
	{ "Midlight",			QColorGroup::Midlight		},
	{ "Dark",				QColorGroup::Dark			},
	{ "Mid",				QColorGroup::Mid			},
	{ "Shadow",				QColorGroup::Shadow			},
	{ "Highlight",			QColorGroup::Highlight		},
	{ "HighlightedText",	QColorGroup::HighlightedText},
	{ "BrightText",			QColorGroup::BrightText		},
	{ "Link",				QColorGroup::Link			},
	{ "LinkVisited",		QColorGroup::LinkVisited	},
	(const char *)0
};

const int	number_of_brush_styles = 16;

struct SBrushStyleName
{
	const char			*name;
	Qt::BrushStyle		style_id;
};

const SBrushStyleName	brush_style_names[] =
{
	{ "NoBrush",			Qt::NoBrush				},
	{ "SolidPattern",		Qt::SolidPattern		},
	{ "Dense1Pattern",		Qt::Dense1Pattern		},
	{ "Dense2Pattern",		Qt::Dense2Pattern		},
	{ "Dense3Pattern",		Qt::Dense3Pattern		},
	{ "Dense4Pattern",		Qt::Dense4Pattern		},
	{ "Dense5Pattern",		Qt::Dense5Pattern		},
	{ "Dense6Pattern",		Qt::Dense6Pattern		},
	{ "Dense7Pattern",		Qt::Dense7Pattern		},
	{ "HorPattern",			Qt::HorPattern			},
	{ "VerPattern",			Qt::VerPattern			},
	{ "CrossPattern",		Qt::CrossPattern		},
	{ "BDiagPattern",		Qt::BDiagPattern		},
	{ "FDiagPattern",		Qt::FDiagPattern		},
	{ "DiagCrossPattern",	Qt::DiagCrossPattern	},
	{ "CustomPattern",		Qt::CustomPattern		},
	(const char *)0
};

#endif
