/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "ruleCodeView.h"

bool	CRuleCodeMultiLineEdit::event(QEvent *e)
{
	bool	tab_flag = rule_code_vbox->GetTabIndicator();

	if (e->type() == QEvent::KeyPress)
	{
		if (((QKeyEvent *)e)->key() == Qt::Key_Escape)
		{
			rule_code_vbox->ToggleTabIndicator();

			if (!tab_flag)
			{
				this->keyPressEvent((QKeyEvent *)e);
				return true;
			}
		}
		else
		{
			if (((QKeyEvent *)e)->key() == Qt::Key_F1)
				rule_code_vbox->ToggleRuleIndicator();
			else if (((QKeyEvent *)e)->key() == Qt::Key_G &&
				((QKeyEvent *)e)->state() == Qt::ControlButton)
				rule_code_vbox->FindString();

			if (tab_flag)
			{
				this->keyPressEvent((QKeyEvent *)e);
				return true;
			}
		}
	}
	else if (e->type() == QEvent::KeyRelease)
	{
		if (tab_flag)
		{
			this->keyReleaseEvent((QKeyEvent *)e);
			return true;
		}
	}

	return CMultiLineEditFc::event(e);
}

CRuleCodeVBoxWidget::CRuleCodeVBoxWidget(
									QWidget *parent,
									CCompilerInterface *ci,
									SMainViewControl *mvc,
									COptionData::SSubViewData *d,
									CRuleCodeView *rcv)
	: CVBoxWidget(parent, ci, mvc), compiler_interface(ci),
		subview_data(d), rule_code_view(rcv),
		module_ptr_map(rcv->GetModulePtrMap())
{
	label = new CLabelFc("rule code", this, true);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	tab_indicator	= false;
	rule_indicator	= false;

	multi_line_edit = new CRuleCodeMultiLineEdit(this);

	multi_line_edit->setWordWrap(QMultiLineEdit::NoWrap);

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	setSpacing(0);
	setStretchFactor(label, 0);
	setStretchFactor(multi_line_edit, 1);

	compiler_data = compiler_interface->GetCompilerData();
}

CRuleCodeVBoxWidget::~CRuleCodeVBoxWidget()
{
}

void	CRuleCodeVBoxWidget::ClearMultiLineEditText()
{
	disconnect(	multi_line_edit,
				SIGNAL(textChanged()),
				this,
				SLOT(CodeTextChanged()));

	multi_line_edit->clear();

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	if (rule_indicator)
	{
		rule_indicator = false;

		ToggleRuleIndicator();
	}
}

void	CRuleCodeVBoxWidget::SetTabStopWidth(int count)
{
	QFontMetrics	fm(font());

	int		w = fm.width(QChar('Z'));

	multi_line_edit->setTabStopWidth(count * w);
}

void	CRuleCodeVBoxWidget::SetMultiLineEditText(const list<string> &code)
{
	disconnect(	multi_line_edit,
				SIGNAL(textChanged()),
				this,
				SLOT(CodeTextChanged()));

	multi_line_edit->clear();

	list<string>::const_iterator	s_iterator = code.begin();

	while (s_iterator != code.end())
	{
		const string	&s = *s_iterator++;

		if (!s.length())
			multi_line_edit->append("\n");
		else
			multi_line_edit->append(s.c_str());
	}

	multi_line_edit->setCursorPosition(0, 0);

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	if (rule_indicator)
	{
		rule_indicator = false;

		ToggleRuleIndicator();
	}
}

void	CRuleCodeVBoxWidget::GetMultiLineEditText(list<string> &code)
{
	code.clear();

	int		count = multi_line_edit->numLines();
	int		i;

	for (i=0; i<count; i++)
		code.push_back(
			(const char *)(multi_line_edit->textLine(i).local8Bit()));

	if (code.back() == string(""))
		code.pop_back();
}

bool	CRuleCodeVBoxWidget::GetCodeEditedFlag()
{
	return multi_line_edit->edited();
}

void	CRuleCodeVBoxWidget::SetCodeEditedFlag(bool f)
{
	multi_line_edit->setEdited(f);
}

bool	CRuleCodeVBoxWidget::GetTabIndicator()
{
	return tab_indicator;
}

void	CRuleCodeVBoxWidget::ToggleTabIndicator()
{
	string	s1("rule code");
	string	s2;

	if (tab_indicator)
	{
		tab_indicator = false;
	}
	else
	{
		s1 += " (tab entry)";

		tab_indicator = true;
	}

	if (rule_indicator)
	{
		if (rsv)
			rsv->GetCurrentFunctionString(s2);

		s1 += ": ";
		s1 += s2;

		label->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	}
	else
		label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	label->setText(s1.c_str());
}

void	CRuleCodeVBoxWidget::ToggleRuleIndicator()
{
	string	s1("rule code");
	string	s2;

	if (tab_indicator)
		s1 += " (tab entry)";

	if (rule_indicator)
	{
		label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

		rule_indicator = false;
	}
	else
	{
		if (rsv)
			rsv->GetCurrentFunctionString(s2);

		s1 += ": ";
		s1 += s2;

		label->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);

		rule_indicator = true;
	}

	label->setText(s1.c_str());
}

void	CRuleCodeVBoxWidget::UndoEdit()
{
	multi_line_edit->undo();
}

void	CRuleCodeVBoxWidget::RedoEdit()
{
	multi_line_edit->redo();
}

void	FindMultiLineEditString(QMultiLineEdit *multi_line_edit);

void	CRuleCodeVBoxWidget::FindString()
{
	FindMultiLineEditString(multi_line_edit);
}

void	CRuleCodeVBoxWidget::InitializeModulePointers()
{
	vector<CSubView *>		&v1 = module_ptr_map["RULE_SELECT_VIEW"];

	if (v1.size())
		rsv = dynamic_cast<CRuleSelectView *>(v1[0]);
	else
		rsv = 0;
}

void	CRuleCodeVBoxWidget::RestoreUndoData()
{
	compiler_data = compiler_interface->GetCompilerData();
}

void	CRuleCodeVBoxWidget::CodeTextChanged()
{
	if (rsv)
		rsv->CodeTextChanged();
}

CRuleCodeView::CRuleCodeView(	QWidget *p,
								CViewNode *n,
								CInterfaceControl *ic,
								SMainViewControl *mvc,
								const string &dfs,
								CPaletteData *dpd,
								COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CRuleCodeVBoxWidget(
		p, dynamic_cast<CCompilerInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
		frame->setPalette(view_node_palette);
	else
		frame->setPalette(frame->palette());
}

CRuleCodeView::~CRuleCodeView()
{
	delete frame;
}

void	CRuleCodeView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CRuleCodeView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CRuleCodeView::InitializeModulePointers()
{
	frame->InitializeModulePointers();
}

void	CRuleCodeView::ClearMultiLineEditText()
{
	frame->ClearMultiLineEditText();
}

void	CRuleCodeView::SetTabStopWidth(int count)
{
	frame->SetTabStopWidth(count);
}

void	CRuleCodeView::SetMultiLineEditText(const list<string> &code)
{
	frame->SetMultiLineEditText(code);
}

void	CRuleCodeView::GetMultiLineEditText(list<string> &code)
{
	frame->GetMultiLineEditText(code);
}

bool	CRuleCodeView::GetCodeEditedFlag()
{
	return frame->GetCodeEditedFlag();
}

void	CRuleCodeView::SetCodeEditedFlag(bool f)
{
	frame->SetCodeEditedFlag(f);
}

void	CRuleCodeView::UndoEdit()
{
	frame->UndoEdit();
}

void	CRuleCodeView::RedoEdit()
{
	frame->RedoEdit();
}

void	CRuleCodeView::FindString()
{
	frame->FindString();
}

void	CRuleCodeView::RestoreUndoData()
{
	frame->RestoreUndoData();
}
