/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef SIMULATECONTROLVIEW_H
#define	SIMULATECONTROLVIEW_H

class CSimulateControlControl;
class CSimulateControlVBoxWidget;
class CSimulateControlView;

#include <list>
#include <string>
#include <utility>

#include <qobject.h>
#include <qwidget.h>
#include <qfont.h>
#include <qtimer.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerData.h"
#include "compilerInterface.h"
#include "simulateInputView.h"
#include "simulateTreeView.h"
#include "parserDialog.h"
#include "optionData.h"
#include "lexicalDriver.h"
#include "parserDriver.h"

class CSimulateControlControl: public CFrameFc
{
	Q_OBJECT
	public:
	CSimulateControlControl(CSimulateControlVBoxWidget *v);
	~CSimulateControlControl() { }

	virtual void	setFont(const QFont &f);

	void	ClearSimulateControl();
	void	UpdateSimulateControl(	const string &state,
									const string &terminal,
									const string &action,
									int level);
	int		GetTimerInterval();
	void	SetTimerInterval(int t);
	int		GetExpandLevel();

	public slots:
	void	SetControlOptions();
	void	ResetSimulator();
	void	NextOperation();
	void	RunSimulator();
	void	ExpandParseTree();

	private:
	CSimulateControlVBoxWidget	*simulate_control_vbox;
	CLabelFc					*state_label;
	CLabelFc					*state_value;
	CLabelFc					*terminal_label;
	CLabelFc					*terminal_value;
	CLabelFc					*action_label;
	CLabelFc					*action_value;
	QGridLayout					*subgrid_layout;
	CLabelFc					*timer_label;
	CLineEditFc					*timer_line_edit;
	CPushButtonFc				*expand_button;
	QSpinBox					*expand_spinbox;
	CPushButtonFc				*options_button;
	CPushButtonFc				*reset_button;
	CPushButtonFc				*next_button;
	CPushButtonFc				*run_button;
};

class CSimulateControlVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CSimulateControlVBoxWidget(	QWidget *parent,
								CCompilerInterface *ci,
								SMainViewControl *mvc,
								COptionData::SSubViewData *d,
								CSimulateControlView *scv);

	virtual ~CSimulateControlVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	SetControlOptions();
	void	ResetSimulator();
	void	NextOperation();
	void	RunSimulator();
	void	ExpandParseTree();
	void	InitializeSimulator();
	void	RestoreUndoData();

	public slots:
	void	TimerOperation();

	private:
	CLabelFc					*label;
	CSimulateControlControl		*simulate_control_control;
	bool						simulate_lexical_flag;
	bool						simulate_parser_flag;
	bool						discard_lexical_error_flag;
	bool						with_unit_rule_eliminations_flag;
	int							number_of_error_indexes;
	int							number_of_error_functions;
	int							*error_function_index_table;
	bool						*lexical_symbol_trap_list;
	bool						*parser_symbol_trap_list;
	CXpmImage					*default_filter_xpm_image;
	CXpmImage					*default_token_literal_xpm_image;
	CXpmImage					*default_token_regexp_xpm_image;
	CXpmImage					*default_error_token_xpm_image;
	CXpmImage					*default_nonterminal_xpm_image;
	CXpmImage					*end_of_file_xpm_image;
	CXpmImage					**lexical_xpm_image_table;
	CXpmImage					**parser_xpm_image_table;

	static const char * const	default_filter_data[];
	static const char * const	default_token_literal_data[];
	static const char * const	default_token_regexp_data[];
	static const char * const	default_error_token_data[];
	static const char * const	default_nonterminal_data[];

	CXpmImage		*CreateXpmImage(const char * const data[]);
	void			CreateAutomatons();
	void			NextLexicalOperation();
	void			NextParserOperation();

	bool	ProcessLexical();
	void	ProcessNonErrorParse();
	void	ProcessFindErrorInputState();
	void	ProcessErrorParseThruErrorShift();
	void	ProcessErrorParseAfterErrorShift();
	void	ProcessErrorParseSynchronized();

	QTimer			*timer;
	bool			ready;
	bool			running;
	bool			finished;
	int				terminal_code;
	unsigned char	*terminal_ptr;
	int				terminal_size;
	int				machine_state_before;
	int				machine_state_after;
	string			control_state_string;
	string			control_terminal_string;
	string			control_action_string;
	string			tree_symbol_string;
	string			tree_state_string;
	string			tree_action_string;
	string			tree_value_string;
	int				driver_state;
	int				action_type;
	bool			push_back_flag;
	int				stack_count;
	int				error_token_code;
	string			error_token_string;
	int				pop_top_length;
	int				expand_level;
	CLexicalDriver	*lexical;
	CParserDriver	*parser;
	QString			input_text;
	string			input_buffer;

	list< pair<int, string> >				synchronization_tokens;
	list< pair<int, string> >::iterator		synchronization_iterator;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData					*option_data;
	COptionData::SSubViewData	*subview_data;
	CSimulateControlView		*simulate_control_view;
	ModulePtrMap				&module_ptr_map;

	CSimulateInputView			*siv;
	CSimulateTreeView			*stv;
	CErrorSelectView			*esv;
};

class CSimulateControlView: public CSubView
{
	public:
	CSimulateControlView(	QWidget *p,
							CViewNode *n,
							CInterfaceControl *ic,
							SMainViewControl *mvc,
							const string &dfs,
							CPaletteData *dpd,
							COptionData::SSubViewData *d);

	virtual ~CSimulateControlView();

	virtual CSimulateControlVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	SetControlOptions();
	void	ResetSimulator();
	void	NextOperation();
	void	RunSimulator();
	void	ExpandParseTree();
	void	InitializeSimulator();
	void	RestoreUndoData();

	private:
	CSimulateControlVBoxWidget		*frame;
};

#endif
