/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "simulateTreeView.h"

void	CParserTreeItem::setOpen(bool o)
{
	if (!o)
	{
		QListViewItem::setOpen(o);
		return;
	}

	list<CParserTreeNode *>		&node_list = node->descendants;

	if (!node_list.size())
	{
		QListViewItem::setOpen(o);
		return;
	}

	CParserTreeNode	*first;
	CParserTreeNode	*next;
	CParserTreeNode	*previous;
	CParserTreeItem	*child_item;

	list<CParserTreeNode *>::iterator	n_iterator = node_list.begin();

	first = *n_iterator++;

	if (!first->item)
	{
		child_item = new CParserTreeItem(	first,
											this,
											first->symbol.c_str(),
											first->state.c_str(),
											first->action.c_str(),
											first->value.c_str());

		child_item->setPixmap(0, *(first->xpm_image->pixmap));

		if (first->descendants.size())
			child_item->setExpandable(true);

		first->SetItem(child_item);
	}

	next = first;

	while (n_iterator != node_list.end())
	{
		previous = next;

		next = *n_iterator++;

		if (!next->item)
		{
			child_item = new CParserTreeItem(	next,
												this,
												previous->item,
												next->symbol.c_str(),
												next->state.c_str(),
												next->action.c_str(),
												next->value.c_str());

			child_item->setPixmap(0, *(next->xpm_image->pixmap));

			if (next->descendants.size())
				child_item->setExpandable(true);

			next->SetItem(child_item);
		}
	}

	QListViewItem::setOpen(o);
}

CParserTreeNode::~CParserTreeNode()
{
	list<CParserTreeNode *>::iterator	n_iterator = descendants.begin();

	while (n_iterator != descendants.end())
		delete *n_iterator++;
}

void	CParserTreeNode::ZeroItemPtrs()
{
	if (!item)
		return;

	item = 0;

	list<CParserTreeNode *>::iterator	n_iterator = descendants.begin();

	while (n_iterator != descendants.end())
		(*n_iterator++)->ZeroItemPtrs();
}

void	CParserTreeNode::ExpandItems(int level, int limit)
{
	if (level == limit)
	{
		list<CParserTreeNode *>::iterator	n_iterator = descendants.begin();

		while (n_iterator != descendants.end())
			(*n_iterator++)->DeleteItem();

		if (descendants.size())
			item->setExpandable(true);
		else
			item->setExpandable(false);

		return;
	}

	item->setOpen(true);

	if (level < limit - 1)
	{
		list<CParserTreeNode *>::iterator	n_iterator = descendants.begin();

		while (n_iterator != descendants.end())
			(*n_iterator++)->ExpandItems(level + 1, limit);
	}
}

void	CSimulateTreeListView::InitializePalette(const QPalette &p)
{
	active_highlight			= p.color(	QPalette::Active,
											QColorGroup::Highlight);
	active_highlighted_text		= p.color(	QPalette::Active,
											QColorGroup::HighlightedText);
	inactive_highlight			= p.color(	QPalette::Inactive,
											QColorGroup::Highlight);
	inactive_highlighted_text	= p.color(	QPalette::Inactive,
											QColorGroup::HighlightedText);

	QPalette	focus_palette = p;

	focus_palette.setColor(	QPalette::Active,
							QColorGroup::Highlight,
							inactive_highlight);

	focus_palette.setColor(	QPalette::Active,
							QColorGroup::HighlightedText,
							inactive_highlighted_text);

	setPalette(focus_palette);
}

void	CSimulateTreeListView::focusInEvent(QFocusEvent *e)
{
	QPalette	p = palette();

	p.setColor(	QPalette::Active,
				QColorGroup::Highlight,
				active_highlight);

	p.setColor(	QPalette::Active,
				QColorGroup::HighlightedText,
				active_highlighted_text);

	setPalette(p);

	QListView::focusInEvent(e);
}

void	CSimulateTreeListView::focusOutEvent(QFocusEvent *e)
{
	QPalette	p = palette();

	p.setColor(	QPalette::Active,
				QColorGroup::Highlight,
				inactive_highlight);

	p.setColor(	QPalette::Active,
				QColorGroup::HighlightedText,
				inactive_highlighted_text);

	setPalette(p);

	QListView::focusOutEvent(e);
}

CSimulateTreeVBoxWidget::CSimulateTreeVBoxWidget(
										QWidget *parent,
										CCompilerInterface *ci,
										SMainViewControl *mvc,
										COptionData::SSubViewData *d,
										CSimulateTreeView *stv)
	: CVBoxWidget(parent, ci, mvc), compiler_interface(ci),
		subview_data(d), simulate_tree_view(stv),
		module_ptr_map(stv->GetModulePtrMap())
{
	label = new CLabelFc("parse", this, true);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	list_view = new CSimulateTreeListView(this);

	list_view->header()->setMovingEnabled(false);
	list_view->setSorting(-1);
	list_view->addColumn("tree");
	list_view->addColumn("state");
	list_view->addColumn("action");
	list_view->addColumn("value");
	list_view->setRootIsDecorated(true);
	list_view->setAllColumnsShowFocus(true);

	setSpacing(0);
	setStretchFactor(label, 0);
	setStretchFactor(list_view, 1);

	compiler_data = compiler_interface->GetCompilerData();
}

CSimulateTreeVBoxWidget::~CSimulateTreeVBoxWidget()
{
	list<CParserTreeNode *>::iterator	n_iterator = stack_nodes.begin();

	while (n_iterator != stack_nodes.end())
		delete *n_iterator++;

	n_iterator = restore_nodes.begin();

	while (n_iterator != restore_nodes.end())
		delete *n_iterator++;
}

void	CSimulateTreeVBoxWidget::InitializeModulePointers()
{
}

void	CSimulateTreeVBoxWidget::ShiftSymbol(	const string &sy,
												const string &st,
												const string &ac,
												const string &va,
												const CXpmImage *xi)
{
	CParserTreeItem		*shift_item =
		new CParserTreeItem(0, list_view, current_node->item,
							sy.c_str(), st.c_str(), ac.c_str(), va.c_str());

	if (xi)
		shift_item->setPixmap(0, *(xi->pixmap));

	current_node = new CParserTreeNode(0, shift_item, 1, sy, st, ac, va, xi);

	shift_item->SetNode(current_node);

	stack_nodes.push_back(current_node);
}

int		CSimulateTreeVBoxWidget::ReduceTop(	const string &sy,
											const string &st,
											const string &ac,
											const string &va,
											const CXpmImage *xi,
											int reduce_length)
{
	int							subtree_depth = 0;
	list<CParserTreeNode *>		node_list;

	list<CParserTreeNode *>::reverse_iterator
		n_iterator_r = stack_nodes.rbegin();

	for (int i=0; i<reduce_length; i++)
	{
		CParserTreeNode		*node = *n_iterator_r++;

		if (subtree_depth < node->subtree_depth)
			subtree_depth = node->subtree_depth;

		node->DeleteItem();

		node_list.push_front(node);

		stack_nodes.pop_back();
	}

	subtree_depth++;

	CParserTreeNode		*top = stack_nodes.back();

	CParserTreeItem		*reduce_item =
							new CParserTreeItem(
								0, list_view, top->item,
								sy.c_str(), st.c_str(), ac.c_str(), va.c_str());

	if (xi)
		reduce_item->setPixmap(0, *(xi->pixmap));

	reduce_item->setExpandable(true);

	current_node = new CParserTreeNode(	0, reduce_item, subtree_depth,
										sy, st, ac, va, xi);

	reduce_item->SetNode(current_node);

	stack_nodes.push_back(current_node);

	list<CParserTreeNode *>::iterator		n_iterator = node_list.begin();

	while (n_iterator != node_list.end())
	{
		CParserTreeNode		*child = *n_iterator++;

		current_node->AddChild(child);
		child->SetParent(current_node);
	}

	return subtree_depth;
}

void	CSimulateTreeVBoxWidget::PopTop(int length)
{
	list<CParserTreeNode *>::reverse_iterator
		n_iterator_r = stack_nodes.rbegin();

	for (int i=0; i<length; i++)
	{
		CParserTreeNode		*node = *n_iterator_r++;

		node->DeleteItem();

		restore_nodes.push_front(node);

		stack_nodes.pop_back();
	}
}

void	CSimulateTreeVBoxWidget::RestoreTop()
{
	list<CParserTreeNode *>::iterator	n_iterator = restore_nodes.begin();

	while (n_iterator != restore_nodes.end())
		stack_nodes.push_back(*n_iterator++);

	restore_nodes.clear();
}

void	CSimulateTreeVBoxWidget::ClearTree(const CXpmImage *xi)
{
	list_view->clear();

	list<CParserTreeNode *>::iterator	n_iterator = stack_nodes.begin();

	while (n_iterator != stack_nodes.end())
		delete *n_iterator++;

	stack_nodes.clear();

	CParserTreeItem		*sof_item =
		new CParserTreeItem(0, list_view, "Start Of File", "0", "Start", "SOF");

	if (xi)
		sof_item->setPixmap(0, *(xi->pixmap));

	current_node = new CParserTreeNode(
					0, sof_item, 1, "Start Of File", "0", "Start", "SOF", xi);

	sof_item->SetNode(current_node);

	stack_nodes.push_back(current_node);
}

void	CSimulateTreeVBoxWidget::ExpandTree(int level)
{
	list<CParserTreeNode *>::iterator		n_iterator = stack_nodes.begin();

	while (n_iterator != stack_nodes.end())
		(*n_iterator++)->ExpandItems(1, level);
}

void	CSimulateTreeVBoxWidget::RestoreUndoData()
{
	compiler_data = compiler_interface->GetCompilerData();
}

CSimulateTreeView::CSimulateTreeView(	QWidget *p,
										CViewNode *n,
										CInterfaceControl *ic,
										SMainViewControl *mvc,
										const string &dfs,
										CPaletteData *dpd,
										COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CSimulateTreeVBoxWidget(
		p, dynamic_cast<CCompilerInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
	{
		frame->setPalette(view_node_palette);
		frame->InitializePalette(view_node_palette);
	}
	else
	{
		frame->setPalette(frame->palette());
		frame->InitializePalette(frame->palette());
	}
}

CSimulateTreeView::~CSimulateTreeView()
{
	delete frame;
}

void	CSimulateTreeView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CSimulateTreeView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CSimulateTreeView::InitializeModulePointers()
{
	frame->InitializeModulePointers();
}

void	CSimulateTreeView::ShiftSymbol(	const string &sy,
										const string &st,
										const string &ac,
										const string &va,
										const CXpmImage *xi)
{
	frame->ShiftSymbol(sy, st, ac, va, xi);
}

int		CSimulateTreeView::ReduceTop(	const string &sy,
										const string &st,
										const string &ac,
										const string &va,
										const CXpmImage *xi,
										int reduce_length)
{
	return frame->ReduceTop(sy, st, ac, va, xi, reduce_length);
}

void	CSimulateTreeView::PopTop(int length)
{
	frame->PopTop(length);
}

void	CSimulateTreeView::RestoreTop()
{
	frame->RestoreTop();
}

void	CSimulateTreeView::ClearTree(const CXpmImage *xi)
{
	frame->ClearTree(xi);
}

void	CSimulateTreeView::ExpandTree(int level)
{
	frame->ExpandTree(1);
	frame->ExpandTree(level);
}

void	CSimulateTreeView::RestoreUndoData()
{
	frame->RestoreUndoData();
}
