/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef SOURCEVIEW_H
#define	SOURCEVIEW_H

class CSourceMultiLineEdit;
class CSourceVBoxWidget;
class CSourceView;

#include <string>
#include <list>

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "optionDialog.h"
#include "filePath.h"

class CSourceMultiLineEdit: public CMultiLineEditFc
{
	Q_OBJECT
	public:
	CSourceMultiLineEdit(CSourceVBoxWidget *v)
		: CMultiLineEditFc((QWidget *)v, "", 4), source_vbox(v) { }
	~CSourceMultiLineEdit() { }

	protected:
	virtual bool	event(QEvent *e);
	virtual void	focusInEvent(QFocusEvent *e);

	private:
	CSourceVBoxWidget		*source_vbox;
};

class CSourceVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CSourceVBoxWidget(	QWidget *parent,
						CCompilerInterface *ci,
						SMainViewControl *mvc,
						COptionData::SSubViewData *d,
						CSourceView *sv);

	virtual ~CSourceVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count, bool f = true);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	bool	GetTabIndicator();
	void	ToggleTabIndicator();
	void	ToggleSourceIndicator();
	void	GetCurrentSourceString(string &s);
	void	GetCursorPositionString(string &s);
	void	OpenSourceFile();
	void	ClearSourceFile();
	void	SaveSourceFile();
	void	SaveSourceFile(const string &s);
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	SetModulePointer();

	public slots:
	void	UpdateCursorPosition(int p, int c);
	void	CodeTextChanged();

	private:
	bool						tab_indicator;
	bool						source_indicator;
	bool						file_modified_flag;
	CLabelFc					*label;
	CSourceMultiLineEdit		*multi_line_edit;
	string						current_file_path;
	int							current_paragraph;
	int							current_column;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CSourceView					*source_view;
	ModulePtrMap				&module_ptr_map;
};

class CSourceView: public CSubView
{
	public:
	CSourceView(QWidget *p,
				CViewNode *n,
				CInterfaceControl *ic,
				SMainViewControl *mvc,
				const string &dfs,
				CPaletteData *dpd,
				COptionData::SSubViewData *d);

	virtual ~CSourceView();

	virtual CSourceVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count, bool f = true);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	void	OpenSourceFile();
	void	ClearSourceFile();
	void	SaveSourceFile();
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();

	private:
	CSourceVBoxWidget		*frame;
};

#endif
