/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef TERMINALSELECTVIEW_H
#define	TERMINALSELECTVIEW_H

class CTerminalSelectListView;
class CTerminalSelectVBoxWidget;
class CTerminalSelectView;

#include <qobject.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qheader.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "terminalCodeView.h"

class CTerminalSelectListView: public QListView
{
	Q_OBJECT
	public:
	CTerminalSelectListView(CTerminalSelectVBoxWidget *v)
		: QListView((QWidget *)v, 0, 0), terminal_select_vbox(v) { }
	~CTerminalSelectListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);

	private:
	CTerminalSelectVBoxWidget	*terminal_select_vbox;
	QColor						active_highlight;
	QColor						active_highlighted_text;
	QColor						inactive_highlight;
	QColor						inactive_highlighted_text;
};

class CTerminalSelectVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CTerminalSelectVBoxWidget(	QWidget *parent,
								CCompilerInterface *ci,
								SMainViewControl *mvc,
								COptionData::SSubViewData *d,
								CTerminalSelectView *tsv);

	virtual ~CTerminalSelectVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	UpdateListView();
	void	GetCurrentFunctionString(string &s);
	void	PostCurrentFunctionChanges();
	void	RestoreUndoData();
	void	CodeTextChanged();

	public slots:
	void	SelectTerminalFunction(QListViewItem *item);

	private:
	CLabelFc					*label;
	CTerminalSelectListView		*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CTerminalSelectView			*terminal_select_view;
	ModulePtrMap				&module_ptr_map;

	CTerminalCodeView			*tcv;

	int		current_function;
	void	IndexString(int index, string &s);
	void	FunctionString(const CTerminal *t, string &s);
	void	UpdateTerminalViews();
};

class CTerminalSelectView: public CSubView
{
	public:
	CTerminalSelectView(QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CTerminalSelectView();

	virtual CTerminalSelectVBoxWidget	*GetWidget() { return frame; }
	virtual void					SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	UpdateListView();
	void	GetCurrentFunctionString(string &s);
	void	PostCurrentFunctionChanges();
	void	RestoreUndoData();
	void	CodeTextChanged();

	private:
	CTerminalSelectVBoxWidget		*frame;
};

#endif
