/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "trelation.h"

template <class S, class T>
STRelation<S, T>::STRelation(int c, STOrderedPair<S, T> *p)
{
	count = c;

	pairs = new TValueList< STOrderedPair<S, T> >(count);

	for (int i=0; i<count; i++)
		pairs->PushBack(p[i]);
}

template <class S, class T>
STRelation<S, T>::STRelation(TValueList< STOrderedPair<S, T> > *p)
{
	count = p->Size();
	pairs = p;
}

template <class S, class T>
STRelation<S, T>::STRelation(const STRelation &r)
{
	typename TValueList< STOrderedPair<S, T> >::listptr		pair_listptr;

	count = r.count;

	pairs = new TValueList< STOrderedPair<S, T> >(count);

	pair_listptr = r.pairs->FirstListPtr();

	while (pair_listptr)
		pairs->PushBack(r.pairs->NextData(pair_listptr));
}

template <class S, class T>
STRelation<S, T>::~STRelation()
{
	delete pairs;
}
	
template <class S, class T>
STRelation<T, S>	*STRelation<S, T>::Inverse()
{
	typename TValueList< STOrderedPair<S, T> >::listptr		pair_listptr;

	STRelation<T, S>	*r = new STRelation<T, S>;

	r->count = count;
	r->pairs = new TValueList< STOrderedPair<T, S> >(count);

	pair_listptr = pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<S, T>	&pair_element =
											pairs->NextData(pair_listptr);

		r->pairs->PushBack(STOrderedPair<T, S>(	pair_element.second,
												pair_element.first));
	}

	return r;
}

STRelation<int, int>::STRelation(int c, STOrderedPair<int, int> *p)
{
	count = c;

	pairs = new TValueList< STOrderedPair<int, int> >(count);

	for (int i=0; i<count; i++)
		pairs->PushBack(p[i]);
}

STRelation<int, int>::STRelation(TValueList< STOrderedPair<int, int> > *p)
{
	count = p->Size();
	pairs = p;
}

STRelation<int, int>::STRelation(const STRelation &r)
{
	TValueList< STOrderedPair<int, int> >::listptr		pair_listptr;

	count = r.count;

	pairs = new TValueList< STOrderedPair<int, int> >(count);

	pair_listptr = r.pairs->FirstListPtr();

	while (pair_listptr)
		pairs->PushBack(r.pairs->NextData(pair_listptr));
}

STRelation<int, int>::~STRelation()
{
	delete pairs;
}
	
STRelation<int, int>	*STRelation<int, int>::Inverse()
{
	TValueList< STOrderedPair<int, int> >::listptr		pair_listptr;

	STRelation<int, int>	*r = new STRelation<int, int>;

	r->count = count;
	r->pairs = new TValueList< STOrderedPair<int, int> >(count);

	pair_listptr = pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<int, int>	&pair_element =
											pairs->NextData(pair_listptr);

		r->pairs->PushBack(STOrderedPair<int, int>(	pair_element.second,
													pair_element.first));
	}

	return r;
}

template <class S, class T>
TValueList<T>			*SubsetImage(	const STRelation<S, T> *r,
										const TValueList<S>	*subset,
										int ub_S, int ub_T)
{
	typename TValueList< STOrderedPair<S, T> >::listptr		pair_st_listptr;
	typename TValueList<S>::listptr							subset_listptr;
	typename TValueList<T>::listptr							normalized_listptr;

	int		i;

	unsigned int	array_size = (ub_T +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	second_st_elements[array_size * bool_per_unsigned_long];

	unsigned int	*sst = (unsigned int *)second_st_elements;
	for (i=0; i<array_size; i++)
		sst[i] = 0;

	T		sorted[ub_T];
	int		sorted_count = 0;

	subset_listptr = subset->FirstListPtr();

	while (subset_listptr)
	{
		S	element = subset->NextData(subset_listptr);

		pair_st_listptr = r->pairs->FirstListPtr();

		while (pair_st_listptr)
		{
			const STOrderedPair<S, T>	&pair =
										r->pairs->NextData(pair_st_listptr);

			if (element == pair.first)
			{
				T		second	= pair.second;
				int		index	= (int)second;

				if (!second_st_elements[index])
				{
					second_st_elements[index]	= true;
					sorted[index]				= second;
					sorted_count++;
				}
			}
		}
	}

	TValueList<T>	*sorted_list = new TValueList<T>(sorted_count);

	for (i=0; i<ub_T; i++)
		if (second_st_elements[i])
		sorted_list->PushBack(sorted[i]);

	return sorted_list;
}

template <>
TValueList<int>			*SubsetImage(	const STRelation<int, int> *r,
										const TValueList<int>	*subset,
										int ub_S, int ub_T)
{
	TValueList< STOrderedPair<int, int> >::listptr	pair_st_listptr;
	TValueList<int>::listptr						subset_listptr;
	TValueList<int>::listptr						normalized_listptr;

	int		i;

	unsigned int	array_size = (ub_T +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	second_st_elements[array_size * bool_per_unsigned_long];

	unsigned int	*sst = (unsigned int *)second_st_elements;
	for (i=0; i<array_size; i++)
		sst[i] = 0;

	int		sorted_count = 0;

	subset_listptr = subset->FirstListPtr();

	while (subset_listptr)
	{
		int		element = subset->NextData(subset_listptr);

		pair_st_listptr = r->pairs->FirstListPtr();

		while (pair_st_listptr)
		{
			const STOrderedPair<int, int>	&pair =
											r->pairs->NextData(pair_st_listptr);

			if (element == pair.first)
			{
				int		index	= (int)pair.second;

				if (!second_st_elements[index])
				{
					second_st_elements[index]	= true;
					sorted_count++;
				}
			}
		}
	}

	TValueList<int>		*sorted_list = new TValueList<int>(sorted_count);

	for (i=0; i<ub_T; i++)
		if (second_st_elements[i])
		sorted_list->PushBack(i);

	return sorted_list;
}

template <class S, class T>
STRelation<S, T>		*RelationUnion(	const STRelation<S, T> *r1,
										const STRelation<S, T> *r2,
										int ub_S, int ub_T)
{
	typename TValueList< STOrderedPair<S, T> >::listptr		pair_listptr;

	unsigned int	array_size = ((ub_S * ub_T) +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	*added_flags = new bool[array_size * bool_per_unsigned_long];

	unsigned int	*af = (unsigned int *)added_flags;

	int	i;
	for (i=0; i<array_size; i++)
		af[i] = 0;

	STRelation<S, T>	*r_union = new STRelation<S, T>;

	int	r_union_size = r1->pairs->Size() + r2->pairs->Size();

	r_union->pairs =
		new TValueList< STOrderedPair<S, T> >(r_union_size);

	pair_listptr = r1->pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<S, T>	&p = r1->pairs->NextData(pair_listptr);

		r_union->pairs->PushBack(p);

		added_flags[ub_T * (int)p.first + (int)p.second] = true;
	}

	pair_listptr = r2->pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<S, T>	&p = r2->pairs->NextData(pair_listptr);

		int		index	= ub_T * (int)p.first + (int)p.second;

		if (!added_flags[index])
		{
			r_union->pairs->PushBack(p);

			added_flags[index] = true;
		}
	}

	delete [] added_flags;

	r_union->count = r_union->pairs->Size();

	return r_union;
}

template <>
STRelation<int, int>	*RelationUnion(	const STRelation<int, int> *r1,
										const STRelation<int, int> *r2,
										int ub_S, int ub_T)
{
	TValueList< STOrderedPair<int, int> >::listptr		pair_listptr;

	unsigned int	array_size = ((ub_S * ub_T) +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	*added_flags = new bool[array_size * bool_per_unsigned_long];

	unsigned int	*af = (unsigned int *)added_flags;

	int	i;
	for (i=0; i<array_size; i++)
		af[i] = 0;

	STRelation<int, int>	*r_union = new STRelation<int, int>;

	int	r_union_size = r1->pairs->Size() + r2->pairs->Size();

	r_union->pairs =
		new TValueList< STOrderedPair<int, int> >(r_union_size);

	pair_listptr = r1->pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<int, int>	&p = r1->pairs->NextData(pair_listptr);

		r_union->pairs->PushBack(p);

		added_flags[ub_T * p.first + p.second] = true;
	}

	pair_listptr = r2->pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<int, int>	&p = r2->pairs->NextData(pair_listptr);

		int		index	= ub_T * p.first + p.second;

		if (!added_flags[index])
		{
			r_union->pairs->PushBack(p);

			added_flags[index] = true;
		}
	}

	delete [] added_flags;

	r_union->count = r_union->pairs->Size();

	return r_union;
}

template <class S, class T>
STRelation<S, T>		*RelationIntersection(	const STRelation<S, T> *r1,
												const STRelation<S, T> *r2,
												int ub_S, int ub_T)
{
	typename TValueList< STOrderedPair<S, T> >::listptr		pair_listptr;

	unsigned int	array_size = ((ub_S * ub_T) +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	*added_flags = new bool[array_size * bool_per_unsigned_long];

	unsigned int	*af = (unsigned int *)added_flags;

	int	i;
	for (i=0; i<array_size; i++)
		af[i] = 0;

	STRelation<S, T>	*intersection = new STRelation<S, T>;

	int	intersection_size =	r1->pairs->Size() < r2->pairs->Size() ?
							r1->pairs->Size() : r2->pairs->Size();

	intersection->pairs =
		new TValueList< STOrderedPair<S, T> >(intersection_size);

	pair_listptr = r1->pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<S, T>	&p = r1->pairs->NextData(pair_listptr);

		added_flags[ub_T * (int)p.first + (int)p.second] = true;
	}

	pair_listptr = r2->pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<S, T>	&p = r2->pairs->NextData(pair_listptr);

		if (added_flags[ub_T * (int)p.first + (int)p.second])
			intersection->pairs->PushBack(p);
	}

	delete [] added_flags;

	intersection->count = intersection->pairs->Size();

	return intersection;
}

template <>
STRelation<int, int>	*RelationIntersection(	const STRelation<int, int> *r1,
												const STRelation<int, int> *r2,
												int ub_S, int ub_T)
{
	TValueList< STOrderedPair<int, int> >::listptr		pair_listptr;

	unsigned int	array_size = ((ub_S * ub_T) +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	*added_flags = new bool[array_size * bool_per_unsigned_long];

	unsigned int	*af = (unsigned int *)added_flags;

	int	i;
	for (i=0; i<array_size; i++)
		af[i] = 0;

	STRelation<int, int>	*intersection = new STRelation<int, int>;

	int	intersection_size =	r1->pairs->Size() < r2->pairs->Size() ?
							r1->pairs->Size() : r2->pairs->Size();

	intersection->pairs =
		new TValueList< STOrderedPair<int, int> >(intersection_size);

	pair_listptr = r1->pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<int, int>	&p = r1->pairs->NextData(pair_listptr);

		added_flags[ub_T * p.first + p.second] = true;
	}

	pair_listptr = r2->pairs->FirstListPtr();

	while (pair_listptr)
	{
		const STOrderedPair<int, int>	&p = r2->pairs->NextData(pair_listptr);

		if (added_flags[ub_T * p.first + p.second])
			intersection->pairs->PushBack(p);
	}

	delete [] added_flags;

	intersection->count = intersection->pairs->Size();

	return intersection;
}

template <class R, class S, class T>
STRelation<R, T>		*Composition(	const STRelation<R, S> *rs,
										const STRelation<S, T> *st,
										int ub_R, int ub_S, int ub_T)
{
	TValueList< STOrderedPair<R, S> >						pair_rs_list;
	TValueList< STOrderedPair<S, T> >						pair_st_list;
	typename TValueList< STOrderedPair<R, S> >::listptr		pair_rs_listptr;
	typename TValueList< STOrderedPair<S, T> >::listptr		pair_st_listptr;

	int		first_rs_count	= 0;
	int		second_st_count	= 0;

	unsigned int	array_size = ((ub_R * ub_T) +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	*fs_elements = new bool[ub_R + ub_S + ub_S + ub_T +
									array_size * bool_per_unsigned_long];

	bool	*first_rs_elements	= fs_elements;
	bool	*second_rs_elements	= first_rs_elements + ub_R;
	bool	*first_st_elements	= second_rs_elements + ub_S;
	bool	*second_st_elements	= first_st_elements + ub_S;
	bool	*added_flags		= second_st_elements + ub_T;

	int	i;
	for (i=0; i<ub_R; i++)
		first_rs_elements[i]	= false;

	for (i=0; i<ub_S; i++)
	{
		second_rs_elements[i]	= false;
		first_st_elements[i]	= false;
	}

	for (i=0; i<ub_T; i++)
		second_st_elements[i]	= false;

	pair_rs_listptr = rs->pairs->FirstListPtr();

	while (pair_rs_listptr)
	{
		const STOrderedPair<R, S>	&p = rs->pairs->NextData(pair_rs_listptr);

		if (!first_rs_elements[(int)p.first])
		{
			first_rs_count++;
			first_rs_elements[(int)p.first] = true;
		}

		second_rs_elements[(int)p.second]	= true;
	}

	pair_st_listptr = st->pairs->FirstListPtr();

	while (pair_st_listptr)
	{
		const STOrderedPair<S, T>	&p = st->pairs->NextData(pair_st_listptr);

		if (!second_st_elements[(int)p.second])
		{
			second_st_count++;
			second_st_elements[(int)p.second] = true;
		}

		if (second_rs_elements[(int)p.first])
		{
			pair_st_list.PushBack(p);
			first_st_elements[(int)p.first] = true;
		}
	}

	pair_rs_listptr = rs->pairs->FirstListPtr();

	while (pair_rs_listptr)
	{
		const STOrderedPair<R, S>	&p = rs->pairs->NextData(pair_rs_listptr);

		if (first_st_elements[(int)p.second])
			pair_rs_list.PushBack(p);
	}

	STRelation<R, T>	*composition = new STRelation<R, T>;

	int	product1		= pair_rs_list.Size() * pair_st_list.Size();
	int	product2		= first_rs_count * second_st_count;

	int	maximum_size	= 	product1 < product2 ?
							product1 : product2;

	composition->pairs =
		new TValueList< STOrderedPair<R, T> >(maximum_size);

	unsigned int	*af = (unsigned int *)added_flags;
	for (i=0; i<array_size; i++)
		af[i] = 0;

	pair_rs_listptr = pair_rs_list.FirstListPtr();

	while (pair_rs_listptr)
	{
		const STOrderedPair<R, S>	&p_rs =
									pair_rs_list.NextData(pair_rs_listptr);

		pair_st_listptr = pair_st_list.FirstListPtr();

		while (pair_st_listptr)
		{
			const STOrderedPair<S, T>	&p_st =
										pair_st_list.NextData(pair_st_listptr);

			if (p_rs.second == p_st.first)
			{
				int		first	= (int)p_rs.first;
				int		second	= (int)p_st.second;
				int		index	= ub_T * first + second;

				if (!added_flags[index])
				{
					composition->pairs->PushBack(
						STOrderedPair<R, T>(p_rs.first, p_st.second));

					added_flags[index] = true;
				}
			}
		}
	}

	delete [] fs_elements;

	composition->count = composition->pairs->Size();

	return composition;
}

template <>
STRelation<int, int>	*Composition(	const STRelation<int, int> *rs,
										const STRelation<int, int> *st,
										int ub_R, int ub_S, int ub_T)
{
	TValueList< STOrderedPair<int, int> >				pair_rs_list;
	TValueList< STOrderedPair<int, int> >				pair_st_list;
	TValueList< STOrderedPair<int, int> >::listptr		pair_rs_listptr;
	TValueList< STOrderedPair<int, int> >::listptr		pair_st_listptr;

	int		first_rs_count	= 0;
	int		second_st_count	= 0;

	unsigned int	array_size = ((ub_R * ub_T) +
						bool_per_unsigned_long - 1) / bool_per_unsigned_long;

	bool	*fs_elements = new bool[ub_R + ub_S + ub_S + ub_T +
									array_size * bool_per_unsigned_long];

	bool	*first_rs_elements	= fs_elements;
	bool	*second_rs_elements	= first_rs_elements + ub_R;
	bool	*first_st_elements	= second_rs_elements + ub_S;
	bool	*second_st_elements	= first_st_elements + ub_S;
	bool	*added_flags		= second_st_elements + ub_T;

	int	i;
	for (i=0; i<ub_R; i++)
		first_rs_elements[i]	= false;

	for (i=0; i<ub_S; i++)
	{
		second_rs_elements[i]	= false;
		first_st_elements[i]	= false;
	}

	for (i=0; i<ub_T; i++)
		second_st_elements[i]	= false;

	pair_rs_listptr = rs->pairs->FirstListPtr();

	while (pair_rs_listptr)
	{
		const STOrderedPair<int, int>	&p =
										rs->pairs->NextData(pair_rs_listptr);

		if (!first_rs_elements[p.first])
		{
			first_rs_count++;
			first_rs_elements[p.first] = true;
		}

		second_rs_elements[p.second]	= true;
	}

	pair_st_listptr = st->pairs->FirstListPtr();

	while (pair_st_listptr)
	{
		const STOrderedPair<int, int>	&p =
										st->pairs->NextData(pair_st_listptr);

		if (!second_st_elements[p.second])
		{
			second_st_count++;
			second_st_elements[p.second] = true;
		}

		if (second_rs_elements[p.first])
		{
			pair_st_list.PushBack(p);
			first_st_elements[p.first] = true;
		}
	}

	pair_rs_listptr = rs->pairs->FirstListPtr();

	while (pair_rs_listptr)
	{
		const STOrderedPair<int, int>	&p =
										rs->pairs->NextData(pair_rs_listptr);

		if (first_st_elements[p.second])
			pair_rs_list.PushBack(p);
	}

	STRelation<int, int>	*composition = new STRelation<int, int>;

	int	product1		= pair_rs_list.Size() * pair_st_list.Size();
	int	product2		= first_rs_count * second_st_count;

	int	maximum_size	= 	product1 < product2 ?
							product1 : product2;

	composition->pairs =
		new TValueList< STOrderedPair<int, int> >(maximum_size);

	unsigned int	*af = (unsigned int *)added_flags;
	for (i=0; i<array_size; i++)
		af[i] = 0;

	pair_rs_listptr = pair_rs_list.FirstListPtr();

	while (pair_rs_listptr)
	{
		const STOrderedPair<int, int>	&p_rs =
										pair_rs_list.NextData(pair_rs_listptr);

		pair_st_listptr = pair_st_list.FirstListPtr();

		while (pair_st_listptr)
		{
			const STOrderedPair<int, int>	&p_st =
										pair_st_list.NextData(pair_st_listptr);

			if (p_rs.second == p_st.first)
			{
				int		first	= p_rs.first;
				int		second	= p_st.second;
				int		index	= ub_T * first + second;

				if (!added_flags[index])
				{
					composition->pairs->PushBack(
						STOrderedPair<int, int>(p_rs.first, p_st.second));

					added_flags[index] = true;
				}
			}
		}
	}

	delete [] fs_elements;

	composition->count = composition->pairs->Size();

	return composition;
}

template <class S, class T>
STRelation<S, T>		*Empty()
{
	STRelation<S, T>	*empty = new STRelation<S, T>;

	empty->count = 0;
	empty->pairs =
		new TValueList< STOrderedPair<S, T> >();

	return empty;
}

template <>
STRelation<int, int>	*Empty()
{
	STRelation<int, int>	*empty = new STRelation<int, int>;

	empty->count = 0;
	empty->pairs =
		new TValueList< STOrderedPair<int, int> >();

	return empty;
}

template <class S, class T>
STRelation<S, T>		*Identity(const STRelation<S, T> *r)
{
	typename TValueList< STOrderedPair<S, T> >::listptr		pair_listptr;

	STRelation<S, T>	*identity = new STRelation<S, T>;

	identity->count = r->count;
	identity->pairs =
		new TValueList< STOrderedPair<S, T> >(identity->count);

	pair_listptr = r->pairs->FirstListPtr();

	while (pair_listptr)
		identity->pairs->PushBack(r->pairs->NextData(pair_listptr));

	return identity;
}

template <>
STRelation<int, int>	*Identity(const STRelation<int, int> *r)
{
	TValueList< STOrderedPair<int, int> >::listptr		pair_listptr;

	STRelation<int, int>	*identity = new STRelation<int, int>;

	identity->count = r->count;
	identity->pairs =
		new TValueList< STOrderedPair<int, int> >(identity->count);

	pair_listptr = r->pairs->FirstListPtr();

	while (pair_listptr)
		identity->pairs->PushBack(r->pairs->NextData(pair_listptr));

	return identity;
}

template <class T>
STRelation<T, T>		*ImageClosure(	const STRelation<T, T> *r,
										const T &a, int ub_T)
{
	TValueList< STOrderedPair<T, T> >						pair_list(r->count);
	typename TValueList< STOrderedPair<T, T> >::listptr		pair_listptr;

	TValueList<T>						accessible_list(r->count);
	typename TValueList<T>::listptr		accessible_listptr;
	TValueList<T>						pending_list(r->count);

	bool	accessible[ub_T];

	int	i;
	for (i=0; i<ub_T; i++)
		accessible[i] = false;

	pair_listptr = r->pairs->FirstListPtr();

	while (pair_listptr)
		pair_list.PushBack(r->pairs->NextData(pair_listptr));

	pending_list.PushBack(a);
	accessible[(int)a] = true;
	accessible_list.PushBack(a);

	while (pending_list.Size())
	{
		T	pending_element = pending_list.FirstData();

		pending_list.PopFront();

		pair_listptr = pair_list.FirstListPtr();

		while (pair_listptr)
		{
			STOrderedPair<T, T>		pair = pair_list.Data(pair_listptr);

			if (pending_element == pair.first)
			{
				if (!accessible[(int)pair.second])
				{
					pending_list.PushBack(pair.second);
					accessible[(int)pair.second] = true;
					accessible_list.PushBack(pair.second);
				}

				pair_listptr = pair_list.Erase(pair_listptr);
			}
			else
				pair_list.NextData(pair_listptr);
		}
	}

	STRelation<T, T>	*closure = new STRelation<T, T>;

	closure->count = accessible_list.Size();
	closure->pairs =
		new TValueList< STOrderedPair<T, T> >(closure->count);

	accessible_listptr = accessible_list.FirstListPtr();

	while (accessible_listptr)
		closure->pairs->PushBack(
		STOrderedPair<T, T>(a, accessible_list.NextData(accessible_listptr)));

	return closure;
}

template <>
STRelation<int, int>	*ImageClosure(	const STRelation<int, int> *r,
										const int &a, int ub_T)
{
	TValueList< STOrderedPair<int, int> >				pair_list(r->count);
	TValueList< STOrderedPair<int, int> >::listptr		pair_listptr;

	TValueList<int>					accessible_list(r->count);
	TValueList<int>::listptr		accessible_listptr;
	TValueList<int>					pending_list(r->count);

	bool	accessible[ub_T];

	int	i;
	for (i=0; i<ub_T; i++)
		accessible[i] = false;

	pair_listptr = r->pairs->FirstListPtr();

	while (pair_listptr)
		pair_list.PushBack(r->pairs->NextData(pair_listptr));

	pending_list.PushBack(a);
	accessible[a] = true;
	accessible_list.PushBack(a);

	while (pending_list.Size())
	{
		int		pending_element = pending_list.FirstData();

		pending_list.PopFront();

		pair_listptr = pair_list.FirstListPtr();

		while (pair_listptr)
		{
			STOrderedPair<int, int>		pair = pair_list.Data(pair_listptr);

			if (pending_element == pair.first)
			{
				if (!accessible[pair.second])
				{
					pending_list.PushBack(pair.second);
					accessible[pair.second] = true;
					accessible_list.PushBack(pair.second);
				}

				pair_listptr = pair_list.Erase(pair_listptr);
			}
			else
				pair_list.NextData(pair_listptr);
		}
	}

	STRelation<int, int>	*closure = new STRelation<int, int>;

	closure->count = accessible_list.Size();
	closure->pairs =
		new TValueList< STOrderedPair<int, int> >(closure->count);

	accessible_listptr = accessible_list.FirstListPtr();

	while (accessible_listptr)
		closure->pairs->PushBack(
		STOrderedPair<int, int>(a,
								accessible_list.NextData(accessible_listptr)));

	return closure;
}

template <class T>
STRelation<T, T>	*ReflexiveTransitiveClosure(const STRelation<T, T> *r,
												const TValueList<T>	*domain,
												int ub_T)
{
	typename TValueList< STOrderedPair<T, T> >::listptr		pair_listptr;
	typename TValueList<T>::listptr							element_listptr;

	STRelation<T, T>	*closure = new STRelation<T, T>;

	closure->pairs =
		new TValueList< STOrderedPair<T, T> >(ub_T);

	element_listptr = domain->FirstListPtr();

	int	i;
	for (i=0; i<ub_T; i++)
	{
		STRelation<T, T>	*image =
			ImageClosure(r, domain->NextData(element_listptr), ub_T);

		pair_listptr = image->pairs->FirstListPtr();

		while (pair_listptr)
			closure->pairs->PushBack(image->pairs->NextData(pair_listptr));
				
		delete image;
	}

	closure->count = closure->pairs->Size();

	return closure;
}

template <>
STRelation<int, int>	*ReflexiveTransitiveClosure(
												const STRelation<int, int> *r,
												const TValueList<int> *domain,
												int ub_T)
{
	TValueList< STOrderedPair<int, int> >::listptr		pair_listptr;
	TValueList<int>::listptr							element_listptr;

	STRelation<int, int>	*closure = new STRelation<int, int>;

	closure->pairs =
		new TValueList< STOrderedPair<int, int> >(ub_T);

	element_listptr = domain->FirstListPtr();

	int	i;
	for (i=0; i<ub_T; i++)
	{
		STRelation<int, int>	*image =
			ImageClosure(r, domain->NextData(element_listptr), ub_T);

		pair_listptr = image->pairs->FirstListPtr();

		while (pair_listptr)
			closure->pairs->PushBack(image->pairs->NextData(pair_listptr));
				
		delete image;
	}

	closure->count = closure->pairs->Size();

	return closure;
}
