/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "viewControl.h"

void	CViewNode::SetPositionAndSize(bool pf)
{
	const QPoint	&p = main_view_control->GetViewData()->GetPosition();
	const QSize		&s = main_view_control->GetViewData()->GetSize();

	if (p != QPoint(-1, -1))
	{
		if (pf)
			GetWidget()->parentWidget()->move(p);
		else
			GetWidget()->move(p);
	}

	if (s != QSize(-1, -1))
	{
		if (pf)
			GetWidget()->parentWidget()->resize(s);
		else
			GetWidget()->resize(s);
	}
}

void	CViewNode::CreateReplacementSubtree(
	COptionData::SMainViewData *mvd, SReplaceNode &rn, vector<int> *iv)
{
	if (rn.modify_with_splitter)
	{
		COptionData::SSplitterData	*sd =
			new COptionData::SSplitterData();

		vector<int>		*index = new vector<int>(iv->size());

		copy(iv->begin(), iv->end(), index->begin());

		sd->SetIndex(index);
		sd->SetOrientation(rn.orientation);

		mvd->AddViewNodeDataPtr(sd);

		for (int i=0; i<rn.count; i++)
		{
			COptionData::SSubViewData	*sv =
				new COptionData::SSubViewData();

			index = new vector<int>(iv->size());

			copy(iv->begin(), iv->end(), index->begin());

			index->push_back(i);

			sv->SetIndex(index);
			sv->SetSubViewName("UNDEFINED_VIEW");

			mvd->AddViewNodeDataPtr(sv);
		}
	}
	else
	{
		COptionData::SSubViewData	*sv =
			new COptionData::SSubViewData();

		vector<int>		*index = new vector<int>(iv->size());

		copy(iv->begin(), iv->end(), index->begin());

		sv->SetIndex(index);
		sv->SetSubViewName(rn.subview_name);

		mvd->AddViewNodeDataPtr(sv);
	}
}

CViewNode	*CViewNode::AddNodeBefore(SAddNode &an, CViewNode **rvn)
{
	return AddNodeSubtree(an, rvn, AddBefore);
}

CViewNode	*CViewNode::AddNodeAfter(SAddNode &an, CViewNode **rvn)
{
	return AddNodeSubtree(an, rvn, AddAfter);
}

CViewNode	*CViewNode::AddNodeSubtree(
	SAddNode &an, CViewNode **rvn, AddNodeType t)
{
	CViewNode	*highlight_node;

	COptionData::SMainViewData	*mvd = main_view_control->GetViewData();

	if (parent_node)
	{
		*rvn = 0;

		vector<int>		*iv = GetViewNodeIndex();

		int		index = (*iv)[iv->size() - 1];

		highlight_node = CreateAddSubtree(mvd, an, t, index);
	}
	else
	{
		COptionData::SSplitterData	*sd =
			new COptionData::SSplitterData();

		sd->SetOrientation(an.root_orientation);

		mvd->AddViewNodeDataPtr(sd);

		CSplitterView	*root_view_node =
			new CSplitterView(0, sd);

		root_view_node->AddDescendantBefore(this, 0);

		*rvn		= root_view_node;
		parent_node	= root_view_node;

		highlight_node = CreateAddSubtree(mvd, an, t, 0);
	}

	return highlight_node;
}

CViewNode	*CViewNode::CreateAddSubtree(COptionData::SMainViewData *mvd,
				SAddNode &an, AddNodeType t, int index)
{
	if (an.modify_with_splitter)
	{
		COptionData::SSplitterData	*sd =
			new COptionData::SSplitterData();

		sd->SetOrientation(an.orientation);

		mvd->AddViewNodeDataPtr(sd);

		CSplitterView	*splitter_view =
			new CSplitterView(parent_node, sd);

		if (t == AddBefore)
			dynamic_cast<CSplitterView *>(parent_node)->
								AddDescendantBefore(splitter_view, index);
		else
			dynamic_cast<CSplitterView *>(parent_node)->
								AddDescendantAfter(splitter_view, index);

		for (int i=0; i<an.count; i++)
		{
			COptionData::SSubViewData	*sv =
				new COptionData::SSubViewData();

			sv->SetSubViewName("UNDEFINED_VIEW");

			mvd->AddViewNodeDataPtr(sv);

			CSubView	*subview = new CSubView(splitter_view, sv);

			splitter_view->AddDescendantBefore(subview, i);
		}

		return splitter_view;
	}
	else
	{
		COptionData::SSubViewData	*sv =
			new COptionData::SSubViewData();

		sv->SetSubViewName(an.subview_name);

		mvd->AddViewNodeDataPtr(sv);

		CSubView	*subview = new CSubView(parent_node, sv);

		if (t == AddBefore)
			dynamic_cast<CSplitterView *>(parent_node)->
								AddDescendantBefore(subview, index);
		else
			dynamic_cast<CSplitterView *>(parent_node)->
								AddDescendantAfter(subview, index);

		return subview;
	}
}

CViewNode	*CViewNode::DeleteNode()
{
	if (!parent_node)
		return 0;

	vector<int>		*iv = GetViewNodeIndex();

	int		index = (*iv)[iv->size() - 1];

	CSplitterView	*sv = dynamic_cast<CSplitterView *>(parent_node);

	sv->RemoveDescendant(index);

	int		count = sv->GetDescendantCount();

	if (index < count)
		return sv->GetDescendant(index);
	else if (!count)
		return parent_node;
	else
		return sv->GetDescendant(count - 1);
}

void	CSplitterWidget::closeEvent(QCloseEvent *ev)
{
	if (interface_control->main_view_menu_manager)
	{
		if (process_close_event_flag)
			interface_control->ChangeMenuItemToHidden(main_view_control);

		ev->accept();
	}
	else
		ev->ignore();
}

CSplitterView::CSplitterView(	QWidget *p,
								CViewNode *n,
								CInterfaceControl *ic,
								SMainViewControl *mvc,
								const string &dfs,
								CPaletteData *dpd,
								COptionData::SSplitterData *d)
	: CViewNode(p, n, ic, mvc, dfs, dpd), splitter_data(d)
{
	splitter = new CSplitterWidget(splitter_data->GetOrientation(), p, ic, mvc);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		splitter->setFont(view_node_font);
	else
		splitter->setFont(splitter->font());

	if (SetupViewNodePalette(view_node_palette))
		splitter->setPalette(view_node_palette);
	else
		splitter->setPalette(splitter->palette());
}

CSplitterView::~CSplitterView()
{
	vector<CViewNode *>::size_type		i;

	for (i=0; i<descendants.size(); i++)
		delete descendants[i];

	delete splitter;
}

void	CSplitterView::CapturePaneSizes(bool rf)
{
	if (!rf)
	{
		QValueList<int>		pane_size_list = splitter->sizes();

		vector<int>		*v = new vector<int>(pane_size_list.size());

		QValueList<int>::size_type		i;

		for (i=0; i<pane_size_list.size(); i++)
			(*v)[i] = pane_size_list[i];

		splitter_data->SetPaneSize(v);
	}
	else
		splitter_data->SetPaneSize(0);

	vector<CViewNode *>::size_type		i;

	for (i=0; i<descendants.size(); i++)
		descendants[i]->CapturePaneSizes(rf);
}

void	CSplitterView::SetPaneSizes()
{
	if (vector<int> *v = splitter_data->GetPaneSize())
	{
		QValueList<int>		pane_size_list;

		vector<int>::size_type		i;

		for (i=0; i<v->size(); i++)
			pane_size_list.push_back((*v)[i]);

		splitter->setSizes(pane_size_list);
	}

	vector<CViewNode *>::size_type		i;

	for (i=0; i<descendants.size(); i++)
		descendants[i]->SetPaneSizes();
}

bool	CSplitterView::AddViewNode(COptionData::SViewNodeData *d)
{
	vector<int>		index_vector;
	vector<int>		*v = d->GetIndex();

	copy(v->begin(), v->end(), back_inserter(index_vector));

	return AddViewNode(d, index_vector);
}

bool	CSplitterView::AddViewNode( COptionData::SViewNodeData *d,
									vector<int> &iv)
{
	if (!iv.size())
		return false;

	int		index = iv[0];

	if (iv.size() == 1)
	{
		if (index != descendants.size())
			return false;

		switch (d->GetNodeType())
		{
			case COptionData::SViewNodeData::SplitterNode:
			descendants.push_back(
				new CSplitterView(
					GetWidget(),
					this,
					GetInterfaceControl(),
					GetMainViewControl(),
					default_font_string,
					default_palette_data,
					dynamic_cast<COptionData::SSplitterData *>(d)));
			break;

			case COptionData::SViewNodeData::SubViewNode:
			descendants.push_back(
				GetInterfaceControl()->CreateSubView(
					GetWidget(),
					this,
					GetInterfaceControl(),
					GetMainViewControl(),
					default_font_string,
					default_palette_data,
					dynamic_cast<COptionData::SSubViewData *>(d)));
			break;
		}

//		splitter->setResizeMode(
//						descendants[descendants.size() - 1]->GetWidget(),
//						QSplitter::Stretch);
	}
	else
	{
		if (index < 0 || index >= descendants.size())
			return false;

		iv.erase(iv.begin());

		return descendants[index]->AddViewNode(d, iv);
	}

	return true;
}

CViewNode   *CSplitterView::GetDescendant(int index)
{
	if (index >= 0 && index < descendants.size())
		return descendants[index];
	else
		return 0;
}

void	CSplitterView::RemoveDescendant(int index)
{
	if (index >= 0 && index < descendants.size())
	{
		descendants.erase(descendants.begin() + index);
	}
}

void	CSplitterView::AddDescendantBefore(CViewNode *n, int index)
{
	if (index >= 0 && index <= descendants.size())
	{
		descendants.insert(descendants.begin() + index, n);
	}
}

void	CSplitterView::AddDescendantAfter(CViewNode *n, int index)
{
	if (index >= 0 && index < descendants.size())
	{
		descendants.insert(descendants.begin() + (index + 1), n);
	}
}

CViewNode   *CSplitterView::NavigateViewNodeTree(NavigationType nt)
{
	CViewNode	*view_node;

	switch (nt)
	{
		case MoveDownTree:
		if (descendants.size())
			view_node = descendants[0];
		else
			view_node = 0;
		break;

		case MoveUpTree:
		view_node = parent_node;
		break;

		case MoveLeftTree:
		if (parent_node)
		{
			vector<int>		*index = splitter_data->GetIndex();

			vector<int>::iterator	v_iterator = index->end();

			int		position_index = *(--v_iterator);

			CSplitterView	*pn = dynamic_cast<CSplitterView *>(parent_node);

			view_node = pn->GetDescendant(position_index - 1);
		}
		else
			view_node = 0;
		break;

		case MoveRightTree:
		if (parent_node)
		{
			vector<int>		*index = splitter_data->GetIndex();

			vector<int>::iterator	v_iterator = index->end();

			int		position_index = *(--v_iterator);

			CSplitterView	*pn = dynamic_cast<CSplitterView *>(parent_node);

			view_node = pn->GetDescendant(position_index + 1);
		}
		else
			view_node = 0;
		break;
	}

	return view_node;
}

CViewNode    *CSplitterView::LocateViewNode(vector<int> *index)
{
	vector<int>		index_vector;

	copy(index->begin(), index->end(), back_inserter(index_vector));

	return LocateViewNode(index_vector);
}

CViewNode    *CSplitterView::LocateViewNode(vector<int> &iv)
{
	if (!iv.size())
		return this;
	else
	{
		int		index = iv[0];

		if (index < 0 || index >= descendants.size())
			return 0;

		iv.erase(iv.begin());

		return descendants[index]->LocateViewNode(iv);
	}
}

void	CSplitterView::ResetFontData()
{
	splitter_data->SetFontString("");

	vector<CViewNode *>::size_type		i;

	for (i=0; i<descendants.size(); i++)
		descendants[i]->ResetFontData();
}

void	CSplitterView::ResetPaletteData()
{
	splitter_data->SetPaletteData(0);

	vector<CViewNode *>::size_type		i;

	for (i=0; i<descendants.size(); i++)
		descendants[i]->ResetPaletteData();
}

void	CSplitterView::SetFontData(const string &fd)
{
	splitter_data->SetFontString(fd);
}

void	CSplitterView::SetPaletteData(CPaletteData *pd)
{
	splitter_data->SetPaletteData(pd);
}

void	CSplitterView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = splitter->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	splitter->setPalette(highlight_palette);
}

void	CSplitterView::RestorePalette()
{
	splitter->setPalette(restore_palette);
}

bool	CSplitterView::SetupViewNodeFont(QFont &f)
{
	if (splitter_data->GetFontString().length())
	{
		FontSpecifier::SetFontSpecifier(f, splitter_data->GetFontString());

		default_font_string = splitter_data->GetFontString();

		return true;
	}
	else if (default_font_string.length())
	{
		FontSpecifier::SetFontSpecifier(f, default_font_string);

		return true;
	}
	else
		return false;
}

bool	CSplitterView::SetupViewNodePalette(QPalette &p)
{
	if (splitter_data->GetPaletteData())
	{
		splitter_data->GetPaletteData()->SetupPalette(p);

		default_palette_data = splitter_data->GetPaletteData();

		return true;
	}
	else if (default_palette_data)
	{
		default_palette_data->SetupPalette(p);

		return true;
	}
	else
		return false;
}

COptionData::SMainViewData  *CSplitterView::CreateMainViewDataWithReplace(
							string &mvn, bool ddf, SReplaceNode &rn)
{
	COptionData::SMainViewData	*main_view_data =
									new COptionData::SMainViewData();

	main_view_data->SetMainViewName(mvn);
	main_view_data->SetDefaultDisplayFlag(ddf);

	CreateMainViewDataWithReplace(main_view_data, rn);

	return main_view_data;
}

void	CSplitterView::CreateMainViewDataWithReplace(
							COptionData::SMainViewData *mvd, SReplaceNode &rn)
{
	if (node_indicator)
	{
		CViewNode::CreateReplacementSubtree(mvd, rn, GetViewNodeIndex());
	}
	else
	{
		COptionData::SSplitterData	*sd =
			new COptionData::SSplitterData(*splitter_data);

		mvd->AddViewNodeDataPtr(sd);

		for (int i=0; i<descendants.size(); i++)
			descendants[i]->CreateMainViewDataWithReplace(mvd, rn);
	}
}

COptionData::SMainViewData  *CSplitterView::ReindexAndCreateMainViewData(
										string &mvn, bool ddf)
{
	COptionData::SMainViewData	*main_view_data =
									new COptionData::SMainViewData();

	main_view_data->SetMainViewName(mvn);
	main_view_data->SetDefaultDisplayFlag(ddf);

	vector<int>		index;

	ReindexAndCreateMainViewData(main_view_data, index);

	return main_view_data;
}

void	CSplitterView::ReindexAndCreateMainViewData(
						COptionData::SMainViewData *mvd, vector<int> &iv)
{
	COptionData::SSplitterData	*sd =
		new COptionData::SSplitterData(*splitter_data);

	vector<int>		*index = new vector<int>(iv.size());

	copy(iv.begin(), iv.end(), index->begin());

	sd->SetIndex(index);

	splitter_data = sd;

	mvd->AddViewNodeDataPtr(sd);

	for (int i=0; i<descendants.size(); i++)
	{
		iv.push_back(i);

		descendants[i]->ReindexAndCreateMainViewData(mvd, iv);

		iv.pop_back();
	}
}

void	CSplitterView::CreateRuntimeModuleMap(RuntimeMainViewMap *rmvm)
{
	vector<CViewNode *>::size_type		i;

	for (i=0; i<descendants.size(); i++)
		descendants[i]->CreateRuntimeModuleMap(rmvm);
}

void	CSplitterView::StoreRuntimeModulePointers(RuntimeMainViewMap *rmvm)
{
	vector<CViewNode *>::size_type		i;

	for (i=0; i<descendants.size(); i++)
		descendants[i]->StoreRuntimeModulePointers(rmvm);
}

CSubView	*CSplitterView::FindSubviewTypePointer(const string &type)
{
	vector<CViewNode *>::size_type		i;

	for (i=0; i<descendants.size(); i++)
	{
		CSubView	*sv = descendants[i]->FindSubviewTypePointer(type);

		if (sv)
			return sv;
	}

	return 0;
}

CViewNode   *CSubView::NavigateViewNodeTree(NavigationType nt)
{
	CViewNode	*view_node;

	switch (nt)
	{
		case MoveDownTree:
		view_node = 0;
		break;

		case MoveUpTree:
		view_node = parent_node;
		break;

		case MoveLeftTree:
		if (parent_node)
		{
			vector<int>		*index = subview_data->GetIndex();

			vector<int>::iterator	v_iterator = index->end();

			int		position_index = *(--v_iterator);

			CSplitterView	*pn = dynamic_cast<CSplitterView *>(parent_node);

			view_node = pn->GetDescendant(position_index - 1);
		}
		else
			view_node = 0;
		break;

		case MoveRightTree:
		if (parent_node)
		{
			vector<int>		*index = subview_data->GetIndex();

			vector<int>::iterator	v_iterator = index->end();

			int		position_index = *(--v_iterator);

			CSplitterView	*pn = dynamic_cast<CSplitterView *>(parent_node);

			view_node = pn->GetDescendant(position_index + 1);
		}
		else
			view_node = 0;
		break;
	}

	return view_node;
}

CViewNode    *CSubView::LocateViewNode(vector<int> *index)
{
	vector<int>		index_vector;

	copy(index->begin(), index->end(), back_inserter(index_vector));

	return LocateViewNode(index_vector);
}

CViewNode    *CSubView::LocateViewNode(vector<int> &iv)
{
	if (!iv.size())
		return this;
	else
		return 0;
}

void	CSubView::ResetFontData()
{
	subview_data->SetFontString("");
}

void	CSubView::ResetPaletteData()
{
	subview_data->SetPaletteData(0);
}

void	CSubView::SetFontData(const string &fd)
{
	subview_data->SetFontString(fd);
}

void	CSubView::SetPaletteData(CPaletteData *pd)
{
	subview_data->SetPaletteData(pd);
}

bool    CSubView::SetupViewNodeFont(QFont &f)
{
	if (subview_data->GetFontString().length())
	{
		FontSpecifier::SetFontSpecifier(f, subview_data->GetFontString());

		default_font_string = subview_data->GetFontString();

		return true;
	}
	else if (default_font_string.length())
	{
		FontSpecifier::SetFontSpecifier(f, default_font_string);

		return true;
	}
	else
		return false;
}

bool    CSubView::SetupViewNodePalette(QPalette &p)
{
	if (subview_data->GetPaletteData())
	{
		subview_data->GetPaletteData()->SetupPalette(p);

		default_palette_data = subview_data->GetPaletteData();

		return true;
	}
	else if (default_palette_data)
	{
		default_palette_data->SetupPalette(p);

		return true;
	}
	else
		return false;
}

COptionData::SMainViewData  *CSubView::CreateMainViewDataWithReplace(
							string &mvn, bool ddf, SReplaceNode &rn)
{
	COptionData::SMainViewData	*main_view_data =
									new COptionData::SMainViewData();

	main_view_data->SetMainViewName(mvn);
	main_view_data->SetDefaultDisplayFlag(ddf);

	CreateMainViewDataWithReplace(main_view_data, rn);

	return main_view_data;
}

void	CSubView::CreateMainViewDataWithReplace(
							COptionData::SMainViewData *mvd, SReplaceNode &rn)
{
	if (node_indicator)
	{
		CViewNode::CreateReplacementSubtree(mvd, rn, GetViewNodeIndex());
	}
	else
	{
		COptionData::SSubViewData	*sv =
			new COptionData::SSubViewData(*subview_data);

		mvd->AddViewNodeDataPtr(sv);
	}
}

COptionData::SMainViewData	*CSubView::ReindexAndCreateMainViewData(
										string &mvn, bool ddf)
{
	COptionData::SMainViewData	*main_view_data =
									new COptionData::SMainViewData();

	main_view_data->SetMainViewName(mvn);
	main_view_data->SetDefaultDisplayFlag(ddf);

	vector<int>		index;

	ReindexAndCreateMainViewData(main_view_data, index);

	return main_view_data;
}

void	CSubView::ReindexAndCreateMainViewData(
						COptionData::SMainViewData *mvd, vector<int> &iv)
{
	COptionData::SSubViewData	*sv =
		new COptionData::SSubViewData(*subview_data);

	vector<int>		*index = new vector<int>(iv.size());

	copy(iv.begin(), iv.end(), index->begin());

	sv->SetIndex(index);

	subview_data = sv;

	mvd->AddViewNodeDataPtr(sv);
}

void	CSubView::CreateRuntimeModuleMap(RuntimeMainViewMap *rmvm)
{
	RuntimeSubtypeMap	&rsm =
		(*rmvm)[main_view_control->GetViewData()->GetMainViewName()];

	RuntimeIndexMap		&rim = rsm[subview_data->GetSubViewName()];

	rim[*subview_data->GetIndex()] = pair<CSubView *, bool>(this, false);
}

void	CSubView::StoreRuntimeModulePointers(RuntimeMainViewMap *rmvm)
{
	ClearRuntimeMainViewMap(rmvm);

	InitializeModulePtrMap(rmvm, subview_data, module_ptr_map);

	InitializeModulePointers();
}

CSubView	*CSubView::FindSubviewTypePointer(const string &type)
{
	if (subview_data->GetSubViewName() == type)
		return this;
	else
		return 0;
}

void	CFrameWidget::closeEvent(QCloseEvent *ev)
{
	if (interface_control->main_view_menu_manager)
	{
		if (process_close_event_flag)
			interface_control->ChangeMenuItemToHidden(main_view_control);

		ev->accept();
	}
	else
		ev->ignore();
}

void	CVBoxWidget::closeEvent(QCloseEvent *ev)
{
	if (interface_control->main_view_menu_manager)
	{
		if (process_close_event_flag)
			interface_control->ChangeMenuItemToHidden(main_view_control);

		ev->accept();
	}
	else
		ev->ignore();
}
