#include "calculateLexicalDriver.h"
#include "calculateParserDriver.h"

int     main(int argc, char *argv[])
{
    CCalculateLexicalDriver     *lexical    = new CCalculateLexicalDriver();
    CCalculateParserDriver      *parser     = new CCalculateParserDriver();

    switch (argc)
    {
        case 1:
//      lexical->SetInputIoStream(&cin);
//      lexical->SetInputStdStream(stdin);
        lexical->SetInputDescriptor(0);
        break;

        default:
//      if (lexical->SetInputFileIoStream(argv[1]) & CCalculateLexicalBase::OpenError)
//      if (lexical->SetInputFileStdStream(argv[1]) & CCalculateLexicalBase::OpenError)
        if (lexical->SetInputFileDescriptor(argv[1]) & CCalculateLexicalBase::OpenError)
        {
            cout << "input file: OpenError" << endl;
            return 1;
        }
    }

    lexical->Initialize();
	lexical->SetImplicitEndToken(";\n");
	lexical->SetParser(parser);
    parser->Initialize();
    parser->SetLexical(lexical);

	CExpressionValue::output_stream = &cout;
	CExpressionValue::output_stream->precision(18);

    CCalculateParserBase::StatusCode   sc = parser->ParseStream();

    int lexical_error   = sc & CCalculateParserBase::LexicalError;
    int parser_error    = sc & CCalculateParserBase::ParserError;

    if (lexical_error)
        cout << "LEXICAL ERROR" << endl;

    if (parser_error)
        cout << "PARSER ERROR" << endl;

    if (lexical_error || parser_error)
    {
        cout    << "current line   = "
                << lexical->GetCurrentLineNumber() + 1 << endl;
        cout    << "current column = "
                << lexical->GetCurrentColumnNumber() + 1 << endl;
    }

    if (sc == CCalculateParserBase::EndOfFile)
	{
		CAssignmentExpression::EvaluateAssignments();
		CAssignmentExpression::DestroyAssignments();
	}

    delete parser;
    delete lexical;
}
