/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef STACKTYPES_H
#define STACKTYPES_H

enum StackElementType
{
	StackLiteralToken,
	StackError,
	StackSingleChar,
	StackScalar,
	StackCharArray,
	StackNonTerminal,
	StackData,
	StackUser,

	STACK_TYPE_LITERALTOKEN		= StackLiteralToken,
	STACK_TYPE_ERROR			= StackError,
	STACK_TYPE_SINGLECHAR		= StackSingleChar,
	STACK_TYPE_SCALAR			= StackScalar,
	STACK_TYPE_CHARARRAY		= StackCharArray,
	STACK_TYPE_NONTERMINAL		= StackNonTerminal,
	STACK_TYPE_DATA				= StackData,
	STACK_TYPE_USER				= StackUser
};

#define		STACK_STATE(i)				stack_ptr[(i)].state
#define		STACK_TYPE(i)				stack_ptr[(i)].type
#define		STACK_TOKEN(i)				stack_ptr[(i)].token
#define		STACK_SCALAR(i)				stack_ptr[(i)].scalar
#define		STACK_CHAR_ARRAY(i)			stack_ptr[(i)].char_array
#define		STACK_DATA(i)				stack_ptr[(i)].data
#define		STACK_REDUCE_ACTION(i)		stack_ptr[(i)].reduce_action

#define		STACK_BOOL(i)			stack_ptr[(i)].scalar.scalar_bool
#define		STACK_CHAR(i)			stack_ptr[(i)].scalar.scalar_char
#define		STACK_UNSIGNED_CHAR(i)	stack_ptr[(i)].scalar.scalar_unsigned_char
#define		STACK_SHORT(i)			stack_ptr[(i)].scalar.scalar_short
#define		STACK_UNSIGNED_SHORT(i)	stack_ptr[(i)].scalar.scalar_unsigned_short
#define		STACK_INT(i)			stack_ptr[(i)].scalar.scalar_int
#define		STACK_UNSIGNED_INT(i)	stack_ptr[(i)].scalar.scalar_unsigned_int
#define		STACK_LONG(i)			stack_ptr[(i)].scalar.scalar_long
#define		STACK_UNSIGNED_LONG(i)	stack_ptr[(i)].scalar.scalar_unsigned_long
#define		STACK_FLOAT(i)			stack_ptr[(i)].scalar.scalar_float
#define		STACK_DOUBLE(i)			stack_ptr[(i)].scalar.scalar_double
#define		STACK_LONG_DOUBLE(i)	stack_ptr[(i)].scalar.scalar_long_double

#define		STACK_RANGE_CHAR_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_char.lower_bound
#define		STACK_RANGE_CHAR_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_char.upper_bound

#define		STACK_RANGE_UNSIGNED_CHAR_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_unsigned_char.lower_bound
#define		STACK_RANGE_UNSIGNED_CHAR_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_unsigned_char.upper_bound

#define		STACK_RANGE_SHORT_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_short.lower_bound
#define		STACK_RANGE_SHORT_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_short.upper_bound

#define		STACK_RANGE_UNSIGNED_SHORT_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_unsigned_short.lower_bound
#define		STACK_RANGE_UNSIGNED_SHORT_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_unsigned_short.upper_bound

#define		STACK_RANGE_INT_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_int.lower_bound
#define		STACK_RANGE_INT_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_int.upper_bound

#define		STACK_RANGE_UNSIGNED_INT_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_unsigned_int.lower_bound
#define		STACK_RANGE_UNSIGNED_INT_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_unsigned_int.upper_bound

#define		STACK_RANGE_LONG_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_long.lower_bound
#define		STACK_RANGE_LONG_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_long.upper_bound

#define		STACK_RANGE_UNSIGNED_LONG_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_unsigned_long.lower_bound
#define		STACK_RANGE_UNSIGNED_LONG_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_unsigned_long.upper_bound

#define		STACK_RANGE_FLOAT_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_float.lower_bound
#define		STACK_RANGE_FLOAT_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_float.upper_bound

#define		STACK_RANGE_DOUBLE_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_double.lower_bound
#define		STACK_RANGE_DOUBLE_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_double.upper_bound

#define		STACK_RANGE_LONG_DOUBLE_LOWER_BOUND(i) \
				stack_ptr[(i)].scalar.range_long_double.lower_bound
#define		STACK_RANGE_LONG_DOUBLE_UPPER_BOUND(i) \
				stack_ptr[(i)].scalar.range_long_double.upper_bound

#endif
