/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "applicationMainWindow.h"

bool     qt_library_warning_message_flag = false;

void    QtLibraryMessageHandler(QtMsgType type, const char *msg)
{
	switch (type)
	{
		case QtDebugMsg:
		cerr << "Debug: " << msg << endl;
		break;

		case QtWarningMsg:
		if (qt_library_warning_message_flag)
			cerr << "Warning: " << msg << endl;
		break;

		case QtFatalMsg:
		cerr << "Fatal: " << msg << endl;
		abort();
		break;
	}
}

const	SMainSubmenuNodeData	CApplication::file_submenu_node_data[] =
{
	{	MN::mn_popup, ""		, 0		, "&File",
		0								, 0,
		MN::mn_enable	, MN::mn_enable	, MN::mn_enable		},

	{	MN::mn_item	, "0"		, 0		, "&New",
		0								, SLOT(NewFile()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "1"		, 1		, "Save &As",
		0								, SLOT(SaveAsFile()),
		MN::mn_disable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "2"		, 2		, "&Open",
		0								, SLOT(OpenFile()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "3"		, 3		, "&Save",
		0								, SLOT(SaveFile()),
		MN::mn_disable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "4"		, 4		, "&Close",
		0								, SLOT(CloseFile()),
		MN::mn_disable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_sep	, "5"		, 5		, 0,
		0								, 0,
		MN::mn_noop		, MN::mn_noop	, MN::mn_noop		},

	{	MN::mn_item	, "6"		, 6		, "&Exit",
		0								, SLOT(close()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_enable		},

	{	MN::menu_node_type_end, 0, 0, 0, 0, 0, 0, 0, 0 }
};

const	SMainSubmenuNodeData	CApplication::view_submenu_node_data[] =
{
	{	MN::mn_popup, ""		, 0		, "&View",
		0								, SLOT(RaiseMainView(int)),
		MN::mn_enable	, MN::mn_enable	, MN::mn_enable		},
/*
	{	MN::mn_popup, "0"		, 0		, "&Interface Type",
		0								, SLOT(SetInterfaceType(int)),
		MN::mn_enable	, MN::mn_enable	, MN::mn_enable		},

	{	MN::mn_item	, "0,0"		, ::SingleDocumentSingleView
										, "Single Document, Single View",
		0								, 0,
		MN::mn_enable	, MN::mn_enable	, MN::mn_enable		},

	{	MN::mn_item	, "0,1"		, ::MultipleDocumentSingleView
										, "Multiple Document, Single View",
		0								, 0,
		MN::mn_enable	, MN::mn_enable	, MN::mn_enable		},

	{	MN::mn_item	, "0,2"		, ::MultipleDocumentMultipleView
										, "Multiple Document, Multiple View",
		0								, 0,
		MN::mn_enable	, MN::mn_enable	, MN::mn_enable		},

	{	MN::mn_popup, "1"		, 1		, "Options",
		0								, 0,
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},
*/
	{	MN::mn_item	, "0"		, 0		, "Edit Option Data",
		0								, SLOT(EditOptions()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "1"		, 1		, "Size/Position",
		0								, SLOT(CaptureSizeAndPosition()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "2"		, 2		, "&Restore",
		0								, SLOT(RestoreViews()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "3"		, 3		, "&Cascade",
		0								, SLOT(CascadeViews()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "4"		, 4		, "&Tile 1",
		0								, SLOT(TileViews1()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "5"		, 5		, "&Tile 2",
		0								, SLOT(TileViews2()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "6"		, 6		, "&Tile 3",
		0								, SLOT(TileViews3()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "7"		, 7		, "&Tile 4",
		0								, SLOT(TileViews4()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::menu_node_type_end, 0, 0, 0, 0, 0, 0, 0, 0 }
};

const	SMainSubmenuNodeData	CApplication::help_submenu_node_data[] =
{
	{	MN::mn_popup, ""		, 0		, "&Help",
		0								, 0,
		MN::mn_enable	, MN::mn_enable	, MN::mn_enable		},

	{	MN::mn_item	, "0"		, 0		, "Contents",
		0								, SLOT(HelpContents()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::mn_item	, "1"		, 1		, "About CPG",
		0								, SLOT(AboutCPG()),
		MN::mn_enable	, MN::mn_enable	, MN::mn_disable	},

	{	MN::menu_node_type_end, 0, 0, 0, 0, 0, 0, 0, 0 }
};

int		CApplication::file_submenu_id;
int		CApplication::view_submenu_id;
int		CApplication::help_submenu_id;

int		CApplication::GetSubmenuNodeCount(const SMainSubmenuNodeData *d)
{
	int		index = 0;
	while (d[index].node_type != MN::menu_node_type_end)
		index++;

	return index;
}

CApplication::CApplication(int &argc, char **argv)
	: QApplication(argc, argv), file_snd(0), view_snd(0), help_snd(0)
{
	CPaletteData::SetupGroupRoleMaps();

	int		i;
	int		node_count;

	file_submenu_id	= GetSubmenuIdGenerator().GetId();
	node_count		= GetSubmenuNodeCount(file_submenu_node_data) + 1;

	file_snd = new SSubmenuNodeData[node_count];

	for (i=0; i<node_count; i++)
	{
		file_snd[i] = SSubmenuNodeData(
						file_submenu_node_data[i].node_type,
						file_submenu_node_data[i].tree_index,
						file_submenu_node_data[i].node_identifier,
						file_submenu_node_data[i].text,
						file_submenu_node_data[i].accelerator,
						file_submenu_node_data[i].slot,
						file_submenu_node_data[i].operation_list,
						SMainSubmenuNodeData::main_submenu_operation_count);
	}

	LoadInterfaceConfigurations();

	view_submenu_id	= GetSubmenuIdGenerator().GetId();
	node_count		= GetSubmenuNodeCount(view_submenu_node_data) + 1;

	view_snd = new SSubmenuNodeData[node_count];

	for (i=0; i<node_count; i++)
	{
		view_snd[i] = SSubmenuNodeData(
						view_submenu_node_data[i].node_type,
						view_submenu_node_data[i].tree_index,
						view_submenu_node_data[i].node_identifier,
						view_submenu_node_data[i].text,
						view_submenu_node_data[i].accelerator,
						view_submenu_node_data[i].slot,
						view_submenu_node_data[i].operation_list,
						SMainSubmenuNodeData::main_submenu_operation_count);
	}

	help_submenu_id	= GetSubmenuIdGenerator().GetId();
	node_count		= GetSubmenuNodeCount(help_submenu_node_data) + 1;

	help_snd = new SSubmenuNodeData[node_count];

	for (i=0; i<node_count; i++)
	{
		help_snd[i] = SSubmenuNodeData(
						help_submenu_node_data[i].node_type,
						help_submenu_node_data[i].tree_index,
						help_submenu_node_data[i].node_identifier,
						help_submenu_node_data[i].text,
						help_submenu_node_data[i].accelerator,
						help_submenu_node_data[i].slot,
						help_submenu_node_data[i].operation_list,
						SMainSubmenuNodeData::main_submenu_operation_count);
	}

	file_view_help_data.file_submenu_id	= file_submenu_id;
	file_view_help_data.view_submenu_id	= view_submenu_id;
	file_view_help_data.help_submenu_id	= help_submenu_id;
	file_view_help_data.file_snd		= file_snd;
	file_view_help_data.view_snd		= view_snd;
	file_view_help_data.help_snd		= help_snd;
}

CApplication::~CApplication()
{
	delete [] file_snd;
	delete [] view_snd;
	delete [] help_snd;

	vector<SInterfaceConfiguration>::size_type	i;
	
	for (i=0; i<interface_configurations.size(); i++)
	{
		const vector< pair<int, SSubmenuNodeData *> >	&submenu_node_data =
			interface_configurations[i].GetSubmenuNodeData();

		vector< pair<int, SSubmenuNodeData *> >::size_type	j;

		for (j=0; j<submenu_node_data.size(); j++)
			delete [] submenu_node_data[j].second;

		delete interface_configurations[i].GetDefaultOptions();
	}
}

bool	CApplication::GetEnvOptionValueString(const char *e, string &option)
{
	char	*ev_ptr = getenv(e);

	if (ev_ptr)
	{
		option = ev_ptr;
		return true;
	}
	else
		return false;
}

void	CApplication::GetApplicationOptions()
{
	SetupApplicationOptions("--data-file-extension-alias",
							"--option-file-extension-alias",
							"--default-option-file-name",
							".",
							"DEFAULT_OPTION_FILE_DIRECTORY",
							"--default-option-file-directory",
							"--initial-file-pair",
							"--initial-file-pair-plus-type",
							"REQUEST_OPTION_FILE_NAME",
							"--request-option-file-name");
}

void	CApplication::SetupApplicationOptions(	const char *dfea_cl,
												const char *ofea_cl,
												const char *dofn_cl,
												const char *dofd,
												const char *dofd_env,
												const char *dofd_cl,
												const char *ifp_cl,
												const char *ifppt_cl,
												const char *rofn_env,
												const char *rofn_cl)
{
	default_option_file_directory = dofd;

	GetEnvOptionValueString(dofd_env, default_option_file_directory);

	if (getenv(rofn_env))
		request_option_file_name_flag = true;
	else
		request_option_file_name_flag = false;

	option_code_map[dfea_cl]	= DataFileExtensionAlias;
	option_code_map[ofea_cl]	= OptionFileExtensionAlias;
	option_code_map[dofn_cl]	= DefaultOptionFileName;
	option_code_map[dofd_cl]	= DefaultOptionFileDirectory;
	option_code_map[ifp_cl]		= InitialFilePair;
	option_code_map[ifppt_cl]	= InitialFilePairPlusType;
	option_code_map[rofn_cl]	= RequestOptionFileName;

	int		i = 1;

	while (i < argc())
	{
		map<string, OptionCodes>::iterator
			oc_iterator = option_code_map.find(string(argv()[i]));

		if (oc_iterator != option_code_map.end())
		{
			switch ((*oc_iterator).second)
			{
				case DataFileExtensionAlias:
				if (i + 2 < argc())
					data_file_extension_aliases.push_back(
						SExtensionAlias(argv()[i+1], argv()[i+2]));
				i += 3;
				break;

				case OptionFileExtensionAlias:
				if (i + 2 < argc())
					option_file_extension_aliases.push_back(
						SExtensionAlias(argv()[i+1], argv()[i+2]));
				i += 3;

				case DefaultOptionFileName:
				if (i + 1 < argc())
					default_option_file_names.push_back(argv()[i+1]);
				i += 2;
				break;

				case DefaultOptionFileDirectory:
				if (i + 1 < argc())
					default_option_file_directory = argv()[i+1];
				i += 2;
				break;

				case InitialFilePair:
				if (i + 2 < argc())
					initial_files.push_back(
						SInitialFile(argv()[i+1], argv()[i+2]));
				i += 3;
				break;

				case InitialFilePairPlusType:
				if (i + 3 < argc())
					initial_files.push_back(
						SInitialFile(argv()[i+1], argv()[i+2], argv()[i+3]));
				i += 4;
				break;

				case RequestOptionFileName:
				request_option_file_name_flag = true;
				i += 1;
				break;
			}
		}
		else
		{
			initial_files.push_back(SInitialFile(argv()[i]));
			i += 1;
		}
	}
}

void    CApplication::SetupInterfaceConfigurations()
{
	vector<SInterfaceConfiguration>::size_type	i;
	vector<SExtensionAlias>::size_type			j;
	vector<string>::size_type					k;
	map<string, int>::iterator					m1_iterator;
	map<string, int>::iterator					m2_iterator;

	for (i=0; i<interface_configurations.size(); i++)
	{
		(*interface_configurations[i].setup_subview_type_data)();

		data_file_extension_to_index_map
			[interface_configurations[i].data_file_extension] = i;

		option_file_extension_to_index_map
			[interface_configurations[i].option_file_extension] = i;

		interface_configurations[i].default_option_file_directory =
			default_option_file_directory;
	}

	for (j=0; j<data_file_extension_aliases.size(); j++)
	{
		SExtensionAlias		&ea = data_file_extension_aliases[j];

		m1_iterator = data_file_extension_to_index_map.find(ea.alias);
		m2_iterator = data_file_extension_to_index_map.find(ea.extension);

		if (m1_iterator == data_file_extension_to_index_map.end() &&
			m2_iterator != data_file_extension_to_index_map.end())
		{
			int		index = (*m2_iterator).second;

			data_file_extension_to_index_map[ea.alias] = index;

			interface_configurations[index].
				data_file_aliases.push_back(ea.alias);
		}
	}

	for (j=0; j<option_file_extension_aliases.size(); j++)
	{
		SExtensionAlias		&ea = option_file_extension_aliases[j];

		m1_iterator = option_file_extension_to_index_map.find(ea.alias);
		m2_iterator = option_file_extension_to_index_map.find(ea.extension);

		if (m1_iterator == option_file_extension_to_index_map.end() &&
			m2_iterator != option_file_extension_to_index_map.end())
		{
			int		index = (*m2_iterator).second;

			option_file_extension_to_index_map[ea.alias] = index;

			interface_configurations[index].
				option_file_aliases.push_back(ea.alias);
		}
	}

	for (k=0; k<default_option_file_names.size(); k++)
	{
		m1_iterator = option_file_extension_to_index_map.begin();

		while (m1_iterator != option_file_extension_to_index_map.end())
		{
			if (FilePath::CheckFileExtension(	default_option_file_names[k],
												(*m1_iterator).first))
			{
				interface_configurations[(*m1_iterator).second].
					default_option_file_name =
						default_option_file_names[k];

				break;
			}

			m1_iterator++;
		}
	}
}

void	CApplication::CreateMainWindow()
{
	main_window = new CMainWindow(this);

	main_window->setCaption(GetApplicationCaption().c_str());
	main_window->show();
}

void	CApplication::LoadDefaultOptionFiles()
{
	vector<SInterfaceConfiguration>::size_type	i;
	
	for (i=0; i<interface_configurations.size(); i++)
		interface_configurations[i].LoadDefaultOptionFile();
}

void	CApplication::SaveDefaultOptionFiles()
{
	vector<SInterfaceConfiguration>::size_type	i;
	
	for (i=0; i<interface_configurations.size(); i++)
		interface_configurations[i].SaveDefaultOptionFile();
}

void	CApplication::ApplicationClose()
{
	QApplication::exit(0);
}

bool    SInterfaceConfiguration::LoadDefaultOptionFile()
{
	options_modified_flag = false;

	string		default_option_file_full_path(default_option_file_directory);

	default_option_file_full_path += '/';
	default_option_file_full_path += default_option_file_name;

	if (FilePath::FileExists(default_option_file_full_path))
	{
		ifstream	i_file_stream(default_option_file_full_path.c_str());

		delete default_option_data;

		CParserDriver::StatusCode	sc =
			COptionData::InputOptionData(i_file_stream, &default_option_data);

		if (sc == CParserDriver::EndOfFile)
			return true;
		else
		{
			CInformationDialog	*ifd = new CInformationDialog(0);

			string		text("Default option file syntax error.\n");

			text += "Option File: ";
			text += default_option_file_name;
			text += '\n';
			text += "Loading internal default option file definition.";

			ifd->SetTitleAndMessageText("Load Default Option File", text);
			ifd->ExecuteDialog();

			delete ifd;

			return CreateDefaultOptions(&default_option_data);
		}
	}
	else
		return CreateDefaultOptions(&default_option_data);
}

bool    SInterfaceConfiguration::SaveDefaultOptionFile()
{
	if (!default_option_data)
		return false;

	if (!options_modified_flag)
		return true;

	string		default_option_file_full_path(default_option_file_directory);

	default_option_file_full_path += '/';
	default_option_file_full_path += default_option_file_name;

	ofstream	o_file_stream(default_option_file_full_path.c_str());

	o_file_stream << *default_option_data;

	options_modified_flag = false;

	return true;
}

bool	SInterfaceConfiguration::CreateDefaultOptions(COptionData **ptr_ptr_od)
{
	int		line_count		= 0;
	int		buffer_size		= 0;

	while (default_default_option_data[line_count])
	{
		buffer_size += strlen(default_default_option_data[line_count]);

		line_count++;
	}

	buffer_size += line_count;

	unsigned char	input_buffer[buffer_size];
	char			*buffer_ptr = reinterpret_cast<char *>(input_buffer);

	for (int i=0; i<line_count; i++)
	{
		strcpy(buffer_ptr, default_default_option_data[i]);

		buffer_ptr += strlen(default_default_option_data[i]);

		*buffer_ptr++ = '\n';
	}

	CParserDriver::StatusCode	sc =
		COptionData::InputOptionData(	input_buffer,
										buffer_size,
										ptr_ptr_od);

	if (sc == CParserDriver::EndOfFile)
		return true;
	else
	{
		CInformationDialog	*ifd = new CInformationDialog(0);

		string		text("Internal default option file syntax error.\n");

		text += "Interface Type: ";
		text += data_file_extension;
		text += " ";
		text += option_file_extension;

		ifd->SetTitleAndMessageText("Create Default Options", text);
		ifd->ExecuteDialog();

		delete ifd;

		return false;
	}
}

void	CViewWidgetStack::closeEvent(QCloseEvent *ev)
{
	const map<int, SMainViewControl *> 
		&cm = interface_control->GetMainViewIdToControlMap();

	map<int, SMainViewControl *>::const_iterator
		m_iterator = cm.find(interface_control->GetCurrentMainViewId());

	if (m_iterator != cm.end())
		interface_control->ChangeMenuItemToHidden((*m_iterator).second);

	ev->accept();
}

bool	CMainWindow::check_matching_new_file_names::operator()(
											pair<int, CInterfaceControl *> x)
{
	return (check_data_name == x.second->GetDataFileName() ||
			check_option_name == x.second->GetOptionFileName());
}

bool	CMainWindow::check_matching_data_file_name::operator()(
											pair<int, CInterfaceControl *> x)
{
	return check_name == x.second->GetDataFileName();
}

bool	CMainWindow::check_matching_option_file_name::operator()(
											pair<int, CInterfaceControl *> x)
{
	return check_name == x.second->GetOptionFileName();
}

void	CMainWindow::create_workspace_views::operator()(
											pair<int, CInterfaceControl *> x)
{
	x.second->CreateWorkspaceViews(workspace);
}

void	CMainWindow::create_widget_stack_views::operator()(
											pair<int, CInterfaceControl *> x)
{
	CViewWidgetStack	*ws =
		new CViewWidgetStack(workspace, x.second);

	interface_id_to_widget_stack_map[x.first] = ws;

	x.second->CreateWidgetStackViews(ws);

	ws->show();
}

void	CMainWindow::create_main_view_id_to_interface_id_map::operator()(
											pair<int, CInterfaceControl *> x)
{
	const vector< pair<int, string> >	&v =
			x.second->GetMainViewIdAndNameInfo();

	for (int i=0; i<v.size(); i++)
		main_view_id_to_interface_id_map[v[i].first] = x.first;

	const pair<int, string>		&p =
			x.second->GetTitleIdAndName();

	main_view_id_to_interface_id_map[p.first] = x.first;
}

void	CMainWindow::destroy_interface_views::operator()(
											pair<int, CInterfaceControl *> x)
{
	x.second->DestroyViews();
}

void	CMainWindow::create_interface_id_and_name_vector::operator()(
											pair<int, CInterfaceControl *> x)
{
	interface_id_and_name_vector.push_back(
		pair<int, string>(x.first, x.second->GetOptionFileName()));
}

CMainWindow::CMainWindow(CApplication *a)
	: Q3MainWindow(	0, 0),
		application(a), interface_type(::InterfaceTypeInitialize),
		central_widget(0), workspace(0), widget_stack(0), help_viewer(0),
		file_open_flag(false), event_block_flag(false)
{
	SetupMainMenu();

	current_main_view_id	= -1;
	current_interface_id	= -1;

	SetInterfaceType(::MultipleDocumentMultipleView);

	status_bar = statusBar();

	status_bar->addWidget(new QLabel(status_bar));

	status_bar->setSizeGripEnabled(false);

	UpdateCurrentFileMessage(string(), string());

	OptionDialog::CreateOptionDialogs(this);

	application->CreateInterfaceDialogs(this);

	SetMainWindowOptions(
		application->GetInterfaceConfigurations()[0].GetDefaultOptions());

	LoadInitialFiles();
}

void	CMainWindow::SetupMainMenu()
{
	SFileViewHelpData	&fvhd = application->GetFileViewHelpData();

	file_submenu_id	= fvhd.file_submenu_id;
	view_submenu_id	= fvhd.view_submenu_id;
	help_submenu_id	= fvhd.help_submenu_id;

	SSubmenuNodeData	*file_snd = fvhd.file_snd;
	SSubmenuNodeData	*view_snd = fvhd.view_snd;
	SSubmenuNodeData	*help_snd = fvhd.help_snd;

	vector< pair<int, SSubmenuNodeData *> >		submenus;
	vector<SInterfaceConfiguration>::size_type	i;
	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	int		submenu_count = 3;

	submenus.push_back(
		pair<int, SSubmenuNodeData *>(file_submenu_id, file_snd));

	for (i=0; i<cf.size(); i++)
	{
		vector< pair<int, SSubmenuNodeData *> >::size_type	j;
		const vector< pair<int, SSubmenuNodeData *> >
			&snd = cf[i].GetSubmenuNodeData();

		for (j=0; j<snd.size(); j++)
			submenus.push_back(snd[j]);

		submenu_count += snd.size();
	}

	submenus.push_back(
		pair<int, SSubmenuNodeData *>(view_submenu_id, view_snd));
	submenus.push_back(
		pair<int, SSubmenuNodeData *>(help_submenu_id, help_snd));

	int				view_submenu_index = submenu_count - 2;
	ostrstream		index_text;

	index_text << view_submenu_index << '\0';

	string	main_view_index_string		= index_text.str();
	string	interface_type_index_string	= main_view_index_string + ",0";

	menu_bar = menuBar();

	menu_configuration	= new SMainMenuConfiguration(submenus);

	menu_configuration->CreateMenu(menu_bar);
	menu_configuration->DisableMenu();
	
	main_view_menu =
		menu_configuration->GetSubMenu(main_view_index_string);
	// interface_type_menu	=
	// 	menu_configuration->GetSubMenu(interface_type_index_string);

	main_view_menu_manager = new CMainViewMenu(main_view_menu);
}

CMainWindow::~CMainWindow()
{
	OptionDialog::DestroyOptionDialogs();

	application->DestroyInterfaceDialogs();

	delete status_bar;
	delete menu_configuration;
	delete main_view_menu_manager;
	delete menu_bar;
	delete help_viewer;
}

bool	CMainWindow::event(QEvent *ev)
{
	switch ((int)ev->type())
	{
		case InterfaceRestore:
		SetInterfaceType(interface_restore_type);
		return true;

		case UpdateGeometry:
		option_edit_frame->UpdateOptionEditFrameGeometry();
		option_edit_scrollview->updateGeometry();
		widget_stack->updateGeometry();
		return true;

		case EventBlockFlag:
		event_block_flag = false;
		return true;
	}

	return QWidget::event(ev);
}

void	CMainWindow::closeEvent(QCloseEvent *event)
{
	if (interface_type == ::EditOptionsView)
		SetInterfaceType(interface_restore_type);

	int		interface_count = interface_id_to_interface_map.size();

	for (int i=0; i<interface_count; i++)
	{
		CloseFile();
		SetEventBlockFlag(false);
	}

	CMessageDialog		*msd = OptionDialog::message_dialog;

	vector<SInterfaceConfiguration>::size_type	j;
	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	for (j=0; j<cf.size(); j++)
	{
		if (cf[j].GetOptionsModifiedFlag())
		{
			string		text("Default option file modified.\n");

			text += "Option File: ";
			text += cf[j].GetDefaultOptionFileName();
			text += '\n';
			text += "Save before exiting ?";

			msd->SetTitleAndMessageText("Exit Application", text);

			if (msd->ExecuteDialog() == QDialog::Accepted)
				cf[j].SaveDefaultOptionFile();
		}
	}

	event->accept();
}

void	CMainWindow::SetMainWindowOptions(COptionData *d)
{
	if (!d) return;

	map<string, string>		*auxiliary_strings = d->GetAuxiliaryStrings();

	map<string, string>::iterator	s_iterator;

	if (auxiliary_strings &&
		(s_iterator =
			auxiliary_strings->find(string("Qt_Library_Warning_Message"))) !=
				auxiliary_strings->end())
	{
		static QRegExp		regexp("(T|t)(R|r)(U|u)(E|e)");

		if (regexp.exactMatch((*s_iterator).second.c_str()))
			qt_library_warning_message_flag = true;
		else
			qt_library_warning_message_flag = false;
	}
	else
		qt_library_warning_message_flag = false;

	if (auxiliary_strings &&
		(s_iterator =
			auxiliary_strings->find(string("Application_Style"))) !=
				auxiliary_strings->end())
	{
		application->setStyle((*s_iterator).second.c_str());
	}
	else
		application->setStyle("windowsxp");

	COptionData::SApplicationData	*main_window_data = d->GetApplicationData();

	if (main_window_data)
	{
		CPaletteData	*main_window_palette_data =
			main_window_data->GetPaletteData();

		if (main_window_palette_data)
		{
			QPalette	main_palette;

			main_window_palette_data->SetupPalette(main_palette);

			menu_configuration->SetMenuPalette(main_palette);
			status_bar->setPalette(main_palette);
		}

		string		&main_window_font_string =
			main_window_data->GetFontString();

		if (main_window_font_string.length())
		{
			QFont		main_font;

			FontSpecifier::SetFontSpecifier(main_font, main_window_font_string);

			menu_configuration->SetMenuFont(main_font);
			status_bar->setFont(main_font);

			QFontMetrics    fm(main_font);

			status_bar->setMinimumHeight((fm.height() * 4) / 3);
		}

		QPoint	main_window_position = main_window_data->GetPosition();

		if (main_window_position != QPoint(-1, -1))
			move(main_window_position);

		QSize	main_window_size = main_window_data->GetSize();

		if (main_window_size != QSize(-1, -1))
			resize(main_window_size);

		SetApplicationMenuOptions(d);

		OptionDialog::SetPaletteAndFont(status_bar);
	}

	SetHelpViewerOptions(d);
}

void    CMainWindow::SetApplicationMenuOptions(COptionData *d)
{
}

void    CMainWindow::SetHelpViewerOptions(COptionData *d)
{
	if (!d || !help_viewer)
		return;

	COptionData::SHelpData	*help_viewer_data = d->GetHelpData();

	if (help_viewer_data)
	{
		CPaletteData	*help_viewer_palette_data =
			help_viewer_data->GetPaletteData();

		if (help_viewer_palette_data)
		{
			QPalette	help_palette;

			help_viewer_palette_data->SetupPalette(help_palette);

			help_viewer->setPalette(help_palette);
		}

		string		&help_viewer_font_string =
			help_viewer_data->GetFontString();

		if (help_viewer_font_string.length())
		{
			QFont		help_font;

			FontSpecifier::SetFontSpecifier(help_font, help_viewer_font_string);

			help_viewer->setFont(help_font);
		}

		QPoint	help_viewer_position = help_viewer_data->GetPosition();

		if (help_viewer_position != QPoint(-1, -1))
			help_viewer->move(help_viewer_position);

		QSize	help_viewer_size = help_viewer_data->GetSize();

		if (help_viewer_size != QSize(-1, -1))
			help_viewer->resize(help_viewer_size);
	}
}

void	CMainWindow::SetOptionEditViewOptions(COptionData *d)
{
	if (!d)
	{
		OptionDialog::SetPaletteAndFont(this);
		return;
	}

	QPalette	option_edit_view_palette;
	QFont		option_edit_view_font;

	map<string, CPaletteData *>
		*auxiliary_palettes = d->GetAuxiliaryPalettes();

	map<string, CPaletteData *>::iterator	m_iterator;

	if (auxiliary_palettes &&
		(m_iterator =
			auxiliary_palettes->find(string("Option_Edit_View_Palette"))) !=
				auxiliary_palettes->end())
	{
		(*m_iterator).second->SetupPalette(option_edit_view_palette);

		option_edit_scrollview->setPalette(option_edit_view_palette);
	}
	else
	{
		CPaletteData	*main_window_palette_data =
			d->GetApplicationData()->GetPaletteData();

		if (main_window_palette_data)
		{
			main_window_palette_data->SetupPalette(option_edit_view_palette);

			option_edit_scrollview->setPalette(option_edit_view_palette);
		}
	}

	map<string, string>		*auxiliary_fonts = d->GetAuxiliaryFonts();

	map<string, string>::iterator	f_iterator;

	if (auxiliary_fonts &&
		(f_iterator =
			auxiliary_fonts->find(string("Option_Edit_View_Font"))) !=
				auxiliary_fonts->end())
	{
		FontSpecifier::SetFontSpecifier(option_edit_view_font,
										(*f_iterator).second);

		option_edit_scrollview->setFont(option_edit_view_font);
	}
	else
	{
		string		&main_window_font_string =
			d->GetApplicationData()->GetFontString();

		if (main_window_font_string.length())
		{
			FontSpecifier::SetFontSpecifier(option_edit_view_font,
											main_window_font_string);

			option_edit_scrollview->setFont(option_edit_view_font);
		}
	}

	OptionDialog::SetPaletteAndFont(option_edit_scrollview);
}

void	CMainWindow::LoadInitialFiles()
{
}

int		CMainWindow::new_file_id = 0;

void	CMainWindow::GetNewFileNames(int type, string &dfn, string &ofn)
{
	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	string	cwd;

	FilePath::GetCurrentWorkingDirectory(cwd);

	ostrstream		new_data_file_name;
	ostrstream		new_option_file_name;

	new_data_file_name	<< cwd << "/new_file_" << new_file_id
						<< cf[type].GetDataFileExtension() << '\0';

	dfn = new_data_file_name.str();

	new_option_file_name	<< cwd << "/new_file_" << new_file_id
							<< cf[type].GetOptionFileExtension() << '\0';

	ofn = new_option_file_name.str();

	new_file_id++;
}

void	CMainWindow::NewFile()
{
	if (GetEventBlockFlag())
		return;

	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	if (cf.size() > 1)
		NewFileMultipleType();
	else
		NewFileType(0);

	SetupEventBlock();
}

void	CMainWindow::NewFileMultipleType()
{
}

void	CMainWindow::NewFileType(int type)
{
	if (interface_type == ::SingleDocumentSingleView &&
		interface_id_to_interface_map.size() == 1)
	{
		CInformationDialog	*ifd = OptionDialog::information_dialog;

		ifd->SetTitleAndMessageText("New File",
			"Currently in single document single view mode.\n"
			"Close open file before creating a new file.");

		ifd->ExecuteDialog();

		return;
	}

	string			data_file_name;
	string			option_file_name;
	COptionData		*option_data;

	while (true)
	{
		GetNewFileNames(type, data_file_name, option_file_name);

		IdToControlMapIterator	m_iterator =
			find_if(interface_id_to_interface_map.begin(),
					interface_id_to_interface_map.end(),
					check_matching_new_file_names(	data_file_name,
													option_file_name));

		if (m_iterator == interface_id_to_interface_map.end())
			break;
	}

	CreateNewData(type);

	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	option_data = new COptionData(*cf[type].GetDefaultOptions());

	CreateInterface(type, data_file_name, option_file_name, option_data);
}

void	CMainWindow::OpenFile()
{
	if (GetEventBlockFlag() || GetFileOpenFlag())
		return;

	vector<SInterfaceConfiguration>
		&ic = application->GetInterfaceConfigurations();

	if (ic.size() > 1)
		OpenFileMultipleType();
	else
		OpenFileSingleType();

	SetFileOpenFlag(true);

	SetupEventBlock();
}

void	CMainWindow::OpenFileMultipleType()
{
}

void	CMainWindow::OpenFileSingleType()
{
	if (interface_type == ::SingleDocumentSingleView &&
		interface_id_to_interface_map.size() == 1)
	{
		CInformationDialog	*ifd = OptionDialog::information_dialog;

		ifd->SetTitleAndMessageText("Open File",
			"Currently in single document single view mode.\n"
			"Close open file before opening another existing file.");

		ifd->ExecuteDialog();

		return;
	}

	int		type = 0;

	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	vector< pair<string, string> >		file_types;
	string								wildcard;

	wildcard = "*" + cf[type].GetDataFileExtension();

	file_types.push_back(pair<string, string>("Data Files", wildcard));

	const vector<string>	&data_file_aliases = cf[type].GetDataFileAliases();

	vector<string>::size_type	i;

	for (i=0; i<data_file_aliases.size(); i++)
	{
		wildcard = "*" + data_file_aliases[i];

		file_types.push_back(pair<string, string>("Data Files", wildcard));
	}

	file_types.push_back(pair<string, string>("All Files", "*"));

	string			data_file_name;
	string			option_file_name;
	COptionData		*option_data;

	CFileDirectoryDialog	*fdd = OptionDialog::file_directory_dialog;

	while (true)
	{
		if (fdd->DisplayOpenFileDialog(	&data_file_name,
										"Open Data File",
										string(),
										string(),
										&file_types) != QDialog::Accepted)
			return;

		IdToControlMapIterator	m_iterator =
			find_if(interface_id_to_interface_map.begin(),
					interface_id_to_interface_map.end(),
					check_matching_data_file_name(data_file_name));

		if (m_iterator == interface_id_to_interface_map.end())
			break;
		else
		{
			CInformationDialog	*ifd = OptionDialog::information_dialog;

			ostrstream		message;

			message	<< "Data file " << data_file_name
					<< " already open." << '\0';

			ifd->SetTitleAndMessageText("Open File", message.str());

			ifd->ExecuteDialog();
		}
	}

	if (application->GetRequestOptionFileNameFlag())
	{
		wildcard = "*" + cf[type].GetOptionFileExtension();

		file_types.clear();
		file_types.push_back(pair<string, string>("Option Files", wildcard));

		const vector<string>	&option_file_aliases =
									cf[type].GetOptionFileAliases();

		vector<string>::size_type	j;

		for (j=0; j<option_file_aliases.size(); j++)
		{
			wildcard = "*" + option_file_aliases[j];

			file_types.push_back(
				pair<string, string>("Option Files", wildcard));
		}

		file_types.push_back(pair<string, string>("All Files", "*"));

		while (true)
		{
			if (fdd->DisplayOpenFileDialog(	&option_file_name,
											"Open Option File",
											string(),
											string(),
											&file_types) != QDialog::Accepted)
				return;

			IdToControlMapIterator	m_iterator =
				find_if(interface_id_to_interface_map.begin(),
						interface_id_to_interface_map.end(),
						check_matching_option_file_name(option_file_name));

			if (m_iterator == interface_id_to_interface_map.end())
				break;
			else
			{
				CInformationDialog	*ifd = OptionDialog::information_dialog;

				ostrstream		message;

				message	<< "Option file " << option_file_name
						<< " already open." << '\0';

				ifd->SetTitleAndMessageText("Open File", message.str());

				ifd->ExecuteDialog();
			}
		}
	}
	else
	{
		string	path;
		string	file_name;

		FilePath::GetPathAndFileName(data_file_name, path, file_name);

		FilePath::CreateAssociatedFileName(
			data_file_name,
			cf[type].GetDataFileExtension(),
			cf[type].GetOptionFileExtension(),
			file_name);

		option_file_name = path + "/" + file_name;
	}

	ifstream	d_file(data_file_name.c_str());

	if (d_file)
	{
		if (!LoadData(type, d_file))
		{
			LoadDataError(type);
			return;
		}
	}
	else
	{
		CInformationDialog	*ifd = OptionDialog::information_dialog;

		ostrstream		message;

		message	<< "Data file " << data_file_name
				<< " not found." << '\0';

		ifd->SetTitleAndMessageText("Open File", message.str());

		ifd->ExecuteDialog();

		return;
	}

	ifstream	o_file(option_file_name.c_str(), ios::in | ios::binary);

	if (o_file)
	{
		if (!LoadOptions(o_file, &option_data))
		{
			LoadOptionsError(option_file_name);

			option_data = new COptionData(*cf[type].GetDefaultOptions());
		}
	}
	else
	{
		if (application->GetRequestOptionFileNameFlag())
		{
			CInformationDialog	*ifd = OptionDialog::information_dialog;

			ostrstream		message;

			message	<< "Option file " << option_file_name
					<< " not found." << endl
					<< "Default option file will be loaded." << '\0';

			ifd->SetTitleAndMessageText("Open File", message.str());

			ifd->ExecuteDialog();
		}

		option_data = new COptionData(*cf[type].GetDefaultOptions());
	}

	CreateInterface(type, data_file_name, option_file_name, option_data);
}

void	CMainWindow::SaveAsFile()
{
	if (GetEventBlockFlag())
		return;

	SaveAsFileType();

	SetupEventBlock();
}

void	CMainWindow::SaveAsFileType()
{
	CInterfaceControl	*current_interface =
		interface_id_to_interface_map[current_interface_id];

	int		type = current_interface->GetConfigurationId();

	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	vector< pair<string, string> >		file_types;
	string								wildcard;

	wildcard = "*" + cf[type].GetDataFileExtension();

	file_types.push_back(pair<string, string>("Data Files", wildcard));

	const vector<string>	&data_file_aliases = cf[type].GetDataFileAliases();

	vector<string>::size_type	i;

	for (i=0; i<data_file_aliases.size(); i++)
	{
		wildcard = "*" + data_file_aliases[i];

		file_types.push_back(pair<string, string>("Data Files", wildcard));
	}

	file_types.push_back(pair<string, string>("All Files", "*"));

	string			data_file_name;
	string			option_file_name;

	CFileDirectoryDialog	*fdd = OptionDialog::file_directory_dialog;

	while (true)
	{
		if (fdd->DisplaySaveAsFileDialog(	&data_file_name,
											"Save As Data File",
											string(),
											string(),
											&file_types) != QDialog::Accepted)
			return;

		IdToControlMapIterator	m_iterator =
			find_if(interface_id_to_interface_map.begin(),
					interface_id_to_interface_map.end(),
					check_matching_data_file_name(data_file_name));

		if (m_iterator == interface_id_to_interface_map.end())
			break;
		else
		{
			CInformationDialog	*ifd = OptionDialog::information_dialog;

			ostrstream		message;

			message	<< "Data file " << data_file_name
					<< " already open." << '\0';

			ifd->SetTitleAndMessageText("Save As File", message.str());

			ifd->ExecuteDialog();
		}
	}

	if (application->GetRequestOptionFileNameFlag())
	{
		wildcard = "*" + cf[type].GetOptionFileExtension();

		file_types.clear();
		file_types.push_back(pair<string, string>("Option Files", wildcard));

		const vector<string>	&option_file_aliases =
									cf[type].GetOptionFileAliases();

		vector<string>::size_type	j;

		for (j=0; j<option_file_aliases.size(); j++)
		{
			wildcard = "*" + option_file_aliases[j];

			file_types.push_back(
				pair<string, string>("Option Files", wildcard));
		}

		file_types.push_back(pair<string, string>("All Files", "*"));

		while (true)
		{
			if (fdd->DisplaySaveAsFileDialog(&option_file_name,
											"Save As Option File",
											string(),
											string(),
											&file_types)!= QDialog::Accepted)
				return;

			IdToControlMapIterator	m_iterator =
				find_if(interface_id_to_interface_map.begin(),
						interface_id_to_interface_map.end(),
						check_matching_option_file_name(option_file_name));

			if (m_iterator == interface_id_to_interface_map.end())
				break;
			else
			{
				CInformationDialog	*ifd = OptionDialog::information_dialog;

				ostrstream		message;

				message	<< "Option file " << option_file_name
						<< " already open." << '\0';

				ifd->SetTitleAndMessageText("Save As File", message.str());

				ifd->ExecuteDialog();
			}
		}
	}
	else
	{
		string	path;
		string	file_name;

		FilePath::GetPathAndFileName(data_file_name, path, file_name);

		FilePath::CreateAssociatedFileName(
			data_file_name,
			cf[type].GetDataFileExtension(),
			cf[type].GetOptionFileExtension(),
			file_name);

		option_file_name = path + "/" + file_name;
	}

	if (FilePath::FileExists(data_file_name))
	{
		CMessageDialog		*msd = OptionDialog::message_dialog;

		string	s("Overwrite existing file named ");
		s += data_file_name;
		s += " ?";

		msd->SetTitleAndMessageText("Save As File", s);

		if (msd->ExecuteDialog() == QDialog::Accepted)
		{
			current_interface->SetDataFileName(data_file_name);
			current_interface->UpdateTitleName();

			UpdateCurrentFileMessage(
								data_file_name,
								current_interface->GetOptionFileName(),
								false,
								current_interface->GetOptionsModifiedFlag());

			ofstream	d_file(data_file_name.c_str());
			SaveData(d_file, current_interface);
		}
		else
			return;
	}
	else
	{
		current_interface->SetDataFileName(data_file_name);
		current_interface->UpdateTitleName();

		UpdateCurrentFileMessage(
								data_file_name,
								current_interface->GetOptionFileName(),
								false,
								current_interface->GetOptionsModifiedFlag());

		ofstream	d_file(data_file_name.c_str());
		SaveData(d_file, current_interface);
	}

	if (FilePath::FileExists(option_file_name))
	{
		CMessageDialog		*msd = OptionDialog::message_dialog;

		string	s("Overwrite existing file named ");
		s += option_file_name;
		s += " ?";

		msd->SetTitleAndMessageText("Save As File", s);

		if (msd->ExecuteDialog() == QDialog::Accepted)
		{
			current_interface->SetOptionFileName(option_file_name);

			UpdateCurrentFileMessage(data_file_name, option_file_name);

			ofstream	o_file(option_file_name.c_str());
			SaveOptions(o_file, current_interface);
		}
		else
			return;
	}
	else
	{
		current_interface->SetOptionFileName(option_file_name);

		UpdateCurrentFileMessage(data_file_name, option_file_name);

		ofstream	o_file(option_file_name.c_str());
		SaveOptions(o_file, current_interface);
	}
}

void	CMainWindow::SaveFile()
{
	if (GetEventBlockFlag())
		return;

	CInterfaceControl	*current_interface =
		interface_id_to_interface_map[current_interface_id];

	if (current_interface->GetDataModifiedFlag())
	{
		ofstream	d_file(current_interface->GetDataFileName().c_str());
		SaveData(d_file, current_interface);
	}

	if (current_interface->GetOptionsModifiedFlag())
	{
		ofstream	o_file(current_interface->GetOptionFileName().c_str());
		SaveOptions(o_file, current_interface);
	}

	SetupEventBlock();
}

void	CMainWindow::CloseFile()
{
	if (GetEventBlockFlag() || current_interface_id == -1)
		return;

	CInterfaceControl	*current_interface =
		interface_id_to_interface_map[current_interface_id];

	current_interface->PostApplicationData();

	bool	dm = current_interface->GetDataModifiedFlag();
	bool	om = current_interface->GetOptionsModifiedFlag();

	if (dm || om)
	{
		string		s;

		if (dm && om)
		{
			s = "Data file ";
			s += current_interface->GetDataFileName();
			s += " and\n option file ";
			s += current_interface->GetOptionFileName();
			s += " are modified.\n";
		}
		else if (dm && !om)
		{
			s = "Data file ";
			s += current_interface->GetDataFileName();
			s += " is modified.\n";
		}
		else if (!dm && om)
		{
			s = "Option file ";
			s += current_interface->GetOptionFileName();
			s += " is modified.\n";
		}
		
		s += "Save before closing ?";

		CMessageDialog		*msd = OptionDialog::message_dialog;

		msd->SetTitleAndMessageText("Close", s);

		if (msd->ExecuteDialog() == QDialog::Accepted)
			SaveFile();
	}

	if (interface_type == ::MultipleDocumentSingleView ||
		interface_type == ::MultipleDocumentMultipleView)
		DisconnectMainViewActivated();

	DestroyInterface();

	if (interface_type == ::MultipleDocumentSingleView ||
		interface_type == ::MultipleDocumentMultipleView)
		ConnectMainViewActivated();

	SetFileOpenFlag(false);

	SetupEventBlock();
}

bool	CMainWindow::LoadOptions(ifstream &f, COptionData **option_data)
{
	CParserDriver::StatusCode	sc =
					COptionData::InputOptionData(f, option_data);

	if (sc == CParserDriver::EndOfFile)
		return true;
	else
		return false;
}

bool	CMainWindow::SaveOptions(ofstream &f, CInterfaceControl *ic)
{
	f << *ic->GetOptionData();

	ic->SetOptionsModifiedFlag(false);

	return true;
}

void	CMainWindow::LoadOptionsError(const string &option_file_name)
{
	CInformationDialog	*ifd = OptionDialog::information_dialog;

	ostrstream		message;

	message	<< "Error loading option file " << option_file_name << "." << endl
			<< "Default options file will be loaded." << '\0';

	ifd->SetTitleAndMessageText("Load Options File", message.str());

	ifd->ExecuteDialog();
}

void	CMainWindow::UpdateCurrentFileMessage(	const string &data_file_name,
												const string &option_file_name,
												bool d_modified_flag,
												bool o_modified_flag)
{
	if (interface_id_to_interface_map.size())
	{
		string	path;
		string	file_name;

		FilePath::GetPathAndFileName(data_file_name, path, file_name);

		string	caption_message(application->GetApplicationCaption());

		caption_message += " - ";
		caption_message += file_name;

		setCaption(caption_message.c_str());

		string	status_message("current file: ");

		if (d_modified_flag)
			status_message += "*";

		status_message += file_name;
		status_message += "  options: ";

		if (o_modified_flag)
			status_message += "*";

		FilePath::GetPathAndFileName(option_file_name, path, file_name);

		status_message += file_name;

		status_bar->message(status_message.c_str());
	}
	else
	{
		setCaption(application->GetApplicationCaption().c_str());

		status_bar->message("no open files");
	}
}

void	CMainWindow::CreateNewData(int type)
{
	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	(*cf[type].create_new_data)();
}

bool	CMainWindow::LoadData(int type, ifstream &f)
{
	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	return (*cf[type].load_data)(f);
}

void	CMainWindow::LoadDataError(int type)
{
	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	(*cf[type].load_data_error)();
}

CInterfaceControl
	*CMainWindow::CreateApplicationInterfaceControl(int c_id, int i_id,
													CMainViewMenu *mvm)
{
	vector<SInterfaceConfiguration>
		&cf = application->GetInterfaceConfigurations();

	return (*cf[c_id].create_interface_control)(c_id, i_id, mvm, this);
}

void	CMainWindow::SetApplicationData(CInterfaceControl *ic)
{
	ic->SetApplicationData();
}

bool	CMainWindow::SaveData(ofstream &f, CInterfaceControl *ic)
{
	return ic->SaveData(f);
}

void	CMainWindow::CreateInterface(	int configuration_id,
										const string &data_file_name,
										const string &option_file_name,
										COptionData *option_data)
{
	current_interface_id = interface_id_generator.GetId();

	CInterfaceControl	*ic =
		CreateApplicationInterfaceControl(	configuration_id,
											current_interface_id,
											main_view_menu_manager);

	interface_id_to_interface_map[current_interface_id] = ic;

	ic->SetDataFileName(data_file_name);
	ic->SetOptionFileName(option_file_name);
	ic->SetOptionData(option_data);
	SetApplicationData(ic);

	SetMainWindowOptions(option_data);

	switch (interface_type)
	{
		case ::SingleDocumentSingleView:
		ic->CreateWidgetStackViews(widget_stack);
		break;

		case ::MultipleDocumentSingleView:
		{
			CViewWidgetStack	*ws =
				new CViewWidgetStack(workspace, ic);
			interface_id_to_widget_stack_map[current_interface_id] = ws;
			ic->CreateWidgetStackViews(ws);
		}
		break;

		case ::MultipleDocumentMultipleView:
		ic->CreateWorkspaceViews(workspace);
		break;
	}

	current_main_view_id = ic->GetCurrentMainViewId();

	const vector< pair<int, string> >	&v = ic->GetMainViewIdAndNameInfo();

	for (int i=0; i<v.size(); i++)
		main_view_id_to_interface_id_map[v[i].first] = current_interface_id;

	const pair<int, string>		&p = ic->GetTitleIdAndName();

	main_view_id_to_interface_id_map[p.first] = current_interface_id;

	ModifyFileViewHelpMenu(
		SMainSubmenuNodeData::main_submenu_open_documents, this);
	ic->EnableInterfaceMenu();

	UpdateCurrentFileMessage(data_file_name, option_file_name);
}

void	CMainWindow::DestroyInterface()
{
	CInterfaceControl	*current_interface =
		interface_id_to_interface_map[current_interface_id];

	current_interface->DisableInterfaceMenu();

	const vector< pair<int, string> >
		&v = current_interface->GetMainViewIdAndNameInfo();

	for (int i=0; i<v.size(); i++)
		main_view_id_to_interface_id_map.erase(v[i].first);

	const pair<int, string>		&p = current_interface->GetTitleIdAndName();

	main_view_id_to_interface_id_map.erase(p.first);

	delete current_interface;

	interface_id_to_interface_map.erase(current_interface_id);

	if (interface_type == ::MultipleDocumentSingleView)
	{
		CViewWidgetStack	*ws =
						interface_id_to_widget_stack_map[current_interface_id];

		delete ws;

		interface_id_to_widget_stack_map.erase(current_interface_id);
	}

	interface_id_generator.ReturnId(current_interface_id);

	if (!interface_id_to_interface_map.size())
	{
		ModifyFileViewHelpMenu(
			SMainSubmenuNodeData::main_submenu_no_open_documents, this);

		current_main_view_id	= -1;
		current_interface_id	= -1;

		SetMainWindowOptions(
			application->GetInterfaceConfigurations()[0].GetDefaultOptions());

		UpdateCurrentFileMessage(string(), string());
	}
	else
	{
		current_interface_id = (*interface_id_to_interface_map.begin()).first;

		CInterfaceControl	*current_interface =
					(*interface_id_to_interface_map.begin()).second;

		current_interface->EnableInterfaceMenu();

		SetMainWindowOptions(current_interface->GetOptionData());

		current_interface->RaiseCurrentView();

		current_main_view_id	= current_interface->GetCurrentMainViewId();

		UpdateCurrentFileMessage(
								current_interface->GetDataFileName(),
								current_interface->GetOptionFileName(),
								current_interface->GetDataModifiedFlag(),
								current_interface->GetOptionsModifiedFlag());
	}
}

void    CMainWindow::CaptureSizeAndPosition()
{
	if (GetEventBlockFlag())
		return;

	vector< pair<int, string> >		interface_id_and_name_vector;

	for_each(	interface_id_to_interface_map.begin(),
				interface_id_to_interface_map.end(),
				create_interface_id_and_name_vector(
											interface_id_and_name_vector));

	CSizePositionDialog		*spd = OptionDialog::size_position_dialog;

	bool			reset_data_flag;
	bool			capture_application_flag;
	bool			capture_help_flag;
	vector<int>		selected_id_vector;

	spd->SetTitleAndResize("Capture Size And Position Data");
	spd->SetInterfaceIdAndNameVector(&interface_id_and_name_vector);
	spd->SetResetDataFlagPointer(&reset_data_flag);
	spd->SetCaptureApplicationFlagPointer(&capture_application_flag);
	spd->SetCaptureHelpFlagPointer(&capture_help_flag);
	spd->SetSelectedIdVectorPointer(&selected_id_vector);

	if (spd->exec() == QDialog::Accepted)
	{
		COptionData		*default_options;

		if (interface_id_to_interface_map.size())
		{
			CInterfaceControl	*current_interface =
					interface_id_to_interface_map[current_interface_id];

			int		type = current_interface->GetConfigurationId();

			default_options =
				application->
					GetInterfaceConfigurations()[type].GetDefaultOptions();
		}
		else
		{
			default_options =
				application->
					GetInterfaceConfigurations()[0].GetDefaultOptions();
		}

		if (capture_application_flag)
		{
			if (reset_data_flag)
			{
				default_options->GetApplicationData()->SetPosition(
															QPoint(-1, -1));
				default_options->GetApplicationData()->SetSize(QSize(-1, -1));
			}
			else
			{
				default_options->GetApplicationData()->SetPosition(pos());
				default_options->GetApplicationData()->SetSize(size());
			}
		}

		if (capture_help_flag)
		{
			if (reset_data_flag)
			{
				default_options->GetHelpData()->SetPosition(QPoint(-1, -1));
				default_options->GetHelpData()->SetSize(QSize(-1, -1));
			}
			else if (help_viewer)
			{
				default_options->GetHelpData()->SetPosition(help_viewer->pos());
				default_options->GetHelpData()->SetSize(help_viewer->size());
			}
		}

		vector<int>::size_type		j;

		for (j=0; j<selected_id_vector.size(); j++)
		{
			CInterfaceControl	*ic =
				interface_id_to_interface_map[selected_id_vector[j]];

			COptionData			*od = ic->GetOptionData();

			if (capture_application_flag)
			{
				if (reset_data_flag)
				{
					od->GetApplicationData()->SetPosition(QPoint(-1, -1));
					od->GetApplicationData()->SetSize(QSize(-1, -1));
				}
				else
				{
					od->GetApplicationData()->SetPosition(pos());
					od->GetApplicationData()->SetSize(size());
				}
			}

			if (capture_help_flag)
			{
				if (reset_data_flag)
				{
					od->GetHelpData()->SetPosition(QPoint(-1, -1));
					od->GetHelpData()->SetSize(QSize(-1, -1));
				}
				else if (help_viewer)
				{
					od->GetHelpData()->SetPosition(help_viewer->pos());
					od->GetHelpData()->SetSize(help_viewer->size());
				}
			}

			ic->CaptureSizeAndPosition(interface_type, reset_data_flag);
			ic->SetOptionsModifiedFlag(true);
		}
	}

	SetupEventBlock();
}

void	CMainWindow::EditOptions()
{
	SetInterfaceType(::EditOptionsView);
}

void	CMainWindow::SetInterfaceType(int type)
{
	if (type == interface_type)
		return;

	if (interface_type == ::MultipleDocumentSingleView ||
		interface_type == ::MultipleDocumentMultipleView)
		DisconnectMainViewActivated();

	interface_restore_type = interface_type;

	switch (type)
	{
		case ::SingleDocumentSingleView:
		if (CheckSDSViewCount())
		{
			switch (interface_type)
			{
				case ::InterfaceTypeInitialize:
				break;

				case ::MultipleDocumentSingleView:
				DestroyMDSViews();
				break;

				case ::MultipleDocumentMultipleView:
				DestroyMDMViews();
				break;

				case ::EditOptionsView:
				DestroyEOViews();
				break;
			}

			CreateSDSViews();
		}
		else
			return;

		break;

		case ::MultipleDocumentSingleView:
		switch (interface_type)
		{
			case ::InterfaceTypeInitialize:
			break;

			case ::SingleDocumentSingleView:
			DestroySDSViews();
			break;

			case ::MultipleDocumentMultipleView:
			DestroyMDMViews();
			break;

			case ::EditOptionsView:
			DestroyEOViews();
			break;
		}

		CreateMDSViews();
		break;

		case ::MultipleDocumentMultipleView:
		switch (interface_type)
		{
			case ::InterfaceTypeInitialize:
			break;

			case ::SingleDocumentSingleView:
			DestroySDSViews();
			break;

			case ::MultipleDocumentSingleView:
			DestroyMDSViews();
			break;

			case ::EditOptionsView:
			DestroyEOViews();
			break;
		}

		CreateMDMViews();
		break;

		case ::EditOptionsView:
		switch (interface_type)
		{
			case ::InterfaceTypeInitialize:
			break;

			case ::SingleDocumentSingleView:
			DestroySDSViews();
			break;

			case ::MultipleDocumentSingleView:
			DestroyMDSViews();
			break;

			case ::MultipleDocumentMultipleView:
			DestroyMDMViews();
			break;
		}

		CreateEOViews();
		break;
	}

	// interface_type_menu->setItemChecked(interface_type, false);

	interface_type = InterfaceType(type);

	// interface_type_menu->setItemChecked(interface_type, true);
}

void	CMainWindow::RestoreViews()
{
	if (GetEventBlockFlag())
		return;

	if (interface_type == ::MultipleDocumentSingleView ||
		interface_type == ::MultipleDocumentMultipleView)
		DisconnectMainViewActivated();

	switch (interface_type)
	{
		case ::SingleDocumentSingleView:
		DestroySDSViews();
		CreateSDSViews();
		break;

		case ::MultipleDocumentSingleView:
		DestroyMDSViews();
		CreateMDSViews();
		break;

		case ::MultipleDocumentMultipleView:
		DestroyMDMViews();
		CreateMDMViews();
		break;

		case ::EditOptionsView:
		break;
	}

	SetupEventBlock();
}

void	CMainWindow::CreateSDSViews()
{
	widget_stack = new QStackedWidget(this);

	setCentralWidget(widget_stack);

	widget_stack->show();

	delete central_widget;

	if (interface_id_to_interface_map.size() == 1)
	{
		ModifyFileViewHelpMenu(
			SMainSubmenuNodeData::main_submenu_open_documents, this);

		CInterfaceControl	*current_interface =
				interface_id_to_interface_map[current_interface_id];

		current_interface->EnableInterfaceMenu();

		current_interface->CreateWidgetStackViews(widget_stack);

		const vector< pair<int, string> >	&v =
				current_interface->GetMainViewIdAndNameInfo();

		for (int i=0; i<v.size(); i++)
			main_view_id_to_interface_id_map[v[i].first] = current_interface_id;

		const pair<int, string>		&p = current_interface->GetTitleIdAndName();

		main_view_id_to_interface_id_map[p.first] = current_interface_id;

		current_main_view_id = current_interface->GetCurrentMainViewId();

		SetMainWindowOptions(current_interface->GetOptionData());

		UpdateCurrentFileMessage(
								current_interface->GetDataFileName(),
								current_interface->GetOptionFileName(),
								current_interface->GetDataModifiedFlag(),
								current_interface->GetOptionsModifiedFlag());

		current_interface->RaiseCurrentView();
	}
	else
		ModifyFileViewHelpMenu(
			SMainSubmenuNodeData::main_submenu_no_open_documents, this);
}

void	CMainWindow::CreateMDSViews()
{
	workspace = new QWorkspace(this);

	setCentralWidget(workspace);

	workspace->show();
	workspace->setScrollBarsEnabled(true);

	delete central_widget;

	for_each(	interface_id_to_interface_map.begin(),
				interface_id_to_interface_map.end(),
				create_widget_stack_views(	workspace,
											interface_id_to_widget_stack_map));

	for_each(	interface_id_to_interface_map.begin(),
				interface_id_to_interface_map.end(),
				create_main_view_id_to_interface_id_map(
											main_view_id_to_interface_id_map));

	if (interface_id_to_interface_map.size())
	{
		ModifyFileViewHelpMenu(
			SMainSubmenuNodeData::main_submenu_open_documents, this);

		CInterfaceControl	*current_interface =
				interface_id_to_interface_map[current_interface_id];

		current_interface->EnableInterfaceMenu();

		current_main_view_id =
				current_interface->GetCurrentMainViewId();

		SetMainWindowOptions(current_interface->GetOptionData());

		UpdateCurrentFileMessage(
								current_interface->GetDataFileName(),
								current_interface->GetOptionFileName(),
								current_interface->GetDataModifiedFlag(),
								current_interface->GetOptionsModifiedFlag());

		current_interface->RaiseCurrentView();
	}
	else
		ModifyFileViewHelpMenu(
			SMainSubmenuNodeData::main_submenu_no_open_documents, this);

	ConnectMainViewActivated();
}

void	CMainWindow::CreateMDMViews()
{
	workspace = new QWorkspace(this);

	setCentralWidget(workspace);

	workspace->show();
	workspace->setScrollBarsEnabled(true);

	delete central_widget;

	for_each(	interface_id_to_interface_map.begin(),
				interface_id_to_interface_map.end(),
				create_workspace_views(workspace));

	for_each(	interface_id_to_interface_map.begin(),
				interface_id_to_interface_map.end(),
				create_main_view_id_to_interface_id_map(
										main_view_id_to_interface_id_map));

	application->processEvents(QEventLoop::AllEvents, 1000);

	if (interface_id_to_interface_map.size())
	{
		ModifyFileViewHelpMenu(
			SMainSubmenuNodeData::main_submenu_open_documents, this);

		CInterfaceControl	*current_interface =
				interface_id_to_interface_map[current_interface_id];

		current_interface->EnableInterfaceMenu();

		current_main_view_id =
				current_interface->GetCurrentMainViewId();

		SetMainWindowOptions(current_interface->GetOptionData());

		UpdateCurrentFileMessage(
								current_interface->GetDataFileName(),
								current_interface->GetOptionFileName(),
								current_interface->GetDataModifiedFlag(),
								current_interface->GetOptionsModifiedFlag());

		current_interface->RaiseCurrentView();
	}
	else
		ModifyFileViewHelpMenu(
			SMainSubmenuNodeData::main_submenu_no_open_documents, this);

	ConnectMainViewActivated();
}

void	CMainWindow::CreateEOViews()
{
	ModifyFileViewHelpMenu(
		SMainSubmenuNodeData::main_submenu_edit_options, this);

	if (interface_id_to_interface_map.size())
	{
		CInterfaceControl	*current_interface =
				interface_id_to_interface_map[current_interface_id];

		current_interface->DisableInterfaceMenu();
	}

	widget_stack = new QStackedWidget(this);

	setCentralWidget(widget_stack);

	delete central_widget;

	option_edit_scrollview = new Q3ScrollView(widget_stack);

	widget_stack->addWidget(option_edit_scrollview);

	option_edit_scrollview->setResizePolicy(Q3ScrollView::AutoOneFit);
	option_edit_scrollview->show();

	option_edit_frame =
		new COptionEditFrame(	option_edit_scrollview->viewport(),
								this,
								COptionEditFrame::Sorted);

	option_edit_scrollview->addChild(option_edit_frame);

	COptionData		*d = 0;

	if (interface_id_to_interface_map.size())
	{
		CInterfaceControl	*current_interface =
				interface_id_to_interface_map[current_interface_id];

		d = current_interface->GetOptionData();
	}
	else
	{
		d = application->GetInterfaceConfigurations()[0].GetDefaultOptions();
	}

	SetOptionEditViewOptions(d);

	option_edit_frame->show();
	option_edit_frame->UpdateOptionEditFrameGeometry();

	widget_stack->show();
	widget_stack->setCurrentIndex(0);

	string		*tab_widget_height =
					d->GetAuxiliaryString("Option_Edit_Tab_Widget_Height");

	if (tab_widget_height)
		option_edit_frame->CreateInitialViewTree(
								atoi(tab_widget_height->c_str()));
	else
		option_edit_frame->CreateInitialViewTree();
}

void	CMainWindow::DestroySDSViews()
{
	for_each(	interface_id_to_interface_map.begin(),
				interface_id_to_interface_map.end(),
				destroy_interface_views());

	main_view_id_to_interface_id_map.clear();

	central_widget = new QWidget(this);

	setCentralWidget(central_widget);

	delete widget_stack;
}

void	CMainWindow::DestroyMDSViews()
{
	for_each(	interface_id_to_interface_map.begin(),
				interface_id_to_interface_map.end(),
				destroy_interface_views());

	main_view_id_to_interface_id_map.clear();

	for_each(	interface_id_to_widget_stack_map.begin(),
				interface_id_to_widget_stack_map.end(),
				destroy_map_T<int, CViewWidgetStack *>());

	interface_id_to_widget_stack_map.clear();

	central_widget = new QWidget(this);

	setCentralWidget(central_widget);

	delete workspace;
}

void	CMainWindow::DestroyMDMViews()
{
	for_each(	interface_id_to_interface_map.begin(),
				interface_id_to_interface_map.end(),
				destroy_interface_views());

	main_view_id_to_interface_id_map.clear();

	central_widget = new QWidget(this);

	setCentralWidget(central_widget);

	delete workspace;
}

void	CMainWindow::DestroyEOViews()
{
	option_edit_scrollview->removeChild(option_edit_frame);

	delete option_edit_frame;

	widget_stack->removeWidget(option_edit_scrollview);

	delete option_edit_scrollview;

	central_widget = new QWidget(this);

	setCentralWidget(central_widget);

	delete widget_stack;
}

bool	CMainWindow::CheckSDSViewCount()
{
	if (interface_id_to_interface_map.size() > 1)
	{
		CInformationDialog	*ifd = OptionDialog::information_dialog;

		ifd->SetTitleAndMessageText("Set Interface Type",
			"Only one file can be open before change\n"
			"to single document single view mode.");

		ifd->ExecuteDialog();

		return false;
	}
	else
		return true;
}

void	CMainWindow::CascadeViews()
{
	if (interface_type == ::SingleDocumentSingleView)
		return;

	if (GetEventBlockFlag())
		return;

	vector<QWidget *>	child_widgets;

	int		child_count		= GetVisibleChildWidgets(child_widgets); if (!child_count) return;

	int		x_size	= workspace->width() - 30 * (child_count - 1);
	int		y_size	= workspace->height() - 30 * (child_count - 1);
	int		x_offset	= 0;
	int		y_offset	= 0;

	for (int i=0; i<child_count; ++i)
	{
		QWidget	*c = child_widgets[i];

		c->move(x_offset, y_offset);
		c->resize(x_size, y_size);

		x_offset += 30;
		y_offset += 30;
	}

	SetupEventBlock();
}

int		CMainWindow::GetVisibleChildWidgets(vector<QWidget *> &child_widgets)
{
	if (current_interface_id == -1)
		return 0;

	CInterfaceControl	*current_interface =
		interface_id_to_interface_map[current_interface_id];

	const map<int, SMainViewControl *> 
		&cm = current_interface->GetMainViewIdToControlMap();

	map<int, SMainViewControl *>::const_iterator
		m_iterator = cm.begin();

	while (m_iterator != cm.end())
	{
		int					main_view_id	= (*m_iterator).first;
		SMainViewControl	*mvc			= (*m_iterator).second;

		if (mvc->GetMainViewVisibleFlag())
		{
			QWidget		*rvw	= mvc->GetRootViewWidget();
			QWidget		*p		= rvw->parentWidget();

			child_widgets.push_back(p);
		}

		++m_iterator;
	}

	return child_widgets.size();
}

int		CMainWindow::CalculateTileCounts(int count, vector<int> &sections)
{
	int		n1;
	int		n2;
	int		square1;
	int		square2;
	int		section_count1;
	int		section_count2;

	if (!count)
		return 0;

	for (n2=1; n2<=count; ++n2)
		if (count <= (square2 = n2 * n2))
			break;

	if (count == square2)
	{
		for (int i=0; i<n2; ++i)
			sections.push_back(n2);
	}
	else
	{
		n1 = n2 - 1;

		square1 = n1 * n1;

		int		m = square1 + n1;

		if (count <= m)
		{
			section_count2 = m - count;
			section_count1 = n1 - section_count2;
		}
		else
		{
			section_count2 = square2 - count;
			section_count1 = n2 - section_count2;
		}

		for (int i=0; i<section_count1; ++i)
			sections.push_back(n2);

		for (int i=0; i<section_count2; ++i)
			sections.push_back(n1);
	}

	return sections.size();
}

int		CMainWindow::CalculateTileParameters(int x, int y, vector<int> &sections, vector<TileData> &tiles)
{
	int		y_offset			= 0;
	int		section_size		= y / sections.size();
	int		section_remainder	= y % sections.size();

	section_size += section_remainder;

	for (vector<int>::size_type i=0; i<sections.size(); ++i)
	{
		int		x_offset		= 0;
		int		tile_size		= x / sections[i];
		int		tile_remainder	= x % sections[i];

		tile_size += tile_remainder;

		for (int j=0; j<sections[i]; ++j)
		{
			tiles.push_back(TileData(x_offset, y_offset, tile_size, section_size));

			x_offset += tile_size;

			if (!j)
				tile_size -= tile_remainder;
		}

		y_offset += section_size;

		if (!i)
			section_size -= section_remainder;
	}

	return tiles.size();
}

void	CMainWindow::TileViews1()
{
	if (interface_type == ::SingleDocumentSingleView)
		return;

	if (GetEventBlockFlag())
		return;

	vector<QWidget *>	child_widgets;
	vector<int>			sections;
	vector<TileData>	tiles;

	int		child_count		= GetVisibleChildWidgets(child_widgets); if (!child_count) return;
	int		section_count	= CalculateTileCounts(child_count, sections);
	int		tile_count		= CalculateTileParameters(workspace->width(), workspace->height(), sections, tiles);

	for (int i=0; i<child_count; ++i)
	{
		QWidget	*c = child_widgets[i];

		c->move(tiles[i].x_offset, tiles[i].y_offset);
		c->resize(tiles[i].x_size, tiles[i].y_size);
	}

	SetupEventBlock();
}

void	CMainWindow::TileViews2()
{
	if (interface_type == ::SingleDocumentSingleView)
		return;

	if (GetEventBlockFlag())
		return;

	vector<QWidget *>	child_widgets;
	vector<int>			sections;
	vector<TileData>	tiles;

	int		child_count		= GetVisibleChildWidgets(child_widgets); if (!child_count) return;
	int		section_count	= CalculateTileCounts(child_count, sections);
	int		tile_count		= CalculateTileParameters(workspace->height(), workspace->width(), sections, tiles);

	for (int i=0; i<child_count; ++i)
	{
		QWidget	*c = child_widgets[i];

		c->move(tiles[i].y_offset, tiles[i].x_offset);
		c->resize(tiles[i].y_size, tiles[i].x_size);
	}

	SetupEventBlock();
}

void	CMainWindow::TileViews3()
{
	if (interface_type == ::SingleDocumentSingleView)
		return;

	if (GetEventBlockFlag())
		return;

	vector<QWidget *>	child_widgets;
	vector<int>			sections;
	vector<TileData>	tiles;

	int		child_count		= GetVisibleChildWidgets(child_widgets); if (!child_count) return;
	int		section_count	= CalculateTileCounts(child_count, sections);

	reverse(sections.begin(), sections.end());

	int		tile_count		= CalculateTileParameters(workspace->width(), workspace->height(), sections, tiles);

	for (int i=0; i<child_count; ++i)
	{
		QWidget	*c = child_widgets[i];

		c->move(tiles[i].x_offset, tiles[i].y_offset);
		c->resize(tiles[i].x_size, tiles[i].y_size);
	}

	SetupEventBlock();
}

void	CMainWindow::TileViews4()
{
	if (interface_type == ::SingleDocumentSingleView)
		return;

	if (GetEventBlockFlag())
		return;

	vector<QWidget *>	child_widgets;
	vector<int>			sections;
	vector<TileData>	tiles;

	int		child_count		= GetVisibleChildWidgets(child_widgets); if (!child_count) return;
	int		section_count	= CalculateTileCounts(child_count, sections);

	reverse(sections.begin(), sections.end());

	int		tile_count		= CalculateTileParameters(workspace->height(), workspace->width(), sections, tiles);

	for (int i=0; i<child_count; ++i)
	{
		QWidget	*c = child_widgets[i];

		c->move(tiles[i].y_offset, tiles[i].x_offset);
		c->resize(tiles[i].y_size, tiles[i].x_size);
	}

	SetupEventBlock();
}

void	CMainWindow::RaiseMainView(int id)
{
	if (interface_type == ::MultipleDocumentSingleView ||
		interface_type == ::MultipleDocumentMultipleView)
		DisconnectMainViewActivated();

		ProcessRaiseMainView(id);

	if (interface_type == ::MultipleDocumentSingleView ||
		interface_type == ::MultipleDocumentMultipleView)
		ConnectMainViewActivated();
}

void	CMainWindow::ProcessRaiseMainView(int id)
{
	map<int, int>::iterator		m_iterator =
									main_view_id_to_interface_id_map.find(id);

	if (m_iterator != main_view_id_to_interface_id_map.end())
	{
		current_main_view_id = (*m_iterator).first;
		current_interface_id = (*m_iterator).second;

		CInterfaceControl	*ic =
			interface_id_to_interface_map[current_interface_id];

		ic->EnableInterfaceMenu();

		SetMainWindowOptions(ic->GetOptionData());

		UpdateCurrentFileMessage(
								ic->GetDataFileName(),
								ic->GetOptionFileName(),
								ic->GetDataModifiedFlag(),
								ic->GetOptionsModifiedFlag());

		ic->RaiseMainView(id);
	}
}

void	CMainWindow::ConnectMainViewActivated()
{
	QObject::connect(	workspace,
						SIGNAL(windowActivated(QWidget *)),
						this,
						SLOT(MainViewActivated(QWidget *)));
}

void	CMainWindow::DisconnectMainViewActivated()
{
	QObject::disconnect(workspace,
						SIGNAL(windowActivated(QWidget *)),
						this,
						SLOT(MainViewActivated(QWidget *)));
}

void    CMainWindow::MainViewActivated(QWidget *w)
{
	if (!w)
		return;

	CInterfaceControl	*interface_control = 0;
	int					new_interface_id;
	int					new_main_view_id;

	switch (interface_type)
	{
		case ::MultipleDocumentSingleView:
		{
			CViewWidgetStack    *ws = dynamic_cast<CViewWidgetStack *>(w);

			if (ws)
			{
				interface_control = ws->GetInterfaceControl();

				new_main_view_id = interface_control->GetCurrentMainViewId();

			}
		}
		break;

		case ::MultipleDocumentMultipleView:
		{
			CSplitterWidget	*sw = dynamic_cast<CSplitterWidget *>(w);

			if (sw)
			{
				interface_control = sw->GetInterfaceControl();

				new_main_view_id =
					sw->GetMainViewControl()->GetMainViewId();

				break;
			}

			CFrameWidget	*sv = dynamic_cast<CFrameWidget *>(w);

			if (sv)
			{
				interface_control = sv->GetInterfaceControl();

				new_main_view_id =
					sv->GetMainViewControl()->GetMainViewId();

				break;
			}
		}
		break;
	}

	if (interface_control)
	{
		current_main_view_id = new_main_view_id;

		new_interface_id = interface_control->GetInterfaceId();

		if (current_interface_id != new_interface_id)
		{
			current_interface_id = new_interface_id;

			interface_control->EnableInterfaceMenu();

			SetMainWindowOptions(interface_control->GetOptionData());

			UpdateCurrentFileMessage(
								interface_control->GetDataFileName(),
								interface_control->GetOptionFileName(),
								interface_control->GetDataModifiedFlag(),
								interface_control->GetOptionsModifiedFlag());
		}
	}
}

void	CMainWindow::HelpContents()
{
	COptionData		*option_data;

	if (!interface_id_to_interface_map.size())
	{
		option_data =
			application->GetInterfaceConfigurations()[0].GetDefaultOptions();
	}
	else
	{
		CInterfaceControl	*current_interface =
			interface_id_to_interface_map[current_interface_id];

		option_data = current_interface->GetOptionData();
	}

	if (!help_viewer)
		help_viewer = new CHelpViewer(0);

	map<string, string>		*auxiliary_strings =
									option_data->GetAuxiliaryStrings();

	map<string, string>::iterator	s_iterator;

	if (auxiliary_strings &&
		(s_iterator =
			auxiliary_strings->find(string("HTML_Source"))) !=
				auxiliary_strings->end())
	{
		help_viewer->SetHTMLSource((*s_iterator).second.c_str());
	}
	else
		help_viewer->SetHTMLSource("cpg.html");

	SetHelpViewerOptions(option_data);

	help_viewer->show();
}

void	CMainWindow::AboutCPG()
{
	if (GetEventBlockFlag())
		return;

	CInformationDialog	*ifd = OptionDialog::information_dialog;

	ifd->SetTitleAndMessageText("About CPG",
		"Compiler - a Parser Generator Program, Version 2.0\n"
		"Copyright (c) 2000, 2003 C. Fayle  All Rights Reserved.\n"
		"\n"
		"This software is distributed under the terms of the\n"
		"GNU General Public License as specified in the file\n"
		"gpl.txt included with the distribution.\n");

	ifd->SetTextAlignment(Qt::AlignLeft);
	ifd->ExecuteDialog();

	SetupEventBlock();
}

ostream		&operator<<(ostream &s, const CMainWindow &mw)
{
	s	<< "CMainWindow" << endl;
	s	<< "current_main_view_id = " << mw.GetCurrentMainViewId() << endl;
	s	<< "current_interface_id = " << mw.GetCurrentInterfaceId() << endl;
	s	<< "CIdGenerator    interface_id_generator" << endl;
	s	<< mw.GetInterfaceIdGenerator() << endl;
	s	<< "CMainViewMenu   *main_view_menu_manager" << endl;
	s	<< *mw.GetMainViewMenuManager();

	s	<< "map<int, int>  main_view_id_to_interface_id_map" << endl;

	const map<int, int>
		&mvitiim = mw.GetMainViewIdToInterfaceIdMap();

	map<int, int>::const_iterator
		mvitiim_iterator = mvitiim.begin();

	while (mvitiim_iterator != mvitiim.end())
	{
		s	<< "main_view_id = " << setw(2) << "  "
			<< (*mvitiim_iterator).first
			<< "interface_id = " << setw(2) << "  "
			<< (*mvitiim_iterator).second
			<< endl;

		mvitiim_iterator++;
	}

	s	<< "map<int, CInterfaceControl *>  interface_id_to_interface_map"
		<< endl;

	const map<int, CInterfaceControl *>
		&iitim = mw.GetInterfaceIdToInterfaceMap();

	map<int, CInterfaceControl *>::const_iterator
		iitim_iterator = iitim.begin();

	while (iitim_iterator != iitim.end())
	{
		s	<< "interface_id = " << (*iitim_iterator).first << endl;
		s	<< *(*iitim_iterator).second;

		iitim_iterator++;
	}

	s	<< "map<int, CViewWidgetStack *>  interface_id_to_widget_stack_map"
		<< endl;

	const map<int, CViewWidgetStack *>
		&iitwsm = mw.GetInterfaceIdToWidgetStackMap();

	map<int, CViewWidgetStack *>::const_iterator
		iitwsm_iterator = iitwsm.begin();

	while (iitwsm_iterator != iitwsm.end())
	{
		s	<< "interface_id = " << (*iitwsm_iterator).first << endl;
		s	<< "widget_stack = " << (void *)(*iitwsm_iterator).second << endl;

		iitwsm_iterator++;
	}

	s << endl;

	return s;
}

void	CMainWindow::ApplicationDebug()
{
	ofstream	debug_file("mw_debug.txt", ios::app);

	time_t		t = time(0);

	debug_file << ctime(&t) << endl;
	debug_file << *this;

	debug_file.close();
}
