/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "compilerCalculate.h"

const char * const	CCompilerCalculate::lexical_base_code_h[] =
{
	"#ifndef LEXICALDRIVER_H",
	"#define LEXICALDRIVER_H",
	"",
	"using namespace std;",
	"",
	"#include <sys/types.h>",
	"#include <sys/stat.h>",
	"#include <fcntl.h>",
	"#include <unistd.h>",
	"#include <stdio.h>",
	"#include <iostream>",
	"#include <fstream>",
	"#include <strstream>",
	"#include <string>",
	"#include <map>",
	"",
	"#include \"tvaluelist.h\"",
	"#include \"stackElement.h\"",
	"",
	"class CLexicalDriver",
	"{",
	"\tpublic:",
	"\tenum LexicalScanType",
	"\t{",
	"\t\tSingleCharLexical,",
	"\t\tRegexpLexical,",
	"\t\tNullLexical",
	"\t};",
	"",
	"\tenum InputError",
	"\t{",
	"\t\tNoError\t\t= 0,",
	"\t\tOpenError\t= 1,",
	"\t\tCloseError\t= 2,",
	"\t\tReadError\t= 4",
	"\t};",
	"",
	"\tCLexicalDriver(int est = 0);",
	"\tvirtual ~CLexicalDriver();",
	"",
	"\tInputError\tSetInputBuffer(const unsigned char *i_buffer, int i_size);",
	"\tInputError\tSetInputString(const string &i_string);",
	"\tInputError\tSetInputIoStream(\t\tistream *i_stream,",
	"\t\t\t\t\t\t\t\t\t\tint b_size = default_block_size);",
	"\tInputError\tSetInputFileIoStream(\tconst string &f_name,",
	"\t\t\t\t\t\t\t\t\t\tint b_size = default_block_size);",
	"\tInputError\tSetInputStdStream(\t\tFILE *f,",
	"\t\t\t\t\t\t\t\t\t\tint b_size = default_block_size);",
	"\tInputError\tSetInputFileStdStream(\tconst string &f_name,",
	"\t\t\t\t\t\t\t\t\t\tint b_size = default_block_size);",
	"\tInputError\tSetInputDescriptor(\t\tint i_d,",
	"\t\t\t\t\t\t\t\t\t\tint b_size = default_block_size);",
	"\tInputError\tSetInputFileDescriptor(\tconst string &f_name,",
	"\t\t\t\t\t\t\t\t\t\tint b_size = default_block_size);",
	"",
	"\tint\t\tGetInputNull() { return 0; }",
	"\tint\t\tGetInputData() { return (this->*input_function)(); }",
	"\tint\t\tGetInputIoStreamData();",
	"\tint\t\tGetInputStdStreamData();",
	"\tint\t\tGetInputDescriptorData();",
	"\tint\t\t(CLexicalDriver::* input_function)();",
	"",
	"\tInputError\tCloseNull() { return NoError; }",
	"\tInputError\tCloseInput();",
	"\tInputError\tCloseIoStream();",
	"\tInputError\tCloseFileIoStream();",
	"\tInputError\tCloseStdStream();",
	"\tInputError\tCloseFileStdStream();",
	"\tInputError\tCloseDescriptor();",
	"\tInputError\tCloseFileDescriptor();",
	"\tInputError\t(CLexicalDriver::* close_function)();",
	"",
	"\tprivate:",
	"\tvoid\t\t\t\tAllocateBuffer(int b_size);",
	"\tstatic const int\tdefault_block_size;",
	"\tistream\t\t\t\t*input_ios;",
	"\tFILE\t\t\t\t*input_std;",
	"\tint\t\t\t\t\tinput_fd;",
	"",
	"\tpublic:",
	"\tvirtual void\tInitialize(int t_size = 100, bool ptf = true) = 0;",
	"\tvirtual int\t\tGetFilterOrToken() = 0;",
	"\tvirtual int\t\tGetFilterOrToken(\tunsigned char *&terminal_ptr,",
	"\t\t\t\t\t\t\t\t\t\tint &terminal_size) = 0;",
	"\tvirtual int\t\tGetToken() = 0;",
	"\tvirtual int\t\tGetToken(unsigned char *&token_ptr, int &token_size) = 0;",
	"\tvirtual void\tLoadStackElement(CStackElement *se) = 0;",
	"",
	"\tvirtual unsigned char\t*GetTerminalString() = 0;",
	"\tvirtual int\t\t\t\tGetTerminalLength() = 0;",
	"\tvirtual int\t\t\t\tGetCurrentTerminalMatchIndex() = 0;",
	"\tvirtual int\t\t\t\tGetCurrentTerminalStateIndex() = 0;",
	"",
	"\tvoid\tPushCurrentTokenBack()",
	"\t{ push_token_back_flag = true; }",
	"\tvoid\tHaltProcessTerminal()",
	"\t{ process_terminal_flag = false; HaltProcessFilter(); }",
	"\tvoid\tBreakOnProcessFilter()",
	"\t{ process_filter_break_flag = true; }",
	"\tvoid\tSetCurrentToken(int t)",
	"\t{ current_token = t; }",
	"\tstring\t&GetFileName()",
	"\t{ return file_name; }",
	"\tvoid\tSetParentLexical(CLexicalDriver *l)",
	"\t{ parent_lexical = l; }",
	"\tCLexicalDriver\t*GetParentLexical()",
	"\t{ return parent_lexical; }",
	"\tstring\tGetSourceFileLocationString(bool one_based = true);",
	"\tstring\tGetIdentifierLocationString(const string &id, bool one_based = true);",
	"",
	"\tstruct SSourceLocation",
	"\t{",
	"\t\tSSourceLocation(int h, int l, int c)",
	"\t\t: char_number(h), line_number(l), column_number(c) { }",
	"\t\tSSourceLocation() : char_number(), line_number(), column_number() { }",
	"",
	"\t\tint\t\tchar_number;",
	"\t\tint\t\tline_number;",
	"\t\tint\t\tcolumn_number;",
	"\t};",
	"",
	"\tvoid\tSetIdentifierLocation(const string &id, const SSourceLocation &l)",
	"\t{ identifier_location_map[id] = l; }",
	"\tvoid\tSetIdentifierLocation(const string &id)",
	"\t{ SetIdentifierLocation(id, SSourceLocation(",
	"\t\tGetCurrentCharNumber(), GetCurrentLineNumber(), GetCurrentColumnNumber())); }",
	"\tSSourceLocation\t\t&GetIdentifierLocation(const string &id)",
	"\t{ return identifier_location_map[id]; }",
	"",
	"\tvirtual int\t\tGetCurrentCharNumber()",
	"\t{ return current_char_number; }",
	"\tvirtual int\t\tGetCurrentLineNumber()",
	"\t{ return current_line_number; }",
	"\tvirtual int\t\tGetCurrentColumnNumber()",
	"\t{ return current_column_number; }",
	"\tvirtual string\t&GetLexicalStatusString(string &s, bool one_based = true);",
	"",
	"\tint\t\tempty_symbol_token;",
	"\tint\t\tlexical_error_code;",
	"\tint\t\tfilter_terminal;",
	"",
	"\tvoid\tSetImplicitEndToken(const string &s)",
	"\t{ implicit_end_token_flag = true; implicit_end_token_string = s; }",
	"",
	"\tprotected:",
	"\tvirtual void\tGetTerminal() = 0;",
	"\tvirtual void\tProcessFilter() = 0;",
	"\tvirtual void\tHaltProcessFilter() = 0;",
	"\tunsigned char\t*input_buffer;",
	"\tint\t\t\t\tinput_buffer_size;",
	"\tint\t\t\t\tinput_buffer_offset;",
	"\tint\t\t\t\tcharacters_remaining;",
	"\tunsigned char\tcurrent_char;",
	"\tunsigned char\tprevious_char;",
	"\tint\t\t\t\ttoken_count;",
	"\tint\t\t\t\tfilter_count;",
	"\tint\t\t\t\tterminal_count;",
	"\tint\t\t\t\tcurrent_token;",
	"\tint\t\t\t\tcurrent_filter;",
	"\tbool\t\t\tpush_token_back_flag;",
	"\tbool\t\t\tprocess_terminal_flag;",
	"\tbool\t\t\tprocess_filter_break_flag;",
	"\tbool\t\t\timplicit_end_token_flag;",
	"\tstring\t\t\timplicit_end_token_string;",
	"\tmap<string, SSourceLocation>\tidentifier_location_map;",
	"\tstring\t\t\tfile_name;",
	"\tCLexicalDriver\t*parent_lexical;",
	"\tint\t\t\t\tcurrent_char_number;",
	"\tint\t\t\t\tcurrent_line_number;",
	"\tint\t\t\t\tcurrent_column_number;",
	"};",
	"",
	"class CLexicalSingleCharDriver : public CLexicalDriver",
	"{",
	"\tpublic:",
	"\tCLexicalSingleCharDriver(\tconst char * const lex_char_token_names[],",
	"\t\t\t\t\t\t\t\tint est = 0);",
	"\t~CLexicalSingleCharDriver();",
	"",
	"\tvirtual void\tInitialize(int t_size = 100, bool ptf = true);",
	"\tvirtual int\t\tGetFilterOrToken();",
	"\tvirtual int\t\tGetFilterOrToken(\tunsigned char *&terminal_ptr,",
	"\t\t\t\t\t\t\t\t\t\tint &terminal_size);",
	"\tvirtual int\t\tGetToken();",
	"\tvirtual int\t\tGetToken(unsigned char *&token_ptr, int &token_size);",
	"\tvirtual void\tLoadStackElement(CStackElement *se);",
	"",
	"\tvirtual unsigned char\t*GetTerminalString()",
	"\t{ return single_char_array_buffer; }",
	"\tvirtual int\t\t\t\tGetTerminalLength()",
	"\t{ return single_char_array_size; }",
	"\tvirtual int\t\t\t\tGetCurrentTerminalMatchIndex()",
	"\t{ return current_token; }",
	"\tvirtual int\t\t\t\tGetCurrentTerminalStateIndex()",
	"\t{ return single_char_array_buffer[0]; }",
	"",
	"\tprotected:",
	"\tvirtual void\tProcessFilter() { }",
	"\tvirtual void\tHaltProcessFilter() { }",
	"",
	"\tprivate:",
	"\tvirtual void\tGetTerminal();",
	"\tconst int\t\tmap_size;",
	"\tint\t\t\t\t*character_map;",
	"\tunsigned char\tsingle_char_array_buffer[2];",
	"\tint\t\t\t\tsingle_char_array_size;",
	"};",
	"",
	"class CLexicalRegexpDriver : public CLexicalDriver",
	"{",
	"\tpublic:",
	"\tCLexicalRegexpDriver(\tint\ttkc, int ftc, int tmc,",
	"\t\t\t\t\t\t\tint est, int ir, int fsmc,",
	"\t\t\t\t\t\t\tconst int *f_table,",
	"\t\t\t\t\t\t\tconst int *rm_table,",
	"\t\t\t\t\t\t\tconst int *pm_table,",
	"\t\t\t\t\t\t\tconst int *tm_table,",
	"\t\t\t\t\t\t\tconst int *sa_table,",
	"\t\t\t\t\t\t\tconst int *tc_table,",
	"\t\t\t\t\t\t\tconst int *t_map_table,",
	"\t\t\t\t\t\t\tconst int *f_map_table,",
	"\t\t\t\t\t\t\tconst int *lt_table,",
	"\t\t\t\t\t\t\tint sctm);",
	"\t~CLexicalRegexpDriver();",
	"",
	"\tvirtual void\tSetupFunctionTables() { }",
	"",
	"\tvirtual void\tInitialize(int t_size = 100, bool ptf = true);",
	"\tvirtual int\t\tGetFilterOrToken();",
	"\tvirtual int\t\tGetFilterOrToken(unsigned char *&terminal_ptr,",
	"\t\t\t\t\t\t\t\t\t\tint &terminal_size);",
	"\tvirtual int\t\tGetToken();",
	"\tvirtual int\t\tGetToken(unsigned char *&token_ptr, int &token_size);",
	"\tvirtual void\tLoadStackElement(CStackElement *se);",
	"",
	"\tvirtual unsigned char\t*GetTerminalString()",
	"\t{ return terminal_char_array_buffer; }",
	"\tvirtual int\t\t\t\tGetTerminalLength()",
	"\t{ return terminal_char_array_size; }",
	"\tvirtual int\t\t\t\tGetCurrentTerminalMatchIndex()",
	"\t{ return terminal_match_index; }",
	"\tvirtual int\t\t\t\tGetCurrentTerminalStateIndex()",
	"\t{ return terminal_state_index; }",
	"",
	"\tint\tGetTokenMatchIndex(int token)\t{ return inverse_token_map[token]; }",
	"\tint\tGetFilterMatchIndex(int filter)\t{ return inverse_filter_map[filter]; }",
	"",
	"\tint\t\tGetLiteralTerminalFlag(int t) { return literal_terminal[t]; }",
	"\tint\t\tGetCurrentLiteralTerminalFlag()",
	"\t{ return literal_terminal[terminal_match_index]; }",
	"",
	"\tvirtual int\t\tGetCurrentCharNumber();",
	"\tvirtual int\t\tGetCurrentLineNumber();",
	"\tvirtual int\t\tGetCurrentColumnNumber();",
	"",
	"\tprotected:",
	"\tvirtual void\tProcessFilter() { }",
	"\tvirtual void\tHaltProcessFilter() { }",
	"",
	"\tvoid\tSetStartCondition(int sc)",
	"\t{ current_start_condition = sc; }",
	"",
	"\tprivate:",
	"\tint\t\t\tinput_range;",
	"\tint\t\t\tfsm_count;",
	"\tconst int\t*fsm_table;",
	"\tconst int\t*regexp_match;",
	"\tconst int\t*prefix_match;",
	"\tconst int\t*token_match;",
	"\tconst int\t*start_assignment;",
	"\tconst int\t*trailing_context;",
	"\tconst int\t*token_map;",
	"\tconst int\t*filter_map;",
	"\tconst int\t*literal_terminal;",
	"\tint\t\t\tsingle_column_token_match;",
	"",
	"\tint\t\t*inverse_token_map;",
	"\tint\t\t*inverse_filter_map;",
	"\tvoid\tSetupInverseTokenMap();",
	"\tvoid\tSetupInverseFilterMap();",
	"",
	"\tstruct STerminalChar",
	"\t{",
	"\t\tSTerminalChar() { }",
	"\t\tSTerminalChar(unsigned char tc, int cn, int line, int column)",
	"\t\t\t: terminal_char(tc), char_number(cn),",
	"\t\t\t\tline_number(line), column_number(column) { }",
	"\t\tunsigned char\tterminal_char;",
	"\t\tint\t\t\t\tchar_number;",
	"\t\tint\t\t\t\tline_number;",
	"\t\tint\t\t\t\tcolumn_number;",
	"\t\tint\t\t\t\tstate_register;",
	"\t\tint\t\t\t\tmatch_register;",
	"\t};",
	"",
	"\tvirtual void\t\t\t\t\t\tGetTerminal();",
	"\tvoid\t\t\t\t\t\t\t\tGetTerminalCharList();",
	"\tTValueList<STerminalChar>\t\t\tterminal_char_list;",
	"\tTValueList<STerminalChar>::listptr\tterminal_char_listptr;",
	"\tunsigned char\t\t\t\t\t\t*terminal_char_array_buffer;",
	"\tint\t\t\t\t\t\t\t\t\tterminal_char_array_maximum;",
	"\tint\t\t\t\t\t\t\t\t\tterminal_char_array_size;",
	"\tint\t\t\t\t\t\t\t\t\tcurrent_start_condition;",
	"\tint\t\t\t\t\t\t\t\t\tterminal_match_index;",
	"\tint\t\t\t\t\t\t\t\t\tterminal_state_index;",
	"};",
	"",
	"#endif",
	0
};

const char * const	CCompilerCalculate::lexical_base_code_cpp[] =
{
	"#include \"lexicalDriver.h\"",
	"",
	"const int\tCLexicalDriver::default_block_size = 4096;",
	"",
	"CLexicalDriver::CLexicalDriver(int est)",
	"\t:\tempty_symbol_token(est),",
	"\t\tlexical_error_code(-1),",
	"\t\tfilter_terminal(-2)",
	"{",
	"\tinput_function\t= &CLexicalDriver::GetInputNull;",
	"\tclose_function\t= &CLexicalDriver::CloseNull;",
	"}",
	"",
	"CLexicalDriver::~CLexicalDriver()",
	"{",
	"\tCloseInput();",
	"}",
	"",
	"string\tCLexicalDriver::GetSourceFileLocationString(bool one_based)",
	"{",
	"\tstring\t\t\ts;",
	"\tCLexicalDriver\t*l = this;",
	"",
	"\twhile (l)",
	"\t{",
	"\t\tostrstream\tos;",
	"",
	"\t\tos << \"file \";",
	"\t\tos << l->GetFileName();",
	"\t\tos << \", line \";",
	"\t\tos << (l->GetCurrentLineNumber() + (one_based ? 1 : 0));",
	"\t\tos << \": \";",
	"\t\tos << s;",
	"\t\tos << '\\0';",
	"",
	"\t\ts = os.str();",
	"\t\tl = l->GetParentLexical();",
	"\t}",
	"",
	"\treturn s;",
	"}",
	"",
	"string\tCLexicalDriver::GetIdentifierLocationString(const string &id, bool one_based)",
	"{",
	"\tstring\t\t\ts;",
	"\tCLexicalDriver\t*l = this;",
	"",
	"\tostrstream\tos1;",
	"",
	"\tos1 << \"file \";",
	"\tos1 << l->GetFileName();",
	"\tos1 << \", line \";",
	"\tos1 << (l->GetIdentifierLocation(id).line_number + (one_based ? 1 : 0));",
	"\tos1 << \": \";",
	"\tos1 << '\\0';",
	"",
	"\ts = os1.str();",
	"\tl = l->GetParentLexical();",
	"",
	"\twhile (l)",
	"\t{",
	"\t\tostrstream\tos2;",
	"",
	"\t\tos2 << \"file \";",
	"\t\tos2 << l->GetFileName();",
	"\t\tos2 << \", line \";",
	"\t\tos2 << (l->GetCurrentLineNumber() + (one_based ? 1 : 0));",
	"\t\tos2 << \": \";",
	"\t\tos2 << s;",
	"\t\tos2 << '\\0';",
	"",
	"\t\ts = os2.str();",
	"\t\tl = l->GetParentLexical();",
	"\t}",
	"",
	"\treturn s;",
	"}",
	"",
	"CLexicalDriver::InputError",
	"\tCLexicalDriver::SetInputBuffer(const unsigned char *i_buffer, int i_size)",
	"{",
	"\tint\t\tr = CloseInput();",
	"",
	"\tinput_function\t= &CLexicalDriver::GetInputNull;",
	"\tclose_function\t= &CLexicalDriver::CloseNull;",
	"",
	"\tinput_buffer\t\t\t= const_cast<unsigned char *>(i_buffer);",
	"\tinput_buffer_size\t\t= i_size;",
	"\tinput_buffer_offset\t\t= 0;",
	"\tcharacters_remaining\t= i_size;",
	"",
	"\treturn InputError(r);",
	"}",
	"",
	"CLexicalDriver::InputError",
	"\tCLexicalDriver::SetInputString(const string &i_string)",
	"{",
	"\treturn SetInputBuffer(",
	"\t\t\t\t\treinterpret_cast<const unsigned char *>(i_string.data()),",
	"\t\t\t\t\ti_string.length());",
	"}",
	"",
	"void\tCLexicalDriver::AllocateBuffer(int b_size)",
	"{",
	"\tinput_buffer\t\t\t= new unsigned char[b_size];",
	"\tinput_buffer_size\t\t= b_size;",
	"\tcharacters_remaining\t= 0;",
	"}",
	"",
	"CLexicalDriver::InputError",
	"\tCLexicalDriver::SetInputIoStream(istream *i_stream, int b_size)",
	"{",
	"\tint\t\tr = CloseInput();",
	"",
	"\tinput_ios = i_stream;",
	"",
	"\tinput_function\t= &CLexicalDriver::GetInputIoStreamData;",
	"\tclose_function\t= &CLexicalDriver::CloseIoStream;",
	"",
	"\tAllocateBuffer(b_size);",
	"",
	"\treturn InputError(r);",
	"}",
	"",
	"CLexicalDriver::InputError",
	"\tCLexicalDriver::SetInputFileIoStream(const string &f_name, int b_size)",
	"{",
	"\tint\t\tr = CloseInput();",
	"",
	"\tinput_ios = new ifstream(f_name.c_str(), ios::in | ios::binary);",
	"",
	"\tif (input_ios->fail())",
	"\t{",
	"\t\tdelete input_ios;",
	"\t\treturn InputError(r | OpenError);",
	"\t}",
	"",
	"\tfile_name = f_name;",
	"",
	"\tinput_function\t= &CLexicalDriver::GetInputIoStreamData;",
	"\tclose_function\t= &CLexicalDriver::CloseFileIoStream;",
	"",
	"\tAllocateBuffer(b_size);",
	"",
	"\treturn InputError(r);",
	"}",
	"",
	"CLexicalDriver::InputError",
	"\tCLexicalDriver::SetInputStdStream(FILE *f, int b_size)",
	"{",
	"\tint\t\tr = CloseInput();",
	"",
	"\tinput_std = f;",
	"",
	"\tinput_function\t= &CLexicalDriver::GetInputStdStreamData;",
	"\tclose_function\t= &CLexicalDriver::CloseStdStream;",
	"",
	"\tAllocateBuffer(b_size);",
	"",
	"\treturn InputError(r);",
	"}",
	"",
	"CLexicalDriver::InputError",
	"\tCLexicalDriver::SetInputFileStdStream(const string &f_name, int b_size)",
	"{",
	"\tint\t\tr = CloseInput();",
	"",
	"\tinput_std = fopen(f_name.c_str(), \"r\");",
	"",
	"\tif (!input_std)",
	"\t\treturn InputError(r | OpenError);",
	"",
	"\tfile_name = f_name;",
	"",
	"\tinput_function\t= &CLexicalDriver::GetInputStdStreamData;",
	"\tclose_function\t= &CLexicalDriver::CloseFileStdStream;",
	"",
	"\tAllocateBuffer(b_size);",
	"",
	"\treturn InputError(r);",
	"}",
	"",
	"CLexicalDriver::InputError",
	"\tCLexicalDriver::SetInputDescriptor(int i_d, int b_size)",
	"{",
	"\tint\t\tr = CloseInput();",
	"",
	"\tinput_fd = i_d;",
	"",
	"\tinput_function\t= &CLexicalDriver::GetInputDescriptorData;",
	"\tclose_function\t= &CLexicalDriver::CloseDescriptor;",
	"",
	"\tAllocateBuffer(b_size);",
	"",
	"\treturn InputError(r);",
	"}",
	"",
	"CLexicalDriver::InputError",
	"\tCLexicalDriver::SetInputFileDescriptor(const string &f_name, int b_size)",
	"{",
	"\tint\t\tr = CloseInput();",
	"",
	"\tinput_fd = open(f_name.c_str(), O_RDONLY);",
	"",
	"\tif (input_fd == -1)",
	"\t\treturn InputError(r | OpenError);",
	"",
	"\tfile_name = f_name;",
	"",
	"\tinput_function\t= &CLexicalDriver::GetInputDescriptorData;",
	"\tclose_function\t= &CLexicalDriver::CloseFileDescriptor;",
	"",
	"\tAllocateBuffer(b_size);",
	"",
	"\treturn InputError(r);",
	"}",
	"",
	"CLexicalDriver::InputError\t\tCLexicalDriver::CloseInput()",
	"{",
	"\tint\t\tr = (this->*close_function)();",
	"",
	"\tinput_function\t= &CLexicalDriver::GetInputNull;",
	"\tclose_function\t= &CLexicalDriver::CloseNull;",
	"",
	"\treturn InputError(r);",
	"}",
	"",
	"CLexicalDriver::InputError\t\tCLexicalDriver::CloseIoStream()",
	"{",
	"\tdelete [] input_buffer;",
	"",
	"\treturn NoError;",
	"}",
	"",
	"CLexicalDriver::InputError\t\tCLexicalDriver::CloseFileIoStream()",
	"{",
	"\tdelete [] input_buffer;",
	"",
	"\tdynamic_cast<ifstream *>(input_ios)->close();",
	"",
	"\tif (input_ios->bad())",
	"\t{",
	"\t\tdelete input_ios;",
	"\t\treturn CloseError;",
	"\t}",
	"\telse",
	"\t{",
	"\t\tdelete input_ios;",
	"\t\treturn NoError;",
	"\t}",
	"}",
	"",
	"CLexicalDriver::InputError\t\tCLexicalDriver::CloseStdStream()",
	"{",
	"\tdelete [] input_buffer;",
	"",
	"\treturn NoError;",
	"}",
	"",
	"CLexicalDriver::InputError\t\tCLexicalDriver::CloseFileStdStream()",
	"{",
	"\tdelete [] input_buffer;",
	"",
	"\tif (fclose(input_std))",
	"\t{",
	"\t\treturn CloseError;",
	"\t}",
	"\telse",
	"\t{",
	"\t\treturn NoError;",
	"\t}",
	"}",
	"",
	"CLexicalDriver::InputError\t\tCLexicalDriver::CloseDescriptor()",
	"{",
	"\tdelete [] input_buffer;",
	"",
	"\treturn NoError;",
	"}",
	"",
	"CLexicalDriver::InputError\t\tCLexicalDriver::CloseFileDescriptor()",
	"{",
	"\tdelete [] input_buffer;",
	"",
	"\tif (close(input_fd) == -1)",
	"\t{",
	"\t\treturn CloseError;",
	"\t}",
	"\telse",
	"\t{",
	"\t\treturn NoError;",
	"\t}",
	"}",
	"",
	"int\t\tCLexicalDriver::GetInputIoStreamData()",
	"{",
	"\tinput_ios->read((char *)input_buffer, input_buffer_size);",
	"",
	"\treturn input_ios->gcount();",
	"}",
	"",
	"int\t\tCLexicalDriver::GetInputStdStreamData()",
	"{",
	"\tsize_t\tr = fread(\tinput_buffer,",
	"\t\t\t\t\t\tsizeof(unsigned char),",
	"\t\t\t\t\t\tinput_buffer_size,",
	"\t\t\t\t\t\tinput_std);",
	"",
	"\treturn r;",
	"}",
	"",
	"int\t\tCLexicalDriver::GetInputDescriptorData()",
	"{",
	"\tssize_t\tr = read(\tinput_fd,",
	"\t\t\t\t\t\tinput_buffer,",
	"\t\t\t\t\t\tinput_buffer_size);",
	"",
	"\tif (r < 0)",
	"\t\tr = 0;",
	"",
	"\treturn r;",
	"}",
	"",
	"string\t&CLexicalDriver::GetLexicalStatusString(string &s, bool one_based)",
	"{",
	"\tostrstream\tos;",
	"",
	"\tif (one_based)",
	"\t{",
	"\t\tos << \"character = \" << current_char_number + 1 << \", \";",
	"\t\tos << \"line = \" << current_line_number + 1 << \", \";",
	"\t\tos << \"column = \" << current_column_number + 1;",
	"\t}",
	"\telse",
	"\t{",
	"\t\tos << \"character = \" << current_char_number << \", \";",
	"\t\tos << \"line = \" << current_line_number << \", \";",
	"\t\tos << \"column = \" << current_column_number;",
	"\t}",
	"",
	"\tos << '\\0';",
	"",
	"\treturn s = os.str();",
	"}",
	"",
	"void\tCLexicalSingleCharDriver::Initialize(int t_size, bool ptf)",
	"{",
	"\tpush_token_back_flag\t\t= false;",
	"\tprocess_terminal_flag\t\t= ptf;",
	"\tprocess_filter_break_flag\t= false;",
	"\timplicit_end_token_flag\t\t= false;",
	"\tparent_lexical\t\t\t\t= 0;",
	"",
	"\tcurrent_char\t\t\t= 0;",
	"\tcurrent_char_number\t\t= -1;",
	"\tcurrent_line_number\t\t= 0;",
	"\tcurrent_column_number\t= -1;",
	"",
	"\tsingle_char_array_buffer[0] = '\\0';",
	"}",
	"",
	"CLexicalSingleCharDriver::CLexicalSingleCharDriver(",
	"\t\t\t\t\t\t\tconst char * const lex_char_token_names[], int est)",
	"\t: CLexicalDriver(est), map_size(256)",
	"{",
	"\tcharacter_map\t= new int[map_size];",
	"",
	"\tint\t\ti;",
	"\tint\t\tj;",
	"",
	"\tfor (i=0; i<map_size; i++)",
	"\t\tcharacter_map[i] = filter_terminal;",
	"",
	"\ttoken_count = 0;",
	"",
	"\twhile (lex_char_token_names[token_count])",
	"\t\ttoken_count++;",
	"",
	"\tif (!empty_symbol_token)",
	"\t\tempty_symbol_token = token_count;",
	"",
	"\tfor (i=0; i<token_count; i++)",
	"\t{",
	"\t\tconst char\t*name = lex_char_token_names[i];",
	"",
	"\t\tif (name[1])",
	"\t\t{",
	"\t\t\tif (!strcmp(name, \"space\"))",
	"\t\t\t{",
	"\t\t\t\tcharacter_map[' '] = i;",
	"\t\t\t}",
	"\t\t\telse if (!strcmp(name, \"digit\"))",
	"\t\t\t{",
	"\t\t\t\tfor (j=0; j<10; j++)",
	"\t\t\t\t\tcharacter_map['0' + j] = i;",
	"\t\t\t}",
	"\t\t\telse if (!strcmp(name, \"hexdigit\"))",
	"\t\t\t{",
	"\t\t\t\tfor (j=0; j<6; j++)",
	"\t\t\t\t\tcharacter_map['A' + j] = i;",
	"",
	"\t\t\t\tfor (j=0; j<6; j++)",
	"\t\t\t\t\tcharacter_map['a' + j] = i;",
	"\t\t\t}",
	"\t\t\telse if (!strcmp(name, \"uppercase\"))",
	"\t\t\t{",
	"\t\t\t\tfor (j=0; j<26; j++)",
	"\t\t\t\t\tcharacter_map['A' + j] = i;",
	"\t\t\t}",
	"\t\t\telse if (!strcmp(name, \"lowercase\"))",
	"\t\t\t{",
	"\t\t\t\tfor (j=0; j<26; j++)",
	"\t\t\t\t\tcharacter_map['a' + j] = i;",
	"\t\t\t}",
	"\t\t\telse if (!strcmp(name, \"letter\"))",
	"\t\t\t{",
	"\t\t\t\tfor (j=0; j<26; j++)",
	"\t\t\t\t\tcharacter_map['A' + j] = i;",
	"",
	"\t\t\t\tfor (j=0; j<26; j++)",
	"\t\t\t\t\tcharacter_map['a' + j] = i;",
	"\t\t\t}",
	"\t\t\telse if (!strcmp(name, \"other\"))",
	"\t\t\t{",
	"\t\t\t\tcharacter_map['!'] = i;",
	"\t\t\t\tcharacter_map['#'] = i;",
	"\t\t\t\tcharacter_map['%'] = i;",
	"\t\t\t\tcharacter_map['&'] = i;",
	"\t\t\t\tcharacter_map['\\''] = i;",
	"\t\t\t\tcharacter_map[':'] = i;",
	"\t\t\t\tcharacter_map[';'] = i;",
	"\t\t\t\tcharacter_map['='] = i;",
	"\t\t\t\tcharacter_map['@'] = i;",
	"\t\t\t\tcharacter_map['_'] = i;",
	"\t\t\t\tcharacter_map['`'] = i;",
	"\t\t\t\tcharacter_map['~'] = i;",
	"\t\t\t}",
	"\t\t}",
	"\t\telse",
	"\t\t\tcharacter_map[name[0]] = i;",
	"\t}",
	"",
	"\tsingle_char_array_buffer[1] = '\\0';",
	"",
	"\tfilter_count\t= 0;",
	"\tterminal_count\t= token_count;",
	"}",
	"",
	"CLexicalSingleCharDriver::~CLexicalSingleCharDriver()",
	"{",
	"\tdelete [] character_map;",
	"}",
	"",
	"int\t\tCLexicalSingleCharDriver::GetFilterOrToken(",
	"\t\t\t\t\t\t\t\t\tunsigned char *&terminal_ptr,",
	"\t\t\t\t\t\t\t\t\tint &terminal_size)",
	"{",
	"\tGetFilterOrToken();",
	"",
	"\tterminal_ptr = single_char_array_buffer;",
	"",
	"\tif (current_token == empty_symbol_token)",
	"\t\tterminal_size = 0;",
	"\telse",
	"\t\tterminal_size = 1;",
	"",
	"\treturn current_token;",
	"}",
	"",
	"int\t\tCLexicalSingleCharDriver::GetFilterOrToken()",
	"{",
	"\tif (push_token_back_flag)",
	"\t\tpush_token_back_flag = false;",
	"\telse",
	"\t\tGetTerminal();",
	"",
	"\treturn current_token;",
	"}",
	"",
	"int\t\tCLexicalSingleCharDriver::GetToken(\tunsigned char *&token_ptr,",
	"\t\t\t\t\t\t\t\t\t\t\tint &token_size)",
	"{",
	"\tGetToken();",
	"",
	"\ttoken_ptr = single_char_array_buffer;",
	"",
	"\tif (current_token == empty_symbol_token)",
	"\t\ttoken_size = 0;",
	"\telse",
	"\t\ttoken_size = 1;",
	"",
	"\treturn current_token;",
	"}",
	"",
	"int\t\tCLexicalSingleCharDriver::GetToken()",
	"{",
	"\tif (push_token_back_flag)",
	"\t\tpush_token_back_flag = false;",
	"\telse",
	"\t{",
	"\t\twhile (1)",
	"\t\t{",
	"\t\t\tGetTerminal();",
	"",
	"\t\t\tif (current_token == filter_terminal)",
	"\t\t\t{",
	"\t\t\t\tif (process_terminal_flag)",
	"\t\t\t\t\tProcessFilter();",
	"",
	"\t\t\t\tif (process_filter_break_flag)",
	"\t\t\t\t{",
	"\t\t\t\t\tprocess_filter_break_flag = false;",
	"\t\t\t\t\tbreak;",
	"\t\t\t\t}",
	"\t\t\t}",
	"\t\t\telse",
	"\t\t\t\tbreak;",
	"\t\t}",
	"\t}",
	"",
	"\treturn current_token;",
	"}",
	"",
	"void\tCLexicalSingleCharDriver::GetTerminal()",
	"{",
	"\tif (!characters_remaining)",
	"\t{",
	"\t\tcharacters_remaining = GetInputData();",
	"",
	"\t\tif (!characters_remaining)",
	"\t\t{",
	"\t\t\tif (implicit_end_token_flag)",
	"\t\t\t{",
	"\t\t\t\tconst char\t\t\t*t\t= implicit_end_token_string.c_str();",
	"\t\t\t\tstring::size_type\tn\t= implicit_end_token_string.size();",
	"",
	"\t\t\t\tn = n < input_buffer_size ? n : input_buffer_size;",
	"",
	"\t\t\t\tfor (string::size_type i=0; i<n; ++i)",
	"\t\t\t\t\tinput_buffer[i] = t[i];",
	"",
	"\t\t\t\tcharacters_remaining\t= n;",
	"\t\t\t\timplicit_end_token_flag\t= false;",
	"\t\t\t}",
	"\t\t\telse",
	"\t\t\t{",
	"\t\t\t\tcurrent_token\t= empty_symbol_token;",
	"",
	"\t\t\t\tsingle_char_array_size\t\t= 0;",
	"\t\t\t\tsingle_char_array_buffer[0]\t= '\\0';",
	"",
	"\t\t\t\treturn;",
	"\t\t\t}",
	"\t\t}",
	"",
	"\t\tinput_buffer_offset = 0;",
	"\t}",
	"",
	"\tprevious_char\t= current_char;",
	"\tcurrent_char\t= input_buffer[input_buffer_offset];",
	"\tcurrent_token\t= character_map[current_char];",
	"",
	"\tinput_buffer_offset++;",
	"\tcharacters_remaining--;",
	"\tcurrent_char_number++;",
	"",
	"\tif (previous_char == '\\n')",
	"\t{",
	"\t\tcurrent_line_number++;",
	"\t\tcurrent_column_number = 0;",
	"\t}",
	"\telse",
	"\t\tcurrent_column_number++;",
	"",
	"\tsingle_char_array_size\t\t= 1;",
	"\tsingle_char_array_buffer[0] = current_char;",
	"}",
	"",
	"void\tCLexicalSingleCharDriver::LoadStackElement(CStackElement *se)",
	"{",
	"\tse->type\t\t\t\t\t\t= StackSingleChar;",
	"\tse->token\t\t\t\t\t\t= current_token;",
	"\tse->scalar.scalar_unsigned_char\t= current_char;",
	"}",
	"",
	"CLexicalRegexpDriver::CLexicalRegexpDriver(\tint\ttkc, int ftc, int tmc,",
	"\t\t\t\t\t\t\t\t\t\t\tint est, int ir, int fsmc,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *f_table,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *rm_table,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *pm_table,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *tm_table,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *sa_table,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *tc_table,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *t_map_table,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *f_map_table,",
	"\t\t\t\t\t\t\t\t\t\t\tconst int *lt_table,",
	"\t\t\t\t\t\t\t\t\t\t\tint sctm)",
	"\t: CLexicalDriver(est)",
	"{",
	"\ttoken_count\t\t\t= tkc;",
	"\tfilter_count\t\t= ftc;",
	"\tterminal_count\t\t= tmc;",
	"\tinput_range\t\t\t= ir;",
	"\tfsm_count\t\t\t= fsmc;",
	"\tfsm_table\t\t\t= f_table;",
	"\tregexp_match\t\t= rm_table;",
	"\tprefix_match\t\t= pm_table;",
	"\ttoken_match\t\t\t= tm_table;",
	"\tstart_assignment\t= sa_table;",
	"\ttrailing_context\t= tc_table;",
	"\ttoken_map\t\t\t= t_map_table;",
	"\tfilter_map\t\t\t= f_map_table;",
	"\tliteral_terminal\t= lt_table;",
	"",
	"\tsingle_column_token_match = sctm;",
	"",
	"\tSetupInverseTokenMap();",
	"\tSetupInverseFilterMap();",
	"",
	"\tterminal_char_array_buffer = 0;",
	"}",
	"",
	"void\tCLexicalRegexpDriver::SetupInverseTokenMap()",
	"{",
	"\tinverse_token_map = new int[token_count];",
	"",
	"\tint\t\ti;",
	"",
	"\tfor (i=0; i<terminal_count; i++)",
	"\t\tif (0 <= token_map[i] && token_map[i] < token_count)",
	"\t\t\tinverse_token_map[token_map[i]] = i;",
	"}",
	"",
	"void\tCLexicalRegexpDriver::SetupInverseFilterMap()",
	"{",
	"\tinverse_filter_map = new int[filter_count];",
	"",
	"\tint\t\ti;",
	"",
	"\tfor (i=0; i<terminal_count; i++)",
	"\t\tif (0 <= filter_map[i] && filter_map[i] < filter_count)",
	"\t\t\tinverse_filter_map[filter_map[i]] = i;",
	"}",
	"",
	"CLexicalRegexpDriver::~CLexicalRegexpDriver()",
	"{",
	"\tdelete [] inverse_token_map;",
	"\tdelete [] inverse_filter_map;",
	"\tdelete [] terminal_char_array_buffer;",
	"}",
	"",
	"void\tCLexicalRegexpDriver::Initialize(int t_size, bool ptf)",
	"{",
	"\tpush_token_back_flag\t\t= false;",
	"\tprocess_terminal_flag\t\t= ptf;",
	"\tprocess_filter_break_flag\t= false;",
	"\timplicit_end_token_flag\t\t= false;",
	"\tparent_lexical\t\t\t\t= 0;",
	"",
	"\tcurrent_char\t\t\t= 0;",
	"\tcurrent_char_number\t\t= -1;",
	"\tcurrent_line_number\t\t= 0;",
	"\tcurrent_column_number\t= -1;",
	"",
	"\tcurrent_start_condition\t= terminal_count;",
	"",
	"\tterminal_match_index\t= 0;",
	"\tterminal_state_index\t= 0;",
	"",
	"\tterminal_char_list.Clear();",
	"",
	"\tdelete [] terminal_char_array_buffer;",
	"",
	"\tterminal_char_array_maximum\t= t_size;",
	"\tterminal_char_array_buffer\t= new unsigned char[t_size + 1];",
	"}",
	"",
	"int\t\tCLexicalRegexpDriver::GetFilterOrToken(",
	"\t\t\t\t\t\t\t\t\tunsigned char *&terminal_ptr,",
	"\t\t\t\t\t\t\t\t\tint &terminal_size)",
	"{",
	"\tGetFilterOrToken();",
	"",
	"\tterminal_ptr\t= terminal_char_array_buffer;",
	"\tterminal_size\t= terminal_char_array_size;",
	"",
	"\treturn current_token;",
	"}",
	"",
	"int\t\tCLexicalRegexpDriver::GetFilterOrToken()",
	"{",
	"\tif (push_token_back_flag)",
	"\t\tpush_token_back_flag = false;",
	"\telse",
	"\t\tGetTerminal();",
	"",
	"\treturn current_token;",
	"}",
	"",
	"int\t\tCLexicalRegexpDriver::GetToken(\tunsigned char *&token_ptr,",
	"\t\t\t\t\t\t\t\t\t\tint &token_size)",
	"{",
	"\tGetToken();",
	"",
	"\ttoken_ptr\t= terminal_char_array_buffer;",
	"\ttoken_size\t= terminal_char_array_size;",
	"",
	"\treturn current_token;",
	"}",
	"",
	"int\t\tCLexicalRegexpDriver::GetToken()",
	"{",
	"\tif (push_token_back_flag)",
	"\t\tpush_token_back_flag = false;",
	"\telse",
	"\t{",
	"\t\twhile (1)",
	"\t\t{",
	"\t\t\tGetTerminal();",
	"",
	"\t\t\tif (current_token == filter_terminal)",
	"\t\t\t{",
	"\t\t\t\tcurrent_filter = filter_map[terminal_match_index];",
	"",
	"\t\t\t\tif (process_terminal_flag)",
	"\t\t\t\t\tProcessFilter();",
	"",
	"\t\t\t\tif (process_filter_break_flag)",
	"\t\t\t\t{",
	"\t\t\t\t\tprocess_filter_break_flag = false;",
	"\t\t\t\t\tbreak;",
	"\t\t\t\t}",
	"\t\t\t}",
	"\t\t\telse",
	"\t\t\t\tbreak;",
	"\t\t}",
	"\t}",
	"",
	"\treturn current_token;",
	"}",
	"",
	"void\tCLexicalRegexpDriver::GetTerminal()",
	"{",
	"\tGetTerminalCharList();",
	"",
	"\tif (!terminal_char_list.Size())",
	"\t{",
	"\t\tcurrent_token\t= empty_symbol_token;",
	"",
	"\t\tterminal_char_array_size\t\t= 0;",
	"\t\tterminal_char_array_buffer[0]\t= '\\0';",
	"",
	"\t\treturn;",
	"\t}",
	"\telse",
	"\t{",
	"\t\twhile (terminal_char_listptr)",
	"\t\t{",
	"\t\t\tSTerminalChar\t&tc1 = terminal_char_list.Data(",
	"\t\t\t\t\t\t\t\t\t\tterminal_char_listptr);",
	"",
	"\t\t\tterminal_state_index = tc1.state_register;",
	"",
	"\t\t\tint\t\tmatch = tc1.match_register;",
	"",
	"\t\t\tif (match != -1)",
	"\t\t\t{",
	"\t\t\t\tterminal_match_index = match;",
	"",
	"\t\t\t\tif (start_assignment[match])",
	"\t\t\t\t\tcurrent_start_condition = match;",
	"",
	"\t\t\t\tcurrent_token = token_map[match];",
	"",
	"\t\t\t\tif (trailing_context[match])",
	"\t\t\t\t{",
	"\t\t\t\t\twhile (terminal_char_listptr)",
	"\t\t\t\t\t{",
	"\t\t\t\t\t\tSTerminalChar\t&tc2 =",
	"\t\t\t\t\t\t\tterminal_char_list.Data(terminal_char_listptr);",
	"",
	"\t\t\t\t\t\tif (prefix_match[tc2.state_register * terminal_count +",
	"\t\t\t\t\t\t\t\t\t\t\tmatch])",
	"\t\t\t\t\t\t\tbreak;",
	"",
	"\t\t\t\t\t\tterminal_char_list.PreviousListPtr(",
	"\t\t\t\t\t\t\t\t\t\t\t\t\tterminal_char_listptr);",
	"\t\t\t\t\t\tterminal_char_array_size--;",
	"\t\t\t\t\t}",
	"",
	"\t\t\t\t\tif (!terminal_char_array_size)",
	"\t\t\t\t\t{",
	"\t\t\t\t\t\tcurrent_token\t\t\t\t= lexical_error_code;",
	"\t\t\t\t\t\tterminal_char_array_size\t= 1;",
	"\t\t\t\t\t}",
	"\t\t\t\t}",
	"",
	"\t\t\t\tif (terminal_char_array_size > terminal_char_array_maximum)",
	"\t\t\t\t{",
	"\t\t\t\t\tterminal_char_array_maximum =",
	"\t\t\t\t\t\tterminal_char_array_size >",
	"\t\t\t\t\t\t\t2 * terminal_char_array_maximum ?",
	"\t\t\t\t\t\tterminal_char_array_size :",
	"\t\t\t\t\t\t2 * terminal_char_array_maximum;",
	"",
	"\t\t\t\t\tdelete [] terminal_char_array_buffer;",
	"\t\t\t\t\tterminal_char_array_buffer =",
	"\t\t\t\t\t\tnew unsigned char[terminal_char_array_maximum + 1];",
	"\t\t\t\t}",
	"",
	"\t\t\t\tterminal_char_listptr = terminal_char_list.FirstListPtr();",
	"",
	"\t\t\t\tint\ti;",
	"\t\t\t\tfor (i=0; i<terminal_char_array_size; i++)",
	"\t\t\t\t{",
	"\t\t\t\t\tSTerminalChar\t&tc3 =",
	"\t\t\t\t\t\tterminal_char_list.NextData(terminal_char_listptr);",
	"",
	"\t\t\t\t\tterminal_char_array_buffer[i] = tc3.terminal_char;",
	"\t\t\t\t}",
	"",
	"\t\t\t\tterminal_char_array_buffer[i] = '\\0';",
	"",
	"\t\t\t\tterminal_char_list.PopFront(terminal_char_array_size);",
	"",
	"\t\t\t\treturn;",
	"\t\t\t}",
	"",
	"\t\t\tterminal_char_list.PreviousListPtr(terminal_char_listptr);",
	"\t\t\tterminal_char_array_size--;",
	"\t\t}",
	"",
	"\t\tcurrent_token\t= lexical_error_code;",
	"",
	"\t\tterminal_char_array_size\t\t= 1;",
	"\t\tterminal_char_array_buffer[0]\t=",
	"\t\t\tterminal_char_list.FirstData().terminal_char;",
	"\t\tterminal_char_array_buffer[1]\t= '\\0';",
	"",
	"\t\tterminal_char_list.PopFront();",
	"",
	"\t\treturn;",
	"\t}",
	"}",
	"",
	"void\tCLexicalRegexpDriver::GetTerminalCharList()",
	"{",
	"\tint\t\tcurrent_state = 0;",
	"",
	"\tterminal_char_array_size\t= 0;",
	"\tterminal_char_listptr\t\t= terminal_char_list.FirstListPtr();",
	"",
	"\twhile (terminal_char_listptr)",
	"\t{",
	"\t\tSTerminalChar\t&tc = terminal_char_list.Data(terminal_char_listptr);",
	"",
	"\t\tcurrent_state = fsm_table[",
	"\t\t\t\t\t\t\tcurrent_state * input_range + tc.terminal_char];",
	"",
	"\t\tif (current_state == -1)",
	"\t\t{",
	"\t\t\tterminal_char_list.PreviousListPtr(terminal_char_listptr);",
	"\t\t\treturn;",
	"\t\t}",
	"",
	"\t\ttc.state_register = current_state;",
	"",
	"\t\tif (single_column_token_match)",
	"\t\t\ttc.match_register = token_match[current_state];",
	"\t\telse",
	"\t\t\ttc.match_register = token_match[",
	"\t\t\t\tcurrent_state * (terminal_count + 1) + current_start_condition];",
	"",
	"\t\tterminal_char_list.NextListPtr(terminal_char_listptr);",
	"\t\tterminal_char_array_size++;",
	"\t}",
	"",
	"\tterminal_char_listptr = terminal_char_list.LastListPtr();",
	"",
	"\twhile (1)",
	"\t{",
	"\t\tif (!characters_remaining)",
	"\t\t{",
	"\t\t\tcharacters_remaining = GetInputData();",
	"",
	"\t\t\tif (!characters_remaining)",
	"\t\t\t{",
	"\t\t\t\tif (implicit_end_token_flag)",
	"\t\t\t\t{",
	"\t\t\t\t\tconst char\t\t\t*t\t= implicit_end_token_string.c_str();",
	"\t\t\t\t\tstring::size_type\tn\t= implicit_end_token_string.size();",
	"",
	"\t\t\t\t\tn = n < input_buffer_size ? n : input_buffer_size;",
	"",
	"\t\t\t\t\tfor (string::size_type i=0; i<n; ++i)",
	"\t\t\t\t\t\tinput_buffer[i] = t[i];",
	"",
	"\t\t\t\t\tcharacters_remaining\t= n;",
	"\t\t\t\t\timplicit_end_token_flag\t= false;",
	"\t\t\t\t}",
	"\t\t\t\telse",
	"\t\t\t\t{",
	"\t\t\t\t\treturn;",
	"\t\t\t\t}",
	"\t\t\t}",
	"",
	"\t\t\tinput_buffer_offset = 0;",
	"\t\t}",
	"",
	"\t\tprevious_char\t= current_char;",
	"\t\tcurrent_char\t= input_buffer[input_buffer_offset];",
	"",
	"\t\tterminal_char_listptr = terminal_char_list.PushBack(",
	"\t\t\t\t\t\t\t\t\tSTerminalChar(\tcurrent_char,",
	"\t\t\t\t\t\t\t\t\t\t\t\t\tcurrent_char_number,",
	"\t\t\t\t\t\t\t\t\t\t\t\t\tcurrent_line_number,",
	"\t\t\t\t\t\t\t\t\t\t\t\t\tcurrent_column_number));",
	"",
	"\t\tinput_buffer_offset++;",
	"\t\tcharacters_remaining--;",
	"\t\tcurrent_char_number++;",
	"",
	"\t\tif (previous_char == '\\n')",
	"\t\t{",
	"\t\t\tcurrent_line_number++;",
	"\t\t\tcurrent_column_number = 0;",
	"\t\t}",
	"\t\telse",
	"\t\t\tcurrent_column_number++;",
	"",
	"\t\tSTerminalChar\t&tc = terminal_char_list.Data(terminal_char_listptr);",
	"",
	"\t\tcurrent_state = fsm_table[current_state * input_range + current_char];",
	"",
	"\t\tif (current_state == -1)",
	"\t\t{",
	"\t\t\tterminal_char_list.PreviousListPtr(terminal_char_listptr);",
	"\t\t\treturn;",
	"\t\t}",
	"",
	"\t\ttc.state_register = current_state;",
	"",
	"\t\tif (single_column_token_match)",
	"\t\t\ttc.match_register = token_match[current_state];",
	"\t\telse",
	"\t\t\ttc.match_register = token_match[",
	"\t\t\t\tcurrent_state * (terminal_count + 1) + current_start_condition];",
	"",
	"\t\tterminal_char_array_size++;",
	"\t}",
	"}",
	"",
	"int\t\tCLexicalRegexpDriver::GetCurrentCharNumber()",
	"{",
	"\tif (terminal_char_list.Size())",
	"\t{",
	"\t\tSTerminalChar\t&tc = terminal_char_list.FirstData();",
	"",
	"\t\treturn tc.char_number;",
	"\t}",
	"\telse",
	"\t\treturn current_char_number;",
	"}",
	"",
	"int\t\tCLexicalRegexpDriver::GetCurrentLineNumber()",
	"{",
	"\tif (terminal_char_list.Size())",
	"\t{",
	"\t\tSTerminalChar\t&tc = terminal_char_list.FirstData();",
	"",
	"\t\treturn tc.line_number;",
	"\t}",
	"\telse",
	"\t\treturn current_line_number;",
	"}",
	"",
	"int\t\tCLexicalRegexpDriver::GetCurrentColumnNumber()",
	"{",
	"\tif (terminal_char_list.Size())",
	"\t{",
	"\t\tSTerminalChar\t&tc = terminal_char_list.FirstData();",
	"",
	"\t\treturn tc.column_number;",
	"\t}",
	"\telse",
	"\t\treturn current_column_number;",
	"}",
	"",
	"void\tCLexicalRegexpDriver::LoadStackElement(CStackElement *se)",
	"{",
	"\tse->type\t= StackLiteralToken;",
	"\tse->token\t= current_token;",
	"}",
	0
};

const char * const	CCompilerCalculate::parser_base_code_h[] =
{
	"#ifndef PARSERDRIVER_H",
	"#define PARSERDRIVER_H",
	"",
	"using namespace std;",
	"",
	"#include \"tvaluelist.h\"",
	"#include \"lexicalDriver.h\"",
	"",
	"class CParserDriver",
	"{",
	"\tpublic:",
	"\tenum StatusCode",
	"\t{",
	"\t\tNoError\t\t\t\t= 0,",
	"\t\tLexicalError\t\t= 1,",
	"\t\tParserError\t\t\t= 2,",
	"\t\tCodeGenerationError\t= 4,",
	"\t\tParserHalted\t\t= 8,",
	"\t\tEndOfFile\t\t\t= 16",
	"\t};",
	"",
	"\tenum ActionType",
	"\t{",
	"\t\tShift,",
	"\t\tReduce,",
	"\t\tAccept,",
	"\t\tError,",
	"\t\tConflict,",
	"\t\tQuit,",
	"\t\tSetupErrorStack,",
	"\t\tShiftErrorToken,",
	"\t\tDiscardToken,",
	"\t\tInputSynchronized,",
	"\t\tSynchronizationComplete",
	"\t};",
	"",
	"\tenum DriverState",
	"\t{",
	"\t\tNonErrorParse,",
	"\t\tFindErrorInputState,",
	"\t\tErrorParseThruErrorShift,",
	"\t\tErrorParseAfterErrorShift,",
	"\t\tErrorParseSynchronization,",
	"\t\tParseStreamDone",
	"\t};",
	"",
	"\tCParserDriver(\tint tce, int sca, int rca, int est, int sa,",
	"\t\t\t\t\tint aa, int ce, int sc, int nce, int nei,",
	"\t\t\t\t\tconst int *a_table, const int *g_table,",
	"\t\t\t\t\tconst int *rls_table, const int *rrl_table);",
	"\tvirtual ~CParserDriver();",
	"",
	"\tvoid\t\t\tInitialize(\tint iss = 100, bool icgf = true,",
	"\t\t\t\t\t\t\t\tbool dlef = false, bool erf = false,",
	"\t\t\t\t\t\t\t\tbool spm = false);",
	"\tvoid\t\t\tInitializeSyntaxMode(\tint iss = 100, bool icgf = true,",
	"\t\t\t\t\t\t\t\t\t\t\tbool dlef = false, bool erf = false)",
	"\t{ Initialize(iss, icgf, dlef, erf, true); }",
	"\tvoid\t\t\tSetInitialCodeGenerationFlag(bool f)",
	"\t{ initial_code_generation_flag = f; }",
	"\tvoid\t\t\tSetDiscardLexicalErrorFlag(bool f)",
	"\t{ discard_lexical_error_flag = f; }",
	"\tvoid\t\t\tSetErrorReportingFlag(bool f)",
	"\t{ error_reporting_flag = f; }",
	"\tvoid\t\t\tSetErrorOutputStream(ostream *o_stream)",
	"\t{ error_output_stream = o_stream; }",
	"\tvoid\t\t\tHaltParser()",
	"\t{ halt_parser_flag = true; }",
	"\tvoid\t\t\tSetErrorToken(int et)",
	"\t{ error_token = et; }",
	"\tvoid\t\t\tSetSynchronizationLength(int sl)",
	"\t{ synchronization_length = sl; }",
	"",
	"\tvoid\t\t\tSetLexical(CLexicalDriver *l) { lexical = l; }",
	"\tvoid\t\t\tPushLexical(CLexicalDriver *l);",
	"\tvoid\t\t\tPopLexical();",
	"\tStatusCode\t\tParseStream();",
	"\tActionType\t\tParseStreamSingleStep();",
	"\tCStackElement\t*CompiledObject() { return stack + 1; }",
	"",
	"\tvirtual void\tSetupFunctionTables() { }",
	"\tvirtual int     CallReduceFunction(int action, void *data)",
	"\t{ stack_ptr->type = StackNonTerminal; return 0; }",
	"\tvirtual void\tCallErrorFunction(int index) { }",
	"\tvirtual void\tCallConflictFunction(int index) { }",
	"\tvirtual void    DeleteGeneratedCode(CStackElement *s, int c) { }",
	"",
	"\tint\t\t\tGetToken() const\t\t\t{ return token; }",
	"\tint\t\t\tGetAction() const\t\t\t{ return action; }",
	"\tint\t\t\tGetMachineState() const\t\t{ return machine_state; }",
	"\tint\t\t\tGetStackCount() const\t\t{ return stack_count; }",
	"\tint\t\t\tGetErrorToken() const\t\t{ return error_token; }",
	"\tint\t\t\tGetErrorStackCount() const\t{ return error_stack_count; }",
	"\tint\t\t\tGetDriverState() const\t\t{ return driver_state; }",
	"",
	"\tCLexicalDriver\t\t*GetCurrentLexical() { return lexical; }",
	"",
	"\tprivate:",
	"\tint\t\t\tterminal_count_e;",
	"\tint\t\t\tsymbol_count_a;",
	"\tint\t\t\trule_count_a;",
	"\tint\t\t\tempty_symbol_token;",
	"\tint\t\t\tshift_action;",
	"\tint\t\t\taccept_action;",
	"\tint\t\t\tconflict_entry;",
	"\tint\t\t\tstate_count;",
	"\tint\t\t\tnumber_of_conflict_entries;",
	"\tint\t\t\tnumber_of_error_indexes;",
	"\tconst int\t*action_table;",
	"\tconst int\t*goto_table;",
	"\tconst int\t*rule_left_symbol_table;",
	"\tconst int\t*rule_right_length_table;",
	"",
	"\tostream\t\t\t*error_output_stream;",
	"\tDriverState\t\tdriver_state;",
	"",
	"\tint\t\t\t\tinitial_stack_size;",
	"\tint\t\t\t\tstack_size;",
	"\tint\t\t\t\tstack_count;",
	"\tCStackElement\t*stack;",
	"",
	"\tprotected:",
	"\tCStackElement\t*stack_ptr;",
	"",
	"\tprivate:",
	"\tbool\t\t\tstack_modification_flag;",
	"\tint\t\t\t\terror_token;",
	"\tint\t\t\t\tsynchronization_length;",
	"\tint\t\t\t\tsynchronization_count;",
	"\tint\t\t\t\terror_stack_size;",
	"\tint\t\t\t\terror_stack_count;",
	"\tCStackElement\t*error_stack;",
	"\tCStackElement\t*error_stack_ptr;",
	"",
	"\tTValueList<CStackElement>\t\t\tinput_token_fifo;",
	"\tTValueList<CStackElement>::listptr\tinput_token_fifo_listptr;",
	"",
	"\tCLexicalDriver\t\t\t\t\t*lexical;",
	"\tTValueList<CLexicalDriver *>\tlexical_stack;",
	"",
	"\tint\t\t\ttoken;",
	"\tint\t\t\taction;",
	"\tint\t\t\tmachine_state;",
	"",
	"\tbool\t\tinitial_code_generation_flag;",
	"\tbool\t\tdiscard_lexical_error_flag;",
	"\tbool\t\terror_reporting_flag;",
	"\tbool\t\tsyntax_parsing_mode;",
	"\tbool\t\tcode_generation_flag;",
	"\tbool\t\tcall_reduce_function_flag;",
	"\tbool\t\thalt_parser_flag;",
	"",
	"\tbool\t\tlexical_error_flag;",
	"\tbool\t\tparser_error_flag;",
	"\tbool\t\tcode_generation_error_flag;",
	"\tbool\t\tend_of_file_flag;",
	"",
	"\tStatusCode\t\tReturnStatusCode();",
	"\tvoid\t\t\tDoubleStack();",
	"\tvoid\t\t\tDoubleErrorStack();",
	"\tActionType\t\tMapActionToType(int action);",
	"\tvoid\t\t\tHaltCodeGeneration();",
	"\tActionType\t\tProcessNonErrorParse();",
	"\tActionType\t\tProcessFindErrorInputState();",
	"\tActionType\t\tProcessErrorParseThruErrorShift();",
	"\tActionType\t\tProcessErrorParseAfterErrorShift();",
	"\tActionType\t\tProcessErrorParseSynchronized();",
	"};",
	"",
	"#endif",
	0
};

const char * const	CCompilerCalculate::parser_base_code_cpp[] =
{
	"#include \"parserDriver.h\"",
	"",
	"CParserDriver::CParserDriver(\tint\ttce, int sca, int rca, int est, int sa,",
	"\t\t\t\t\t\t\t\tint aa, int ce, int sc, int nce, int nei,",
	"\t\t\t\t\t\t\t\tconst int *a_table, const int *g_table,",
	"\t\t\t\t\t\t\t\tconst int *rls_table, const int *rrl_table)",
	"\t:\tlexical_stack(10)",
	"{",
	"\tterminal_count_e\t\t\t\t= tce;",
	"\tsymbol_count_a\t\t\t\t\t= sca;",
	"\trule_count_a\t\t\t\t\t= rca;",
	"\tempty_symbol_token\t\t\t\t= est;",
	"\tshift_action\t\t\t\t\t= sa;",
	"\taccept_action\t\t\t\t\t= aa;",
	"\tconflict_entry\t\t\t\t\t= ce;",
	"\tstate_count\t\t\t\t\t\t= sc;",
	"\tnumber_of_conflict_entries\t\t= nce;",
	"\tnumber_of_error_indexes\t\t\t= nei;",
	"\taction_table\t\t\t\t\t= a_table;",
	"\tgoto_table\t\t\t\t\t\t= g_table;",
	"\trule_left_symbol_table\t\t\t= rls_table;",
	"\trule_right_length_table\t\t\t= rrl_table;",
	"",
	"\tstack\t\t= 0;",
	"\terror_stack\t= 0;",
	"}",
	"",
	"CParserDriver::~CParserDriver()",
	"{",
	"\tdelete [] stack;",
	"\tdelete [] error_stack;",
	"}",
	"",
	"CParserDriver::StatusCode\tCParserDriver::ReturnStatusCode()",
	"{",
	"\tint\t\tcode = NoError;",
	"",
	"\tif (lexical_error_flag)",
	"\t\tcode = LexicalError;",
	"",
	"\tif (parser_error_flag)",
	"\t\tcode |= ParserError;",
	"",
	"\tif (code_generation_error_flag)",
	"\t\tcode |= CodeGenerationError;",
	"",
	"\tif (halt_parser_flag)",
	"\t\tcode |= ParserHalted;",
	"",
	"\tif (end_of_file_flag)",
	"\t\tcode |= EndOfFile;",
	"",
	"\treturn StatusCode(code);",
	"}",
	"",
	"void\tCParserDriver::PushLexical(CLexicalDriver *l)",
	"{",
	"\tlexical_stack.PushBack(lexical);",
	"",
	"\tlexical = l;",
	"",
	"\tif (!code_generation_flag && syntax_parsing_mode)",
	"\t\tlexical->HaltProcessTerminal();",
	"}",
	"",
	"void\tCParserDriver::PopLexical()",
	"{",
	"\tdelete lexical;",
	"",
	"\tlexical = lexical_stack.LastData();",
	"",
	"\tif (!code_generation_flag && syntax_parsing_mode)",
	"\t\tlexical->HaltProcessTerminal();",
	"",
	"\tlexical_stack.PopBack();",
	"}",
	"",
	"void\t\tCParserDriver::Initialize(\tint iss, bool icgf, ",
	"\t\t\t\t\t\t\t\t\t\tbool dlef, bool erf, bool spm)",
	"{",
	"\tinitial_stack_size\t\t\t\t= iss;",
	"\tinitial_code_generation_flag\t= icgf;",
	"\tdiscard_lexical_error_flag\t\t= dlef;",
	"\terror_reporting_flag\t\t\t= erf;",
	"\tsyntax_parsing_mode\t\t\t\t= spm;",
	"",
	"\tdelete [] stack;",
	"\tdelete [] error_stack;",
	"",
	"\tstack_size\t= initial_stack_size;",
	"\tstack\t\t= new CStackElement[stack_size];",
	"\tstack_ptr\t= stack;",
	"",
	"\tstack_ptr[0].state\t= 0;",
	"\tstack_ptr[0].type\t= StackLiteralToken;",
	"\tstack_count\t\t\t= 1;",
	"",
	"\terror_stack_size\t= initial_stack_size;",
	"\terror_stack\t\t\t= new CStackElement[error_stack_size];",
	"\terror_stack_ptr\t\t= error_stack;",
	"\terror_stack_count\t= 0;",
	"",
	"\tdriver_state = NonErrorParse;",
	"",
	"\tcode_generation_flag\t\t= initial_code_generation_flag;",
	"",
	"\tif (!code_generation_flag && syntax_parsing_mode)",
	"\t\tcall_reduce_function_flag = false;",
	"\telse",
	"\t\tcall_reduce_function_flag = true;",
	"",
	"\thalt_parser_flag\t\t\t= false;",
	"\tlexical_error_flag\t\t\t= false;",
	"\tparser_error_flag\t\t\t= false;",
	"\tcode_generation_error_flag\t= false;",
	"\tend_of_file_flag\t\t\t= false;",
	"",
	"\terror_output_stream = &cout;",
	"}",
	"",
	"void\t\tCParserDriver::DoubleStack()",
	"{",
	"\tCStackElement\t*double_stack = new CStackElement[2 * stack_size];",
	"",
	"\tfor (int i=0; i<stack_size; i++)",
	"\t\tdouble_stack[i] = stack[i];",
	"",
	"\tstack_size *= 2;",
	"",
	"\tdelete stack;",
	"\tstack\t\t= double_stack;",
	"\tstack_ptr\t= stack + (stack_count - 1);",
	"}",
	"",
	"void\t\tCParserDriver::DoubleErrorStack()",
	"{",
	"\tCStackElement\t*double_stack = new CStackElement[2 * error_stack_size];",
	"",
	"\tfor (int i=0; i<error_stack_size; i++)",
	"\t\tdouble_stack[i] = error_stack[i];",
	"",
	"\terror_stack_size *= 2;",
	"",
	"\tdelete error_stack;",
	"\terror_stack\t\t= double_stack;",
	"\terror_stack_ptr\t= error_stack + (error_stack_count - 1);",
	"}",
	"",
	"CParserDriver::ActionType\tCParserDriver::MapActionToType(int action)",
	"{",
	"\tif (action == shift_action)\t\t\t\t\t\treturn Shift;",
	"\telse if (0 <= action && action < rule_count_a)\treturn Reduce;",
	"\telse if (action == accept_action)\t\t\t\treturn Accept;",
	"\telse if (action < 0)\t\t\t\t\t\t\treturn Error;",
	"\telse if (action >= conflict_entry)\t\t\t\treturn Conflict;",
	"}",
	"",
	"void\tCParserDriver::HaltCodeGeneration()",
	"{",
	"\tif (code_generation_flag)",
	"\t{",
	"\t\tcode_generation_flag = false;",
	"",
	"\t\tif (syntax_parsing_mode)",
	"\t\t{",
	"\t\t\tcall_reduce_function_flag = false;",
	"",
	"\t\t\tlexical->HaltProcessTerminal();",
	"\t\t}",
	"",
	"\t\tDeleteGeneratedCode(stack, stack_count);",
	"\t}",
	"}",
	"",
	"CParserDriver::StatusCode\tCParserDriver::ParseStream()",
	"{",
	"\tif (!code_generation_flag && syntax_parsing_mode)",
	"\t\tlexical->HaltProcessTerminal();",
	"",
	"\twhile (driver_state != ParseStreamDone)",
	"\t\tParseStreamSingleStep();",
	"",
	"\treturn ReturnStatusCode();",
	"}",
	"",
	"CParserDriver::ActionType\tCParserDriver::ParseStreamSingleStep()",
	"{",
	"\tActionType\taction_type;",
	"",
	"\tswitch (driver_state)",
	"\t{",
	"\t\tcase NonErrorParse:",
	"\t\taction_type = ProcessNonErrorParse();",
	"\t\tswitch (action_type)",
	"\t\t{",
	"\t\t\tcase Shift:",
	"\t\t\tcase Reduce:",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase Accept:",
	"\t\t\tcase Quit:",
	"\t\t\tdriver_state = ParseStreamDone;",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase Error:",
	"\t\t\tcase Conflict:",
	"\t\t\tdriver_state = FindErrorInputState;",
	"\t\t\tbreak;",
	"\t\t}",
	"\t\tbreak;",
	"",
	"\t\tcase FindErrorInputState:",
	"\t\taction_type = ProcessFindErrorInputState();",
	"\t\tswitch (action_type)",
	"\t\t{",
	"\t\t\tcase Quit:",
	"\t\t\tdriver_state = ParseStreamDone;",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase SetupErrorStack:",
	"\t\t\tdriver_state = ErrorParseThruErrorShift;",
	"\t\t\tbreak;",
	"\t\t}",
	"\t\tbreak;",
	"",
	"\t\tcase ErrorParseThruErrorShift:",
	"\t\taction_type = ProcessErrorParseThruErrorShift();",
	"\t\tswitch (action_type)",
	"\t\t{",
	"\t\t\tcase Reduce:",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase Quit:",
	"\t\t\tdriver_state = ParseStreamDone;",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase ShiftErrorToken:",
	"\t\t\tdriver_state = ErrorParseAfterErrorShift;",
	"\t\t\tbreak;",
	"\t\t}",
	"\t\tbreak;",
	"",
	"\t\tcase ErrorParseAfterErrorShift:",
	"\t\taction_type = ProcessErrorParseAfterErrorShift();",
	"\t\tswitch (action_type)",
	"\t\t{",
	"\t\t\tcase Shift:",
	"\t\t\tcase Reduce:",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase Accept:",
	"\t\t\tcase Quit:",
	"\t\t\tdriver_state = ParseStreamDone;",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase InputSynchronized:",
	"\t\t\tdriver_state = ErrorParseSynchronization;",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase DiscardToken:",
	"\t\t\tbreak;",
	"\t\t}",
	"\t\tbreak;",
	"",
	"\t\tcase ErrorParseSynchronization:",
	"\t\taction_type = ProcessErrorParseSynchronized();",
	"\t\tswitch (action_type)",
	"\t\t{",
	"\t\t\tcase Shift:",
	"\t\t\tcase Reduce:",
	"\t\t\tbreak;",
	"",
	"\t\t\tcase SynchronizationComplete:",
	"\t\t\tdriver_state = NonErrorParse;",
	"\t\t\tbreak;",
	"\t\t}",
	"\t\tbreak;",
	"\t}",
	"",
	"\treturn action_type;",
	"}",
	"",
	"CParserDriver::ActionType\tCParserDriver::ProcessNonErrorParse()",
	"{",
	"\tint\t\treduce_function_return;",
	"",
	"\twhile (true)",
	"\t{",
	"\t\ttoken = lexical->GetToken();",
	"",
	"\t\tif (halt_parser_flag)",
	"\t\t{",
	"\t\t\tHaltCodeGeneration();",
	"",
	"\t\t\tif (error_reporting_flag)",
	"\t\t\t{",
	"\t\t\t\tstring\ts;",
	"",
	"\t\t\t\t*error_output_stream << \"Parser Halted: \";",
	"\t\t\t\t*error_output_stream << lexical->GetLexicalStatusString(s);",
	"\t\t\t\t*error_output_stream << endl;",
	"\t\t\t}",
	"",
	"\t\t\treturn Quit;",
	"\t\t}",
	"\t\telse if (token < 0)",
	"\t\t{",
	"\t\t\tlexical_error_flag = true;",
	"\t\t\tHaltCodeGeneration();",
	"",
	"\t\t\tif (error_reporting_flag)",
	"\t\t\t{",
	"\t\t\t\tstring\ts;",
	"",
	"\t\t\t\t*error_output_stream << \"Lexical Error: \";",
	"\t\t\t\t*error_output_stream << lexical->GetLexicalStatusString(s);",
	"\t\t\t\t*error_output_stream << endl;",
	"\t\t\t}",
	"",
	"\t\t\tif (!discard_lexical_error_flag)",
	"\t\t\t\treturn Quit;",
	"\t\t}",
	"\t\telse if (token == empty_symbol_token && lexical_stack.Size())",
	"\t\t{",
	"\t\t\tPopLexical();",
	"\t\t}",
	"\t\telse",
	"\t\t\tbreak;",
	"\t}",
	"",
	"\tmachine_state\t= stack_ptr->state;",
	"\taction\t\t\t= action_table[machine_state * terminal_count_e + token];",
	"\t\t",
	"\tswitch (MapActionToType(action))",
	"\t{",
	"\t\tcase Shift:",
	"\t\t{",
	"\t\t\tmachine_state = goto_table[machine_state * symbol_count_a + token];",
	"",
	"\t\t\tstack_ptr++;",
	"\t\t\tstack_ptr->state = machine_state;",
	"\t\t\tstack_count++;",
	"",
	"\t\t\tif (stack_count == stack_size)",
	"\t\t\t\tDoubleStack();",
	"",
	"\t\t\tlexical->LoadStackElement(stack_ptr);",
	"\t\t}",
	"\t\treturn Shift;",
	"",
	"\t\tcase Reduce:",
	"\t\t{",
	"\t\t\tint\t\trule_right_length = rule_right_length_table[action];",
	"",
	"\t\t\tstack_ptr -= rule_right_length;",
	"\t\t\t\t",
	"\t\t\tmachine_state = stack_ptr->state;",
	"\t\t\tmachine_state = goto_table[machine_state * symbol_count_a +",
	"\t\t\t\t\t\t\t\t\t\t\trule_left_symbol_table[action]];",
	"\t\t\tstack_ptr++;",
	"\t\t\tstack_ptr->state\t\t\t= machine_state;",
	"\t\t\tstack_ptr->reduce_action\t= action;",
	"\t\t\tstack_count -= (rule_right_length - 1);",
	"",
	"\t\t\tif (stack_count == stack_size)",
	"\t\t\t\tDoubleStack();",
	"",
	"\t\t\tlexical->PushCurrentTokenBack();",
	"",
	"\t\t\tif (call_reduce_function_flag)",
	"\t\t\t{",
	"\t\t\t\treduce_function_return = CallReduceFunction(action, 0);",
	"",
	"\t\t\t\tif (reduce_function_return == -1)",
	"\t\t\t\t{",
	"\t\t\t\t\tcode_generation_error_flag = true;",
	"\t\t\t\t\tHaltCodeGeneration();",
	"\t\t\t\t}",
	"\t\t\t}",
	"\t\t\telse",
	"\t\t\t{",
	"\t\t\t\tstack_ptr->type = StackNonTerminal;",
	"\t\t\t}",
	"\t\t}",
	"\t\treturn Reduce;",
	"",
	"\t\tcase Accept:",
	"\t\tend_of_file_flag = true;",
	"\t\treturn Accept;",
	"",
	"\t\tcase Error:",
	"\t\t{",
	"\t\t\tparser_error_flag = true;",
	"\t\t\tHaltCodeGeneration();",
	"",
	"\t\t\tlexical->PushCurrentTokenBack();",
	"",
	"\t\t\terror_token = -1;",
	"\t\t\tCallErrorFunction(-action);",
	"\t\t}",
	"\t\treturn Error;",
	"",
	"\t\tcase Conflict:",
	"\t\t{",
	"\t\t\tparser_error_flag = true;",
	"\t\t\tHaltCodeGeneration();",
	"",
	"\t\t\tlexical->PushCurrentTokenBack();",
	"",
	"\t\t\terror_token = -1;",
	"\t\t\tCallConflictFunction(action - conflict_entry);",
	"\t\t}",
	"\t\treturn Conflict;",
	"\t}",
	"}",
	"",
	"CParserDriver::ActionType\tCParserDriver::ProcessFindErrorInputState()",
	"{",
	"\tint\t\ti;",
	"",
	"\tif (error_token == -1)",
	"\t\treturn Quit;",
	"",
	"\tfor (i=stack_count-1; i>=0; i--)",
	"\t{",
	"\t\tmachine_state = stack[i].state;",
	"",
	"\t\tint\terror_token_action =",
	"\t\t\t\taction_table[machine_state * terminal_count_e + error_token];",
	"",
	"\t\tif (error_token_action >= 0 && error_token_action <= shift_action)",
	"\t\t\tbreak;",
	"\t}",
	"",
	"\tif (i >= 0)",
	"\t{",
	"\t\tstack_count = i + 1;",
	"",
	"\t\tstack_ptr = stack + i;",
	"",
	"\t\treturn SetupErrorStack;",
	"\t}",
	"\telse",
	"\t\treturn Quit;",
	"}",
	"",
	"CParserDriver::ActionType\tCParserDriver::ProcessErrorParseThruErrorShift()",
	"{",
	"\tint\t\treduce_function_return;",
	"",
	"\tmachine_state\t= stack_ptr->state;",
	"\taction\t\t= action_table[machine_state * terminal_count_e + error_token];",
	"\t\t",
	"\tswitch (MapActionToType(action))",
	"\t{",
	"\t\tcase Shift:",
	"\t\t{",
	"\t\t\tmachine_state =",
	"\t\t\t\t\tgoto_table[machine_state * symbol_count_a + error_token];",
	"",
	"\t\t\tstack_ptr++;",
	"\t\t\tstack_ptr->state\t= machine_state;",
	"\t\t\tstack_ptr->type\t\t= StackError;",
	"\t\t\tstack_ptr->token\t= error_token;",
	"\t\t\tstack_count++;",
	"",
	"\t\t\tif (stack_count == stack_size)",
	"\t\t\t\tDoubleStack();",
	"",
	"\t\t\terror_stack_count = stack_count;",
	"",
	"\t\t\twhile (error_stack_count >= error_stack_size)",
	"\t\t\t\tDoubleErrorStack();",
	"",
	"\t\t\tfor (int i=error_stack_count-1; i>=0; i--)",
	"\t\t\t\terror_stack[i] = stack[i];",
	"",
	"\t\t\terror_stack_ptr\t= error_stack + (error_stack_count - 1);",
	"",
	"\t\t\tinput_token_fifo.Clear();",
	"\t\t\tinput_token_fifo_listptr\t= 0;",
	"\t\t\tsynchronization_count\t\t= 0;",
	"\t\t\tstack_modification_flag\t\t= false;",
	"\t\t}",
	"\t\treturn ShiftErrorToken;",
	"",
	"\t\tcase Reduce:",
	"\t\t{",
	"\t\t\tint\t\trule_right_length = rule_right_length_table[action];",
	"",
	"\t\t\tstack_ptr -= rule_right_length;",
	"",
	"\t\t\tmachine_state = stack_ptr->state;",
	"\t\t\tmachine_state = goto_table[machine_state * symbol_count_a +",
	"\t\t\t\t\t\t\t\t\t\t\trule_left_symbol_table[action]];",
	"\t\t\tstack_ptr++;",
	"\t\t\tstack_ptr->state\t\t\t= machine_state;",
	"\t\t\tstack_ptr->reduce_action\t= action;",
	"\t\t\tstack_count -= (rule_right_length - 1);",
	"",
	"\t\t\tif (stack_count == stack_size)",
	"\t\t\t\tDoubleStack();",
	"",
	"\t\t\tif (call_reduce_function_flag)",
	"\t\t\t{",
	"\t\t\t\treduce_function_return = CallReduceFunction(action, 0);",
	"",
	"\t\t\t\tif (reduce_function_return == -1)",
	"\t\t\t\t{",
	"\t\t\t\t\tcode_generation_error_flag = true;",
	"\t\t\t\t}",
	"\t\t\t}",
	"\t\t\telse",
	"\t\t\t{",
	"\t\t\t\tstack_ptr->type = StackNonTerminal;",
	"\t\t\t}",
	"\t\t}",
	"\t\treturn Reduce;",
	"",
	"\t\tcase Accept:",
	"\t\tcase Error:",
	"\t\tcase Conflict:",
	"\t\treturn Quit;",
	"\t}",
	"}",
	"",
	"CParserDriver::ActionType\tCParserDriver::ProcessErrorParseAfterErrorShift()",
	"{",
	"\tCStackElement\tstack_element;",
	"",
	"\tif (input_token_fifo_listptr)",
	"\t{",
	"\t\tCStackElement\t&se = input_token_fifo.Data(input_token_fifo_listptr);",
	"",
	"\t\ttoken = se.token;",
	"\t}",
	"\telse",
	"\t{",
	"\t\twhile (true)",
	"\t\t{",
	"\t\t\ttoken = lexical->GetToken();",
	"",
	"\t\t\tif (halt_parser_flag)",
	"\t\t\t{",
	"\t\t\t\tif (error_reporting_flag)",
	"\t\t\t\t{",
	"\t\t\t\t\tstring\ts;",
	"",
	"\t\t\t\t\t*error_output_stream << \"Parser Halted: \";",
	"\t\t\t\t\t*error_output_stream << lexical->GetLexicalStatusString(s);",
	"\t\t\t\t\t*error_output_stream << endl;",
	"\t\t\t\t}",
	"",
	"\t\t\t\treturn Quit;",
	"\t\t\t}",
	"\t\t\telse if (token < 0)",
	"\t\t\t{",
	"\t\t\t\tlexical_error_flag = true;",
	"",
	"\t\t\t\tif (error_reporting_flag)",
	"\t\t\t\t{",
	"\t\t\t\t\tstring\ts;",
	"",
	"\t\t\t\t\t*error_output_stream << \"Lexical Error: \";",
	"\t\t\t\t\t*error_output_stream << lexical->GetLexicalStatusString(s);",
	"\t\t\t\t\t*error_output_stream << endl;",
	"\t\t\t\t}",
	"",
	"\t\t\t\tif (!discard_lexical_error_flag)",
	"\t\t\t\t\treturn Quit;",
	"\t\t\t}",
	"\t\t\telse if (token == empty_symbol_token && lexical_stack.Size())",
	"\t\t\t{",
	"\t\t\t\tPopLexical();",
	"\t\t\t}",
	"\t\t\telse",
	"\t\t\t\tbreak;",
	"\t\t}",
	"",
	"\t\tlexical->LoadStackElement(&stack_element);",
	"",
	"\t\tinput_token_fifo.PushBack(stack_element);",
	"",
	"\t\tinput_token_fifo_listptr = input_token_fifo.LastListPtr();",
	"\t}",
	"",
	"\tmachine_state\t= error_stack_ptr->state;",
	"\taction\t\t\t= action_table[machine_state * terminal_count_e + token];",
	"\t\t",
	"\tswitch (MapActionToType(action))",
	"\t{",
	"\t\tcase Shift:",
	"\t\t{",
	"\t\t\tmachine_state =",
	"\t\t\t\t\tgoto_table[machine_state * symbol_count_a + token];",
	"",
	"\t\t\terror_stack_ptr++;",
	"\t\t\terror_stack_ptr->state\t= machine_state;",
	"\t\t\terror_stack_ptr->type\t= StackLiteralToken;",
	"\t\t\terror_stack_ptr->token\t= token;",
	"\t\t\terror_stack_count++;",
	"",
	"\t\t\tif (error_stack_count == error_stack_size)",
	"\t\t\t\tDoubleErrorStack();",
	"",
	"\t\t\tsynchronization_count++;",
	"",
	"\t\t\tif (synchronization_count == synchronization_length)",
	"\t\t\t{",
	"\t\t\t\tinput_token_fifo_listptr = input_token_fifo.FirstListPtr();",
	"",
	"\t\t\t\tsynchronization_count = 0;",
	"",
	"\t\t\t\treturn InputSynchronized;",
	"\t\t\t}",
	"\t\t\telse",
	"\t\t\t\tinput_token_fifo.NextListPtr(input_token_fifo_listptr);",
	"",
	"\t\t\tstack_modification_flag = true;",
	"\t\t}",
	"\t\treturn Shift;",
	"",
	"\t\tcase Reduce:",
	"\t\t{",
	"\t\t\tint\t\trule_right_length = rule_right_length_table[action];",
	"",
	"\t\t\terror_stack_ptr -= rule_right_length;",
	"\t\t\t\t",
	"\t\t\tmachine_state = error_stack_ptr->state;",
	"\t\t\tmachine_state = goto_table[machine_state * symbol_count_a +",
	"\t\t\t\t\t\t\t\t\t\t\trule_left_symbol_table[action]];",
	"\t\t\terror_stack_ptr++;",
	"\t\t\terror_stack_ptr->state\t\t\t= machine_state;",
	"\t\t\terror_stack_ptr->type\t\t\t= StackNonTerminal;",
	"\t\t\terror_stack_ptr->reduce_action\t= action;",
	"\t\t\terror_stack_count -= (rule_right_length - 1);",
	"",
	"\t\t\tif (error_stack_count == error_stack_size)",
	"\t\t\t\tDoubleErrorStack();",
	"",
	"\t\t\tstack_modification_flag = true;",
	"\t\t}",
	"\t\treturn Reduce;",
	"",
	"\t\tcase Accept:",
	"\t\tend_of_file_flag = true;",
	"\t\treturn Accept;",
	"",
	"\t\tcase Error:",
	"\t\tcase Conflict:",
	"\t\t{",
	"\t\t\tif (token == empty_symbol_token)",
	"\t\t\t\treturn Quit;",
	"",
	"\t\t\tinput_token_fifo_listptr\t= input_token_fifo.PopFront();",
	"\t\t\tsynchronization_count\t\t= 0;",
	"",
	"\t\t\tif (stack_modification_flag)",
	"\t\t\t{",
	"\t\t\t\terror_stack_count = stack_count;",
	"",
	"\t\t\t\tfor (int i=error_stack_count-1; i>=0; i--)",
	"\t\t\t\t\terror_stack[i] = stack[i];",
	"",
	"\t\t\t\terror_stack_ptr = error_stack + (error_stack_count - 1);",
	"",
	"\t\t\t\tstack_modification_flag = false;",
	"\t\t\t}",
	"\t\t}",
	"\t\treturn DiscardToken;",
	"\t}",
	"}",
	"",
	"CParserDriver::ActionType\tCParserDriver::ProcessErrorParseSynchronized()",
	"{",
	"\tint\t\treduce_function_return;",
	"",
	"\tCStackElement\t&se = input_token_fifo.Data(input_token_fifo_listptr);",
	"",
	"\ttoken = se.token;",
	"",
	"\tmachine_state\t= stack_ptr->state;",
	"\taction\t\t\t= action_table[machine_state * terminal_count_e + token];",
	"\t\t",
	"\tswitch (MapActionToType(action))",
	"\t{",
	"\t\tcase Shift:",
	"\t\t{",
	"\t\t\tmachine_state = goto_table[machine_state * symbol_count_a + token];",
	"",
	"\t\t\tstack_ptr++;",
	"",
	"\t\t\t*stack_ptr = se;",
	"",
	"\t\t\tstack_ptr->state = machine_state;",
	"",
	"\t\t\tstack_count++;",
	"",
	"\t\t\tif (stack_count == stack_size)",
	"\t\t\t\tDoubleStack();",
	"",
	"\t\t\tinput_token_fifo.NextListPtr(input_token_fifo_listptr);",
	"",
	"\t\t\tsynchronization_count++;",
	"",
	"\t\t\tif (synchronization_count == synchronization_length)",
	"\t\t\t\treturn SynchronizationComplete;",
	"\t\t}",
	"\t\treturn Shift;",
	"",
	"\t\tcase Reduce:",
	"\t\t{",
	"\t\t\tint\t\trule_right_length = rule_right_length_table[action];",
	"",
	"\t\t\tstack_ptr -= rule_right_length;",
	"",
	"\t\t\tmachine_state = stack_ptr->state;",
	"\t\t\tmachine_state = goto_table[machine_state * symbol_count_a +",
	"\t\t\t\t\t\t\t\t\t\t\trule_left_symbol_table[action]];",
	"\t\t\tstack_ptr++;",
	"\t\t\tstack_ptr->state\t\t\t= machine_state;",
	"\t\t\tstack_ptr->reduce_action\t= action;",
	"\t\t\tstack_count -= (rule_right_length - 1);",
	"",
	"\t\t\tif (stack_count == stack_size)",
	"\t\t\t\tDoubleStack();",
	"",
	"\t\t\tif (call_reduce_function_flag)",
	"\t\t\t{",
	"\t\t\t\treduce_function_return = CallReduceFunction(action, 0);",
	"",
	"\t\t\t\tif (reduce_function_return == -1)",
	"\t\t\t\t{",
	"\t\t\t\t\tcode_generation_error_flag\t= true;",
	"\t\t\t\t}",
	"\t\t\t}",
	"\t\t\telse",
	"\t\t\t{",
	"\t\t\t\tstack_ptr->type = StackNonTerminal;",
	"\t\t\t}",
	"\t\t}",
	"\t\treturn Reduce;",
	"",
	"\t\tcase Accept:",
	"\t\tcase Error:",
	"\t\tcase Conflict:",
	"\t\treturn Quit;",
	"\t}",
	"}",
	0
};
