/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef COMPILERINTERFACE_H
#define COMPILERINTERFACE_H

#include <qapplication.h>
#include <qdesktopwidget.h>
#include <qregexp.h>

class CCompilerInterface;

#include "compilerCalculate.h"
#include "interfaceControl.h"
#include "undefinedView.h"
#include "terminalView.h"
#include "errorTokenView.h"
#include "nonterminalView.h"
#include "implicitView.h"
#include "precedenceView.h"
#include "ruleView.h"
#include "parserDialog.h"
#include "conflictEntryView.h"
#include "conflictStatusView.h"
#include "conflictActionView.h"
#include "conflictCodeView.h"
#include "errorSelectView.h"
#include "errorCodeView.h"
#include "terminalSelectView.h"
#include "terminalCodeView.h"
#include "ruleSelectView.h"
#include "ruleCodeView.h"
#include "classCodeView.h"
#include "machineView.h"
#include "sourceView.h"
#include "simulateControlView.h"
#include "simulateInputView.h"
#include "simulateTreeView.h"

class CCompilerInterface: public CInterfaceControl
{
	Q_OBJECT
	public:
	CCompilerInterface(int c_id, int i_id, CMainViewMenu *mvm, CMainWindow *mw);
	virtual ~CCompilerInterface();

	CCompilerData	*GetCompilerData() const
	{ return compiler_data; }
	void			SetCompilerData(CCompilerData *d)
	{ delete compiler_data; compiler_data = d; }

	virtual void	InitializeModulePointers();
	virtual void	SetModulePointer(CSubView *sv, const string &type);
	virtual void	EnableInterfaceMenu();
	virtual void	DisableInterfaceMenu();

	static CInterfaceControl	*CreateInterfaceControl(
					int c_id, int i_id, CMainViewMenu *mvm, CMainWindow *mw);

	static void		CreateNewData();
	static bool		LoadData(ifstream &f);
	static void		LoadDataError();
	virtual void	PostApplicationData();
	virtual void    SetApplicationData();
	virtual bool    SaveData(ofstream &f);

	virtual CSubView	*CreateSubView(	QWidget *p,
										CViewNode *n,
										CInterfaceControl *ic,
										SMainViewControl *mvc,
										const string &dfs,
										CPaletteData *dpd,
										COptionData::SSubViewData *d);

	public slots:
	void	ModifyStartContext();
	void	InsertAfterTerminal();
	void	InsertBeforeTerminal();
	void	EditTerminal();
	void	DeleteTerminal();
	void	MoveTerminalUp();
	void	MoveTerminalDown();
	void	InsertAfterErrorToken();
	void	InsertBeforeErrorToken();
	void	EditErrorToken();
	void	DeleteErrorToken();
	void	MoveErrorTokenUp();
	void	MoveErrorTokenDown();
	void	InsertAfterNonTerminal();
	void	InsertBeforeNonTerminal();
	void	EditNonTerminal();
	void	DeleteNonTerminal();
	void	MoveNonTerminalUp();
	void	MoveNonTerminalDown();
	void	InsertAfterPrecedence();
	void	InsertBeforePrecedence();
	void	EditPrecedence();
	void	DeletePrecedence();
	void	MovePrecedenceUp();
	void	MovePrecedenceDown();
	void	InsertAfterRule();
	void	InsertBeforeRule();
	void	EditRule();
	void	DeleteRule();
	void	MoveRuleUp();
	void	MoveRuleDown();
	void	UndoGrammar();
	void	CalculateDialog();
	void	ErrorEntriesDialog();
	void	UnitRulesDialog();
	void	GenerateCodeDialog();
	void	FindStringTerminal();
	void	UndoEditTerminal();
	void	RedoEditTerminal();
	void	ClearTerminal();
	void	FindStringRule();
	void	UndoEditRule();
	void	RedoEditRule();
	void	ClearRule();
	void	FindStringClass();
	void	UndoEditClass();
	void	RedoEditClass();
	void	ClearClass();
	void	FindStringConflict();
	void	UndoEditConflict();
	void	RedoEditConflict();
	void	ClearConflict();
	void	FindStringError();
	void	UndoEditError();
	void	RedoEditError();
	void	ClearError();
	void	OpenSource();
	void	SaveSource();
	void	FindStringSource();
	void	UndoEditSource();
	void	RedoEditSource();
	void	ClearSource();
	void	SetSimulatorControlOptions();
	void	ResetSimulator();
	void	NextSimulatorOperation();
	void	RunSimulator();
	void	ExpandSimulatorParseTree();
	void	OpenSimulateInput();
	void	SaveSimulateInput();
	void	FindStringSimulateInput();
	void	UndoEditSimulateInput();
	void	RedoEditSimulateInput();
	void	ClearSimulateInput();

	public:
	static CCompilerData					*compiler_data_load;
	static vector< pair<string, int> >		subview_types;
	static map< string, set<string> >		subview_connection_map;
	static void								SetupSubviewTypeData();

	static void		SetupConfiguration(	vector<SInterfaceConfiguration> &c,
										CIdGenerator &submenu_id_generator);
	static void		SetupSubmenuNodeData(
							vector< pair<int, SSubmenuNodeData *> > &d,
							CIdGenerator &submenu_id_generator);

	CUndefinedView			*undefined_view;
	CTerminalView			*terminal_view;
	CErrorTokenView			*error_token_view;
	CNonTerminalView		*nonterminal_view;
	CImplicitView			*implicit_view;
	CPrecedenceView			*precedence_view;
	CRuleView				*rule_view;
	CConflictEntryView		*conflict_entry_view;
	CConflictStatusView		*conflict_status_view;
	CConflictActionView		*conflict_action_view;
	CConflictCodeView		*conflict_code_view;
	CErrorSelectView		*error_select_view;
	CErrorCodeView			*error_code_view;
	CTerminalSelectView		*terminal_select_view;
	CTerminalCodeView		*terminal_code_view;
	CRuleSelectView			*rule_select_view;
	CRuleCodeView			*rule_code_view;
	CClassCodeView			*class_code_view;
	CMachineView			*machine_view;
	CSourceView				*source_view;
	CSimulateControlView	*simulate_control_view;
	CSimulateInputView		*simulate_input_view;
	CSimulateTreeView		*simulate_tree_view;

	CCompilerData		*compiler_data;
	CCompilerData		*undo_data;
	strstream			*undo_buffer;
	CCompilerCalculate	*compiler_calculate;

	CCompilerCalculate	*GetCompilerCalculate() const
	{ return compiler_calculate; }

	void	StoreUndoData();
	void	RestoreUndoData();

	void	EnableParserSubmenu();
	void	SetMultiLineEditTabStopWidth();
	void	SetSimulateInputViewWordWrap();
	void	CalculateMachine(
				bool calculate_l,
				CCompilerData::FiniteStateMachineType l_type,
				int range,
				bool calculate_p,
				CCompilerData::ParserType p_type);
	void	CalculateErrorEntries(	CCompilerData::ErrorCalculation c,
									CCompilerData::ErrorFunctionNumbering n,
									CCompilerData::ErrorFunctionAggregation a);
	void	CalculateUnitRuleElimination(bool calculate);
	void	GenerateCode(	bool generate_l,
							bool generate_p,
							bool generate_b,
							bool unit_rule_flag,
							string &directory,
							string &l_prefix,
							string &p_prefix,
							string &b_prefix,
							bool tty = false,
							bool rm_table = false);
	string	&MachineStatusString(string &s);
	string	&LexicalStatusString(string &s);
	string	&ParserStatusString(string &s);
	string	&ConflictSectionStatusString(string &s);
	string	&ErrorEntriesStatusString(string &s);
	string	&ErrorCodeSectionStatusString(string &s);
	string	&UnitRuleEliminationStatusString(string &s);
	string	&GenerateCodeStatusString(string &s);
	bool	GetLexicalCalculated() const
	{ return compiler_calculate->GetLexicalCalculated(); }
	bool	GetParserCalculated() const
	{ return compiler_calculate->GetParserCalculated(); }
	bool	GetErrorEntriesNumbered() const
	{ return compiler_calculate->GetErrorEntriesNumbered(); }
	bool	GetErrorEntriesCalculated() const
	{ return compiler_calculate->GetErrorEntriesCalculated(); }
	bool	GetUnitRuleEliminationCalculated() const
	{ return compiler_calculate->GetUnitRuleEliminationCalculated(); }
	CParse			*GetParser() const
	{ return compiler_calculate->GetParser(); }
	CAutomaton		*GetAutomaton() const
	{ return compiler_calculate->GetAutomaton(); }

	struct SGrammarSubmenuNodeData
	{
		enum Operations
		{
			grammar_submenu_interface_enable	= 0,
			grammar_submenu_interface_disable	= 1,
			grammar_submenu_operation_count		= 2
		};

		const int		node_type;
		const char		*tree_index;
		const int		node_identifier;
		const char		*text;
		const int		accelerator;
		const char		*slot;
		const int		operation_list[grammar_submenu_operation_count];
	};

	static int		GetGrammarSubmenuNodeCount(
						const SGrammarSubmenuNodeData *d);

	static int									grammar_submenu_id;
	static const	SGrammarSubmenuNodeData		grammar_submenu_node_data[];

	struct SParserSubmenuNodeData
	{
		enum Operations
		{
			parser_submenu_interface_calculate_enable		= 0,
			parser_submenu_interface_generate_code_enable	= 1,
			parser_submenu_interface_error_entries_enable	= 2,
			parser_submenu_interface_unit_rules_enable		= 3,
			parser_submenu_interface_disable				= 4,
			parser_submenu_operation_count					= 5
		};

		const int		node_type;
		const char		*tree_index;
		const int		node_identifier;
		const char		*text;
		const int		accelerator;
		const char		*slot;
		const int		operation_list[parser_submenu_operation_count];
	};

	static int		GetParserSubmenuNodeCount(
						const SParserSubmenuNodeData *d);

	static int									parser_submenu_id;
	static const	SParserSubmenuNodeData		parser_submenu_node_data[];

	struct SCodeSubmenuNodeData
	{
		enum Operations
		{
			code_submenu_interface_enable	= 0,
			code_submenu_interface_disable	= 1,
			code_submenu_operation_count	= 2
		};

		const int		node_type;
		const char		*tree_index;
		const int		node_identifier;
		const char		*text;
		const int		accelerator;
		const char		*slot;
		const int		operation_list[code_submenu_operation_count];
	};

	static int		GetCodeSubmenuNodeCount(
						const SCodeSubmenuNodeData *d);

	static int									code_submenu_id;
	static const	SCodeSubmenuNodeData		code_submenu_node_data[];

	struct SSimulateSubmenuNodeData
	{
		enum Operations
		{
			simulate_submenu_interface_enable	= 0,
			simulate_submenu_interface_disable	= 1,
			simulate_submenu_operation_count	= 2
		};

		const int		node_type;
		const char		*tree_index;
		const int		node_identifier;
		const char		*text;
		const int		accelerator;
		const char		*slot;
		const int		operation_list[simulate_submenu_operation_count];
	};

	static int		GetSimulateSubmenuNodeCount(
						const SSimulateSubmenuNodeData *d);

	static int									simulate_submenu_id;
	static const	SSimulateSubmenuNodeData	simulate_submenu_node_data[];

	static const char * const	compiler_default_1024x768[];
	static const char * const	compiler_default_1280x1024[];
	static const char * const	compiler_default_1400x1050[];
};

#endif
