/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "conflictActionView.h"

void	CConflictActionListBox::InitializePalette(const QPalette &p)
{
	active_highlight			= p.color(	QPalette::Active,
											QColorGroup::Highlight);
	active_highlighted_text		= p.color(	QPalette::Active,
											QColorGroup::HighlightedText);
	inactive_highlight			= p.color(	QPalette::Inactive,
											QColorGroup::Highlight);
	inactive_highlighted_text	= p.color(	QPalette::Inactive,
											QColorGroup::HighlightedText);

	QPalette	focus_palette = p;

	focus_palette.setColor(	QPalette::Active,
							QColorGroup::Highlight,
							inactive_highlight);

	focus_palette.setColor(	QPalette::Active,
							QColorGroup::HighlightedText,
							inactive_highlighted_text);

	setPalette(focus_palette);
}

void	CConflictActionListBox::focusInEvent(QFocusEvent *e)
{
	QPalette	p = palette();

	p.setColor(	QPalette::Active,
				QColorGroup::Highlight,
				active_highlight);

	p.setColor(	QPalette::Active,
				QColorGroup::HighlightedText,
				active_highlighted_text);

	setPalette(p);

	CListBoxFc::focusInEvent(e);
}

void	CConflictActionListBox::focusOutEvent(QFocusEvent *e)
{
	QPalette	p = palette();

	p.setColor(	QPalette::Active,
				QColorGroup::Highlight,
				inactive_highlight);

	p.setColor(	QPalette::Active,
				QColorGroup::HighlightedText,
				inactive_highlighted_text);

	setPalette(p);

	CListBoxFc::focusOutEvent(e);
}

CConflictActionVBoxWidget::CConflictActionVBoxWidget(
									QWidget *parent,
									CCompilerInterface *ci,
									SMainViewControl *mvc,
									COptionData::SSubViewData *d,
									CConflictActionView *cav)
	: CVBoxWidget(parent, ci, mvc), compiler_interface(ci),
		subview_data(d), conflict_action_view(cav),
		module_ptr_map(cav->GetModulePtrMap())
{
	label = new CLabelFc("action", this, true);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	list_box = new CConflictActionListBox(this);

	setSpacing(0);
	setStretchFactor(label, 0);
	setStretchFactor(list_box, 1);

	compiler_data = compiler_interface->GetCompilerData();
}

CConflictActionVBoxWidget::~CConflictActionVBoxWidget()
{
}

void	CConflictActionVBoxWidget::InitializeModulePointers()
{
}

void	CConflictActionVBoxWidget::ClearListBox()
{
	list_box->clear();
}

void	CConflictActionVBoxWidget::UpdateListBox(	const list<string> &items,
													int current)
{
	disconnect(	list_box,
				SIGNAL(highlighted(int)),
				this,
				SLOT(SelectConflictAction(int)));

	list_box->clear();

	list<string>::const_iterator	s_iterator = items.begin();

	while (s_iterator != items.end())
		new Q3ListBoxText(list_box, (*s_iterator++).c_str());

	list_box->setCurrentItem(current);

	connect(list_box,
			SIGNAL(highlighted(int)),
			this,
			SLOT(SelectConflictAction(int)));
}

void	CConflictActionVBoxWidget::SetCurrentListBoxItem(int current)
{
	disconnect(	list_box,
				SIGNAL(highlighted(int)),
				this,
				SLOT(SelectConflictAction(int)));

	list_box->setCurrentItem(current);

	connect(list_box,
			SIGNAL(highlighted(int)),
			this,
			SLOT(SelectConflictAction(int)));
}

void	CConflictActionVBoxWidget::SelectConflictAction(int index)
{
	vector<CSubView *>		&v1 = module_ptr_map["CONFLICT_ENTRY_VIEW"];

	if (v1.size())
	{
		CConflictEntryView	*cev = dynamic_cast<CConflictEntryView *>(v1[0]);

		cev->SelectConflictAction(index);
	}
}

void	CConflictActionVBoxWidget::RestoreUndoData()
{
	compiler_data = compiler_interface->GetCompilerData();
}

CConflictActionView::CConflictActionView(	QWidget *p,
											CViewNode *n,
											CInterfaceControl *ic,
											SMainViewControl *mvc,
											const string &dfs,
											CPaletteData *dpd,
											COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CConflictActionVBoxWidget(
		p, dynamic_cast<CCompilerInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
	{
		frame->setPalette(view_node_palette);
		frame->InitializePalette(view_node_palette);
	}
	else
	{
		frame->setPalette(frame->palette());
		frame->InitializePalette(frame->palette());
	}
}

CConflictActionView::~CConflictActionView()
{
	delete frame;
}

void	CConflictActionView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CConflictActionView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CConflictActionView::InitializeModulePointers()
{
	frame->InitializeModulePointers();
}

void	CConflictActionView::ClearListBox()
{
	frame->ClearListBox();
}

void	CConflictActionView::UpdateListBox(	const list<string> &items,
											int current)
{
	frame->UpdateListBox(items, current);
}

void	CConflictActionView::SetCurrentListBoxItem(int current)
{
	frame->SetCurrentListBoxItem(current);
}

void	CConflictActionView::RestoreUndoData()
{
	frame->RestoreUndoData();
}
