/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "conflictCodeView.h"

bool	CConflictCodeMultiLineEdit::event(QEvent *e)
{
	bool	tab_flag = conflict_code_vbox->GetTabIndicator();

	if (e->type() == QEvent::KeyPress)
	{
		if (((QKeyEvent *)e)->key() == Qt::Key_Escape)
		{
			conflict_code_vbox->ToggleTabIndicator();

			if (!tab_flag)
			{
				this->keyPressEvent((QKeyEvent *)e);
				return true;
			}
		}
		else
		{
			if (((QKeyEvent *)e)->key() == Qt::Key_F1)
				conflict_code_vbox->ToggleConflictIndicator();
			else if (((QKeyEvent *)e)->key() == Qt::Key_G &&
				((QKeyEvent *)e)->state() == Qt::ControlButton)
				conflict_code_vbox->FindString();

			if (tab_flag)
			{
				this->keyPressEvent((QKeyEvent *)e);
				return true;
			}
		}
	}
	else if (e->type() == QEvent::KeyRelease)
	{
		if (tab_flag)
		{
			this->keyReleaseEvent((QKeyEvent *)e);
			return true;
		}
	}

	return CMultiLineEditFc::event(e);
}

CConflictCodeVBoxWidget::CConflictCodeVBoxWidget(
									QWidget *parent,
									CCompilerInterface *ci,
									SMainViewControl *mvc,
									COptionData::SSubViewData *d,
									CConflictCodeView *ccv)
	: CVBoxWidget(parent, ci, mvc), compiler_interface(ci),
		subview_data(d), conflict_code_view(ccv),
		module_ptr_map(ccv->GetModulePtrMap())
{
	label = new CLabelFc("conflict code", this, true);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	tab_indicator		= false;
	conflict_indicator	= false;

	multi_line_edit = new CConflictCodeMultiLineEdit(this);

	multi_line_edit->setWordWrap(Q3MultiLineEdit::NoWrap);

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	setSpacing(0);
	setStretchFactor(label, 0);
	setStretchFactor(multi_line_edit, 1);

	compiler_data = compiler_interface->GetCompilerData();
}

CConflictCodeVBoxWidget::~CConflictCodeVBoxWidget()
{
}

void	CConflictCodeVBoxWidget::ClearMultiLineEditText()
{
	disconnect(	multi_line_edit,
				SIGNAL(textChanged()),
				this,
				SLOT(CodeTextChanged()));

	multi_line_edit->clear();

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	if (conflict_indicator)
	{
		conflict_indicator = false;

		ToggleConflictIndicator();
	}
}

void	CConflictCodeVBoxWidget::SetTabStopWidth(int count)
{
	QFontMetrics	fm(font());

	int		w = fm.width(QChar('Z'));

	multi_line_edit->setTabStopWidth(count * w);
}

void	CConflictCodeVBoxWidget::SetMultiLineEditText(const list<string> &code)
{
	disconnect(	multi_line_edit,
				SIGNAL(textChanged()),
				this,
				SLOT(CodeTextChanged()));

	multi_line_edit->clear();

	list<string>::const_iterator	s_iterator = code.begin();

	while (s_iterator != code.end())
	{
		const string	&s = *s_iterator++;

		if (!s.length())
			multi_line_edit->append("\n");
		else
			multi_line_edit->append(s.c_str());
	}

	multi_line_edit->setCursorPosition(0, 0);

	connect(multi_line_edit,
			SIGNAL(textChanged()),
			this,
			SLOT(CodeTextChanged()));

	if (conflict_indicator)
	{
		conflict_indicator = false;

		ToggleConflictIndicator();
	}
}

void	CConflictCodeVBoxWidget::GetMultiLineEditText(list<string> &code)
{
	code.clear();

	int		count = multi_line_edit->numLines();
	int		i;

	for (i=0; i<count; i++)
		code.push_back(
			(const char *)(multi_line_edit->textLine(i).local8Bit()));

	if (code.back() == string(""))
		code.pop_back();
}

bool	CConflictCodeVBoxWidget::GetCodeEditedFlag()
{
	return multi_line_edit->edited();
}

void	CConflictCodeVBoxWidget::SetCodeEditedFlag(bool f)
{
	multi_line_edit->setEdited(f);
}

bool	CConflictCodeVBoxWidget::GetTabIndicator()
{
	return tab_indicator;
}

void	CConflictCodeVBoxWidget::ToggleTabIndicator()
{
	string	s1("conflict code");
	string	s2;

	if (tab_indicator)
	{
		tab_indicator = false;
	}
	else
	{
		s1 += " (tab entry)";

		tab_indicator = true;
	}

	if (conflict_indicator)
	{
		if (cev)
			cev->GetCurrentEntryString(s2);

		s1 += ": ";
		s1 += s2;

		label->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	}
	else
		label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	label->setText(s1.c_str());
}

void	CConflictCodeVBoxWidget::ToggleConflictIndicator()
{
	string	s1("conflict code");
	string	s2;

	if (tab_indicator)
		s1 += " (tab entry)";

	if (conflict_indicator)
	{
		label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

		conflict_indicator = false;
	}
	else
	{
		if (cev)
			cev->GetCurrentEntryString(s2);

		s1 += ": ";
		s1 += s2;

		label->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);

		conflict_indicator = true;
	}

	label->setText(s1.c_str());
}

void	CConflictCodeVBoxWidget::UndoEdit()
{
	multi_line_edit->undo();
}

void	CConflictCodeVBoxWidget::RedoEdit()
{
	multi_line_edit->redo();
}

void	FindMultiLineEditString(Q3MultiLineEdit *multi_line_edit);

void	CConflictCodeVBoxWidget::FindString()
{
	FindMultiLineEditString(multi_line_edit);
}

void	CConflictCodeVBoxWidget::InitializeModulePointers()
{
	vector<CSubView *>		&v1 = module_ptr_map["CONFLICT_ENTRY_VIEW"];

	if (v1.size())
		cev = dynamic_cast<CConflictEntryView *>(v1[0]);
	else
		cev = 0;
}

void	CConflictCodeVBoxWidget::RestoreUndoData()
{
	compiler_data = compiler_interface->GetCompilerData();
}

void	CConflictCodeVBoxWidget::CodeTextChanged()
{
	if (cev)
		cev->CodeTextChanged();
}

CConflictCodeView::CConflictCodeView(	QWidget *p,
										CViewNode *n,
										CInterfaceControl *ic,
										SMainViewControl *mvc,
										const string &dfs,
										CPaletteData *dpd,
										COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CConflictCodeVBoxWidget(
		p, dynamic_cast<CCompilerInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
		frame->setPalette(view_node_palette);
	else
		frame->setPalette(frame->palette());
}

CConflictCodeView::~CConflictCodeView()
{
	delete frame;
}

void	CConflictCodeView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CConflictCodeView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CConflictCodeView::InitializeModulePointers()
{
	frame->InitializeModulePointers();
}

void	CConflictCodeView::ClearMultiLineEditText()
{
	frame->ClearMultiLineEditText();
}

void	CConflictCodeView::SetTabStopWidth(int count)
{
	frame->SetTabStopWidth(count);
}

void	CConflictCodeView::SetMultiLineEditText(const list<string> &code)
{
	frame->SetMultiLineEditText(code);
}

void	CConflictCodeView::GetMultiLineEditText(list<string> &code)
{
	frame->GetMultiLineEditText(code);
}

bool	CConflictCodeView::GetCodeEditedFlag()
{
	return frame->GetCodeEditedFlag();
}

void	CConflictCodeView::SetCodeEditedFlag(bool f)
{
	frame->SetCodeEditedFlag(f);
}

void	CConflictCodeView::UndoEdit()
{
	frame->UndoEdit();
}

void	CConflictCodeView::RedoEdit()
{
	frame->RedoEdit();
}

void	CConflictCodeView::FindString()
{
	frame->FindString();
}

void	CConflictCodeView::RestoreUndoData()
{
	frame->RestoreUndoData();
}
