/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef CONFLICTSTATUSVIEW_H
#define	CONFLICTSTATUSVIEW_H

class CConflictStatusControl;
class CConflictStatusVBoxWidget;
class CConflictStatusView;

#include <qobject.h>
#include <qwidget.h>
#include <qfont.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "conflictEntryView.h"

class CConflictStatusControl: public CFrameFc
{
	Q_OBJECT
	public:
	CConflictStatusControl(CConflictStatusVBoxWidget *v);
	~CConflictStatusControl() { }

	virtual void	setFont(const QFont &f);

	void	ClearStatusControl();
	void	UpdateStatusControl(const string &entry,
								const string &state,
								const string &symbol,
								const string &action);

	public slots:
	void	ClearCodeCurrentEntry();
	void	DefaultResetCurrentEntry();
	void	ClearCodeAll();
	void	DefaultResetAll();

	private:
	CConflictStatusVBoxWidget	*conflict_status_vbox;
	CLabelFc					*entry_label;
	CLabelFc					*entry_value;
	CLabelFc					*state_label;
	CLabelFc					*state_value;
	CLabelFc					*symbol_label;
	CLabelFc					*symbol_value;
	CLabelFc					*action_label;
	CLabelFc					*action_value;
	QGridLayout					*subgrid_layout;
	CPushButtonFc				*clear_code_button;
	CPushButtonFc				*default_reset_button;
	CPushButtonFc				*clear_all_button;
	CPushButtonFc				*default_all_button;
};

class CConflictStatusVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CConflictStatusVBoxWidget(	QWidget *parent,
								CCompilerInterface *ci,
								SMainViewControl *mvc,
								COptionData::SSubViewData *d,
								CConflictStatusView *csv);

	virtual ~CConflictStatusVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	ClearStatusControl();
	void	UpdateStatusControl(const string &entry,
								const string &state,
								const string &symbol,
								const string &action);

	void	ClearCodeCurrentEntry();
	void	DefaultResetCurrentEntry();
	void	ClearCodeAll();
	void	DefaultResetAll();
	void	RestoreUndoData();

	private:
	CLabelFc					*label;
	CConflictStatusControl		*conflict_status_control;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CConflictStatusView			*conflict_status_view;
	ModulePtrMap				&module_ptr_map;
};

class CConflictStatusView: public CSubView
{
	public:
	CConflictStatusView(QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CConflictStatusView();

	virtual CConflictStatusVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ClearStatusControl();
	void	UpdateStatusControl(const string &entry,
								const string &state,
								const string &symbol,
								const string &action);
	void	RestoreUndoData();

	private:
	CConflictStatusVBoxWidget		*frame;
};

#endif
