/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "defaultView.h"

CDefaultFrameWidget::CDefaultFrameWidget(	QWidget *parent,
											CDefaultInterface *di,
											SMainViewControl *mvc,
											COptionData::SSubViewData *d,
											CDefaultView *dv)
	: CFrameWidget(parent, di, mvc), default_interface(di),
		subview_data(d), default_view(dv)
{
	QFontInfo		fi(font());

	int		pixel_size = fi.pixelSize();

	int		m = grid_layout_margin_data[pixel_size];
	int		s = grid_layout_spacing_data[pixel_size];

	grid_layout = new QGridLayout(this, 1, 1, m, s);

	grid_layout->setRowStretch(0, 1);
	grid_layout->setColStretch(0, 1);

	ostrstream		text_stream;
	vector<int>		*v = d->GetIndex();

	CDefaultData::CreateIndexText(text_stream, *v);

	text_stream << endl << '\0';

	index_text = text_stream.str();

	CDefaultData	*dd = default_interface->GetDefaultData();

	default_text = dd->GetData(	mvc->view_data->GetMainViewName(),
								*d->GetIndex());

	if (!default_text.length())
		default_text = "DEFAULT_VIEW";

	label = new CLabelFc((index_text + default_text).c_str(), this);

	label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	grid_layout->addWidget(label, 0, 0);
}

CDefaultFrameWidget::~CDefaultFrameWidget()
{
}

void	CDefaultFrameWidget::SetLabelText(const QString &s)
{
	default_text = (const char *)(s.local8Bit());

	CDefaultData	*dd = default_interface->GetDefaultData();

	dd->SetData(GetMainViewControl()->GetViewData()->GetMainViewName(),
				*subview_data->GetIndex(),
				default_text);

	default_interface->SetDataModifiedFlag(true);

	label->setText((index_text + default_text).c_str());
}

CDefaultView::CDefaultView(	QWidget *p,
							CViewNode *n,
							CInterfaceControl *ic,
							SMainViewControl *mvc,
							const string &dfs,
							CPaletteData *dpd,
							COptionData::SSubViewData *d)
	: CSubView(p, n, ic, mvc, dfs, dpd, d)
{
	frame = new CDefaultFrameWidget(
		p, dynamic_cast<CDefaultInterface *>(ic), mvc, d, this);

	QFont		view_node_font;
	QPalette	view_node_palette;

	if (SetupViewNodeFont(view_node_font))
		frame->setFont(view_node_font);
	else
		frame->setFont(frame->font());

	if (SetupViewNodePalette(view_node_palette))
		frame->setPalette(view_node_palette);
	else
		frame->setPalette(frame->palette());
}

CDefaultView::~CDefaultView()
{
	delete frame;
}

void	CDefaultView::SetHighlightPalette(CPaletteData *pd)
{
	restore_palette = frame->palette();

	QPalette	highlight_palette;

	pd->SetupPalette(highlight_palette);

	frame->setPalette(highlight_palette);
}

void	CDefaultView::RestorePalette()
{
	frame->setPalette(restore_palette);
}

void	CDefaultView::SetLabelText(const QString &s)
{
	frame->SetLabelText(s);
}
