/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef ERRORSELECTVIEW_H
#define	ERRORSELECTVIEW_H

class CErrorSelectControl;
class CErrorSelectListView;
class CErrorSelectVBoxWidget;
class CErrorSelectView;

#include <qobject.h>
#include <qwidget.h>
#include <q3listview.h>
#include <q3header.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "errorCodeView.h"
#include "optionDialog.h"

class CErrorSelectControl: public CFrameFc
{
	Q_OBJECT
	public:
	CErrorSelectControl(CErrorSelectVBoxWidget *v);
	~CErrorSelectControl() { }

	void	ClearSelectControl();
	void	UpdateSelectControl(const string &s);

	public slots:
	void	ClearCodeCurrentFunction();
	void	ClearCodeAll();
	void	EditErrorToken();

	private:
	CErrorSelectVBoxWidget		*error_select_vbox;
	CPushButtonFc				*clear_code_button;
	CPushButtonFc				*clear_all_button;
	CPushButtonFc				*edit_token_button;
	CLabelFc					*label;
};

class CErrorSelectListView: public Q3ListView
{
	Q_OBJECT
	public:
	CErrorSelectListView(CErrorSelectVBoxWidget *v)
		: Q3ListView((QWidget *)v, 0, 0), error_select_vbox(v) { }
	~CErrorSelectListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	keyPressEvent(QKeyEvent *e);
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);
	virtual void	mouseDoubleClickEvent(QMouseEvent *e);

	private:
	CErrorSelectVBoxWidget	*error_select_vbox;
	QColor					active_highlight;
	QColor					active_highlighted_text;
	QColor					inactive_highlight;
	QColor					inactive_highlighted_text;
};

class CErrorSelectVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CErrorSelectVBoxWidget(	QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CErrorSelectView *esv);

	virtual ~CErrorSelectVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	UpdateListView();
	void	ClearCodeCurrentFunction();
	void	ClearCodeAll();
	void	EditErrorToken();
	void	GetCurrentFunctionString(string &s);
	void	PostCurrentFunctionChanges();
	int		GetSimulatorErrorToken(int index);
	void	RestoreUndoData();
	void	CodeTextChanged();

	public slots:
	void	SelectErrorFunction(Q3ListViewItem *item);

	private:
	struct SErrorData
	{
		SErrorData() { }
		SErrorData(int st, int sy, int t = -1)
			: state(st), symbol(sy), token(t), token_string("(none)") { }

		int		state;
		int		symbol;
		string	function_string;
		int		token;
		string	token_string;
	};

	CLabelFc				*label;
	CErrorSelectControl		*error_select_control;
	CErrorSelectListView	*list_view;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CErrorSelectView			*error_select_view;
	ModulePtrMap				&module_ptr_map;

	CErrorCodeView			*ecv;

	CSymbolInformation		*symbols;
	SErrorData				*error_data;
	int						number_of_error_functions;

	bool	error_entries_numbered;
	int		state_index_width;
	int		symbol_index_width;
	int		current_function;
	void	IndexString(int index, string &s);
	void	UpdateErrorViews();
};

class CErrorSelectView: public CSubView
{
	public:
	CErrorSelectView(	QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CErrorSelectView();

	virtual CErrorSelectVBoxWidget	*GetWidget() { return frame; }
	virtual void					SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	UpdateListView();
	void	ClearCodeCurrentFunction();
	void	ClearCodeAll();
	void	EditErrorToken();
	void	GetCurrentFunctionString(string &s);
	void	PostCurrentFunctionChanges();
	int		GetSimulatorErrorToken(int index);
	void	RestoreUndoData();
	void	CodeTextChanged();

	private:
	CErrorSelectVBoxWidget		*frame;
};

#endif
