/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "helpViewer.h"

CHelpNavigateWidget::CHelpNavigateWidget(CHelpViewer *v)
	: CFrameFc((QWidget *)v, 1, 4), help_viewer(v)
{
	grid_layout->setRowStretch(0, 1);

	grid_layout->setColStretch(0, 0);
	grid_layout->setColStretch(1, 0);
	grid_layout->setColStretch(2, 0);
	grid_layout->setColStretch(3, 1);

	QString		size_string("#########");

	backward_button	= new CPushButtonFc("Backward", this, size_string);
	forward_button	= new CPushButtonFc("Forward", this, size_string);
	home_button		= new CPushButtonFc("Home", this, size_string);
	help_label		= new CLabelFc("CPG User Guide", this);

	backward_button->setEnabled(false);
	forward_button->setEnabled(false);
	help_label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);

	grid_layout->addWidget(backward_button,			0, 0);
	grid_layout->addWidget(forward_button,			0, 1);
	grid_layout->addWidget(home_button,				0, 2);
	grid_layout->addWidget(help_label,				0, 3);

	connect(backward_button,
			SIGNAL(clicked()),
			SLOT(NavigateBackward()));

	connect(forward_button,
			SIGNAL(clicked()),
			SLOT(NavigateForward()));

	connect(home_button,
			SIGNAL(clicked()),
			SLOT(NavigateHome()));
}

void	CHelpNavigateWidget::SetBackwardEnabled(bool f)
{
	backward_button->setEnabled(f);
}

void	CHelpNavigateWidget::SetForwardEnabled(bool f)
{
	forward_button->setEnabled(f);
}

void	CHelpNavigateWidget::NavigateBackward()
{
	help_viewer->NavigateBackward();
}

void	CHelpNavigateWidget::NavigateForward()
{
	help_viewer->NavigateForward();
}

void	CHelpNavigateWidget::NavigateHome()
{
	help_viewer->NavigateHome();
}

CHelpViewer::CHelpViewer(QWidget *parent)
	: Q3VBox(parent, 0,
		Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu |
		Qt::WStyle_MinMax | Qt::WStyle_Customize | Qt::WType_TopLevel)
{
	help_navigate_widget	= new CHelpNavigateWidget(this);
	text_browser			= new Q3TextBrowser(this);

	text_browser->setFrameStyle(QFrame::Panel | QFrame::Sunken);

	QStringList		sl;

	sl.append(".");
	sl.append("./doc");
	sl.append("./doc/html");

	char	*ev = getenv("CPGDIR");

	if (ev)
	{
		sl.append(QString(ev));
		sl.append(QString(ev) + "/doc");
		sl.append(QString(ev) + "/doc/html");
		sl.append(QString(ev) + "/doc/stl");
	}

	text_browser->mimeSourceFactory()->setFilePath(sl);

	setSpacing(0);
	setStretchFactor(help_navigate_widget, 0);
	setStretchFactor(text_browser, 1);

	setCaption("CPG User Guide");

	connect(text_browser,
			SIGNAL(backwardAvailable(bool)),
			SLOT(BackwardAvailable(bool)));

	connect(text_browser,
			SIGNAL(forwardAvailable(bool)),
			SLOT(ForwardAvailable(bool)));
}

void	CHelpViewer::NavigateBackward()
{
	text_browser->backward();
}

void	CHelpViewer::NavigateForward()
{
	text_browser->forward();
}

void	CHelpViewer::NavigateHome()
{
	text_browser->home();
}

void	CHelpViewer::SetHTMLSource(const QString &s)
{
	text_browser->setSource(s);
}

void	CHelpViewer::BackwardAvailable(bool available)
{
	help_navigate_widget->SetBackwardEnabled(available);
}

void	CHelpViewer::ForwardAvailable(bool available)
{
	help_navigate_widget->SetForwardEnabled(available);
}
