/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef IDGENERATOR_H
#define IDGENERATOR_H

using namespace std;

#include <list>
#include <iostream>
#include <iomanip>

class CIdGenerator
{
	public:
	CIdGenerator(int s = default_initial_size);
	~CIdGenerator();

	enum rvalue
	{
		NoError		= 0,
		OutOfRange	= 1,
		DuplicateId	= 2,
	};

	int			GetId();
	rvalue		ReturnId(int id);

	const list<int>	&GetIdList() const;

	private:
	int			initial_size;
	int			current_size;
	list<int>	id_list;

	static const int	default_initial_size;
};

ostream		&operator<<(ostream &s, const CIdGenerator &idg);

#endif
