/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "compilerData.h"
#include "compilerCalculate.h"

int     main(int argc, char *argv[])
{
	istream		*f			= &cin;
	bool		file_flag	= false;
	int			index		= 1;

	string	directory(".");
	bool	parser_data(false);

	while (index < argc)
    {
		if (!strcmp(argv[index], "-d"))
		{
			if (index == argc - 1)
			{
				cout << "Missing directory path." << endl;

				if (file_flag)
				{
					dynamic_cast<ifstream *>(f)->close();
					delete f;
				}

				exit(1);
			}

			index++;

			directory = argv[index];
		}
		else if (!strcmp(argv[index], "-p"))
			parser_data = true;
		else if (!file_flag)
		{
			f = new ifstream(argv[index]);

			if (!*f)
			{
				cout << "Bad file path: " << argv[index] << endl;
				delete f;
				exit(1);
			}

			file_flag = true;
		}

		index++;
    }

	CCompilerData	compiler_data;

	compiler_data.InitializeStackCode();

	*f >> compiler_data;

	if (file_flag)
	{
		dynamic_cast<ifstream *>(f)->close();
		delete f;
	}

	CCompilerCalculate	compiler_calculate(&compiler_data);

	bool	status_flag;
	string	status_string;

	status_flag = compiler_calculate.CalculateLexical();

	cout << compiler_calculate.LexicalStatusString(status_string);

	if (!status_flag)
		exit(2);

	status_flag = compiler_calculate.CalculateParser();

	cout << compiler_calculate.ParserStatusString(status_string);

	if (!status_flag)
		exit(3);

	if (compiler_calculate.GetParserCalculated())
	{
		status_flag = compiler_calculate.ValidateConflictSections();

		cout << compiler_calculate.ConflictSectionStatusString(status_string);

		if (status_flag)
			compiler_calculate.ModifyConflictActions();
		else
			exit(4);
		
		compiler_calculate.CalculateErrorEntries();

		cout << compiler_calculate.ErrorEntriesStatusString(status_string);

		status_flag = compiler_calculate.ValidateErrorCodeSections();

		cout << compiler_calculate.ErrorCodeSectionStatusString(status_string);

		if (!status_flag)
			exit(5);
	}

	if (compiler_calculate.GetErrorEntriesCalculated())
	{
		compiler_calculate.CalculateUnitRuleElimination();

		cout << compiler_calculate.UnitRuleEliminationStatusString(
															status_string);
	}

	bool	generate_l		= compiler_calculate.GetLexicalCalculated();
	bool	generate_p		= compiler_calculate.GetParserCalculated();
	bool	generate_b		= compiler_data.GetGenerateBaseClasses();
	bool	unit_rule_flag	=
					compiler_calculate.GetUnitRuleEliminationCalculated();

	status_flag = compiler_calculate.GenerateCode(	generate_l,
													generate_p,
													generate_b,
													unit_rule_flag,
													directory);

	cout << endl;
	cout << compiler_calculate.GenerateCodeStatusString(status_string);

	if (!status_flag)
		exit(6);

	if (parser_data && compiler_calculate.GetParserCalculated())
	{
		int		count = compiler_calculate.GetParser()->machine_count;
		int		i;
		string	s;

		switch (compiler_data.GetParserType())
		{
			case CCompilerData::LR_1:

			cout << "LR(1) Machine States" << endl << endl;

			for (i=0; i<count; i++)
			{
				cout << "**** State " << i << endl;
				cout << compiler_calculate.LR1MachineStateString(i, s) << endl;
			}

			break;

			case CCompilerData::LALR_1:

			cout << "LR(0) Machine States" << endl << endl;

			for (i=0; i<count; i++)
			{
				cout << "**** State " << i << endl;
				cout << compiler_calculate.LR0MachineStateString(i, s) << endl;
			}

			cout << "LALR(1) Lookahead Terminals" << endl << endl;

			for (i=0; i<count; i++)
			{
				cout << "**** State " << i << endl;
				cout << compiler_calculate.LALR1LookaheadString(i, s) << endl;
			}

			break;

			case CCompilerData::SLR_1:

			cout << "LR(0) Machine States" << endl << endl;

			for (i=0; i<count; i++)
			{
				cout << "**** State " << i << endl;
				cout << compiler_calculate.LR0MachineStateString(i, s) << endl;
			}

			cout << "SLR(1) Lookahead Terminals" << endl << endl;

			for (i=0; i<count; i++)
			{
				cout << "**** State " << i << endl;
				cout << compiler_calculate.SLR1LookaheadString(i, s) << endl;
			}

			break;
		}
	}
}
