/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#include "regexpParserDriver.h"


CRegexpParserDriver::CRegexpParserDriver()
    : CParserDriver(
        Regexp_Terminal_Count_E,
        Regexp_Symbol_Count_A,
        Regexp_Rule_Count_A,
        Regexp_Parser_Empty_Symbol_Token,
        Regexp_Shift_Action,
        Regexp_Accept_Action,
        Regexp_Conflict_Entry,
        Regexp_State_Count,
        Regexp_Number_Of_Conflict_Entries,
        Regexp_Number_Of_Error_Indexes,
        Regexp_Action_Table,
        Regexp_Goto_Table,
        Regexp_Rule_Left_Symbol_Table,
        Regexp_Rule_Right_Length_Table)
{
    reduce_functions =
    new (int (CRegexpParserDriver::*[Regexp_Rule_Count_A - 1])(void *));

    conflict_functions =
    new (void (CRegexpParserDriver::*[Regexp_Number_Of_Conflict_Entries])());

    error_functions =
    new (void (CRegexpParserDriver::*[Regexp_Number_Of_Error_Indexes + 1])());

    SetupFunctionTables();

	escape_lexical	= new CLexicalSingleCharDriver(escape_char_token_names);
	escape_parser	= new CEscapeParserDriver();

	escape_parser->SetLexical(escape_lexical);
}

CRegexpParserDriver::~CRegexpParserDriver()
{
    delete [] reduce_functions;
    delete [] conflict_functions;
    delete [] error_functions;

	delete escape_parser;
	delete escape_lexical;
}

int     CRegexpParserDriver::CallReduceFunction(int action, void *data)
{
    return (this->*reduce_functions[action])(data);
}

void    CRegexpParserDriver::CallConflictFunction(int index)
{
    (this->*conflict_functions[index])();
}

void    CRegexpParserDriver::CallErrorFunction(int index)
{
    (this->*error_functions[index])();
}

void    CRegexpParserDriver::DeleteGeneratedCode(CStackElement *s, int c)
{
    for (int i=c-1; i>=0; i--)
    {
        CStackElement   &se = s[i];

        if (se.type == StackCharArray)
            delete [] se.char_array;
        else if (se.type == StackData)
            (this->*reduce_functions[se.reduce_action])(se.data);
    }
}

//  rule reduce function definitions for CRegexpParserDriver

//  00  * start         ->  context
//
int     CRegexpParserDriver::Reduce_00(void *data)
{
	if (!data)
	{
	}
	else
		delete (CContext *)data;

	return 0;
}

//  01    start         ->  <  string_seq  >  context
//
int     CRegexpParserDriver::Reduce_01(void *data)
{
	if (!data)
	{
		VListPtrChar	*sequence_list	= (VListPtrChar *)STACK_DATA(1);
		CContext		*context		= (CContext *)STACK_DATA(3);

		context->SetStartActivations(*sequence_list);

		delete sequence_list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = context;
	}
	else
		delete (CContext *)data;

	return 0;
}

//  02    start         ->  context  <  string_seq  >
//
int     CRegexpParserDriver::Reduce_02(void *data)
{
	if (!data)
	{
		CContext		*context		= (CContext *)STACK_DATA(0);
		VListPtrChar	*sequence_list	= (VListPtrChar *)STACK_DATA(2);

		context->SetStartAssignments(*sequence_list);

		delete sequence_list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = context;
	}
	else
		delete (CContext *)data;

	return 0;
}

//  03    start         ->  <  string_seq  >  context  <  string_seq  >
//
int     CRegexpParserDriver::Reduce_03(void *data)
{
	if (!data)
	{
		VListPtrChar	*sequence_list1	= (VListPtrChar *)STACK_DATA(1);
		CContext		*context		= (CContext *)STACK_DATA(3);
		VListPtrChar	*sequence_list2	= (VListPtrChar *)STACK_DATA(5);

		context->SetStartActivations(*sequence_list1);
		context->SetStartAssignments(*sequence_list2);

		delete sequence_list1;
		delete sequence_list2;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = context;
	}
	else
		delete (CContext *)data;

	return 0;
}

//  04    string_seq    ->  string
//
int     CRegexpParserDriver::Reduce_04(void *data)
{
	if (!data)
	{
		VListInt	*symbol_list = (VListInt *)STACK_DATA(0);

		int		length	= symbol_list->Size();
		int		index	= 0;

		char	*char_string = new char[length + 1];

		VListIntPtr		listptr = symbol_list->FirstListPtr();

		while (listptr)
			char_string[index++] = symbol_list->NextData(listptr);

		char_string[index] = '\0';

		delete symbol_list;

		VListPtrChar	*sequence_list = new VListPtrChar(10);

		sequence_list->PushBack(char_string);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = sequence_list;
	}
	else
	{
		VListPtrChar		*sequence_list	= (VListPtrChar *)data;
		VListPtrCharPtr		listptr			= sequence_list->FirstListPtr();

		while (listptr)
			delete [] sequence_list->NextData(listptr);

		delete sequence_list;
	}

	return 0;
}

//  05    string_seq    ->  string_seq  ,  string
//
int     CRegexpParserDriver::Reduce_05(void *data)
{
	if (!data)
	{
		VListInt	*symbol_list = (VListInt *)STACK_DATA(2);

		int		length	= symbol_list->Size();
		int		index	= 0;

		char	*char_string = new char[length + 1];

		VListIntPtr		listptr = symbol_list->FirstListPtr();

		while (listptr)
			char_string[index++] = symbol_list->NextData(listptr);

		char_string[index] = '\0';

		delete symbol_list;

		VListPtrChar	*sequence_list = (VListPtrChar *)STACK_DATA(0);

		sequence_list->PushBack(char_string);
	}
	else
	{
		VListPtrChar		*sequence_list	= (VListPtrChar *)data;
		VListPtrCharPtr		listptr			= sequence_list->FirstListPtr();

		while (listptr)
			delete [] sequence_list->NextData(listptr);

		delete sequence_list;
	}

	return 0;
}

//  06    context       ->  regexp
//
int     CRegexpParserDriver::Reduce_06(void *data)
{
	if (!data)
	{
		CContext	*context = new CContext((CNdAutomaton *)STACK_DATA(0));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = context;
	}
	else
		delete (CContext *)data;

	return 0;
}

//  07    context       ->  regexp  /  regexp
//
int     CRegexpParserDriver::Reduce_07(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd0 = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*nd2 = (CNdAutomaton *)STACK_DATA(2);

		nd0->SetPrefixFinalFlags();

		CNdAutomaton	*nd = NdCat(nd0, nd2);

		CContext	*context = new CContext(nd);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = context;
	}
	else
		delete (CContext *)data;

	return 0;
}

//  08  * regexp        ->  or_expr
//
int     CRegexpParserDriver::Reduce_08(void *data)
{
	if (!data)
	{
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  09    regexp        ->  regexp  |  or_expr
//
int     CRegexpParserDriver::Reduce_09(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd[2];
		nd[0] = (CNdAutomaton *)STACK_DATA(0);
		nd[1] = (CNdAutomaton *)STACK_DATA(2);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = NdOr(nd, 2);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  10  * or_expr       ->  subexpr
//
int     CRegexpParserDriver::Reduce_10(void *data)
{
	if (!data)
	{
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  11    or_expr       ->  or_expr  subexpr
//
int     CRegexpParserDriver::Reduce_11(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd0 = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*nd1 = (CNdAutomaton *)STACK_DATA(1);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = NdCat(nd0, nd1);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  12  * subexpr       ->  p_expr
//
int     CRegexpParserDriver::Reduce_12(void *data)
{
	if (!data)
	{
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  13  * subexpr       ->  repeat_expr
//
int     CRegexpParserDriver::Reduce_13(void *data)
{
	if (!data)
	{
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  14  * subexpr       ->  char_seq
//
int     CRegexpParserDriver::Reduce_14(void *data)
{
	if (!data)
	{
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  15  * subexpr       ->  quotation
//
int     CRegexpParserDriver::Reduce_15(void *data)
{
	if (!data)
	{
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  16    subexpr       ->  string  p_expr
//
int     CRegexpParserDriver::Reduce_16(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(0);
		CNdAutomaton	*nd0	= NdSymbolString(*list);
		CNdAutomaton	*nd1 	= (CNdAutomaton *)STACK_DATA(1);

		delete list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = NdCat(nd0, nd1);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  17    subexpr       ->  string  repeat_expr
//
int     CRegexpParserDriver::Reduce_17(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(0);
		CNdAutomaton	*nd0	= NdSymbolString(*list);
		CNdAutomaton	*nd1 	= (CNdAutomaton *)STACK_DATA(1);

		delete list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = NdCat(nd0, nd1);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  18    subexpr       ->  string  quotation
//
int     CRegexpParserDriver::Reduce_18(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(0);
		CNdAutomaton	*nd0	= NdSymbolString(*list);
		CNdAutomaton	*nd1 	= (CNdAutomaton *)STACK_DATA(1);

		delete list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = NdCat(nd0, nd1);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  19    subexpr       ->  char_seq  p_expr
//
int     CRegexpParserDriver::Reduce_19(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd0 = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*nd1 = (CNdAutomaton *)STACK_DATA(1);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = NdCat(nd0, nd1);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  20    subexpr       ->  char_seq  repeat_expr
//
int     CRegexpParserDriver::Reduce_20(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd0 = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*nd1 = (CNdAutomaton *)STACK_DATA(1);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = NdCat(nd0, nd1);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  21    subexpr       ->  char_seq  quotation
//
int     CRegexpParserDriver::Reduce_21(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd0 = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*nd1 = (CNdAutomaton *)STACK_DATA(1);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = NdCat(nd0, nd1);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  22    p_expr        ->  (  regexp  )
//
int     CRegexpParserDriver::Reduce_22(void *data)
{
	if (!data)
	{
		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = STACK_DATA(1);
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  23    repeat_expr   ->  character  repeat_char
//
int     CRegexpParserDriver::Reduce_23(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd = NdSymbol(STACK_UNSIGNED_CHAR(0));
		CNdAutomaton	*ndr;

		int		repeat_char = STACK_UNSIGNED_CHAR(1);

		switch (repeat_char)
		{
			case '*':
			ndr = NdZeroOrMore(nd);
			break;

			case '+':
			ndr = NdMOrMore(nd, 1);
			break;

			case '?':
			ndr = NdZeroToN(nd, 1);
			break;
		}

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ndr;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  24    repeat_expr   ->  class_char  repeat_char
//
int     CRegexpParserDriver::Reduce_24(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*ndr;

		int		repeat_char = STACK_UNSIGNED_CHAR(1);

		switch (repeat_char)
		{
			case '*':
			ndr = NdZeroOrMore(nd);
			break;

			case '+':
			ndr = NdMOrMore(nd, 1);
			break;

			case '?':
			ndr = NdZeroToN(nd, 1);
			break;
		}

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ndr;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  25    repeat_expr   ->  quotation  repeat_char
//
int     CRegexpParserDriver::Reduce_25(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*ndr;

		int		repeat_char = STACK_UNSIGNED_CHAR(1);

		switch (repeat_char)
		{
			case '*':
			ndr = NdZeroOrMore(nd);
			break;

			case '+':
			ndr = NdMOrMore(nd, 1);
			break;

			case '?':
			ndr = NdZeroToN(nd, 1);
			break;
		}

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ndr;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  26    repeat_expr   ->  p_expr  repeat_char
//
int     CRegexpParserDriver::Reduce_26(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*ndr;

		int		repeat_char = STACK_UNSIGNED_CHAR(1);

		switch (repeat_char)
		{
			case '*':
			ndr = NdZeroOrMore(nd);
			break;

			case '+':
			ndr = NdMOrMore(nd, 1);
			break;

			case '?':
			ndr = NdZeroToN(nd, 1);
			break;
		}

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ndr;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  27    repeat_expr   ->  character  repeat_range
//
int     CRegexpParserDriver::Reduce_27(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd = NdSymbol(STACK_UNSIGNED_CHAR(0));
		CNdAutomaton	*ndr;

		int		lower_bound = STACK_RANGE_INT_LOWER_BOUND(1);
		int		upper_bound = STACK_RANGE_INT_UPPER_BOUND(1);

		if (lower_bound > upper_bound)
			ndr = NdMOrMore(nd, lower_bound);
		else
			ndr = NdMToN(nd, lower_bound, upper_bound);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ndr;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  28    repeat_expr   ->  class_char  repeat_range
//
int     CRegexpParserDriver::Reduce_28(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*ndr;

		int		lower_bound = STACK_RANGE_INT_LOWER_BOUND(1);
		int		upper_bound = STACK_RANGE_INT_UPPER_BOUND(1);

		if (lower_bound > upper_bound)
			ndr = NdMOrMore(nd, lower_bound);
		else
			ndr = NdMToN(nd, lower_bound, upper_bound);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ndr;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  29    repeat_expr   ->  quotation  repeat_range
//
int     CRegexpParserDriver::Reduce_29(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*ndr;

		int		lower_bound = STACK_RANGE_INT_LOWER_BOUND(1);
		int		upper_bound = STACK_RANGE_INT_UPPER_BOUND(1);

		if (lower_bound > upper_bound)
			ndr = NdMOrMore(nd, lower_bound);
		else
			ndr = NdMToN(nd, lower_bound, upper_bound);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ndr;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  30    repeat_expr   ->  p_expr  repeat_range
//
int     CRegexpParserDriver::Reduce_30(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd = (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*ndr;

		int		lower_bound = STACK_RANGE_INT_LOWER_BOUND(1);
		int		upper_bound = STACK_RANGE_INT_UPPER_BOUND(1);

		if (lower_bound > upper_bound)
			ndr = NdMOrMore(nd, lower_bound);
		else
			ndr = NdMToN(nd, lower_bound, upper_bound);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = ndr;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  31  * repeat_char   ->  *
//
int     CRegexpParserDriver::Reduce_31(void *data)
{
    return 0;
}

//  32  * repeat_char   ->  +
//
int     CRegexpParserDriver::Reduce_32(void *data)
{
    return 0;
}

//  33  * repeat_char   ->  ?
//
int     CRegexpParserDriver::Reduce_33(void *data)
{
    return 0;
}

//  34    repeat_range  ->  {  digit_seq  ,  digit_seq  }
//
int     CRegexpParserDriver::Reduce_34(void *data)
{
	VListInt	*digit_list1 = (VListInt *)STACK_DATA(1);
	VListInt	*digit_list2 = (VListInt *)STACK_DATA(3);

	int		length1 = digit_list1->Size();
	int		length2 = digit_list2->Size();

	char	lower_bound_char[length1 + 1];
	char	upper_bound_char[length2 + 1];

	int				index	= 0;
	VListIntPtr		listptr	= digit_list1->FirstListPtr();

	while (listptr)
		lower_bound_char[index++] = digit_list1->NextData(listptr);

	lower_bound_char[index] = '\0';

	index	= 0;
	listptr	= digit_list2->FirstListPtr();

	while (listptr)
		upper_bound_char[index++] = digit_list2->NextData(listptr);

	upper_bound_char[index] = '\0';

	delete digit_list1;
	delete digit_list2;

	STACK_TYPE(0)					= STACK_TYPE_SCALAR;
	STACK_RANGE_INT_LOWER_BOUND(0)	= atoi(lower_bound_char);
	STACK_RANGE_INT_UPPER_BOUND(0)	= atoi(upper_bound_char);

	return 0;
}

//  35    repeat_range  ->  {  digit_seq  ,  }
//
int     CRegexpParserDriver::Reduce_35(void *data)
{
	VListInt	*digit_list1 = (VListInt *)STACK_DATA(1);

	int		length1 = digit_list1->Size();

	char	lower_bound_char[length1 + 1];

	int				index	= 0;
	VListIntPtr		listptr	= digit_list1->FirstListPtr();

	while (listptr)
		lower_bound_char[index++] = digit_list1->NextData(listptr);

	lower_bound_char[index] = '\0';

	delete digit_list1;

	STACK_TYPE(0)					= STACK_TYPE_SCALAR;
	STACK_RANGE_INT_LOWER_BOUND(0)	= atoi(lower_bound_char);
	STACK_RANGE_INT_UPPER_BOUND(0)	= -1;

	return 0;
}

//  36    repeat_range  ->  {  ,  digit_seq  }
//
int     CRegexpParserDriver::Reduce_36(void *data)
{
	VListInt	*digit_list2 = (VListInt *)STACK_DATA(2);

	int		length2 = digit_list2->Size();

	char	upper_bound_char[length2 + 1];

	int				index	= 0;
	VListIntPtr		listptr	= digit_list2->FirstListPtr();

	while (listptr)
		upper_bound_char[index++] = digit_list2->NextData(listptr);

	upper_bound_char[index] = '\0';

	delete digit_list2;

	STACK_TYPE(0)					= STACK_TYPE_SCALAR;
	STACK_RANGE_INT_LOWER_BOUND(0)	= 0;
	STACK_RANGE_INT_UPPER_BOUND(0)	= atoi(upper_bound_char);

	return 0;
}

//  37    char_seq      ->  string
//
int     CRegexpParserDriver::Reduce_37(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(0);
		CNdAutomaton	*nd		= NdSymbolString(*list);

		delete list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = nd;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  38  * char_seq      ->  class_char
//
int     CRegexpParserDriver::Reduce_38(void *data)
{
	if (!data)
	{
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  39    char_seq      ->  string  class_char
//
int     CRegexpParserDriver::Reduce_39(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(0);
		CNdAutomaton	*nd0	= NdSymbolString(*list);
		CNdAutomaton	*nd1	= (CNdAutomaton *)STACK_DATA(1);

		delete list;
		CNdAutomaton	*nd = NdCat(nd0, nd1);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = nd;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  40    char_seq      ->  char_seq  string
//
int     CRegexpParserDriver::Reduce_40(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd0	= (CNdAutomaton *)STACK_DATA(0);
		VListInt		*list	= (VListInt *)STACK_DATA(1);
		CNdAutomaton	*nd1	= NdSymbolString(*list);

		delete list;
		CNdAutomaton	*nd = NdCat(nd0, nd1);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = nd;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  41    char_seq      ->  char_seq  class_char
//
int     CRegexpParserDriver::Reduce_41(void *data)
{
	if (!data)
	{
		CNdAutomaton	*nd0	= (CNdAutomaton *)STACK_DATA(0);
		CNdAutomaton	*nd1	= (CNdAutomaton *)STACK_DATA(1);

		CNdAutomaton	*nd = NdCat(nd0, nd1);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = nd;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  42    string        ->  character
//
int     CRegexpParserDriver::Reduce_42(void *data)
{
	if (!data)
	{
		VListInt	*symbol_list = new VListInt(20);

		symbol_list->PushBack(STACK_UNSIGNED_CHAR(0));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = symbol_list;
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  43    string        ->  string  character
//
int     CRegexpParserDriver::Reduce_43(void *data)
{
	if (!data)
	{
		((VListInt *)STACK_DATA(0))->PushBack(STACK_UNSIGNED_CHAR(1));
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  44  * character     ->  text_char
//
int     CRegexpParserDriver::Reduce_44(void *data)
{
    return 0;
}

//  45  * character     ->  escape_char
//
int     CRegexpParserDriver::Reduce_45(void *data)
{
    return 0;
}

//  46    quotation     ->  "  quote_seq  "
//
int     CRegexpParserDriver::Reduce_46(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(1);
		CNdAutomaton	*nd		= NdSymbolString(*list);

		delete list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = nd;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  47    quote_seq     ->  quote_char
//
int     CRegexpParserDriver::Reduce_47(void *data)
{
	if (!data)
	{
		VListInt	*quote_seq = new VListInt(20);

		quote_seq->PushBack(STACK_UNSIGNED_CHAR(0));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = quote_seq;
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  48    quote_seq     ->  quote_seq  quote_char
//
int     CRegexpParserDriver::Reduce_48(void *data)
{
	if (!data)
	{
		((VListInt *)STACK_DATA(0))->PushBack(STACK_UNSIGNED_CHAR(1));
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  49    class_char    ->  .
//
int     CRegexpParserDriver::Reduce_49(void *data)
{
	if (!data)
	{
		VListInt	list(101);

		list.PushBack('\t');
		list.PushBack('\v');
		list.PushBack('\b');
		list.PushBack('\r');
		list.PushBack('\f');
		list.PushBack('\a');

		for (int i=32; i<=126; i++)
			list.PushBack(i);

		CNdAutomaton	*nd = NdSymbolClass(list);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = nd;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  50    class_char    ->  [  class_seq  ]
//
int     CRegexpParserDriver::Reduce_50(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(1);
		CNdAutomaton	*nd		= 0;

		if (list->FirstData() == '\\')
		{
			int		length = list->Size();

			unsigned char	escape_char[length + 1];

			int				index	= 0;
			VListIntPtr		listptr	= list->FirstListPtr();

			while (listptr)
				escape_char[index++] = list->NextData(listptr);

			escape_char[index] = '\0';

			escape_lexical->SetInputBuffer(escape_char, length);
			escape_lexical->Initialize();
			escape_parser->InitializeSyntaxMode();

			CParserDriver::StatusCode	sc = escape_parser->ParseStream();

			if (sc == CParserDriver::EndOfFile)
			{
				CStackElement   *se = escape_parser->CompiledObject();

				int		lower_bound	= se->scalar.range_int.lower_bound;
				int		upper_bound	= se->scalar.range_int.upper_bound;

				lower_bound =	lower_bound < CNdAutomaton::input_range ?
								lower_bound : CNdAutomaton::input_range - 1;

				upper_bound =	upper_bound < CNdAutomaton::input_range ?
								upper_bound : CNdAutomaton::input_range - 1;

				if (lower_bound == upper_bound)
					nd = NdSymbol(lower_bound);
				else
				{
					VListInt	escape_list;

					for (int i=lower_bound; i<=upper_bound; i++)
						escape_list.PushBack(i);

					nd = NdSymbolClass(escape_list);
				}
			}
		}

		if (!nd)
			nd = NdSymbolClass(*list);

		delete list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = nd;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  51    class_char    ->  [  ^  class_seq  ]
//
int     CRegexpParserDriver::Reduce_51(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(2);
		CNdAutomaton	*nd		= NdSymbolComplement(*list);

		delete list;

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = nd;
	}
	else
	{
		CNdAutomaton	*nd = (CNdAutomaton *)data;

		nd->DeleteObjects();
		delete nd;
	}

	return 0;
}

//  52    class_seq     ->  class_item
//
int     CRegexpParserDriver::Reduce_52(void *data)
{
	if (!data)
	{
		VListInt	*symbol_list = new VListInt(10);

		symbol_list->PushBack(STACK_UNSIGNED_CHAR(0));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = symbol_list;
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  53  * class_seq     ->  class_range
//
int     CRegexpParserDriver::Reduce_53(void *data)
{
	if (!data)
	{
	}
	else
		delete (VListInt *)data;		

	return 0;
}

//  54    class_seq     ->  class_seq  class_item
//
int     CRegexpParserDriver::Reduce_54(void *data)
{
	if (!data)
	{
		((VListInt *)STACK_DATA(0))->PushBack(STACK_UNSIGNED_CHAR(1));
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  55    class_seq     ->  class_seq  class_range
//
int     CRegexpParserDriver::Reduce_55(void *data)
{
	if (!data)
	{
		VListInt		*list	= (VListInt *)STACK_DATA(1);
		VListIntPtr		listptr	= list->FirstListPtr();

		while (listptr)
			((VListInt *)STACK_DATA(0))->PushBack(list->NextData(listptr));
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  56  * class_item    ->  text_char
//
int     CRegexpParserDriver::Reduce_56(void *data)
{
    return 0;
}

//  57  * class_item    ->  escape_char
//
int     CRegexpParserDriver::Reduce_57(void *data)
{
    return 0;
}

//  58  * class_item    ->  special_char
//
int     CRegexpParserDriver::Reduce_58(void *data)
{
    return 0;
}

//  59    class_range   ->  class_item  -  class_item
//
int     CRegexpParserDriver::Reduce_59(void *data)
{
	if (!data)
	{
		VListInt	*symbol_list = new VListInt(100);

		int		first;
		int		last;

		if (STACK_UNSIGNED_CHAR(0) < STACK_UNSIGNED_CHAR(2))
		{
			first	= STACK_UNSIGNED_CHAR(0);
			last	= STACK_UNSIGNED_CHAR(2);
		}
		else
		{
			first	= STACK_UNSIGNED_CHAR(2);
			last	= STACK_UNSIGNED_CHAR(0);
		}

		for (int i=first; i<=last; i++)
			symbol_list->PushBack(i);

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = symbol_list;
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  60    digit_seq     ->  digit
//
int     CRegexpParserDriver::Reduce_60(void *data)
{
	if (!data)
	{
		VListInt	*digit_list = new VListInt(10);

		digit_list->PushBack(STACK_UNSIGNED_CHAR(0));

		STACK_TYPE(0) = STACK_TYPE_DATA;
		STACK_DATA(0) = digit_list;
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  61    digit_seq     ->  digit_seq  digit
//
int     CRegexpParserDriver::Reduce_61(void *data)
{
	if (!data)
	{
		((VListInt *)STACK_DATA(0))->PushBack(STACK_UNSIGNED_CHAR(1));
	}
	else
		delete (VListInt *)data;

	return 0;
}

//  62    escape_char   ->  \  text_char
//
int     CRegexpParserDriver::Reduce_62(void *data)
{
	switch (STACK_UNSIGNED_CHAR(1))
	{
		case 'n': STACK_UNSIGNED_CHAR(0) = '\n'; break;
		case 't': STACK_UNSIGNED_CHAR(0) = '\t'; break;
		case 'v': STACK_UNSIGNED_CHAR(0) = '\v'; break;
		case 'b': STACK_UNSIGNED_CHAR(0) = '\b'; break;
		case 'r': STACK_UNSIGNED_CHAR(0) = '\r'; break;
		case 'f': STACK_UNSIGNED_CHAR(0) = '\f'; break;
		case 'a': STACK_UNSIGNED_CHAR(0) = '\a'; break;
		default:  STACK_UNSIGNED_CHAR(0) = STACK_UNSIGNED_CHAR(1); break;
	}

	return 0;
}

//  63    escape_char   ->  \  special_char
//
int     CRegexpParserDriver::Reduce_63(void *data)
{
	STACK_UNSIGNED_CHAR(0) = STACK_UNSIGNED_CHAR(1);

	return 0;
}

//  64    escape_char   ->  \  "
//
int     CRegexpParserDriver::Reduce_64(void *data)
{
	STACK_UNSIGNED_CHAR(0) = STACK_UNSIGNED_CHAR(1);

	return 0;
}

//  65    escape_char   ->  \  \
//
int     CRegexpParserDriver::Reduce_65(void *data)
{
	STACK_UNSIGNED_CHAR(0) = STACK_UNSIGNED_CHAR(1);

	return 0;
}

//  66    escape_char   ->  \  [
//
int     CRegexpParserDriver::Reduce_66(void *data)
{
	STACK_UNSIGNED_CHAR(0) = STACK_UNSIGNED_CHAR(1);

	return 0;
}

//  67    escape_char   ->  \  ]
//
int     CRegexpParserDriver::Reduce_67(void *data)
{
	STACK_UNSIGNED_CHAR(0) = STACK_UNSIGNED_CHAR(1);

	return 0;
}

//  68  * quote_char    ->  text_char
//
int     CRegexpParserDriver::Reduce_68(void *data)
{
    return 0;
}

//  69  * quote_char    ->  escape_char
//
int     CRegexpParserDriver::Reduce_69(void *data)
{
    return 0;
}

//  70  * quote_char    ->  special_char
//
int     CRegexpParserDriver::Reduce_70(void *data)
{
    return 0;
}

//  71  * quote_char    ->  [
//
int     CRegexpParserDriver::Reduce_71(void *data)
{
    return 0;
}

//  72  * quote_char    ->  ]
//
int     CRegexpParserDriver::Reduce_72(void *data)
{
    return 0;
}

//  73  * text_char     ->  letter
//
int     CRegexpParserDriver::Reduce_73(void *data)
{
    return 0;
}

//  74  * text_char     ->  digit
//
int     CRegexpParserDriver::Reduce_74(void *data)
{
    return 0;
}

//  75  * text_char     ->  other
//
int     CRegexpParserDriver::Reduce_75(void *data)
{
    return 0;
}

//  76  * special_char  ->  space
//
int     CRegexpParserDriver::Reduce_76(void *data)
{
    return 0;
}

//  77  * special_char  ->  (
//
int     CRegexpParserDriver::Reduce_77(void *data)
{
    return 0;
}

//  78  * special_char  ->  )
//
int     CRegexpParserDriver::Reduce_78(void *data)
{
    return 0;
}

//  79  * special_char  ->  *
//
int     CRegexpParserDriver::Reduce_79(void *data)
{
    return 0;
}

//  80  * special_char  ->  +
//
int     CRegexpParserDriver::Reduce_80(void *data)
{
    return 0;
}

//  81  * special_char  ->  ?
//
int     CRegexpParserDriver::Reduce_81(void *data)
{
    return 0;
}

//  82  * special_char  ->  |
//
int     CRegexpParserDriver::Reduce_82(void *data)
{
    return 0;
}

//  83  * special_char  ->  -
//
int     CRegexpParserDriver::Reduce_83(void *data)
{
    return 0;
}

//  84  * special_char  ->  ^
//
int     CRegexpParserDriver::Reduce_84(void *data)
{
    return 0;
}

//  85  * special_char  ->  .
//
int     CRegexpParserDriver::Reduce_85(void *data)
{
    return 0;
}

//  86  * special_char  ->  {
//
int     CRegexpParserDriver::Reduce_86(void *data)
{
    return 0;
}

//  87  * special_char  ->  }
//
int     CRegexpParserDriver::Reduce_87(void *data)
{
    return 0;
}

//  88  * special_char  ->  ,
//
int     CRegexpParserDriver::Reduce_88(void *data)
{
    return 0;
}

//  89  * special_char  ->  $
//
int     CRegexpParserDriver::Reduce_89(void *data)
{
    return 0;
}

//  90  * special_char  ->  /
//
int     CRegexpParserDriver::Reduce_90(void *data)
{
    return 0;
}

//  91  * special_char  ->  <
//
int     CRegexpParserDriver::Reduce_91(void *data)
{
    return 0;
}

//  92  * special_char  ->  >
//
int     CRegexpParserDriver::Reduce_92(void *data)
{
    return 0;
}

//  conflict function definitions for CRegexpParserDriver

//  conflict entry 0
//  machine state 17  terminal symbol 0 letter
//  action set shift rule:14 conflict
//
void    CRegexpParserDriver::Conflict_00()
{
}

//  conflict entry 1
//  machine state 17  terminal symbol 1 digit
//  action set shift rule:14 conflict
//
void    CRegexpParserDriver::Conflict_01()
{
}

//  conflict entry 2
//  machine state 17  terminal symbol 2 other
//  action set shift rule:14 conflict
//
void    CRegexpParserDriver::Conflict_02()
{
}

//  conflict entry 3
//  machine state 17  terminal symbol 4 (
//  action set shift rule:14 conflict
//
void    CRegexpParserDriver::Conflict_03()
{
}

//  conflict entry 4
//  machine state 17  terminal symbol 10 \
//  action set shift rule:14 conflict
//
void    CRegexpParserDriver::Conflict_04()
{
}

//  conflict entry 5
//  machine state 17  terminal symbol 11 "
//  action set shift rule:14 conflict
//
void    CRegexpParserDriver::Conflict_05()
{
}

//  conflict entry 6
//  machine state 17  terminal symbol 12 [
//  action set shift rule:14 conflict
//
void    CRegexpParserDriver::Conflict_06()
{
}

//  conflict entry 7
//  machine state 17  terminal symbol 16 .
//  action set shift rule:14 conflict
//
void    CRegexpParserDriver::Conflict_07()
{
}

//  conflict entry 8
//  machine state 18  terminal symbol 0 letter
//  action set shift rule:37 conflict
//
void    CRegexpParserDriver::Conflict_08()
{
}

//  conflict entry 9
//  machine state 18  terminal symbol 1 digit
//  action set shift rule:37 conflict
//
void    CRegexpParserDriver::Conflict_09()
{
}

//  conflict entry 10
//  machine state 18  terminal symbol 2 other
//  action set shift rule:37 conflict
//
void    CRegexpParserDriver::Conflict_10()
{
}

//  conflict entry 11
//  machine state 18  terminal symbol 4 (
//  action set shift rule:37 conflict
//
void    CRegexpParserDriver::Conflict_11()
{
}

//  conflict entry 12
//  machine state 18  terminal symbol 10 \
//  action set shift rule:37 conflict
//
void    CRegexpParserDriver::Conflict_12()
{
}

//  conflict entry 13
//  machine state 18  terminal symbol 11 "
//  action set shift rule:37 conflict
//
void    CRegexpParserDriver::Conflict_13()
{
}

//  conflict entry 14
//  machine state 18  terminal symbol 12 [
//  action set shift rule:37 conflict
//
void    CRegexpParserDriver::Conflict_14()
{
}

//  conflict entry 15
//  machine state 18  terminal symbol 16 .
//  action set shift rule:37 conflict
//
void    CRegexpParserDriver::Conflict_15()
{
}

//  conflict entry 16
//  machine state 78  terminal symbol 0 letter
//  action set shift rule:40 conflict
//
void    CRegexpParserDriver::Conflict_16()
{
}

//  conflict entry 17
//  machine state 78  terminal symbol 1 digit
//  action set shift rule:40 conflict
//
void    CRegexpParserDriver::Conflict_17()
{
}

//  conflict entry 18
//  machine state 78  terminal symbol 2 other
//  action set shift rule:40 conflict
//
void    CRegexpParserDriver::Conflict_18()
{
}

//  conflict entry 19
//  machine state 78  terminal symbol 10 \
//  action set shift rule:40 conflict
//
void    CRegexpParserDriver::Conflict_19()
{
}

//  conflict entry 20
//  machine state 57  terminal symbol 14 -
//  action set shift rule:52 conflict
//
void    CRegexpParserDriver::Conflict_20()
{
}

//  conflict entry 21
//  machine state 97  terminal symbol 14 -
//  action set shift rule:54 conflict
//
void    CRegexpParserDriver::Conflict_21()
{
}

//  conflict entry 22
//  machine state 55  terminal symbol 14 -
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_22()
{
}

//  conflict entry 23
//  machine state 55  terminal symbol 0 letter
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_23()
{
}

//  conflict entry 24
//  machine state 55  terminal symbol 1 digit
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_24()
{
}

//  conflict entry 25
//  machine state 55  terminal symbol 2 other
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_25()
{
}

//  conflict entry 26
//  machine state 55  terminal symbol 3 space
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_26()
{
}

//  conflict entry 27
//  machine state 55  terminal symbol 4 (
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_27()
{
}

//  conflict entry 28
//  machine state 55  terminal symbol 5 )
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_28()
{
}

//  conflict entry 29
//  machine state 55  terminal symbol 6 *
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_29()
{
}

//  conflict entry 30
//  machine state 55  terminal symbol 7 +
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_30()
{
}

//  conflict entry 31
//  machine state 55  terminal symbol 8 ?
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_31()
{
}

//  conflict entry 32
//  machine state 55  terminal symbol 9 |
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_32()
{
}

//  conflict entry 33
//  machine state 55  terminal symbol 10 \
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_33()
{
}

//  conflict entry 34
//  machine state 55  terminal symbol 15 ^
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_34()
{
}

//  conflict entry 35
//  machine state 55  terminal symbol 16 .
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_35()
{
}

//  conflict entry 36
//  machine state 55  terminal symbol 17 {
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_36()
{
}

//  conflict entry 37
//  machine state 55  terminal symbol 18 }
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_37()
{
}

//  conflict entry 38
//  machine state 55  terminal symbol 19 ,
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_38()
{
}

//  conflict entry 39
//  machine state 55  terminal symbol 20 $
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_39()
{
}

//  conflict entry 40
//  machine state 55  terminal symbol 21 /
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_40()
{
}

//  conflict entry 41
//  machine state 55  terminal symbol 22 <
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_41()
{
}

//  conflict entry 42
//  machine state 55  terminal symbol 23 >
//  action set shift rule:84 conflict
//
void    CRegexpParserDriver::Conflict_42()
{
}

//  error function definitions for CRegexpParserDriver

// inaccessible error
//
void    CRegexpParserDriver::Error_1()
{
}

// accessible error
//
void    CRegexpParserDriver::Error_2()
{
}

void    CRegexpParserDriver::SetupFunctionTables()
{
    reduce_functions[ 0] = &CRegexpParserDriver::Reduce_00;
    reduce_functions[ 1] = &CRegexpParserDriver::Reduce_01;
    reduce_functions[ 2] = &CRegexpParserDriver::Reduce_02;
    reduce_functions[ 3] = &CRegexpParserDriver::Reduce_03;
    reduce_functions[ 4] = &CRegexpParserDriver::Reduce_04;
    reduce_functions[ 5] = &CRegexpParserDriver::Reduce_05;
    reduce_functions[ 6] = &CRegexpParserDriver::Reduce_06;
    reduce_functions[ 7] = &CRegexpParserDriver::Reduce_07;
    reduce_functions[ 8] = &CRegexpParserDriver::Reduce_08;
    reduce_functions[ 9] = &CRegexpParserDriver::Reduce_09;
    reduce_functions[10] = &CRegexpParserDriver::Reduce_10;
    reduce_functions[11] = &CRegexpParserDriver::Reduce_11;
    reduce_functions[12] = &CRegexpParserDriver::Reduce_12;
    reduce_functions[13] = &CRegexpParserDriver::Reduce_13;
    reduce_functions[14] = &CRegexpParserDriver::Reduce_14;
    reduce_functions[15] = &CRegexpParserDriver::Reduce_15;
    reduce_functions[16] = &CRegexpParserDriver::Reduce_16;
    reduce_functions[17] = &CRegexpParserDriver::Reduce_17;
    reduce_functions[18] = &CRegexpParserDriver::Reduce_18;
    reduce_functions[19] = &CRegexpParserDriver::Reduce_19;
    reduce_functions[20] = &CRegexpParserDriver::Reduce_20;
    reduce_functions[21] = &CRegexpParserDriver::Reduce_21;
    reduce_functions[22] = &CRegexpParserDriver::Reduce_22;
    reduce_functions[23] = &CRegexpParserDriver::Reduce_23;
    reduce_functions[24] = &CRegexpParserDriver::Reduce_24;
    reduce_functions[25] = &CRegexpParserDriver::Reduce_25;
    reduce_functions[26] = &CRegexpParserDriver::Reduce_26;
    reduce_functions[27] = &CRegexpParserDriver::Reduce_27;
    reduce_functions[28] = &CRegexpParserDriver::Reduce_28;
    reduce_functions[29] = &CRegexpParserDriver::Reduce_29;
    reduce_functions[30] = &CRegexpParserDriver::Reduce_30;
    reduce_functions[31] = &CRegexpParserDriver::Reduce_31;
    reduce_functions[32] = &CRegexpParserDriver::Reduce_32;
    reduce_functions[33] = &CRegexpParserDriver::Reduce_33;
    reduce_functions[34] = &CRegexpParserDriver::Reduce_34;
    reduce_functions[35] = &CRegexpParserDriver::Reduce_35;
    reduce_functions[36] = &CRegexpParserDriver::Reduce_36;
    reduce_functions[37] = &CRegexpParserDriver::Reduce_37;
    reduce_functions[38] = &CRegexpParserDriver::Reduce_38;
    reduce_functions[39] = &CRegexpParserDriver::Reduce_39;
    reduce_functions[40] = &CRegexpParserDriver::Reduce_40;
    reduce_functions[41] = &CRegexpParserDriver::Reduce_41;
    reduce_functions[42] = &CRegexpParserDriver::Reduce_42;
    reduce_functions[43] = &CRegexpParserDriver::Reduce_43;
    reduce_functions[44] = &CRegexpParserDriver::Reduce_44;
    reduce_functions[45] = &CRegexpParserDriver::Reduce_45;
    reduce_functions[46] = &CRegexpParserDriver::Reduce_46;
    reduce_functions[47] = &CRegexpParserDriver::Reduce_47;
    reduce_functions[48] = &CRegexpParserDriver::Reduce_48;
    reduce_functions[49] = &CRegexpParserDriver::Reduce_49;
    reduce_functions[50] = &CRegexpParserDriver::Reduce_50;
    reduce_functions[51] = &CRegexpParserDriver::Reduce_51;
    reduce_functions[52] = &CRegexpParserDriver::Reduce_52;
    reduce_functions[53] = &CRegexpParserDriver::Reduce_53;
    reduce_functions[54] = &CRegexpParserDriver::Reduce_54;
    reduce_functions[55] = &CRegexpParserDriver::Reduce_55;
    reduce_functions[56] = &CRegexpParserDriver::Reduce_56;
    reduce_functions[57] = &CRegexpParserDriver::Reduce_57;
    reduce_functions[58] = &CRegexpParserDriver::Reduce_58;
    reduce_functions[59] = &CRegexpParserDriver::Reduce_59;
    reduce_functions[60] = &CRegexpParserDriver::Reduce_60;
    reduce_functions[61] = &CRegexpParserDriver::Reduce_61;
    reduce_functions[62] = &CRegexpParserDriver::Reduce_62;
    reduce_functions[63] = &CRegexpParserDriver::Reduce_63;
    reduce_functions[64] = &CRegexpParserDriver::Reduce_64;
    reduce_functions[65] = &CRegexpParserDriver::Reduce_65;
    reduce_functions[66] = &CRegexpParserDriver::Reduce_66;
    reduce_functions[67] = &CRegexpParserDriver::Reduce_67;
    reduce_functions[68] = &CRegexpParserDriver::Reduce_68;
    reduce_functions[69] = &CRegexpParserDriver::Reduce_69;
    reduce_functions[70] = &CRegexpParserDriver::Reduce_70;
    reduce_functions[71] = &CRegexpParserDriver::Reduce_71;
    reduce_functions[72] = &CRegexpParserDriver::Reduce_72;
    reduce_functions[73] = &CRegexpParserDriver::Reduce_73;
    reduce_functions[74] = &CRegexpParserDriver::Reduce_74;
    reduce_functions[75] = &CRegexpParserDriver::Reduce_75;
    reduce_functions[76] = &CRegexpParserDriver::Reduce_76;
    reduce_functions[77] = &CRegexpParserDriver::Reduce_77;
    reduce_functions[78] = &CRegexpParserDriver::Reduce_78;
    reduce_functions[79] = &CRegexpParserDriver::Reduce_79;
    reduce_functions[80] = &CRegexpParserDriver::Reduce_80;
    reduce_functions[81] = &CRegexpParserDriver::Reduce_81;
    reduce_functions[82] = &CRegexpParserDriver::Reduce_82;
    reduce_functions[83] = &CRegexpParserDriver::Reduce_83;
    reduce_functions[84] = &CRegexpParserDriver::Reduce_84;
    reduce_functions[85] = &CRegexpParserDriver::Reduce_85;
    reduce_functions[86] = &CRegexpParserDriver::Reduce_86;
    reduce_functions[87] = &CRegexpParserDriver::Reduce_87;
    reduce_functions[88] = &CRegexpParserDriver::Reduce_88;
    reduce_functions[89] = &CRegexpParserDriver::Reduce_89;
    reduce_functions[90] = &CRegexpParserDriver::Reduce_90;
    reduce_functions[91] = &CRegexpParserDriver::Reduce_91;
    reduce_functions[92] = &CRegexpParserDriver::Reduce_92;

    conflict_functions[ 0] = &CRegexpParserDriver::Conflict_00;
    conflict_functions[ 1] = &CRegexpParserDriver::Conflict_01;
    conflict_functions[ 2] = &CRegexpParserDriver::Conflict_02;
    conflict_functions[ 3] = &CRegexpParserDriver::Conflict_03;
    conflict_functions[ 4] = &CRegexpParserDriver::Conflict_04;
    conflict_functions[ 5] = &CRegexpParserDriver::Conflict_05;
    conflict_functions[ 6] = &CRegexpParserDriver::Conflict_06;
    conflict_functions[ 7] = &CRegexpParserDriver::Conflict_07;
    conflict_functions[ 8] = &CRegexpParserDriver::Conflict_08;
    conflict_functions[ 9] = &CRegexpParserDriver::Conflict_09;
    conflict_functions[10] = &CRegexpParserDriver::Conflict_10;
    conflict_functions[11] = &CRegexpParserDriver::Conflict_11;
    conflict_functions[12] = &CRegexpParserDriver::Conflict_12;
    conflict_functions[13] = &CRegexpParserDriver::Conflict_13;
    conflict_functions[14] = &CRegexpParserDriver::Conflict_14;
    conflict_functions[15] = &CRegexpParserDriver::Conflict_15;
    conflict_functions[16] = &CRegexpParserDriver::Conflict_16;
    conflict_functions[17] = &CRegexpParserDriver::Conflict_17;
    conflict_functions[18] = &CRegexpParserDriver::Conflict_18;
    conflict_functions[19] = &CRegexpParserDriver::Conflict_19;
    conflict_functions[20] = &CRegexpParserDriver::Conflict_20;
    conflict_functions[21] = &CRegexpParserDriver::Conflict_21;
    conflict_functions[22] = &CRegexpParserDriver::Conflict_22;
    conflict_functions[23] = &CRegexpParserDriver::Conflict_23;
    conflict_functions[24] = &CRegexpParserDriver::Conflict_24;
    conflict_functions[25] = &CRegexpParserDriver::Conflict_25;
    conflict_functions[26] = &CRegexpParserDriver::Conflict_26;
    conflict_functions[27] = &CRegexpParserDriver::Conflict_27;
    conflict_functions[28] = &CRegexpParserDriver::Conflict_28;
    conflict_functions[29] = &CRegexpParserDriver::Conflict_29;
    conflict_functions[30] = &CRegexpParserDriver::Conflict_30;
    conflict_functions[31] = &CRegexpParserDriver::Conflict_31;
    conflict_functions[32] = &CRegexpParserDriver::Conflict_32;
    conflict_functions[33] = &CRegexpParserDriver::Conflict_33;
    conflict_functions[34] = &CRegexpParserDriver::Conflict_34;
    conflict_functions[35] = &CRegexpParserDriver::Conflict_35;
    conflict_functions[36] = &CRegexpParserDriver::Conflict_36;
    conflict_functions[37] = &CRegexpParserDriver::Conflict_37;
    conflict_functions[38] = &CRegexpParserDriver::Conflict_38;
    conflict_functions[39] = &CRegexpParserDriver::Conflict_39;
    conflict_functions[40] = &CRegexpParserDriver::Conflict_40;
    conflict_functions[41] = &CRegexpParserDriver::Conflict_41;
    conflict_functions[42] = &CRegexpParserDriver::Conflict_42;

    error_functions[1] = &CRegexpParserDriver::Error_1;
    error_functions[2] = &CRegexpParserDriver::Error_2;
}
