/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef RULECODEVIEW_H
#define	RULECODEVIEW_H

class CRuleCodeMultiLineEdit;
class CRuleCodeVBoxWidget;
class CRuleCodeView;

#include <string>
#include <list>

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "ruleSelectView.h"

class CRuleCodeMultiLineEdit: public CMultiLineEditFc
{
	Q_OBJECT
	public:
	CRuleCodeMultiLineEdit(CRuleCodeVBoxWidget *v)
		: CMultiLineEditFc((QWidget *)v, "", 4), rule_code_vbox(v) { }
	~CRuleCodeMultiLineEdit() { }

	protected:
	virtual bool	event(QEvent *e);

	private:
	CRuleCodeVBoxWidget		*rule_code_vbox;
};

class CRuleCodeVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CRuleCodeVBoxWidget(QWidget *parent,
						CCompilerInterface *ci,
						SMainViewControl *mvc,
						COptionData::SSubViewData *d,
						CRuleCodeView *rcv);

	virtual ~CRuleCodeVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	bool	GetTabIndicator();
	void	ToggleTabIndicator();
	void	ToggleRuleIndicator();
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	RestoreUndoData();

	public slots:
	void	CodeTextChanged();

	private:
	bool						tab_indicator;
	bool						rule_indicator;
	CLabelFc					*label;
	CRuleCodeMultiLineEdit		*multi_line_edit;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CRuleCodeView				*rule_code_view;
	ModulePtrMap				&module_ptr_map;

	CRuleSelectView				*rsv;
};

class CRuleCodeView: public CSubView
{
	public:
	CRuleCodeView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CRuleCodeView();

	virtual CRuleCodeVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	RestoreUndoData();

	private:
	CRuleCodeVBoxWidget		*frame;
};

#endif
