/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef SIMULATEINPUTVIEW_H
#define	SIMULATEINPUTVIEW_H

class CSimulateInputMultiLineEdit;
class CSimulateInputVBoxWidget;
class CSimulateInputView;

#include <string>
#include <list>

#include <qobject.h>
#include <qwidget.h>
#include <qevent.h>
#include <qstring.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "optionDialog.h"
#include "filePath.h"

class CSimulateInputMultiLineEdit: public CMultiLineEditFc
{
	Q_OBJECT
	public:
	CSimulateInputMultiLineEdit(CSimulateInputVBoxWidget *v)
		: CMultiLineEditFc((QWidget *)v, "", 4), simulate_input_vbox(v) { }
	~CSimulateInputMultiLineEdit() { }

	void	InputCursorRight(bool mark, bool wrap);

	protected:
	virtual bool	event(QEvent *e);
	virtual void	focusInEvent(QFocusEvent *e);

	private:
	CSimulateInputVBoxWidget		*simulate_input_vbox;
};

class CSimulateInputVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CSimulateInputVBoxWidget(	QWidget *parent,
								CCompilerInterface *ci,
								SMainViewControl *mvc,
								COptionData::SSubViewData *d,
								CSimulateInputView *siv);

	virtual ~CSimulateInputVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count, bool f = true);
	void	SetWordWrap(bool wrap = false, bool f = true);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	bool	GetTabIndicator();
	void	ToggleTabIndicator();
	void	ToggleSimulateInputIndicator();
	void	GetCurrentSimulateInputString(string &s);
	void	GetCursorPositionString(string &s);
	void	OpenSimulateInputFile();
	void	ClearSimulateInputFile();
	void	SaveSimulateInputFile();
	void	SaveSimulateInputFile(const string &s);
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	GetInputText(QString &s);
	void	SetInputCursorPosition(int line, int column);
	void	HighlightInputText(int length);
	void	SetModulePointer();
	void	RestoreUndoData();

	public slots:
	void	UpdateCursorPosition(int p, int c);
	void	CodeTextChanged();

	private:
	bool							tab_indicator;
	bool							simulate_input_indicator;
	bool							file_modified_flag;
	CLabelFc						*label;
	CSimulateInputMultiLineEdit		*multi_line_edit;
	string							current_file_path;
	int								current_paragraph;
	int								current_column;

	CCompilerInterface				*compiler_interface;
	CCompilerData					*compiler_data;
	COptionData::SSubViewData		*subview_data;
	CSimulateInputView				*simulate_input_view;
	ModulePtrMap					&module_ptr_map;
};

class CSimulateInputView: public CSubView
{
	public:
	CSimulateInputView(	QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CSimulateInputView();

	virtual CSimulateInputVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ClearMultiLineEditText();
	void	SetTabStopWidth(int count, bool f = true);
	void	SetWordWrap(bool wrap = false, bool f = true);
	void	SetMultiLineEditText(const list<string> &code);
	void	GetMultiLineEditText(list<string> &code);
	bool	GetCodeEditedFlag();
	void	SetCodeEditedFlag(bool f);
	void	OpenSimulateInputFile();
	void	ClearSimulateInputFile();
	void	SaveSimulateInputFile();
	void	UndoEdit();
	void	RedoEdit();
	void	FindString();
	void	GetInputText(QString &s);
	void	SetInputCursorPosition(int line, int column);
	void	HighlightInputText(int length);
	void	RestoreUndoData();

	private:
	CSimulateInputVBoxWidget		*frame;
};

#endif
