/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef SIMULATETREEVIEW_H
#define	SIMULATETREEVIEW_H

class CParserTreeItem;
class CParserTreeNode;
class CSimulateTreeListView;
class CSimulateTreeVBoxWidget;
class CSimulateTreeView;

#include <qobject.h>
#include <qwidget.h>
#include <q3listview.h>
#include <q3header.h>
#include <qevent.h>
#include <qcolor.h>
#include <qpalette.h>
#include <qstring.h>

#include "fontchangeControl.h"
#include "viewControl.h"
#include "compilerInterface.h"
#include "optionData.h"

class CParserTreeItem: public Q3ListViewItem
{
	public:
	CParserTreeItem(CParserTreeNode *n,
					Q3ListView *p,
					QString s0, QString s1, QString s2, QString s3)
		: Q3ListViewItem(p, s0, s1, s2, s3), node(n) { }

	CParserTreeItem(CParserTreeNode *n,
					Q3ListView *p,
					Q3ListViewItem *a,
					QString s0, QString s1, QString s2, QString s3)
		: Q3ListViewItem(p, a, s0, s1, s2, s3), node(n) { }

	CParserTreeItem(CParserTreeNode *n,
					Q3ListViewItem *p,
					QString s0, QString s1, QString s2, QString s3)
		: Q3ListViewItem(p, s0, s1, s2, s3), node(n) { }

	CParserTreeItem(CParserTreeNode *n,
					Q3ListViewItem *p,
					Q3ListViewItem *a,
					QString s0, QString s1, QString s2, QString s3)
		: Q3ListViewItem(p, a, s0, s1, s2, s3), node(n) { }

	virtual void	setOpen(bool o);
	void			SetNode(CParserTreeNode *n) { node = n; }

	CParserTreeNode		*node;
};

class CParserTreeNode
{
	public:
	CParserTreeNode(CParserTreeNode *p,
					CParserTreeItem *i,
					int sd,
					const string &sy,
					const string &st,
					const string &ac,
					const string &va,
					const CXpmImage *xi)
		: parent(p), item(i), subtree_depth(sd),
			symbol(sy), state(st), action(ac), value(va),
			xpm_image(xi) { }
	~CParserTreeNode();

	void	SetParent(CParserTreeNode *p)	{ parent = p; }
	void	SetItem(CParserTreeItem *i)		{ item = i; }
	void	AddChild(CParserTreeNode *n)	{ descendants.push_back(n); }
	void	DeleteItem()					{ delete item; ZeroItemPtrs(); }
	void	ZeroItemPtrs();
	void	ExpandItems(int level, int limit);

	CParserTreeNode				*parent;
	CParserTreeItem				*item;
	int							subtree_depth;
	string						symbol;
	string						state;
	string						action;
	string						value;
	const CXpmImage				*xpm_image;
	list<CParserTreeNode *>		descendants;
};

class CSimulateTreeListView: public Q3ListView
{
	Q_OBJECT
	public:
	CSimulateTreeListView(CSimulateTreeVBoxWidget *v)
		: Q3ListView((QWidget *)v, 0, 0), simulate_tree_vbox(v) { }
	~CSimulateTreeListView() { }

	void	InitializePalette(const QPalette &p);

	protected:
	virtual void	focusInEvent(QFocusEvent *e);
	virtual void	focusOutEvent(QFocusEvent *e);

	private:
	CSimulateTreeVBoxWidget		*simulate_tree_vbox;
	QColor						active_highlight;
	QColor						active_highlighted_text;
	QColor						inactive_highlight;
	QColor						inactive_highlighted_text;
};

class CSimulateTreeVBoxWidget: public CVBoxWidget
{
	Q_OBJECT
	public:
	CSimulateTreeVBoxWidget(QWidget *parent,
							CCompilerInterface *ci,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CSimulateTreeView *stv);

	virtual ~CSimulateTreeVBoxWidget();

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	void	InitializePalette(const QPalette &p)
	{ list_view->InitializePalette(p); }
	void	InitializeModulePointers();

	void	ShiftSymbol(const string &sy,
						const string &st,
						const string &ac,
						const string &va,
						const CXpmImage *xi);

	int		ReduceTop(	const string &sy,
						const string &st,
						const string &ac,
						const string &va,
						const CXpmImage *xi,
						int reduce_length);

	void	PopTop(int length);
	void	RestoreTop();

	void	ClearTree(const CXpmImage *xi);
	void	ExpandTree(int level);
	void	RestoreUndoData();

	private:
	CLabelFc					*label;
	CSimulateTreeListView		*list_view;
	list<CParserTreeNode *>		stack_nodes;
	list<CParserTreeNode *>		restore_nodes;
	CParserTreeNode				*current_node;

	CCompilerInterface			*compiler_interface;
	CCompilerData				*compiler_data;
	COptionData::SSubViewData	*subview_data;
	CSimulateTreeView			*simulate_tree_view;
	ModulePtrMap				&module_ptr_map;
};

class CSimulateTreeView: public CSubView
{
	public:
	CSimulateTreeView(	QWidget *p,
						CViewNode *n,
						CInterfaceControl *ic,
						SMainViewControl *mvc,
						const string &dfs,
						CPaletteData *dpd,
						COptionData::SSubViewData *d);

	virtual ~CSimulateTreeView();

	virtual CSimulateTreeVBoxWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	virtual void		InitializeModulePointers();

	void	ShiftSymbol(const string &sy,
						const string &st,
						const string &ac,
						const string &va,
						const CXpmImage *xi);

	int		ReduceTop(	const string &sy,
						const string &st,
						const string &ac,
						const string &va,
						const CXpmImage *xi,
						int reduce_length);

	void	PopTop(int length);
	void	RestoreTop();

	void	ClearTree(const CXpmImage *xi);
	void	ExpandTree(int level);
	void	RestoreUndoData();

	private:
	CSimulateTreeVBoxWidget		*frame;
};

#endif
