/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef TRELATION_H
#define TRELATION_H

#include "tvaluelist.h"

template <class S, class T>
class STOrderedPair
{
	public:
	STOrderedPair() : first(), second() { }
	~STOrderedPair() { }

	STOrderedPair(const S &s, const T &t)
	{
		first	= s;
		second	= t;
	}

	STOrderedPair(const STOrderedPair &p)
	{
		first	= p.first;
		second	= p.second;
	}

	STOrderedPair	&operator=(const STOrderedPair &p)
	{
		if (this != &p)
		{
			first	= p.first;
			second	= p.second;
		}

		return *this;
	}

	bool	operator==(const STOrderedPair &p)
	{
		if (first == p.first && second == p.second)
			return true;
		else
			return false;
	}

	bool	operator!=(const STOrderedPair &p)
	{
		if (first != p.first || second != p.second)
			return true;
		else
			return false;
	}

	S	First() const	{ return first; }
	S	&First()		{ return first; }
	T	Second() const	{ return second; }
	T	&Second()		{ return second; }

	S	first;
	T	second;
};

template <>
class STOrderedPair<int, int>
{
	public:
	STOrderedPair() : first(), second() { }
	~STOrderedPair() { }

	STOrderedPair(const int &s, const int &t)
	{
		first	= s;
		second	= t;
	}

	STOrderedPair(const STOrderedPair &p)
	{
		first	= p.first;
		second	= p.second;
	}

	STOrderedPair	&operator=(const STOrderedPair &p)
	{
		if (this != &p)
		{
			first	= p.first;
			second	= p.second;
		}

		return *this;
	}

	bool	operator==(const STOrderedPair &p)
	{
		if (first == p.first && second == p.second)
			return true;
		else
			return false;
	}

	bool	operator!=(const STOrderedPair &p)
	{
		if (first != p.first || second != p.second)
			return true;
		else
			return false;
	}

	int		First() const	{ return first; }
	int		&First()		{ return first; }
	int		Second() const	{ return second; }
	int		&Second()		{ return second; }

	int		first;
	int		second;
};

template <class S, class T>
class STRelation
{
	public:
	STRelation() { }
	STRelation(int c, STOrderedPair<S, T> *p);
	STRelation(TValueList< STOrderedPair<S, T> >	*p);
	STRelation(const STRelation &r);
	~STRelation();

	STRelation<T, S>	*Inverse();

	int									count;
	TValueList< STOrderedPair<S, T> >	*pairs;

	private:
	STRelation	&operator=(const STRelation &r);
};

template <>
class STRelation<int, int>
{
	public:
	STRelation() { }
	STRelation(int c, STOrderedPair<int, int> *p);
	STRelation(TValueList< STOrderedPair<int, int> >	*p);
	STRelation(const STRelation &r);
	~STRelation();

	STRelation<int, int>	*Inverse();

	int										count;
	TValueList< STOrderedPair<int, int> >	*pairs;

	private:
	STRelation	&operator=(const STRelation &r);
};

typedef		STRelation<int, int>					RelationInt;
typedef		STOrderedPair<int, int>					OrdPairInt;
typedef		TValueList< STOrderedPair<int, int> >	VListOrdPairInt;

const unsigned int bool_per_unsigned_long =
					sizeof(unsigned long) / sizeof(bool);

template <class S, class T>
STRelation<S, T>		*RelationUnion(	const STRelation<S, T> *r1,
										const STRelation<S, T> *r2,
										int ub_S, int ub_T);

template <>
STRelation<int, int>	*RelationUnion(	const STRelation<int, int> *r1,
										const STRelation<int, int> *r2,
										int ub_S, int ub_T);

template <class S, class T>
STRelation<S, T>		*RelationIntersection(	const STRelation<S, T> *r1,
												const STRelation<S, T> *r2,
												int ub_S, int ub_T);

template <>
STRelation<int, int>	*RelationIntersection(	const STRelation<int, int> *r1,
												const STRelation<int, int> *r2,
												int ub_S, int ub_T);

template <class R, class S, class T>
STRelation<R, T>		*Composition(	const STRelation<R, S> *rs,
										const STRelation<S, T> *st,
										int ub_R, int ub_S, int ub_T);

template <>
STRelation<int, int>	*Composition(	const STRelation<int, int> *rs,
										const STRelation<int, int> *st,
										int ub_R, int ub_S, int ub_T);

template <class S, class T>
STRelation<S, T>		*Empty();

template <>
STRelation<int, int>	*Empty();

template <class S, class T>
STRelation<S, T>		*Identity(const STRelation<S, T> *r);

template <>
STRelation<int, int>	*Identity(const STRelation<int, int> *r);

template <class T>
STRelation<T, T>		*ImageClosure(	const STRelation<T, T> *r,
										const T &a, int ub_T);

template <>
STRelation<int, int>	*ImageClosure(	const STRelation<int, int> *r,
										const int &a, int ub_T);

template <class T>
STRelation<T, T>	*ReflexiveTransitiveClosure(const STRelation<T, T> *r,
												const TValueList<T>	*domain,
												int ub_T);

template <>
STRelation<int, int>	*ReflexiveTransitiveClosure(
												const STRelation<int, int> *r,
												const TValueList<int> *domain,
												int ub_T);

template <class S, class T>
TValueList<T>			*SubsetImage(	const STRelation<S, T> *r,
										const TValueList<S>	*subset,
										int ub_S, int ub_T);

template <>
TValueList<int>			*SubsetImage(	const STRelation<int, int> *r,
										const TValueList<int>	*subset,
										int ub_S, int ub_T);

#endif
