/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef TTYTREE_H
#define TTYTREE_H

using namespace std;

#include <list>
#include <string>
#include <functional>
#include <algorithm>
#include <cstdarg>
#include <iostream>

template <class T>
struct destroy_T : public unary_function<T, void>
{
	void	operator()(T x) { delete x; }
};

struct SttyTreeNode
{
	enum SymbolType { Token, NonTerminal };

	SttyTreeNode			*parent;
	SymbolType				symbol_type;
	string					name_text;
	string					value_text;
	bool					print_value_only_flag;
	list<SttyTreeNode *>	children;

	static int			token_count;
	static int			reduction_count;
	static int			tree_level;
	static int			horizontal_spacing;
	static int			vertical_spacing;
	static bool			global_print_value_only_flag;
	static list<int>	bar_position_list;

	SttyTreeNode(	SttyTreeNode *p = 0,
					SymbolType t = NonTerminal,
					const char *n = 0,
					const char *v = 0,
					bool f = global_print_value_only_flag);

	~SttyTreeNode();

	SttyTreeNode(const char *n = 0);

	bool	operator==(const SttyTreeNode &node) const;

	void	shift(	const char *token_name,
					const char *token_value,
					bool p_flag = global_print_value_only_flag);

	void	reduce(	const char *left_symbol_name,
					list<SttyTreeNode *> &rule_right);

	int		reduce_rule(const char *left_symbol_name ...);

	void	print();
};

struct print_node : public unary_function<SttyTreeNode *, void>
{
	void	operator()(SttyTreeNode *node);
};

#endif
