/*****************************************************************************/
/*                                                                           */
/*  Compiler - a Parser Generator Program, Version 2.0                       */
/*  Copyright (c) 2000, 2003  Charles M. Fayle  All Rights Reserved.         */
/*                                                                           */
/*  This software is distributed under the terms of the GNU General Public   */
/*  License as specified in the file gpl.txt included with the distribution. */
/*                                                                           */
/*****************************************************************************/
//
//  $Id$
//

#ifndef UNDEFINEDVIEW_H
#define	UNDEFINEDVIEW_H

class CUndefinedFrameWidget;
class CUndefinedView;

#include "viewControl.h"
#include "interfaceControl.h"

class CUndefinedFrameWidget: public CFrameWidget
{
	Q_OBJECT
	public:
	CUndefinedFrameWidget(	QWidget *parent,
							CInterfaceControl *ic,
							SMainViewControl *mvc,
							COptionData::SSubViewData *d,
							CUndefinedView *uv);

	virtual ~CUndefinedFrameWidget();

	void	CreateIndexText(ostrstream &s,
							const vector<int> &index,
							bool f = true);

	COptionData::SSubViewData	*GetSubviewData() const
	{ return subview_data; }

	private:
	QGridLayout		*grid_layout;
	CLabelFc		*label;
	string			index_text;

	CInterfaceControl			*interface_control;
	COptionData::SSubViewData	*subview_data;
	CUndefinedView				*undefined_view;
};

class CUndefinedView: public CSubView
{
	public:
	CUndefinedView(	QWidget *p,
					CViewNode *n,
					CInterfaceControl *ic,
					SMainViewControl *mvc,
					const string &dfs,
					CPaletteData *dpd,
					COptionData::SSubViewData *d);

	virtual ~CUndefinedView();

	virtual CUndefinedFrameWidget	*GetWidget() { return frame; }
	virtual void		SetProcessCloseEventFlag(bool f)
	{ frame->SetProcessCloseEventFlag(f); }

	virtual void		SetHighlightPalette(CPaletteData *pd);
	virtual void		RestorePalette();

	protected:
	CUndefinedFrameWidget		*frame;
};

#endif
